/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultObject;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;

public class ResultObjectUtil {
    private int columnCount;
    private Class[] typeArray;
    private IResultClass rsMetaData;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$eclipse$datatools$connectivity$oda$IClob;
    static /* synthetic */ Class class$org$eclipse$datatools$connectivity$oda$IBlob;

    public static ResultObjectUtil newInstance(IResultClass rsMetaData) {
        ResultObjectUtil instance = new ResultObjectUtil();
        int length = rsMetaData.getFieldCount();
        instance.typeArray = new Class[length];
        for (int i = 0; i < length; ++i) {
            try {
                instance.typeArray[i] = rsMetaData.getFieldValueClass(i + 1);
                continue;
            }
            catch (DataException e) {
                // empty catch block
            }
        }
        instance.columnCount = rsMetaData.getFieldCount();
        instance.rsMetaData = rsMetaData;
        return instance;
    }

    private ResultObjectUtil() {
    }

    ResultObject newResultObject(Object[] rowData) {
        return new ResultObject(this.rsMetaData, rowData);
    }

    public IResultObject[] readData(InputStream bis, int length) throws IOException {
        IResultObject[] rowDatas = new ResultObject[length];
        for (int i = 0; i < length; ++i) {
            int rowLen = IOUtil.readInt((InputStream)bis);
            byte[] rowDataBytes = new byte[rowLen];
            bis.read(rowDataBytes);
            ByteArrayInputStream bais = new ByteArrayInputStream(rowDataBytes);
            DataInputStream dis = new DataInputStream(bais);
            Object[] obs = new Object[this.columnCount];
            for (int j = 0; j < this.columnCount; ++j) {
                Class fieldType = this.typeArray[j];
                if (dis.readByte() == 0) {
                    obs[j] = null;
                    continue;
                }
                if (fieldType.equals(class$java$lang$Integer == null ? ResultObjectUtil.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    obs[j] = new Integer(dis.readInt());
                    continue;
                }
                if (fieldType.equals(class$java$lang$Double == null ? ResultObjectUtil.class$("java.lang.Double") : class$java$lang$Double)) {
                    obs[j] = new Double(dis.readDouble());
                    continue;
                }
                if (fieldType.equals(class$java$math$BigDecimal == null ? ResultObjectUtil.class$("java.math.BigDecimal") : class$java$math$BigDecimal)) {
                    obs[j] = new BigDecimal(dis.readUTF());
                    continue;
                }
                if (fieldType.equals(class$java$util$Date == null ? ResultObjectUtil.class$("java.util.Date") : class$java$util$Date)) {
                    obs[j] = new Date(dis.readLong());
                    continue;
                }
                if (fieldType.equals(class$java$sql$Time == null ? ResultObjectUtil.class$("java.sql.Time") : class$java$sql$Time)) {
                    obs[j] = new Time(dis.readLong());
                    continue;
                }
                if (fieldType.equals(class$java$sql$Timestamp == null ? ResultObjectUtil.class$("java.sql.Timestamp") : class$java$sql$Timestamp)) {
                    obs[j] = new Timestamp(dis.readLong());
                    continue;
                }
                if (fieldType.equals(class$java$lang$Boolean == null ? ResultObjectUtil.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                    obs[j] = new Boolean(dis.readBoolean());
                    continue;
                }
                if (fieldType.equals(class$java$lang$String == null ? ResultObjectUtil.class$("java.lang.String") : class$java$lang$String)) {
                    obs[j] = dis.readUTF();
                    continue;
                }
                if (fieldType.equals(class$org$eclipse$datatools$connectivity$oda$IClob == null ? ResultObjectUtil.class$("org.eclipse.datatools.connectivity.oda.IClob") : class$org$eclipse$datatools$connectivity$oda$IClob)) {
                    obs[j] = dis.readUTF();
                    continue;
                }
                if (fieldType.equals(class$org$eclipse$datatools$connectivity$oda$IBlob == null ? ResultObjectUtil.class$("org.eclipse.datatools.connectivity.oda.IBlob") : class$org$eclipse$datatools$connectivity$oda$IBlob)) {
                    int len = IOUtil.readInt((InputStream)dis);
                    if (len == 0) {
                        obs[j] = null;
                        continue;
                    }
                    byte[] bytes = new byte[len];
                    dis.read(bytes);
                    obs[j] = bytes;
                    continue;
                }
                if (!fieldType.equals(DataType.getClass((int)0))) continue;
                ObjectInputStream ois = new ObjectInputStream(dis);
                try {
                    obs[j] = ois.readObject();
                }
                catch (Exception e) {
                    // empty catch block
                }
                ois.close();
            }
            rowDatas[i] = this.newResultObject(obs);
            rowDataBytes = null;
            dis = null;
            bais = null;
        }
        return rowDatas;
    }

    public void writeData(OutputStream bos, IResultObject[] resultObjects, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            this.writeData(bos, resultObjects[i]);
        }
    }

    public void writeData(OutputStream bos, IResultObject resultObject) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        for (int j = 0; j < this.columnCount; ++j) {
            Object fieldValue = null;
            try {
                fieldValue = resultObject.getFieldValue(j + 1);
            }
            catch (DataException e) {
                // empty catch block
            }
            if (fieldValue == null) {
                dos.writeByte(0);
                continue;
            }
            dos.writeByte(1);
            Class fieldType = this.typeArray[j];
            if (fieldType.equals(class$java$lang$Integer == null ? ResultObjectUtil.class$("java.lang.Integer") : class$java$lang$Integer)) {
                dos.writeInt((Integer)fieldValue);
                continue;
            }
            if (fieldType.equals(class$java$lang$Double == null ? ResultObjectUtil.class$("java.lang.Double") : class$java$lang$Double)) {
                dos.writeDouble((Double)fieldValue);
                continue;
            }
            if (fieldType.equals(class$java$math$BigDecimal == null ? ResultObjectUtil.class$("java.math.BigDecimal") : class$java$math$BigDecimal)) {
                dos.writeUTF(((BigDecimal)fieldValue).toString());
                continue;
            }
            if (fieldType.equals(class$java$util$Date == null ? ResultObjectUtil.class$("java.util.Date") : class$java$util$Date)) {
                dos.writeLong(((Date)fieldValue).getTime());
                continue;
            }
            if (fieldType.equals(class$java$sql$Time == null ? ResultObjectUtil.class$("java.sql.Time") : class$java$sql$Time)) {
                dos.writeLong(((Time)fieldValue).getTime());
                continue;
            }
            if (fieldType.equals(class$java$sql$Timestamp == null ? ResultObjectUtil.class$("java.sql.Timestamp") : class$java$sql$Timestamp)) {
                dos.writeLong(((Timestamp)fieldValue).getTime());
                continue;
            }
            if (fieldType.equals(class$java$lang$Boolean == null ? ResultObjectUtil.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                dos.writeBoolean((Boolean)fieldValue);
                continue;
            }
            if (fieldType.equals(class$java$lang$String == null ? ResultObjectUtil.class$("java.lang.String") : class$java$lang$String)) {
                dos.writeUTF(fieldValue.toString());
                continue;
            }
            if (fieldType.equals(class$org$eclipse$datatools$connectivity$oda$IClob == null ? ResultObjectUtil.class$("org.eclipse.datatools.connectivity.oda.IClob") : class$org$eclipse$datatools$connectivity$oda$IClob)) {
                dos.writeUTF(fieldValue.toString());
                continue;
            }
            if (fieldType.equals(class$org$eclipse$datatools$connectivity$oda$IBlob == null ? ResultObjectUtil.class$("org.eclipse.datatools.connectivity.oda.IBlob") : class$org$eclipse$datatools$connectivity$oda$IBlob)) {
                byte[] bytes = (byte[])fieldValue;
                if (bytes == null || bytes.length == 0) {
                    IOUtil.writeInt((OutputStream)dos, (int)0);
                    continue;
                }
                IOUtil.writeInt((OutputStream)dos, (int)bytes.length);
                dos.write((byte[])fieldValue);
                continue;
            }
            if (!fieldType.equals(DataType.getClass((int)0))) continue;
            if (!(fieldValue instanceof Serializable)) {
                fieldValue = fieldValue.toString();
            }
            ObjectOutputStream oo = new ObjectOutputStream(dos);
            oo.writeObject(fieldValue);
            oo.close();
        }
        dos.flush();
        byte[] rowsDataBytes = baos.toByteArray();
        IOUtil.writeInt((OutputStream)bos, (int)rowsDataBytes.length);
        bos.write(rowsDataBytes);
        rowsDataBytes = null;
        dos = null;
        baos = null;
    }
}

