/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.engine.api.querydefn.ComputedColumn;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.BaseQuery;
import org.eclipse.birt.data.engine.executor.transform.ComputedColumnsState;
import org.eclipse.birt.data.engine.executor.transform.FilterUtil;
import org.eclipse.birt.data.engine.executor.transform.IRowProcessor;
import org.eclipse.birt.data.engine.executor.transform.MultiPassRowProcessorCCAssistant;
import org.eclipse.birt.data.engine.executor.transform.MultiPassRowProcessorFilterAssistant;
import org.eclipse.birt.data.engine.executor.transform.OdiResultSetWrapper;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulatorUtil;
import org.eclipse.birt.data.engine.executor.transform.SinglePassRowProcessor;
import org.eclipse.birt.data.engine.impl.ComputedColumnHelper;
import org.eclipse.birt.data.engine.impl.FilterByRow;
import org.eclipse.birt.data.engine.odi.IEventHandler;

class MultiPassRowProcessor
implements IRowProcessor {
    private ResultSetPopulator populator;
    private SinglePassRowProcessor singlePassRowProcessor;
    private static final boolean ALLOW_GROUP_FILTERING = false;

    MultiPassRowProcessor(ResultSetPopulator populator) {
        this.populator = populator;
        this.singlePassRowProcessor = new SinglePassRowProcessor(populator);
    }

    public boolean pass(OdiResultSetWrapper odaResultSet) throws DataException {
        ComputedColumnsState iccState = null;
        ComputedColumnHelper computedColumnHelper = null;
        FilterByRow filterByRow = null;
        Object[] fetchEventsList = ResultSetPopulatorUtil.getFetchEventListFromQuery(this.populator);
        for (int i = 0; i < fetchEventsList.length; ++i) {
            if (fetchEventsList[i] instanceof ComputedColumnHelper) {
                computedColumnHelper = (ComputedColumnHelper)fetchEventsList[i];
                computedColumnHelper.setExecutorHelper(this.populator.getEventHandler().getExecutorHelper());
                continue;
            }
            if (!(fetchEventsList[i] instanceof FilterByRow)) continue;
            filterByRow = (FilterByRow)fetchEventsList[i];
            filterByRow.setExecutorHelper(this.populator.getEventHandler().getExecutorHelper());
        }
        PassStatusController psController = new PassStatusController(this.populator, filterByRow, computedColumnHelper);
        if (!psController.needMultipassProcessing()) {
            if (computedColumnHelper != null) {
                computedColumnHelper.setModel(0);
            }
            this.singlePassRowProcessor.pass(odaResultSet);
            this.populator.getExpressionProcessor().setDataSetMode(false);
            this.handleEndOfDataSetProcess();
        } else {
            if (computedColumnHelper != null) {
                iccState = new ComputedColumnsState(computedColumnHelper);
            }
            this.doPopulation(odaResultSet, iccState, computedColumnHelper, filterByRow, psController);
        }
        return false;
    }

    private void doPopulation(OdiResultSetWrapper odaResultSet, ComputedColumnsState iccState, ComputedColumnHelper computedColumnHelper, FilterByRow filterByRow, PassStatusController psController) throws DataException {
        MultiPassRowProcessorCCAssistant ccAssistant = new MultiPassRowProcessorCCAssistant(this.populator, this.singlePassRowProcessor);
        this.populator.getExpressionProcessor().setDataSetMode(true);
        this.populateResultSetCacheInResultSetPopulator(odaResultSet, computedColumnHelper, filterByRow);
        this.populateDataSet(iccState, computedColumnHelper, filterByRow, psController, ccAssistant);
        this.handleEndOfDataSetProcess();
        this.populator.getExpressionProcessor().setDataSetMode(false);
        this.populateResultSet(iccState, computedColumnHelper, filterByRow, psController, ccAssistant);
        if (psController.needDoOperation(4)) {
            this.clearTemporaryComputedColumns(iccState, computedColumnHelper, ccAssistant);
        }
    }

    private void populateResultSetCacheInResultSetPopulator(OdiResultSetWrapper odaResultSet, ComputedColumnHelper computedColumnHelper, FilterByRow filterByRow) throws DataException {
        Object[] groups = null;
        Object[] sorts = null;
        int max = 0;
        if (computedColumnHelper != null) {
            computedColumnHelper.setModel(4);
        }
        if (filterByRow != null) {
            filterByRow.setWorkingFilterSet(4);
        }
        max = this.populator.getQuery().getMaxRows();
        if (filterByRow != null) {
            this.populator.getQuery().setMaxRows(0);
        }
        groups = this.populator.getQuery().getGrouping();
        sorts = this.populator.getQuery().getOrdering();
        this.populator.getQuery().setGrouping(new ArrayList());
        this.populator.getQuery().setOrdering(new ArrayList());
        this.singlePassRowProcessor.pass(odaResultSet);
        this.restoreMaxRowsGroupingOrdering(groups, sorts);
        this.populator.getQuery().setMaxRows(max);
    }

    private void handleEndOfDataSetProcess() {
        IEventHandler eventHandler = this.populator.getEventHandler();
        if (eventHandler != null) {
            eventHandler.handleEndOfDataSetProcess(this.populator.getResultIterator());
        }
    }

    private void populateDataSet(ComputedColumnsState iccState, ComputedColumnHelper computedColumnHelper, FilterByRow filterByRow, PassStatusController psController, MultiPassRowProcessorCCAssistant ccAssistant) throws DataException {
        Object[] groups = this.populator.getQuery().getGrouping();
        Object[] sorts = this.populator.getQuery().getOrdering();
        this.populator.getQuery().setGrouping(new ArrayList());
        this.populator.getQuery().setOrdering(new ArrayList());
        List aggCCList = this.prepareProcessingComputedColumns(iccState, computedColumnHelper, 0);
        if (psController.needDoOperation(1)) {
            this.doDataSetFilter(iccState, filterByRow);
        }
        if (psController.needDoOperation(2)) {
            if (!psController.needDoOperation(1)) {
                this.singlePassRowProcessor.pass(new OdiResultSetWrapper(this.populator.getResultIterator()));
            }
            computedColumnHelper.getComputedColumnList().clear();
            computedColumnHelper.getComputedColumnList().addAll(aggCCList);
            this.populateDataSetComputedColumns(iccState, computedColumnHelper, ccAssistant);
        }
        this.restoreMaxRowsGroupingOrdering(groups, sorts);
    }

    private void doDataSetFilter(ComputedColumnsState iccState, FilterByRow filterByRow) throws DataException {
        boolean changeMaxRows = filterByRow.getFilterList(2).size() + filterByRow.getFilterList(5).size() > 0;
        this.applyFilters(iccState, filterByRow, 1, changeMaxRows);
    }

    private OdiResultSetWrapper populateDataSetComputedColumns(ComputedColumnsState iccState, ComputedColumnHelper computedColumnHelper, MultiPassRowProcessorCCAssistant ccAssistant) throws DataException {
        computedColumnHelper.setModel(0);
        this.populateComputedColumns(ccAssistant, iccState, computedColumnHelper, 0);
        computedColumnHelper.setModel(4);
        return new OdiResultSetWrapper(this.populator.getResultIterator());
    }

    private void populateResultSet(ComputedColumnsState iccState, ComputedColumnHelper computedColumnHelper, FilterByRow filterByRow, PassStatusController psController, MultiPassRowProcessorCCAssistant ccAssistant) throws DataException {
        List aggCCList = this.prepareProcessingComputedColumns(iccState, computedColumnHelper, 1);
        if (psController.needDoOperation(3)) {
            this.doResultSetFilter(iccState, filterByRow);
        }
        if (psController.needDoOperation(4)) {
            if (!psController.needDoOperation(3)) {
                this.singlePassRowProcessor.pass(new OdiResultSetWrapper(this.populator.getResultIterator()));
            }
            if (aggCCList.size() != 0) {
                computedColumnHelper.getComputedColumnList().clear();
                computedColumnHelper.getComputedColumnList().addAll(aggCCList);
                this.populateResultSetTempComputedColumns(iccState, computedColumnHelper, ccAssistant);
            }
            if (psController.needDoOperation(5)) {
                this.doGroupRowFilter(filterByRow);
            }
        }
        if (!(psController.needDoOperation(2) || psController.needDoOperation(1) || psController.needDoOperation(3) || psController.needDoOperation(4))) {
            this.singlePassRowProcessor.pass(new OdiResultSetWrapper(this.populator.getResultIterator()));
        }
        if (this.populator.getQuery().getGrouping() != null || this.populator.getQuery().getGrouping().length > 0) {
            this.populator.getGroupProcessorManager().doGroupFilteringAndSorting(this.populator.getCache(), this.populator.getExpressionProcessor());
        }
    }

    private List prepareProcessingComputedColumns(ComputedColumnsState iccState, ComputedColumnHelper computedColumnHelper, int model) throws DataException {
        ArrayList aggCCList = new ArrayList();
        ArrayList simpleCCList = new ArrayList();
        if (iccState != null) {
            iccState.setModel(model);
            for (int i = 0; i < iccState.getCount(); ++i) {
                if (this.populator.getExpressionProcessor().hasAggregation(iccState.getComputedColumn(i).getExpression())) continue;
                iccState.setValueAvailable(i);
            }
        }
        if (computedColumnHelper != null) {
            computedColumnHelper.setModel(model);
            List l = computedColumnHelper.getComputedColumnList();
            for (int i = 0; i < l.size(); ++i) {
                if (this.populator.getExpressionProcessor().hasAggregation(((ComputedColumn)l.get(i)).getExpression())) {
                    aggCCList.add(l.get(i));
                    continue;
                }
                simpleCCList.add(l.get(i));
            }
            computedColumnHelper.getComputedColumnList().clear();
            computedColumnHelper.getComputedColumnList().addAll(simpleCCList);
        }
        if (iccState != null) {
            if (model == 0) {
                this.populator.getExpressionProcessor().prepareComputedColumns(iccState);
            } else if (model == 1) {
                iccState.setModel(0);
                this.populator.getExpressionProcessor().prepareComputedColumns(iccState);
                iccState.setModel(1);
                this.populator.getExpressionProcessor().prepareComputedColumns(iccState);
            }
        }
        return aggCCList;
    }

    private void doResultSetFilter(ComputedColumnsState iccState, FilterByRow filterByRow) throws DataException {
        boolean changeMaxRows = filterByRow.getFilterList(5).size() > 0;
        this.applyFilters(iccState, filterByRow, 2, changeMaxRows);
        filterByRow.setWorkingFilterSet(4);
    }

    private void populateResultSetTempComputedColumns(ComputedColumnsState iccState, ComputedColumnHelper computedColumnHelper, MultiPassRowProcessorCCAssistant ccAssistant) throws DataException {
        this.populateComputedColumns(ccAssistant, iccState, computedColumnHelper, 1);
        computedColumnHelper.setModel(4);
    }

    private void restoreMaxRowsGroupingOrdering(Object[] groupings, Object[] orderings) throws DataException {
        int j;
        BaseQuery query = this.populator.getQuery();
        ArrayList<Object> temp = new ArrayList<Object>();
        if (groupings != null) {
            for (j = 0; j < groupings.length; ++j) {
                temp.add(groupings[j]);
            }
        }
        query.setGrouping(temp);
        temp.clear();
        if (orderings != null) {
            for (j = 0; j < orderings.length; ++j) {
                temp.add(orderings[j]);
            }
        }
        query.setOrdering(temp);
    }

    private void applyFilters(ComputedColumnsState iccState, FilterByRow filterByRow, int filterType, boolean changeMaxRows) throws DataException {
        if (filterByRow != null && filterByRow.isFilterSetExist(filterType)) {
            int max = this.populator.getQuery().getMaxRows();
            if (changeMaxRows) {
                this.populator.getQuery().setMaxRows(0);
            }
            filterByRow.setWorkingFilterSet(filterType);
            new MultiPassRowProcessorFilterAssistant(this.populator, this.singlePassRowProcessor).applyFilters(new OdiResultSetWrapper(this.populator.getResultIterator()), iccState, filterByRow);
            this.populator.getQuery().setMaxRows(max);
        }
        if (filterByRow != null) {
            filterByRow.setWorkingFilterSet(4);
        }
    }

    private void populateComputedColumns(MultiPassRowProcessorCCAssistant ccAssistant, ComputedColumnsState iccState, ComputedColumnHelper computedColumnHelper, int model) throws DataException {
        iccState.setModel(model);
        if (iccState.getCount() > 0) {
            ccAssistant.populateComputedColumns(new OdiResultSetWrapper(this.populator.getResultIterator()), iccState, computedColumnHelper);
        }
    }

    private void clearTemporaryComputedColumns(ComputedColumnsState iccState, ComputedColumnHelper computedColumnHelper, MultiPassRowProcessorCCAssistant ccAssistant) throws DataException {
        iccState.setModel(2);
        ccAssistant.finalize(iccState, computedColumnHelper);
    }

    private void doGroupRowFilter(FilterByRow filterByRow) throws DataException {
        filterByRow.setWorkingFilterSet(5);
        this.singlePassRowProcessor.pass(new OdiResultSetWrapper(this.populator.getResultIterator()));
        filterByRow.setWorkingFilterSet(4);
    }

    private class PassStatusController {
        public static final int DATA_SET_FILTERING = 1;
        public static final int DATA_SET_COMPUTED_COLUMN_POPULATING = 2;
        public static final int RESULT_SET_FILTERING = 3;
        public static final int RESULT_SET_TEMP_COMPUTED_COLUMN_POPULATING = 4;
        public static final int GROUP_ROW_FILTERING = 5;
        private boolean hasDataSetFilters;
        private boolean hasDataSetCC;
        private boolean hasResultSetFilters;
        private boolean hasResultSetTempCC;
        private boolean hasGroupRowFilters;
        private boolean needMultipassProcessing;
        private boolean hasAggregationInDataSetCC;

        PassStatusController(ResultSetPopulator populator, FilterByRow filterByRow, ComputedColumnHelper computedColumnHelper) throws DataException {
            this.hasDataSetFilters = filterByRow == null ? false : filterByRow.isFilterSetExist(1);
            this.hasDataSetCC = computedColumnHelper == null ? false : computedColumnHelper.isComputedColumnExist(0);
            this.hasResultSetFilters = filterByRow == null ? false : filterByRow.isFilterSetExist(2);
            this.hasResultSetTempCC = computedColumnHelper == null ? false : computedColumnHelper.isComputedColumnExist(1);
            boolean bl = this.hasGroupRowFilters = filterByRow == null ? false : filterByRow.isFilterSetExist(5);
            if (computedColumnHelper != null) {
                computedColumnHelper.setModel(0);
                this.hasAggregationInDataSetCC = ResultSetPopulatorUtil.hasAggregationsInComputedColumns(computedColumnHelper, populator);
                computedColumnHelper.setModel(4);
            }
            this.needMultipassProcessing = this.hasAggregationInDataSetCC || FilterUtil.hasMultiPassFilters(filterByRow) || populator.getQuery().getGrouping() != null && populator.getQuery().getGrouping().length > 0 || populator.getQuery().getOrdering() != null && populator.getQuery().getOrdering().length > 0;
        }

        public boolean needDoOperation(int operType) {
            switch (operType) {
                case 1: {
                    return this.hasDataSetFilters;
                }
                case 2: {
                    return this.hasDataSetCC && (this.hasAggregationInDataSetCC || !this.hasDataSetFilters);
                }
                case 3: {
                    return this.hasResultSetFilters;
                }
                case 4: {
                    return this.hasResultSetTempCC;
                }
                case 5: {
                    return this.hasGroupRowFilters;
                }
            }
            return false;
        }

        public boolean needMultipassProcessing() {
            return this.needMultipassProcessing;
        }
    }
}

