/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform;

import java.util.ArrayList;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.ResultFieldMetadata;
import org.eclipse.birt.data.engine.executor.transform.ComputedColumnsState;
import org.eclipse.birt.data.engine.executor.transform.IComputedColumnsState;
import org.eclipse.birt.data.engine.executor.transform.OdiResultSetWrapper;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulatorUtil;
import org.eclipse.birt.data.engine.executor.transform.SinglePassRowProcessor;
import org.eclipse.birt.data.engine.impl.ComputedColumnHelper;
import org.eclipse.birt.data.engine.odi.ICustomDataSet;
import org.eclipse.birt.data.engine.odi.IResultClass;

public class MultiPassRowProcessorCCAssistant {
    private ResultSetPopulator populator;
    private SinglePassRowProcessor singlePassRowProcessor;

    MultiPassRowProcessorCCAssistant(ResultSetPopulator populator, SinglePassRowProcessor singlePassRowProcessor) {
        this.populator = populator;
        this.singlePassRowProcessor = singlePassRowProcessor;
    }

    void populateComputedColumns(OdiResultSetWrapper odaResultSet, ComputedColumnsState iccState, ComputedColumnHelper computedColumnHelper) throws DataException {
        while (this.needMoreExpressionProcessOnComputedColumns(iccState)) {
            this.makeAPassToComputedColumn(iccState, computedColumnHelper, odaResultSet.getWrappedOdiResultSet() instanceof ICustomDataSet);
        }
    }

    private boolean needMoreExpressionProcessOnComputedColumns(IComputedColumnsState iccState) {
        if (iccState == null) {
            return false;
        }
        for (int i = 0; i < iccState.getCount(); ++i) {
            if (iccState.isValueAvailable(i)) continue;
            return true;
        }
        return false;
    }

    private void makeAPassToComputedColumn(ComputedColumnsState iccState, ComputedColumnHelper computedColumnHelper, boolean isCustomDataSet) throws DataException {
        if (isCustomDataSet) {
            this.populator.setResultSetMetadata(this.rebuildCustomedResultClass(this.populator.getResultSetMetadata(), false));
        }
        this.populateComputedColumns(iccState, computedColumnHelper);
        if (isCustomDataSet) {
            this.populator.setResultSetMetadata(this.rebuildCustomedResultClass(this.populator.getResultSetMetadata(), true));
        }
        this.processCachedResultSet(this.populator);
    }

    private IResultClass rebuildCustomedResultClass(IResultClass meta, boolean returnToOriginalValue) throws DataException {
        ArrayList<ResultFieldMetadata> projectedColumns = new ArrayList<ResultFieldMetadata>();
        for (int i = 1; i <= meta.getFieldCount(); ++i) {
            projectedColumns.add(new ResultFieldMetadata(0, meta.getFieldName(i), meta.getFieldLabel(i), meta.getFieldValueClass(i), meta.getFieldNativeTypeName(i), returnToOriginalValue ? true : ResultSetPopulatorUtil.isTemporaryResultSetComputedColumn(meta.getFieldName(i))));
        }
        return new ResultClass(projectedColumns);
    }

    private void populateComputedColumns(ComputedColumnsState iccState, ComputedColumnHelper computedColumnHelper) throws DataException {
        this.calculateAggregation(iccState);
        int startValue = iccState.getLastAccessedComputedColumnIndex() + 1;
        computedColumnHelper.getComputedColumnList().clear();
        for (int i = startValue; i < iccState.getCount() && iccState.isValueAvailable(i); ++i) {
            computedColumnHelper.getComputedColumnList().add(iccState.getComputedColumn(i));
            iccState.setLastAccessedComputedColumnId(i);
        }
        computedColumnHelper.setRePrepare(true);
    }

    private void calculateAggregation(IComputedColumnsState iccState) throws DataException {
        this.populator.getExpressionProcessor().setResultIterator(this.populator.getResultIterator());
        this.populator.getExpressionProcessor().setResultSetMetaData(this.populator.getResultSetMetadata());
        this.populator.getExpressionProcessor().compileComputedColumn(iccState);
        this.populator.getExpressionProcessor().calculate();
    }

    private void processCachedResultSet(ResultSetPopulator rsp) throws DataException {
        this.singlePassRowProcessor.pass(new OdiResultSetWrapper(rsp.getResultIterator()));
    }

    private void cleanTempColumns() throws DataException {
        this.populator.setResultSetMetadata(this.rebuildResultClass(this.populator.getResultSetMetadata()));
        this.singlePassRowProcessor.initOdiResultSet(new OdiResultSetWrapper(this.populator.getResultIterator()), null);
        this.populator.getCache().reset();
        this.populator.getCache().next();
        this.populator.getGroupProcessorManager().getGroupCalculationUtil().getGroupInformationUtil().setLeaveGroupIndex(0);
    }

    private IResultClass rebuildResultClass(IResultClass meta) throws DataException {
        ArrayList<ResultFieldMetadata> projectedColumns = new ArrayList<ResultFieldMetadata>();
        for (int i = 1; i <= meta.getFieldCount(); ++i) {
            if (ResultSetPopulatorUtil.isTemporaryResultSetComputedColumn(meta.getFieldName(i))) continue;
            ResultFieldMetadata field = new ResultFieldMetadata(0, meta.getFieldName(i), meta.getFieldLabel(i), meta.getFieldValueClass(i), meta.getFieldNativeTypeName(i), meta.isCustomField(i));
            field.setAlias(meta.getFieldAlias(i));
            projectedColumns.add(field);
        }
        ResultClass result = new ResultClass(projectedColumns);
        return result;
    }

    void finalize(ComputedColumnsState iccState, ComputedColumnHelper computedColumnHelper) throws DataException {
        this.populator.getExpressionProcessor().clear();
        computedColumnHelper.setModel(4);
        this.cleanTempColumns();
    }
}

