/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform;

import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.BaseQuery;
import org.eclipse.birt.data.engine.executor.cache.CacheRequest;
import org.eclipse.birt.data.engine.executor.cache.ResultSetCache;
import org.eclipse.birt.data.engine.executor.cache.SmartCache;
import org.eclipse.birt.data.engine.executor.cache.SmartRowResultSet;
import org.eclipse.birt.data.engine.executor.transform.IExpressionProcessor;
import org.eclipse.birt.data.engine.executor.transform.MultiPassRowProcessor;
import org.eclipse.birt.data.engine.executor.transform.OdiResultSetWrapper;
import org.eclipse.birt.data.engine.executor.transform.OrderingInfo;
import org.eclipse.birt.data.engine.executor.transform.group.GroupProcessorManager;
import org.eclipse.birt.data.engine.odi.IEventHandler;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultIterator;

public class ResultSetPopulator {
    private ResultSetCache smartCache;
    private IExpressionProcessor exprProcessor = null;
    private BaseQuery query;
    private IResultClass rsMeta;
    private IResultIterator ri;
    private GroupProcessorManager groupProcessorManager;
    private IEventHandler eventHandler;

    private ResultSetPopulator(BaseQuery query, IResultClass rsMeta, IResultIterator ri) throws DataException {
        this.query = query;
        this.rsMeta = rsMeta;
        this.ri = ri;
        this.groupProcessorManager = new GroupProcessorManager(query, this.ri, this.rsMeta, this);
        this.exprProcessor = query.getExprProcessor();
        this.exprProcessor.setQuery(this.query);
        this.exprProcessor.setResultSetPopulator(this);
    }

    ResultSetPopulator(BaseQuery query, IResultClass rsMeta, IResultIterator ri, IEventHandler eventHandler) throws DataException {
        this(query, rsMeta, ri);
        this.eventHandler = eventHandler;
    }

    public IEventHandler getEventHandler() {
        return this.eventHandler;
    }

    public GroupProcessorManager getGroupProcessorManager() {
        return this.groupProcessorManager;
    }

    public BaseQuery getQuery() {
        return this.query;
    }

    void setQuery(BaseQuery query) {
        this.query = query;
    }

    public ResultSetCache getCache() {
        return this.smartCache;
    }

    public void setCache(ResultSetCache cache) {
        this.smartCache = cache;
    }

    public IResultClass getResultSetMetadata() {
        return this.rsMeta;
    }

    public void setResultSetMetadata(IResultClass resultMeta) {
        this.rsMeta = resultMeta;
    }

    public IResultIterator getResultIterator() {
        return this.ri;
    }

    public IExpressionProcessor getExpressionProcessor() {
        return this.exprProcessor;
    }

    public void populateResultSet(OdiResultSetWrapper odaResultSet) throws DataException {
        new MultiPassRowProcessor(this).pass(odaResultSet);
    }

    public void reSetSmartCacheUsingOrderingInfo(OrderingInfo odInfo) throws DataException {
        this.reSetCache(odInfo);
        this.groupProcessorManager.getGroupCalculationUtil().getGroupInformationUtil().doGrouping();
        this.getCache().next();
    }

    public void reSetCache(OrderingInfo odInfo) throws DataException {
        this.getCache().reset();
        this.getCache().next();
        this.setCache(new SmartCache(new CacheRequest(this.query.getMaxRows(), this.query.getFetchEvents(), null, this.getEventHandler()), new SmartRowResultSet(this.getCache(), this.rsMeta, odInfo), this.rsMeta));
        this.groupProcessorManager.getGroupCalculationUtil().setResultSetCache(this.getCache());
    }

    void first(int groupLevel) throws DataException {
        this.groupProcessorManager.getGroupCalculationUtil().getGroupInformationUtil().first(groupLevel);
    }

    void last(int groupLevel) throws DataException {
        this.groupProcessorManager.getGroupCalculationUtil().getGroupInformationUtil().last(groupLevel);
    }

    int getEndingGroupLevel() throws DataException {
        return this.groupProcessorManager.getGroupCalculationUtil().getGroupInformationUtil().getEndingGroupLevel();
    }

    int getStartingGroupLevel() throws DataException {
        return this.getGroupProcessorManager().getGroupCalculationUtil().getGroupInformationUtil().getStartingGroupLevel();
    }

    int getCurrentGroupIndex(int groupLevel) throws DataException {
        return this.getGroupProcessorManager().getGroupCalculationUtil().getGroupInformationUtil().getCurrentGroupIndex(groupLevel);
    }

    public int[] getGroupStartAndEndIndex(int groupLevel) throws DataException {
        return this.getGroupProcessorManager().getGroupCalculationUtil().getGroupInformationUtil().getGroupStartAndEndIndex(groupLevel);
    }
}

