/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform.group;

import java.util.List;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.BaseQuery;
import org.eclipse.birt.data.engine.executor.cache.ResultSetCache;
import org.eclipse.birt.data.engine.executor.transform.IExpressionProcessor;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.executor.transform.group.GroupCalculationUtil;
import org.eclipse.birt.data.engine.executor.transform.group.GroupInstanceFilter;
import org.eclipse.birt.data.engine.executor.transform.group.GroupInstanceSorter;
import org.eclipse.birt.data.engine.executor.transform.group.GroupWithIntervalsProcessor;
import org.eclipse.birt.data.engine.odi.IQuery;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.mozilla.javascript.Context;

public class GroupProcessorManager {
    private GroupCalculationUtil groupCalculationUtil;
    private ResultSetPopulator populator;
    private IExpressionProcessor exprProcessor;

    public GroupProcessorManager(BaseQuery query, IResultIterator ri, IResultClass rsMeta, ResultSetPopulator populator) throws DataException {
        this.populator = populator;
        this.groupCalculationUtil = new GroupCalculationUtil(query, populator.getResultSetMetadata(), this.populator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGroupFilteringAndSorting(ResultSetCache rsCache, IExpressionProcessor exprProc) throws DataException {
        this.populator.setCache(rsCache);
        this.exprProcessor = exprProc;
        this.exprProcessor.setResultIterator(this.populator.getResultIterator());
        Context cx = Context.enter();
        try {
            new GroupInstanceFilter(this).doGroupFiltering(cx);
            new GroupInstanceSorter(this).doGroupSorting(cx);
        }
        finally {
            Context.exit();
        }
    }

    public void processGroupWithIntervals(ResultSetCache rsCache, IQuery.GroupSpec[] groups, IExpressionProcessor iep) throws DataException {
        this.exprProcessor = iep;
        this.exprProcessor.setResultIterator(this.populator.getResultIterator());
        new GroupWithIntervalsProcessor(this).processGroupWithIntervals(rsCache, groups);
    }

    public void calculateExpressionList(List expressionList, List groupLevelList, int type) throws DataException {
        int[] groupLevelArray = new int[groupLevelList.size()];
        for (int i = 0; i < groupLevelList.size(); ++i) {
            groupLevelArray[i] = (Integer)groupLevelList.get(i);
        }
        this.exprProcessor.calculate(expressionList.toArray(), groupLevelArray, type);
    }

    public IExpressionProcessor getExpressionProcessor() {
        return this.exprProcessor;
    }

    public ResultSetPopulator getResultSetPopulator() {
        return this.populator;
    }

    public GroupCalculationUtil getGroupCalculationUtil() {
        return this.groupCalculationUtil;
    }
}

