/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.sql.Blob;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.api.IInputParameterBinding;
import org.eclipse.birt.data.engine.api.IParameterDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ComputedColumn;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.script.IDataSourceInstanceHandle;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.BaseQuery;
import org.eclipse.birt.data.engine.executor.DataSetCacheManager;
import org.eclipse.birt.data.engine.executor.JointDataSetQuery;
import org.eclipse.birt.data.engine.executor.dscache.DataSourceQuery;
import org.eclipse.birt.data.engine.executor.transform.IExpressionProcessor;
import org.eclipse.birt.data.engine.expression.ExpressionProcessor;
import org.eclipse.birt.data.engine.expression.FilterExpressionParser;
import org.eclipse.birt.data.engine.impl.ColumnInfo;
import org.eclipse.birt.data.engine.impl.ComputedColumnHelper;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.impl.DataSourceRuntime;
import org.eclipse.birt.data.engine.impl.DummyICCState;
import org.eclipse.birt.data.engine.impl.ExecutorHelper;
import org.eclipse.birt.data.engine.impl.ExpressionUtil;
import org.eclipse.birt.data.engine.impl.FilterByRow;
import org.eclipse.birt.data.engine.impl.IExecutorHelper;
import org.eclipse.birt.data.engine.impl.IQueryExecutor;
import org.eclipse.birt.data.engine.impl.IQueryService;
import org.eclipse.birt.data.engine.impl.PreparedOdaDSQuery;
import org.eclipse.birt.data.engine.impl.PreparedScriptDSQuery;
import org.eclipse.birt.data.engine.impl.QueryExecutorUtil;
import org.eclipse.birt.data.engine.impl.ResultMetaData;
import org.eclipse.birt.data.engine.impl.aggregation.AggregateCalculator;
import org.eclipse.birt.data.engine.impl.aggregation.AggregateTable;
import org.eclipse.birt.data.engine.odaconsumer.ParameterHint;
import org.eclipse.birt.data.engine.odi.ICandidateQuery;
import org.eclipse.birt.data.engine.odi.IDataSource;
import org.eclipse.birt.data.engine.odi.IEventHandler;
import org.eclipse.birt.data.engine.odi.IPreparedDSQuery;
import org.eclipse.birt.data.engine.odi.IQuery;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.eclipse.birt.data.engine.script.OnFetchScriptHelper;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public abstract class QueryExecutor
implements IQueryExecutor {
    private IBaseQueryDefinition baseQueryDefn;
    private AggregateTable aggrTable;
    private AggregateCalculator aggregates;
    private Scriptable sharedScope;
    private Scriptable parentScope;
    private Scriptable queryScope;
    private boolean isPrepared = false;
    private boolean isExecuted = false;
    private Map queryAppContext;
    private int nestedLevel = 1;
    protected DataSourceRuntime dataSource;
    protected DataSetRuntime dataSet;
    protected IDataSource odiDataSource;
    protected IQuery odiQuery;
    protected IQueryService outerResults;
    private IResultIterator odiResult;
    private IExecutorHelper parentHelper;
    private List temporaryComputedColumns = new ArrayList();
    private static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    QueryExecutor(Scriptable sharedScope, IBaseQueryDefinition baseQueryDefn, AggregateTable aggrTable) {
        this.sharedScope = sharedScope;
        this.baseQueryDefn = baseQueryDefn;
        this.aggrTable = aggrTable;
    }

    protected abstract DataSourceRuntime findDataSource() throws DataException;

    protected abstract DataSetRuntime newDataSetRuntime() throws DataException;

    protected abstract IDataSource createOdiDataSource() throws DataException;

    protected abstract IQuery createOdiQuery() throws DataException;

    protected void prepareOdiQuery() throws DataException {
    }

    protected abstract IResultIterator executeOdiQuery(IEventHandler var1) throws DataException;

    void setAppContext(Map context) {
        this.queryAppContext = context;
    }

    void prepareExecution(IQueryResults outerRts, Scriptable targetScope) throws DataException {
        if (this.isPrepared) {
            return;
        }
        this.parentScope = targetScope;
        this.dataSource = this.findDataSource();
        if (outerRts != null) {
            this.outerResults = (IQueryService)((Object)outerRts);
            if (this.outerResults.isClosed()) {
                throw new DataException("data.engine.ResultClosed");
            }
            this.nestedLevel = this.outerResults.getNestedLevel();
            this.setParentExecutorHelper(this.outerResults.getExecutorHelper());
        }
        this.dataSet = this.newDataSetRuntime();
        if (!$assertionsDisabled && this.dataSet == null) {
            throw new AssertionError();
        }
        this.openDataSource();
        this.dataSet.beforeOpen();
        ExpressionProcessor exprProcessor = new ExpressionProcessor(null, null, this.dataSet, null);
        this.odiQuery = this.createOdiQuery();
        this.odiQuery.setDistinctValueFlag(this.dataSet.needDistinctValue());
        this.odiQuery.setExprProcessor(exprProcessor);
        this.populateOdiQuery();
        this.prepareOdiQuery();
        this.isPrepared = true;
    }

    protected void openDataSource() throws DataException {
        if (!$assertionsDisabled && this.odiDataSource != null) {
            throw new AssertionError();
        }
        if (this.dataSource != null) {
            if (!this.dataSource.isOpen() || DataSetCacheManager.getInstance().doesLoadFromCache()) {
                this.dataSource.beforeOpen();
                this.odiDataSource = this.createOdiDataSource();
                this.odiDataSource.setAppContext(this.queryAppContext);
                this.dataSource.openOdiDataSource(this.odiDataSource);
                this.dataSource.afterOpen();
            } else {
                this.odiDataSource = this.dataSource.getOdiDataSource();
                this.odiDataSource.setAppContext(this.queryAppContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateOdiQuery() throws DataException {
        if (!$assertionsDisabled && this.odiQuery == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.baseQueryDefn == null) {
            throw new AssertionError();
        }
        Context cx = Context.enter();
        try {
            int i;
            this.populateGrouping(cx);
            List sorts = this.baseQueryDefn.getSorts();
            if (sorts != null && !sorts.isEmpty()) {
                IQuery.SortSpec[] sortSpecs = new IQuery.SortSpec[sorts.size()];
                Iterator it = sorts.iterator();
                i = 0;
                while (it.hasNext()) {
                    IQuery.SortSpec dest;
                    ISortDefinition src = (ISortDefinition)it.next();
                    int sortIndex = -1;
                    String sortKey = src.getColumn();
                    sortKey = sortKey == null ? src.getExpression().getText() : this.getColumnRefExpression(sortKey);
                    this.temporaryComputedColumns.add(new ComputedColumn("_{$TEMP_SORT_" + i + "$}_", sortKey, 0));
                    sortIndex = -1;
                    sortKey = String.valueOf("_{$TEMP_SORT_" + i + "$}_");
                    sortSpecs[i] = dest = new IQuery.SortSpec(sortIndex, sortKey, src.getSortDirection() == 0);
                    ++i;
                }
                this.odiQuery.setOrdering(Arrays.asList(sortSpecs));
            }
            List dataSetFilters = new ArrayList();
            ArrayList queryFilters = new ArrayList();
            if (this.dataSet.getFilters() != null) {
                dataSetFilters = this.dataSet.getFilters();
            }
            if (this.baseQueryDefn.getFilters() != null) {
                for (i = 0; i < this.baseQueryDefn.getFilters().size(); ++i) {
                    queryFilters.add(this.baseQueryDefn.getFilters().get(i));
                }
            }
            List multipassFilters = this.prepareFilters(cx, dataSetFilters, queryFilters, this.temporaryComputedColumns);
            ArrayList computedColumns = null;
            computedColumns = this.dataSet.getComputedColumns();
            if (computedColumns == null) {
                computedColumns = new ArrayList();
            }
            if (computedColumns.size() > 0 || this.temporaryComputedColumns.size() > 0) {
                ComputedColumnHelper objectEvent = new ComputedColumnHelper(this.dataSet, computedColumns, this.temporaryComputedColumns);
                this.odiQuery.addOnFetchEvent(objectEvent);
                this.dataSet.getComputedColumns().addAll(this.temporaryComputedColumns);
            }
            if (this.dataSet.getEventHandler() != null) {
                OnFetchScriptHelper event = new OnFetchScriptHelper(this.dataSet);
                this.odiQuery.addOnFetchEvent(event);
            }
            if (dataSetFilters.size() + queryFilters.size() + multipassFilters.size() > 0) {
                FilterByRow objectEvent = new FilterByRow(dataSetFilters, queryFilters, multipassFilters, this.dataSet);
                this.odiQuery.addOnFetchEvent(objectEvent);
            }
            this.odiQuery.setMaxRows(this.baseQueryDefn.getMaxRows());
            this.prepareCacheQuery();
        }
        finally {
            Context.exit();
        }
    }

    private void prepareCacheQuery() {
        if (this.odiQuery instanceof DataSourceQuery && this.temporaryComputedColumns != null && this.temporaryComputedColumns.size() > 0) {
            ((DataSourceQuery)this.odiQuery).setTempComputedColumn(this.temporaryComputedColumns);
        }
    }

    private void populateGrouping(Context cx) throws DataException {
        List groups = this.baseQueryDefn.getGroups();
        if (groups != null && !groups.isEmpty()) {
            IQuery.GroupSpec[] groupSpecs = new IQuery.GroupSpec[groups.size()];
            Iterator it = groups.iterator();
            int i = 0;
            while (it.hasNext()) {
                IQuery.GroupSpec dest;
                IGroupDefinition src = (IGroupDefinition)it.next();
                if (!(src.getKeyColumn() != null && src.getKeyColumn().trim().length() != 0 || src.getKeyExpression() != null && src.getKeyExpression().trim().length() != 0)) {
                    throw new DataException("data.engine.BadGroupExpr");
                }
                String expr = this.getGroupKeyExpression(src);
                String groupName = "";
                groupName = expr.trim().equalsIgnoreCase("row[0]") || expr.trim().equalsIgnoreCase("row._rowPosition") || expr.trim().equalsIgnoreCase("dataSetRow[0]") || expr.trim().equalsIgnoreCase("dataSetRow._rowPosition") ? "_{$TEMP_GROUP_" + i + "ROWID$}_" : "_{$TEMP_GROUP_" + i + "$}_";
                if (src.getInterval() != 0 && src.getIntervalRange() != 0.0) {
                    try {
                        expr = ExpressionUtil.createGroupByExpression(src.getInterval(), src.getIntervalStart(), this.getGroupKeyExpression(src), src.getIntervalRange(), this.getColumnDataType(cx, expr));
                    }
                    catch (BirtException be) {
                        throw DataException.wrap(be);
                    }
                }
                groupSpecs[i] = dest = QueryExecutorUtil.groupDefnToSpec(cx, src, expr, groupName, -1);
                if (dest.getInterval() != 0 && dest.getIntervalRange() != 0.0) {
                    if (dest.getInterval() == 100) {
                        this.temporaryComputedColumns.add(new ComputedColumn(groupName, expr, 5));
                    } else {
                        this.temporaryComputedColumns.add(new ComputedColumn(groupName, expr, 2));
                    }
                } else {
                    this.temporaryComputedColumns.add(new ComputedColumn(groupName, expr, QueryExecutorUtil.getTempComputedColumnType(groupSpecs[i].getInterval())));
                }
                ++i;
            }
            this.odiQuery.setGrouping(Arrays.asList(groupSpecs));
        }
    }

    private int getColumnDataType(Context cx, String expr) {
        String columnName = QueryExecutorUtil.getColInfoFromJSExpr(cx, expr).getColumnName();
        if (columnName == null) {
            return -1;
        }
        if (columnName.equals("__rownum")) {
            return 2;
        }
        Object baseExpr = this.baseQueryDefn.getResultSetExpressions().get(columnName);
        if (baseExpr == null) {
            return -1;
        }
        return ((IBaseExpression)baseExpr).getDataType();
    }

    private String getGroupKeyExpression(IGroupDefinition src) {
        String expr = src.getKeyColumn();
        expr = expr == null ? src.getKeyExpression() : this.getColumnRefExpression(expr);
        return expr;
    }

    private String getColumnRefExpression(String expr) {
        return "row[\"" + JavascriptEvalUtil.transformToJsConstants((String)expr) + "\"]";
    }

    void setParentExecutorHelper(IExecutorHelper helper) {
        this.parentHelper = helper;
    }

    private List prepareFilters(Context cx, List dataSetFilters, List queryFilters, List temporaryComputedColumns) {
        ArrayList result = new ArrayList();
        this.prepareFilter(cx, dataSetFilters, temporaryComputedColumns, result);
        this.prepareFilter(cx, queryFilters, temporaryComputedColumns, result);
        return result;
    }

    private void prepareFilter(Context cx, List dataSetFilters, List temporaryComputedColumns, List result) {
        if (dataSetFilters != null && !dataSetFilters.isEmpty()) {
            Iterator it = dataSetFilters.iterator();
            int i = 0;
            while (it.hasNext()) {
                IFilterDefinition src = (IFilterDefinition)it.next();
                IBaseExpression expr = src.getExpression();
                if (this.isGroupFilter(src)) {
                    ConditionalExpression ce = (ConditionalExpression)expr;
                    String exprText = ce.getExpression().getText();
                    ColumnInfo columnInfo = QueryExecutorUtil.getColInfoFromJSExpr(cx, exprText);
                    int index = columnInfo.getColumnIndex();
                    String name = columnInfo.getColumnName();
                    if (name == null && index < 0) {
                        temporaryComputedColumns.add(new ComputedColumn("_{$TEMP_FILTER_" + i + "$}_", exprText, 0));
                        it.remove();
                        result.add(new FilterDefinition(new ConditionalExpression(new ScriptExpression(String.valueOf("dataSetRow[\"_{$TEMP_FILTER_" + i + "$}_\"]")), ce.getOperator(), ce.getOperand1(), ce.getOperand2())));
                    }
                }
                ++i;
            }
        }
    }

    private boolean isGroupFilter(IFilterDefinition filter) {
        IBaseExpression expr = filter.getExpression();
        if (expr instanceof IConditionalExpression) {
            String expr4Exception = ((ConditionalExpression)expr).getExpression().getText();
            try {
                new FilterExpressionParser(null, null).compileFilterExpression(expr4Exception);
            }
            catch (DataException e) {
                return true;
            }
        }
        return false;
    }

    public IResultMetaData getResultMetaData() throws DataException {
        if (!($assertionsDisabled || this.odiQuery instanceof IPreparedDSQuery || this.odiQuery instanceof ICandidateQuery || this.odiQuery instanceof JointDataSetQuery)) {
            throw new AssertionError();
        }
        if (this.odiQuery instanceof IPreparedDSQuery) {
            if (((IPreparedDSQuery)((Object)this.odiQuery)).getResultClass() != null) {
                return new ResultMetaData(((IPreparedDSQuery)((Object)this.odiQuery)).getResultClass());
            }
            return null;
        }
        if (this.odiQuery instanceof JointDataSetQuery) {
            return new ResultMetaData(((JointDataSetQuery)this.odiQuery).getResultClass());
        }
        return new ResultMetaData(((ICandidateQuery)this.odiQuery).getResultClass());
    }

    public void execute(IEventHandler eventHandler) throws DataException {
        logger.logp(Level.FINER, QueryExecutor.class.getName(), "execute", "Start to execute");
        if (this.isExecuted) {
            return;
        }
        ExecutorHelper helper = new ExecutorHelper(this.getQueryScope());
        helper.setParent(this.parentHelper);
        eventHandler.setExecutorHelper(helper);
        this.odiResult = this.executeOdiQuery(eventHandler);
        if (this.odiQuery instanceof BaseQuery) {
            IExpressionProcessor ep = ((BaseQuery)this.odiQuery).getExprProcessor();
            Map results = this.baseQueryDefn.getResultSetExpressions();
            Object[] o = results.values().toArray();
            Object[] names = results.keySet().toArray();
            DummyICCState iccState = new DummyICCState(o, names);
            ep.setResultIterator(this.odiResult);
            while (!iccState.isFinish()) {
                ep.compileExpression(iccState);
                ep.calculate();
            }
        }
        helper.setJSRowObject(this.dataSet.getJSResultRowObject());
        this.resetComputedColumns();
        this.dataSet.setResultSet(this.odiResult, false);
        this.aggregates = new AggregateCalculator(this.aggrTable, this.odiResult);
        this.aggregates.calculate(this.getQueryScope());
        this.isExecuted = true;
        logger.logp(Level.FINER, QueryExecutor.class.getName(), "execute", "Finish executing");
    }

    private void resetComputedColumns() {
        List l = this.getDataSet().getComputedColumns();
        if (l != null) {
            l.removeAll(this.temporaryComputedColumns);
        }
    }

    public void close() {
        if (this.odiQuery == null) {
            logger.logp(Level.FINER, QueryExecutor.class.getName(), "close", "executor closed ");
            return;
        }
        try {
            this.dataSet.beforeClose();
        }
        catch (DataException e) {
            logger.logp(Level.FINE, QueryExecutor.class.getName(), "close", e.getMessage(), (Throwable)((Object)e));
        }
        if (this.odiResult != null) {
            this.odiResult.close();
        }
        this.odiQuery.close();
        try {
            this.dataSet.close();
        }
        catch (DataException e) {
            logger.logp(Level.FINE, QueryExecutor.class.getName(), "close", e.getMessage(), (Throwable)((Object)e));
        }
        this.odiQuery = null;
        this.odiDataSource = null;
        this.aggregates = null;
        this.odiResult = null;
        this.queryScope = null;
        this.isPrepared = false;
        this.isExecuted = false;
        try {
            this.dataSet.afterClose();
        }
        catch (DataException e) {
            logger.logp(Level.FINE, QueryExecutor.class.getName(), "close", e.getMessage(), (Throwable)((Object)e));
        }
        this.dataSet = null;
        this.dataSource = null;
        logger.logp(Level.FINER, QueryExecutor.class.getName(), "close", "executor closed ");
    }

    public DataSetRuntime getDataSet() {
        return this.dataSet;
    }

    public Scriptable getSharedScope() {
        return this.sharedScope;
    }

    public Scriptable getQueryScope() {
        if (this.queryScope == null) {
            this.queryScope = this.newSubScope(this.parentScope);
            this.queryScope.setPrototype(this.dataSet.getJSDataSetObject());
        }
        return this.queryScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Scriptable newSubScope(Scriptable parentAndProtoScope) {
        if (parentAndProtoScope == null) {
            parentAndProtoScope = this.sharedScope;
        }
        Context cx = Context.enter();
        try {
            Scriptable scope = cx.newObject(parentAndProtoScope);
            scope.setParentScope(parentAndProtoScope);
            scope.setPrototype(parentAndProtoScope);
            Scriptable scriptable = scope;
            return scriptable;
        }
        finally {
            Context.exit();
        }
    }

    public int getNestedLevel() {
        return this.nestedLevel;
    }

    public IDataSourceInstanceHandle getDataSourceInstanceHandle() {
        return this.dataSource;
    }

    public Scriptable getJSAggrValueObject() {
        if (this.aggregates != null) {
            return this.aggregates.getJSAggrValueObject();
        }
        return null;
    }

    public DataSetRuntime[] getNestedDataSets(int nestedCount) {
        return this.outerResults.getDataSetRuntime(nestedCount);
    }

    public IResultIterator getOdiResultSet() {
        return this.odiResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection resolveDataSetParameters(boolean evaluateValue) throws DataException {
        if (!($assertionsDisabled || this instanceof PreparedOdaDSQuery.OdaDSQueryExecutor || this instanceof PreparedScriptDSQuery.ScriptDSQueryExecutor)) {
            throw new AssertionError();
        }
        List paramDefns = this.getDataSet().getParameters();
        int nParams = paramDefns == null ? 0 : paramDefns.size();
        ParameterHint[] paramHints = new ParameterHint[nParams];
        boolean[] bindingResolved = new boolean[nParams];
        for (int i = 0; i < nParams; ++i) {
            IParameterDefinition paramDefn = (IParameterDefinition)paramDefns.get(i);
            paramHints[i] = this.createParameterHint(paramDefn, paramDefn.getDefaultInputValue());
            bindingResolved[i] = false;
            if (!paramDefn.isInputMode() || paramDefn.getName() == null) continue;
            Object paramValue = DataSetRuntime.UNSET_VALUE;
            try {
                paramValue = this.getDataSet().getInputParameterValue(paramDefn.getName());
            }
            catch (BirtException e) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                throw DataException.wrap(e);
            }
            if (paramValue == DataSetRuntime.UNSET_VALUE) continue;
            String paramValueStr = this.getParameterValueString(paramHints[i].getDataType(), paramValue);
            paramHints[i].setDefaultInputValue(paramValueStr);
            bindingResolved[i] = true;
        }
        Context cx = null;
        if (evaluateValue) {
            cx = Context.enter();
        }
        try {
            this.resolveParameterBindings(((IQueryDefinition)this.baseQueryDefn).getInputParamBindings(), paramHints, bindingResolved, cx);
            this.resolveParameterBindings(this.getDataSet().getInputParamBindings(), paramHints, bindingResolved, cx);
        }
        finally {
            if (cx != null) {
                Context.exit();
            }
        }
        return Arrays.asList(paramHints);
    }

    private void resolveParameterBindings(Collection bindings, ParameterHint[] paramHints, boolean[] bindingResolved, Context cx) throws DataException {
        if (bindings == null) {
            return;
        }
        Iterator it = bindings.iterator();
        while (it.hasNext()) {
            this.resolveParameterBinding((IInputParameterBinding)it.next(), paramHints, bindingResolved, cx);
        }
    }

    private void resolveParameterBinding(IInputParameterBinding binding, ParameterHint[] paramHints, boolean[] bindingResolved, Context cx) throws DataException {
        int i = this.findParameterHint(paramHints, binding.getPosition(), binding.getName());
        if (i < 0) {
            logger.warning("Ignored binding defined for non-exising data set parameter: name=" + binding.getName() + ", position=" + binding.getPosition());
        } else if (!bindingResolved[i]) {
            IBaseExpression value = cx != null ? this.evaluateInputParameterValue(this.getQueryScope(), cx, binding) : binding.getExpr();
            String valueStr = this.getParameterValueString(paramHints[i].getDataType(), value);
            paramHints[i].setDefaultInputValue(valueStr);
            bindingResolved[i] = true;
            if (cx != null && paramHints[i].isInputMode() && paramHints[i].getName() != null) {
                try {
                    this.getDataSet().setInputParameterValue(paramHints[i].getName(), value);
                }
                catch (BirtException e) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    throw DataException.wrap(e);
                }
            }
        }
    }

    private int findParameterHint(ParameterHint[] hints, int position, String name) {
        for (int i = 0; i < hints.length; ++i) {
            ParameterHint paramHint = hints[i];
            if (!(position <= 0 ? paramHint.getName().equalsIgnoreCase(name) : paramHint.getPosition() == position)) continue;
            return i;
        }
        return -1;
    }

    private Object evaluateInputParameterValue(Scriptable scope, Context cx, IInputParameterBinding iParamBind) throws DataException {
        Object evaluateResult = null;
        Scriptable evaluateScope = scope;
        if (this.outerResults != null) {
            try {
                evaluateScope = this.outerResults.getQueryScope();
                evaluateResult = this.outerResults.getExecutorHelper().evaluate(iParamBind.getExpr());
            }
            catch (BirtException e) {
                DataException dataEx = new DataException("data.engine.UnexpectedError", e);
                logger.logp(Level.FINE, PreparedOdaDSQuery.class.getName(), "getMergedParameters", "Error occurs in IQueryResults.getResultIterator()", e);
                throw dataEx;
            }
        }
        if (evaluateResult == null) {
            evaluateResult = ScriptEvalUtil.evalExpr(iParamBind.getExpr(), cx, evaluateScope, "ParamBinding(" + iParamBind.getName() + ")", 0);
        }
        if (evaluateResult == null) {
            throw new DataException("data.engine.NullDefaultInParamValue");
        }
        return evaluateResult;
    }

    private String getParameterValueString(Class paramType, Object paramValue) throws DataException {
        if (paramValue instanceof String) {
            return (String)paramValue;
        }
        try {
            paramValue = DataTypeUtil.convert((Object)paramValue, (Class)paramType);
            return DataTypeUtil.toString((Object)paramValue);
        }
        catch (BirtException e) {
            throw new DataException("data.engine.DataConversionError", e);
        }
    }

    private ParameterHint createParameterHint(IParameterDefinition paramDefn, Object paramValue) throws DataException {
        Class dataTypeClass;
        if (!$assertionsDisabled && paramValue == null) {
            throw new AssertionError();
        }
        ParameterHint parameterHint = new ParameterHint(paramDefn.getName(), paramDefn.isInputMode(), paramDefn.isOutputMode());
        if (paramDefn.getPosition() > 0) {
            parameterHint.setPosition(paramDefn.getPosition());
        }
        if ((dataTypeClass = DataType.getClass((int)paramDefn.getType())) == DataType.AnyType.class || dataTypeClass == Boolean.class || dataTypeClass == Blob.class) {
            dataTypeClass = String.class;
        }
        parameterHint.setDataType(dataTypeClass);
        parameterHint.setIsInputOptional(paramDefn.isInputOptional());
        parameterHint.setDefaultInputValue(this.getParameterValueString(dataTypeClass, paramValue));
        parameterHint.setIsNullable(paramDefn.isNullable());
        return parameterHint;
    }

    static {
        $assertionsDisabled = !QueryExecutor.class.desiredAssertionStatus();
        logger = Logger.getLogger(DataEngineImpl.class.getName());
    }
}

