/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IScriptDataSetDesign;
import org.eclipse.birt.data.engine.api.script.IScriptDataSetEventHandler;
import org.eclipse.birt.data.engine.api.script.IScriptDataSetMetaDataDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultFieldMetadata;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.impl.IQueryExecutor;
import org.eclipse.birt.data.engine.impl.ScriptDataSourceRuntime;

public class ScriptDataSetRuntime
extends DataSetRuntime
implements IScriptDataSetMetaDataDefinition {
    private IScriptDataSetEventHandler scriptEventHandler;
    private List describedColumns;
    static final /* synthetic */ boolean $assertionsDisabled;

    ScriptDataSetRuntime(IScriptDataSetDesign dataSet, IQueryExecutor executor) {
        super(dataSet, executor);
        if (this.getEventHandler() instanceof IScriptDataSetEventHandler) {
            this.scriptEventHandler = (IScriptDataSetEventHandler)this.getEventHandler();
        }
        logger.log(Level.FINER, "ScriptDataSetRuntime starts up");
    }

    public IScriptDataSetDesign getSubdesign() {
        return (IScriptDataSetDesign)this.getDesign();
    }

    public ScriptDataSourceRuntime getScriptDataSource() {
        if (!$assertionsDisabled && !(this.getDataSource() instanceof ScriptDataSourceRuntime)) {
            throw new AssertionError();
        }
        return (ScriptDataSourceRuntime)this.getDataSource();
    }

    public void open() throws DataException {
        if (this.scriptEventHandler != null) {
            try {
                this.scriptEventHandler.handleOpen(this);
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
        }
    }

    public boolean fetch() throws DataException {
        if (this.scriptEventHandler != null) {
            try {
                return this.scriptEventHandler.handleFetch(this, this.getDataRow());
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
        }
        return false;
    }

    public void close() throws DataException {
        if (this.scriptEventHandler != null) {
            try {
                this.scriptEventHandler.handleClose(this);
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
        }
        super.close();
    }

    public void addColumn(String name, Class dataType) throws BirtException {
        if (this.describedColumns == null) {
            this.describedColumns = new ArrayList();
        }
        if (name == null || name.length() == 0) {
            throw new DataException("data.engine.EmptyCustomFieldName");
        }
        if (dataType == null) {
            throw new DataException("data.engine.BadDataType");
        }
        int nextIndex = this.describedColumns.size() + 1;
        ResultFieldMetadata c = new ResultFieldMetadata(nextIndex, name, name, dataType, dataType.getName(), true);
        this.describedColumns.add(c);
    }

    public boolean describe() throws DataException {
        if (this.scriptEventHandler != null) {
            try {
                return this.scriptEventHandler.handleDescribe(this, this);
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
        }
        return false;
    }

    public String getExtensionID() {
        return "SCRIPT";
    }

    List getDescribedMetaData() {
        return this.describedColumns;
    }

    static {
        $assertionsDisabled = !ScriptDataSetRuntime.class.desiredAssertionStatus();
    }
}

