/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.transform.group.GroupInfo;

public class GroupInfoUtil {
    static final /* synthetic */ boolean $assertionsDisabled;

    public static List[] getGroupInfo(List[] groups, int[] indexArray) throws DataException {
        HashMap<GroupInfo, Integer> deleteNumMap = new HashMap<GroupInfo, Integer>();
        if (groups == null || groups.length == 0 || indexArray == null) {
            return groups;
        }
        List endLevelList = groups[groups.length - 1];
        if (GroupInfoUtil.validateGroupLevel(endLevelList, indexArray)) {
            int firstChild = -1;
            int count = 0;
            int startCount = 0;
            GroupInfo baseInfo = (GroupInfo)endLevelList.get(0);
            for (int i = 1; i < endLevelList.size(); ++i) {
                count = 0;
                GroupInfo info = (GroupInfo)endLevelList.get(i);
                firstChild = info.firstChild;
                while (startCount < indexArray.length && indexArray[startCount] < firstChild && indexArray[startCount] >= baseInfo.firstChild) {
                    ++startCount;
                    ++count;
                }
                if (count < firstChild - baseInfo.firstChild) {
                    deleteNumMap.put(info, new Integer(firstChild - baseInfo.firstChild - count));
                }
                baseInfo = info;
            }
        } else {
            throw new DataException("data.engine.document.invalidIndexArray");
        }
        return GroupInfoUtil.cleanUnUsedGroupInstance(GroupInfoUtil.doRefactorOnGroupInfo(groups, deleteNumMap));
    }

    private static List[] doRefactorOnGroupInfo(List[] groups, Map deletedNumMap) throws DataException {
        int deleteNum;
        GroupInfo info;
        int i;
        List endLevelList = groups[groups.length - 1];
        for (i = 1; i < endLevelList.size(); ++i) {
            info = (GroupInfo)endLevelList.get(i);
            if (deletedNumMap.get(info) == null || (deleteNum = ((Integer)deletedNumMap.get(info)).intValue()) <= 0 || !GroupInfoUtil.refactorOnGroup(groups, i, deleteNum, groups.length - 1)) continue;
            deletedNumMap.remove(info);
        }
        for (i = 1; i < endLevelList.size(); ++i) {
            info = (GroupInfo)endLevelList.get(i);
            if (deletedNumMap.get(info) == null || (deleteNum = ((Integer)deletedNumMap.get(info)).intValue()) <= 0) continue;
            GroupInfoUtil.resetStatus(groups, i, deleteNum, groups.length - 1);
        }
        return groups;
    }

    private static boolean refactorOnGroup(List[] groups, int groupIndex, int deletedNum, int level) throws DataException {
        List levelList = groups[level];
        GroupInfo groupInfo = (GroupInfo)levelList.get(groupIndex);
        GroupInfo baseInfo = (GroupInfo)levelList.get(groupIndex - 1);
        if (groupInfo.firstChild > 0 && baseInfo.firstChild >= 0 && groupInfo.firstChild - baseInfo.firstChild > deletedNum) {
            for (int index = groupIndex; index < levelList.size() && groupInfo.firstChild > 0; ++index) {
                groupInfo = (GroupInfo)levelList.get(index);
                groupInfo.firstChild -= deletedNum;
            }
            return true;
        }
        if (groupInfo.firstChild > 0 && baseInfo.firstChild >= 0 && groupInfo.firstChild - baseInfo.firstChild == deletedNum) {
            return false;
        }
        throw new DataException("data.engine.document.invalidGroupItem");
    }

    private static void resetStatus(List[] groups, int groupIndex, int deletedNum, int level) {
        List levelList = groups[level];
        GroupInfo deletedGroup = (GroupInfo)levelList.get(groupIndex);
        for (int index = groupIndex + 1; index < levelList.size(); ++index) {
            GroupInfo groupInfo = (GroupInfo)levelList.get(index);
            if (groupInfo.firstChild <= 0 || groupInfo.firstChild <= deletedGroup.firstChild) continue;
            groupInfo.firstChild -= deletedNum;
        }
        deletedGroup.firstChild = -2;
    }

    private static boolean validateGroupLevel(List endLevelList, int[] indexArray) {
        if (!$assertionsDisabled && endLevelList == null) {
            throw new AssertionError();
        }
        int index = 0;
        for (int i = 0; i < indexArray.length; ++i) {
            if ((index = GroupInfoUtil.findGroup(i, index, indexArray, endLevelList)) != -1) continue;
            return false;
        }
        return true;
    }

    private static int findGroup(int arrayIndex, int startIndex, int[] indexArray, List endLevelList) {
        for (int i = startIndex; i < endLevelList.size(); ++i) {
            GroupInfo info = (GroupInfo)endLevelList.get(i);
            int start = info.firstChild;
            int end = -1;
            if (i + 1 < endLevelList.size()) {
                end = ((GroupInfo)endLevelList.get((int)(i + 1))).firstChild - 1;
            }
            if (end != -1 && indexArray[arrayIndex] > end || indexArray[arrayIndex] < start) continue;
            return i;
        }
        return -1;
    }

    static List[] cleanUnUsedGroupInstance(List[] groups) {
        int last = groups.length - 1;
        List lastGroup = groups[last];
        for (int i = 0; i < lastGroup.size(); ++i) {
            if (((GroupInfo)lastGroup.get((int)i)).firstChild != -2) continue;
            return GroupInfoUtil.cleanUnUsedGroupInstance(GroupInfoUtil.removeWholeGroup(groups, last, i));
        }
        return groups;
    }

    private static List[] removeWholeGroup(List[] groups, int groupLevelIndex, int groupInstanceIndex) {
        List lastGroup = groups[groupLevelIndex];
        int parent = ((GroupInfo)lastGroup.get((int)groupInstanceIndex)).parent;
        boolean shouldRemoveParent = GroupInfoUtil.manipulateParentGroup(groups, groupLevelIndex, groupInstanceIndex);
        if (groupLevelIndex < groups.length - 1 && groupInstanceIndex < lastGroup.size() - 1) {
            int start = ((GroupInfo)groups[groupLevelIndex].get((int)(groupInstanceIndex + 1))).firstChild;
            List childGroup = groups[groupLevelIndex + 1];
            for (int j = start; j < childGroup.size(); ++j) {
                --((GroupInfo)childGroup.get((int)j)).parent;
            }
        }
        lastGroup.remove(groupInstanceIndex);
        if (shouldRemoveParent) {
            return GroupInfoUtil.removeWholeGroup(groups, groupLevelIndex - 1, parent);
        }
        return groups;
    }

    private static boolean manipulateParentGroup(List[] groups, int groupLevelIndex, int groupInstanceIndex) {
        boolean shouldRemoveParent = false;
        int parent = ((GroupInfo)groups[groupLevelIndex].get((int)groupInstanceIndex)).parent;
        if (groupLevelIndex > 0) {
            List parentGroup = groups[groupLevelIndex - 1];
            for (int j = parent + 1; j < parentGroup.size(); ++j) {
                --((GroupInfo)parentGroup.get((int)j)).firstChild;
            }
            if (GroupInfoUtil.isWholeGroupEliminate(groupInstanceIndex, parent, groups[groupLevelIndex])) {
                shouldRemoveParent = true;
            }
        }
        return shouldRemoveParent;
    }

    private static boolean isWholeGroupEliminate(int currentIndex, int parent, List groups) {
        if (currentIndex - 1 >= 0 && ((GroupInfo)groups.get((int)(currentIndex - 1))).parent == parent) {
            return false;
        }
        return currentIndex + 1 >= groups.size() || ((GroupInfo)groups.get((int)(currentIndex + 1))).parent != parent;
    }

    static {
        $assertionsDisabled = !GroupInfoUtil.class.desiredAssertionStatus();
    }
}

