/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

import java.io.OutputStream;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.document.QueryResultIDUtil;
import org.eclipse.birt.data.engine.impl.document.QueryResultInfo;

public class StreamManager {
    private DataEngineContext context;
    private String rootQueryResultID;
    private String parentQueryResultID;
    private String selfQueryResultID;
    private String subQueryID;
    private String subQueryName;
    public static final int BASE_SCOPE = 0;
    public static final int PARENT_SCOPE = 1;
    public static final int SELF_SCOPE = 2;
    public static final int ROOT_STREAM = 0;
    public static final int SUB_QUERY_ROOT_STREAM = 1;
    public static final int SUB_QUERY_STREAM = 2;

    public StreamManager(DataEngineContext context, QueryResultInfo queryResultInfo) {
        this.context = context;
        this.rootQueryResultID = queryResultInfo.getRootQueryResultID();
        this.parentQueryResultID = queryResultInfo.getParentQueryResultID();
        this.selfQueryResultID = queryResultInfo.getSelfQueryResultID();
        this.subQueryName = queryResultInfo.getSubQueryName();
        this.subQueryID = this.subQueryName == null ? null : QueryResultIDUtil.buildSubQueryID(this.subQueryName, queryResultInfo.getIndex());
    }

    OutputStream getOutStream(int streamType, int streamPos, int streamScope) throws DataException {
        StreamID streamID = this.getStreamID(streamPos, streamScope);
        return this.context.getOutputStream(streamID.startStream, streamID.subQueryStream, streamType);
    }

    public RAInputStream getInStream(int streamType, int streamPos, int streamScope) throws DataException {
        StreamID streamID = this.getStreamID(streamPos, streamScope);
        return (RAInputStream)this.context.getInputStream(streamID.startStream, streamID.subQueryStream, streamType);
    }

    public RAInputStream getInStream2(int streamType, int streamPos, int streamScope, int parentIndex) throws DataException {
        String tempID = this.subQueryID;
        this.subQueryID = QueryResultIDUtil.buildSubQueryID(this.subQueryName, parentIndex);
        StreamID streamID = this.getStreamID(streamPos, streamScope);
        this.subQueryID = tempID;
        return (RAInputStream)this.context.getInputStream(streamID.startStream, streamID.subQueryStream, streamType);
    }

    boolean hasInStream(int streamType, int streamPos, int streamScope) throws DataException {
        StreamID streamID = this.getStreamID(streamPos, streamScope);
        return this.context.hasInStream(streamID.startStream, streamID.subQueryStream, streamType);
    }

    boolean hasOutStream(int streamType, int streamPos, int streamScope) {
        StreamID streamID = this.getStreamID(streamPos, streamScope);
        return this.context.hasOutStream(streamID.startStream, streamID.subQueryStream, streamType);
    }

    private StreamID getStreamID(int streamPos, int streamScope) {
        String startStream = null;
        if (streamScope == 0) {
            startStream = this.rootQueryResultID != null ? this.rootQueryResultID : this.selfQueryResultID;
        } else if (streamScope == 1) {
            startStream = QueryResultIDUtil.getRealStreamID(this.rootQueryResultID, this.parentQueryResultID);
        } else if (streamScope == 2) {
            startStream = QueryResultIDUtil.getRealStreamID(this.rootQueryResultID, this.selfQueryResultID);
        }
        String subQueryStream = null;
        if (!this.isSubquery()) {
            if (streamPos == 0) {
                subQueryStream = null;
            } else if (streamPos == 1) {
                subQueryStream = this.subQueryName;
            } else if (streamPos == 2) {
                subQueryStream = this.subQueryID;
            }
        } else if (streamPos == 0) {
            subQueryStream = this.subQueryID;
        } else if (streamPos == 1) {
            subQueryStream = this.subQueryName;
        } else if (streamPos == 2) {
            subQueryStream = this.subQueryID;
        }
        return new StreamID(startStream, subQueryStream);
    }

    boolean isSubquery() {
        return this.subQueryName != null;
    }

    boolean isBasedOnSecondRD() throws DataException {
        return this.parentQueryResultID != null;
    }

    boolean isSecondRD() throws DataException {
        return this.rootQueryResultID != null;
    }

    String getQueryResultUID() {
        return QueryResultIDUtil.buildID(this.rootQueryResultID, this.selfQueryResultID);
    }

    private static class StreamID {
        private String startStream;
        private String subQueryStream;

        private StreamID(String startStream, String subQueryStream) {
            this.startStream = startStream;
            this.subQueryStream = subQueryStream;
        }
    }
}

