/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.document.CacheProvider;
import org.eclipse.birt.data.engine.impl.document.RDGroupUtil;
import org.eclipse.birt.data.engine.impl.document.StreamManager;
import org.eclipse.birt.data.engine.impl.document.util.ExprDataReader1;
import org.eclipse.birt.data.engine.impl.document.util.ExprDataReader2;
import org.eclipse.birt.data.engine.impl.document.util.IExprDataReader;
import org.eclipse.birt.data.engine.impl.document.util.IExprResultSet;

public class ExprResultSet
implements IExprResultSet {
    private InputStream rowExprsIs;
    private InputStream rowLenIs;
    private BufferedInputStream rowExprsBuffDis;
    private BufferedInputStream rowLenBuffDis;
    protected RAInputStream rowExprsRAIs;
    protected RAInputStream rowLenRAIs;
    protected RAInputStream rowInfoRAIs;
    protected int rowCount;
    private int version;
    private boolean isBasedOnSecondRD;
    protected RDGroupUtil rdGroupUtil;
    protected IExprDataReader exprResultReader;
    protected StreamManager streamManager;
    static /* synthetic */ Class class$org$eclipse$birt$data$engine$impl$document$util$ExprResultSet;

    public ExprResultSet(StreamManager streamManager, RDGroupUtil rdGroupUtil, int version, boolean isBasedOnSecondRD) throws DataException {
        this.streamManager = streamManager;
        this.version = version;
        this.isBasedOnSecondRD = isBasedOnSecondRD;
        this.rdGroupUtil = rdGroupUtil;
        this.prepare();
        this.rdGroupUtil.setCacheProvider(new CacheProviderImpl(this));
    }

    protected void prepare() throws DataException {
        if (!this.isBasedOnSecondRD) {
            this.rowExprsIs = this.streamManager.getInStream(31, 0, 2);
            this.rowExprsBuffDis = new BufferedInputStream(this.rowExprsIs);
            if (this.version == 1) {
                this.rowLenIs = this.streamManager.getInStream(33, 0, 2);
                this.rowLenBuffDis = new BufferedInputStream(this.rowLenIs);
            }
            this.exprResultReader = new ExprDataReader1(this.rowExprsBuffDis, this.rowLenBuffDis, this.version);
            this.rowCount = this.exprResultReader.getCount();
        } else {
            this.rowExprsRAIs = this.streamManager.getInStream(31, 0, 0);
            this.rowLenRAIs = this.streamManager.getInStream(33, 0, 0);
            this.rowInfoRAIs = this.streamManager.getInStream(51, 0, 2);
            this.exprResultReader = new ExprDataReader2(this.rowExprsRAIs, this.rowLenRAIs, this.rowInfoRAIs);
            this.rowCount = this.exprResultReader.getCount();
        }
    }

    public boolean next() throws DataException {
        boolean hasNext = this.exprResultReader.next();
        this.rdGroupUtil.next(hasNext);
        return hasNext;
    }

    public Object getValue(String name) throws DataException {
        Map exprValueMap = this.exprResultReader.getRowValue();
        if (!exprValueMap.containsKey(name)) {
            throw new DataException("data.engine.InValidExpr");
        }
        return exprValueMap.get(name);
    }

    public void moveTo(int rowIndex) throws DataException {
        int currIndex = this.getCurrentIndex();
        if (rowIndex < 0 || rowIndex >= this.rowCount) {
            throw new DataException("data.engine.invalidRowIndex", new Integer(rowIndex));
        }
        if (rowIndex < currIndex) {
            throw new DataException("data.engine.backwardSeekError");
        }
        if (rowIndex == currIndex) {
            return;
        }
        int gapValue = rowIndex - currIndex;
        for (int i = 0; i < gapValue; ++i) {
            this.next();
        }
    }

    public int getCurrentId() {
        return this.exprResultReader.getRowId();
    }

    public int getCurrentIndex() {
        return this.exprResultReader.getRowIndex();
    }

    public int getStartingGroupLevel() throws DataException {
        return this.rdGroupUtil.getStartingGroupLevel();
    }

    public int getEndingGroupLevel() throws DataException {
        return this.rdGroupUtil.getEndingGroupLevel();
    }

    public void skipToEnd(int groupLevel) throws DataException {
        this.rdGroupUtil.last(groupLevel);
    }

    public void close() throws DataException {
        try {
            if (this.exprResultReader != null) {
                this.exprResultReader.close();
            }
            if (this.rowExprsBuffDis != null) {
                this.rowExprsBuffDis.close();
                this.rowExprsIs.close();
            }
            if (this.rowLenBuffDis != null) {
                this.rowLenBuffDis.close();
                this.rowLenIs.close();
            }
            if (this.rowExprsRAIs != null) {
                this.rowExprsRAIs.close();
                this.rowLenRAIs.close();
                this.rowInfoRAIs.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class CacheProviderImpl
    implements CacheProvider {
        private ExprResultSet exprResultSet;
        static final /* synthetic */ boolean $assertionsDisabled;

        public CacheProviderImpl(ExprResultSet exprResultSet) {
            this.exprResultSet = exprResultSet;
        }

        public int getCount() {
            return this.exprResultSet.rowCount;
        }

        public int getCurrentIndex() {
            return this.exprResultSet.getCurrentIndex();
        }

        public void moveTo(int destIndex) throws DataException {
            int currIndex = this.exprResultSet.getCurrentIndex();
            if (!$assertionsDisabled && destIndex < currIndex) {
                throw new AssertionError();
            }
            int forwardSteps = destIndex - currIndex;
            for (int i = 0; i < forwardSteps; ++i) {
                this.exprResultSet.next();
            }
        }

        static {
            $assertionsDisabled = !(class$org$eclipse$birt$data$engine$impl$document$util$ExprResultSet == null ? (class$org$eclipse$birt$data$engine$impl$document$util$ExprResultSet = ExprResultSet.class$("org.eclipse.birt.data.engine.impl.document.util.ExprResultSet")) : class$org$eclipse$birt$data$engine$impl$document$util$ExprResultSet).desiredAssertionStatus();
        }
    }
}

