/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.util.Hashtable;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.odaconsumer.ConnectionManager;
import org.eclipse.birt.data.engine.odaconsumer.Driver;
import org.eclipse.birt.data.engine.odaconsumer.LogHelper;
import org.eclipse.datatools.connectivity.oda.IDriver;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;

class DriverManager {
    private static DriverManager sm_driverManager;
    private Hashtable m_loadedDrivers;
    private static String sm_className;
    private static String sm_loggerName;
    private static LogHelper sm_logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    private DriverManager() {
    }

    static DriverManager getInstance() throws IllegalStateException {
        return sm_driverManager;
    }

    IDriver getDriverHelper(String dataSourceElementId) throws DataException {
        String methodName = "getDriverHelper";
        sm_logger.entering(sm_className, methodName, dataSourceElementId);
        Driver driver = this.getDriver(dataSourceElementId);
        IDriver ret = driver.getDriverHelper();
        sm_logger.exiting(sm_className, methodName, ret);
        return ret;
    }

    String getExtensionDataSourceId(String dataSourceElementId) throws DataException {
        String methodName = "getExtensionDataSourceId";
        sm_logger.entering(sm_className, methodName, dataSourceElementId);
        Driver driver = this.getDriver(dataSourceElementId);
        ExtensionManifest config = driver.getDriverExtensionConfig();
        String ret = config.getDataSourceElementID();
        sm_logger.exiting(sm_className, methodName, ret);
        return ret;
    }

    void setDriverLogConfiguration(String dataSourceElementId) {
        String methodName = "setDriverLogConfiguration";
        if (sm_logger.isLoggingEnterExitLevel()) {
            sm_logger.entering(sm_className, methodName, new Object[]{dataSourceElementId});
        }
        if (!$assertionsDisabled && dataSourceElementId == null) {
            throw new AssertionError();
        }
        Driver driver = this.getDriver(dataSourceElementId);
        if (!$assertionsDisabled && driver == null) {
            throw new AssertionError();
        }
        driver.setLogConfiguration();
        sm_logger.exiting(sm_className, methodName);
    }

    int getNativeToOdaMapping(String dataSourceElementId, String dataSetType, int nativeType) throws DataException {
        String methodName = "getNativeToOdaMapping";
        if (sm_logger.isLoggingEnterExitLevel()) {
            sm_logger.entering(sm_className, methodName, new Object[]{dataSourceElementId, dataSetType, new Integer(nativeType)});
        }
        Driver driver = this.getDriver(dataSourceElementId);
        int ret = driver.getTypeMapping(dataSetType, nativeType);
        sm_logger.exiting(sm_className, methodName, ret);
        return ret;
    }

    private Driver getDriver(String dataSourceElementId) {
        if (!($assertionsDisabled || dataSourceElementId != null && dataSourceElementId.length() != 0)) {
            throw new AssertionError();
        }
        Driver driver = (Driver)this.getLoadedDrivers().get(dataSourceElementId);
        if (driver == null) {
            driver = new Driver(dataSourceElementId);
            this.getLoadedDrivers().put(dataSourceElementId, driver);
        }
        return driver;
    }

    Hashtable getLoadedDrivers() {
        if (this.m_loadedDrivers == null) {
            this.m_loadedDrivers = new Hashtable();
        }
        return this.m_loadedDrivers;
    }

    static {
        $assertionsDisabled = !DriverManager.class.desiredAssertionStatus();
        sm_driverManager = new DriverManager();
        sm_className = DriverManager.class.getName();
        sm_loggerName = ConnectionManager.sm_packageName;
        sm_logger = LogHelper.getInstance(sm_loggerName);
    }
}

