/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.style.IStyleProcessor;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartType;
import org.eclipse.birt.chart.ui.swt.interfaces.IDataServiceProvider;
import org.eclipse.birt.chart.ui.swt.interfaces.IUIServiceProvider;
import org.eclipse.birt.chart.ui.swt.wizard.ChartUIExtensionsImpl;
import org.eclipse.birt.core.ui.frameworks.taskwizard.interfaces.IWizardContext;

public class ChartWizardContext
implements IWizardContext {
    private transient Chart chartModel = null;
    private transient IChartType chartType = null;
    private transient Object extendedItem = null;
    private transient String sDefaultOutputFormat;
    private transient String sOutputFormat = this.sDefaultOutputFormat = "SVG";
    private transient IUIServiceProvider uiProvider;
    private transient IDataServiceProvider dataProvider;
    private transient IStyleProcessor processor;
    private transient boolean isMoreAxesSupported;
    private transient boolean isRtL;

    public ChartWizardContext(Chart chartModel) {
        this.chartModel = chartModel;
    }

    public String getWizardID() {
        return this.getExtendedItem() == null ? "org.eclipse.birt.chart.ui.ChartWizard" : this.getExtendedItem().toString();
    }

    public Chart getModel() {
        return this.chartModel;
    }

    public void setModel(Chart model) {
        this.chartModel = model;
    }

    public Object getExtendedItem() {
        return this.extendedItem;
    }

    public void setExtendedItem(Object extendedItem) {
        this.extendedItem = extendedItem;
    }

    public String getOutputFormat() {
        return this.sOutputFormat;
    }

    public void setOutputFormat(String format) {
        this.sOutputFormat = format;
    }

    public String getDefaultOutputFormat() {
        return this.sDefaultOutputFormat;
    }

    public void setDefaultOutputFormat(String sOutputFormat) {
        this.sDefaultOutputFormat = sOutputFormat;
    }

    public IUIServiceProvider getUIServiceProvider() {
        return this.uiProvider;
    }

    public void setUIServiceProvider(IUIServiceProvider uiProvider) {
        this.uiProvider = uiProvider;
    }

    public IDataServiceProvider getDataServiceProvider() {
        return this.dataProvider;
    }

    public void setDataServiceProvider(IDataServiceProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    public void setChartType(IChartType chartType) {
        this.chartType = chartType;
    }

    public IChartType getChartType() {
        if (this.chartType == null) {
            LinkedHashMap<String, IChartType> htTypes = new LinkedHashMap<String, IChartType>();
            Collection cTypes = ChartUIExtensionsImpl.instance().getUIChartTypeExtensions();
            Iterator iterTypes = cTypes.iterator();
            while (iterTypes.hasNext()) {
                IChartType type = (IChartType)iterTypes.next();
                htTypes.put(type.getName(), type);
            }
            this.chartType = (IChartType)htTypes.get(this.chartModel.getType());
        }
        return this.chartType;
    }

    public void setProcessor(IStyleProcessor processor) {
        this.processor = processor;
    }

    public IStyleProcessor getProcessor() {
        return this.processor;
    }

    public void setMoreAxesSupported(boolean isMoreAxesSupported) {
        this.isMoreAxesSupported = isMoreAxesSupported;
    }

    public boolean isMoreAxesSupported() {
        return this.isMoreAxesSupported;
    }

    public boolean isRtL() {
        return this.isRtL;
    }

    public void setRtL(boolean isRtL) {
        this.isRtL = isRtL;
    }
}

