/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.ui.plugin.ChartUIPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class UIHelper {
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.ui/util");

    public static Point getScreenLocation(Composite cmpTarget) {
        Point ptScreen = new Point(0, 0);
        try {
            Composite cTmp = cmpTarget;
            while (!(cTmp instanceof Shell)) {
                ptScreen.x += cTmp.getLocation().x;
                ptScreen.y += cTmp.getLocation().y;
                cTmp = cTmp.getParent();
            }
        }
        catch (Exception e) {
            logger.log(e);
        }
        return cmpTarget.getShell().toDisplay(ptScreen);
    }

    public static void centerOnScreen(Shell shell) {
        shell.setLocation(Display.getCurrent().getPrimaryMonitor().getClientArea().width / 2 - shell.getSize().x / 2, Display.getCurrent().getPrimaryMonitor().getClientArea().height / 2 - shell.getSize().y / 2);
    }

    public static URL getURL(String sPluginRelativePath) {
        URL url = null;
        if (Platform.getExtensionRegistry() != null) {
            try {
                url = new URL(ChartUIPlugin.getDefault().getBundle().getEntry("/"), sPluginRelativePath);
            }
            catch (MalformedURLException e) {
                logger.log((Exception)e);
            }
        } else {
            try {
                url = new URL("file:///" + new File(sPluginRelativePath).getAbsolutePath());
            }
            catch (MalformedURLException e) {
                logger.log((Exception)e);
            }
        }
        return url;
    }

    private static Image createImage(String sPluginRelativePath) {
        Image img = null;
        try {
            try {
                img = new Image((Device)Display.getCurrent(), UIHelper.getURL(sPluginRelativePath).openStream());
            }
            catch (MalformedURLException e1) {
                img = new Image((Device)Display.getCurrent(), (InputStream)new FileInputStream(UIHelper.getURL(sPluginRelativePath).toString()));
            }
        }
        catch (FileNotFoundException e) {
            logger.log((Exception)e);
        }
        catch (IOException e) {
            logger.log((Exception)e);
        }
        if (img == null) {
            img = new Image((Device)Display.getCurrent(), 1, 1);
        }
        return img;
    }

    public static Image getImage(String sPluginRelativePath) {
        ImageRegistry registry = JFaceResources.getImageRegistry();
        Image image = registry.get(sPluginRelativePath);
        if (image == null) {
            image = UIHelper.createImage(sPluginRelativePath);
            registry.put(sPluginRelativePath, image);
        }
        return image;
    }
}

