/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.script;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.util.mediator.IColleague;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.internal.ui.editors.script.JSDocumentProvider;
import org.eclipse.birt.report.designer.internal.ui.editors.script.JSEditorInput;
import org.eclipse.birt.report.designer.internal.ui.editors.script.JSExpListProvider;
import org.eclipse.birt.report.designer.internal.ui.editors.script.JSSourceViewerConfiguration;
import org.eclipse.birt.report.designer.internal.ui.editors.script.JSSyntaxContext;
import org.eclipse.birt.report.designer.internal.ui.editors.script.TreeViewPalettePage;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.data.DataViewPage;
import org.eclipse.birt.report.designer.internal.ui.views.data.DataViewTreeViewerPage;
import org.eclipse.birt.report.designer.internal.ui.views.outline.DesignerOutlinePage;
import org.eclipse.birt.report.designer.internal.ui.views.property.ReportPropertySheetPage;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.ProviderFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ScriptDataSourceHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.views.palette.PalettePage;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.StatusTextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public class JSEditor
extends StatusTextEditor
implements ISelectionChangedListener,
IColleague {
    private static final String NO_EXPRESSION = Messages.getString((String)"JSEditor.Display.NoExpression");
    private IEditorPart editingDomainEditor;
    private boolean settingText = false;
    JSEditorInput editorInput = new JSEditorInput("");
    Combo cmbExpList = null;
    public ComboViewer cmbExprListViewer;
    IPropertyDefn cmbItemLastSelected = null;
    boolean editorUIEnabled = true;
    private ActionRegistry actionRegistry = null;
    private Button butReset;
    private Label ano;
    private final HashMap selectionMap = new HashMap();
    private boolean isModified;
    private JSSyntaxContext context = new JSSyntaxContext();
    private Object editObject;
    public TreeViewPalettePage palettePage = new TreeViewPalettePage();

    public JSEditor(IEditorPart parent) {
        this.editingDomainEditor = parent;
        this.setSourceViewerConfiguration(new JSSourceViewerConfiguration(this.context));
        this.setDocumentProvider((IDocumentProvider)new JSDocumentProvider());
        this.setSite((IWorkbenchPartSite)parent.getEditorSite());
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public boolean isDirty() {
        return this.isCodeModified();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void dispose() {
        this.selectionMap.clear();
        this.editingDomainEditor = null;
        super.dispose();
        ((MultiPageEditorSite)this.getSite()).dispose();
    }

    public void createPartControl(Composite parent) {
        Composite child = this.initEditorLayout(parent);
        this.setInput((IEditorInput)this.editorInput);
        this.cmbExprListViewer = new ComboViewer(this.cmbExpList);
        JSExpListProvider provider = new JSExpListProvider();
        this.cmbExprListViewer.setContentProvider((IContentProvider)provider);
        this.cmbExprListViewer.setLabelProvider((IBaseLabelProvider)provider);
        Object model = this.getModel();
        if (model != null) {
            this.cmbExpList.setVisible(true);
            this.setComboViewerInput(model);
        } else {
            this.setComboViewerInput(Messages.getString((String)"JSEditor.Input.trial"));
        }
        this.cmbExprListViewer.addSelectionChangedListener((ISelectionChangedListener)this.palettePage.getSupport());
        this.cmbExprListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection != null) {
                    JSEditor.this.settingText = true;
                    Object[] sel = ((IStructuredSelection)selection).toArray();
                    if (sel.length == 1 && sel[0] instanceof IPropertyDefn) {
                        IPropertyDefn elePropDefn;
                        DesignElementHandle desHandle = (DesignElementHandle)JSEditor.this.cmbExprListViewer.getInput();
                        JSEditor.this.saveModelIfNeeds();
                        JSEditor.this.cmbItemLastSelected = elePropDefn = (IPropertyDefn)sel[0];
                        JSEditor.this.setEditorText(desHandle.getStringProperty(elePropDefn.getName()));
                        JSEditor.this.setIsModified(false);
                        JSEditor.this.selectionMap.put(JSEditor.this.getModel(), selection);
                        String method = JSEditor.this.cmbItemLastSelected.getName();
                        Map argMap = DEUtil.getDesignElementMethodArguments((DesignElementHandle)desHandle, (String)method);
                        JSEditor.this.context.clear();
                        Iterator iter = argMap.entrySet().iterator();
                        while (iter.hasNext()) {
                            Map.Entry element = iter.next();
                            String name = (String)element.getKey();
                            String type = (String)element.getValue();
                            JSEditor.this.context.setVariable(name, type);
                        }
                    }
                    JSEditor.this.settingText = false;
                }
            }
        });
        super.createPartControl(child);
        this.getViewer().addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                if (!JSEditor.this.settingText && !JSEditor.this.isModified && event.getOffset() != 0) {
                    JSEditor.this.markDirty();
                }
            }
        });
        this.getSourceViewer().getTextWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JSEditor.this.markDirty();
            }
        });
        SessionHandleAdapter.getInstance().getMediator().addColleague((IColleague)this);
        this.disableEditor();
    }

    public Object getModel() {
        return this.editObject;
    }

    protected void createActions() {
        super.createActions();
    }

    public void setAction(String actionID, IAction action) {
        super.setAction(actionID, action);
        if (action.getId() == null) {
            action.setId(actionID);
        }
        this.getActionRegistry().registerAction(action);
    }

    private void updateAnnotationLabel(Object handle) {
        String name = ProviderFactory.createProvider((Object)handle).getNodeDisplayName(handle);
        if (name == null) {
            this.ano.setText("");
        } else {
            this.ano.setText(name);
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ActionRegistry.class) {
            return this.getActionRegistry();
        }
        if (adapter == PalettePage.class) {
            if (this.cmbExprListViewer != null) {
                this.cmbExprListViewer.addSelectionChangedListener((ISelectionChangedListener)this.palettePage.getSupport());
            }
            return this.palettePage;
        }
        if (adapter == IContentOutlinePage.class) {
            DesignerOutlinePage outlinePage = new DesignerOutlinePage(SessionHandleAdapter.getInstance().getReportDesignHandle());
            return outlinePage;
        }
        if (adapter == IPropertySheetPage.class) {
            ReportPropertySheetPage sheetPage = new ReportPropertySheetPage();
            return sheetPage;
        }
        if (adapter == DataViewPage.class) {
            DataViewTreeViewerPage page = new DataViewTreeViewerPage(SessionHandleAdapter.getInstance().getReportDesignHandle());
            return page;
        }
        return super.getAdapter(adapter);
    }

    private Composite initEditorLayout(Composite parent) {
        Composite mainPane = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        mainPane.setLayout((Layout)layout);
        Composite barPane = new Composite(mainPane, 0);
        layout = new GridLayout(4, false);
        barPane.setLayout((Layout)layout);
        GridData gdata = new GridData(768);
        barPane.setLayoutData((Object)gdata);
        this.cmbExpList = new Combo(barPane, 8);
        GridData layoutData = new GridData(768);
        this.cmbExpList.setLayoutData((Object)layoutData);
        this.butReset = new Button(barPane, 8);
        this.butReset.setText(Messages.getString((String)"JSEditor.Button.Reset"));
        layoutData = new GridData();
        layoutData.horizontalIndent = 6;
        this.butReset.setLayoutData((Object)layoutData);
        this.butReset.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JSEditor.this.setEditorText("");
                JSEditor.this.markDirty();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Label column = new Label(barPane, 514);
        layoutData = new GridData();
        layoutData.heightHint = 20;
        layoutData.horizontalIndent = 10;
        column.setLayoutData((Object)layoutData);
        this.ano = new Label(barPane, 0);
        layoutData = new GridData(772);
        this.ano.setLayoutData((Object)layoutData);
        final Composite sep = new Composite(mainPane, 0);
        layoutData = new GridData(768);
        layoutData.heightHint = 1;
        sep.setLayoutData((Object)layoutData);
        sep.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                Rectangle rect = sep.getBounds();
                gc.setForeground(ColorConstants.darkGray);
                gc.drawLine(0, 0, rect.width, 0);
            }
        });
        Composite jsEditorContainer = new Composite(mainPane, 0);
        gdata = new GridData(1808);
        jsEditorContainer.setLayoutData((Object)gdata);
        jsEditorContainer.setLayout((Layout)new FillLayout());
        return jsEditorContainer;
    }

    public void selectionChanged(SelectionChangedEvent event) {
    }

    public void handleSelectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        this.handleSelectionChanged(selection);
    }

    public void handleSelectionChanged(ISelection selection) {
        if (this.getSourceViewer() == null || !this.getSourceViewer().getTextWidget().isVisible()) {
            return;
        }
        if (this.editorUIEnabled) {
            this.saveModelIfNeeds();
        }
        if (selection != null) {
            this.settingText = true;
            Object[] sel = ((IStructuredSelection)selection).toArray();
            if (sel.length == 1 && sel[0] instanceof DesignElementHandle) {
                this.editObject = sel[0];
                this.palettePage.getSupport().setCurrentEditObject(this.editObject);
                if (this.editObject instanceof ExtendedItemHandle) {
                    this.disableEditor();
                    this.cmbExpList.removeAll();
                    this.cmbItemLastSelected = null;
                    this.getSourceViewer().getTextWidget().setEnabled(true);
                    this.setEditorText(((ExtendedItemHandle)this.editObject).getExternalScript());
                    this.context.setVariable("this", "org.eclipse.birt.report.model.api.ExtendedItemHandle");
                } else {
                    this.setComboViewerInput(this.editObject);
                    this.cmbItemLastSelected = null;
                    this.setEditorText("");
                    if (this.cmbExpList.getItemCount() > 0) {
                        this.enableEditor();
                        this.selectItemInComboExpList((ISelection)this.selectionMap.get(this.getModel()));
                    } else {
                        this.disableEditor();
                    }
                }
                this.checkDirty();
            } else {
                this.disableEditor();
                this.cmbExpList.removeAll();
                this.cmbItemLastSelected = null;
                this.palettePage.getSupport().setCurrentEditObject(null);
            }
            this.updateAnnotationLabel(sel.length > 0 ? sel[0] : null);
            this.settingText = false;
        }
    }

    private void checkDirty() {
    }

    private void selectItemInComboExpList(ISelection selection) {
        IPropertyDefn propDefn;
        ISelection sel = selection;
        if (sel.isEmpty() && this.cmbExpList.getItemCount() > 0 && (propDefn = (IPropertyDefn)this.cmbExprListViewer.getElementAt(0)) != null) {
            sel = new StructuredSelection((Object)propDefn);
        }
        this.cmbExprListViewer.setSelection(sel);
    }

    private void setEditorText(String text) {
        if (text == null) {
            text = "";
        }
        ((JSDocumentProvider)this.getDocumentProvider()).getDocument(this.editorInput).set(text);
    }

    private String getEditorText() {
        return this.getDocumentProvider().getDocument((Object)this.editorInput).get();
    }

    private boolean saveEditorContentsDE(DesignElementHandle desHdl) {
        if (desHdl != null && this.getEditorText() != null) {
            try {
                if (desHdl instanceof ExtendedItemHandle) {
                    ((ExtendedItemHandle)desHdl).setExternalScript(this.getEditorText());
                } else if (this.cmbItemLastSelected != null) {
                    desHdl.setStringProperty(this.cmbItemLastSelected.getName(), this.getEditorText());
                    this.selectionMap.put(this.getModel(), this.cmbExprListViewer.getSelection());
                }
            }
            catch (SemanticException e) {
                ExceptionHandler.handle((Throwable)e);
                return false;
            }
        }
        return true;
    }

    public void saveModel() {
        if (this.isCodeModified() && this.editObject instanceof DesignElementHandle) {
            this.saveEditorContentsDE((DesignElementHandle)this.editObject);
        }
        this.setIsModified(false);
    }

    public void setIsModified(boolean b) {
        this.isModified = b;
    }

    private boolean isCodeModified() {
        return this.isModified;
    }

    public void saveModelIfNeeds() {
        if (this.checkEditorActive() && this.isCodeModified() && this.editObject instanceof DesignElementHandle) {
            this.saveEditorContentsDE((DesignElementHandle)this.editObject);
        }
    }

    protected void markDirty() {
        this.isModified = true;
        ((IFormPage)this.editingDomainEditor).getEditor().editorDirtyStateChanged();
        this.firePropertyChange(257);
    }

    protected boolean checkEditorActive() {
        return true;
    }

    private void enableEditor() {
        if (!this.editorUIEnabled) {
            this.getSourceViewer().getTextWidget().setEnabled(true);
            this.cmbExpList.setEnabled(true);
            this.butReset.setEnabled(true);
            this.editorUIEnabled = true;
        }
        this.settingText = true;
        this.setEditorText("");
        this.settingText = false;
    }

    private void disableEditor() {
        if (this.editorUIEnabled) {
            this.getSourceViewer().getTextWidget().setEnabled(false);
            this.cmbExpList.setEnabled(false);
            this.butReset.setEnabled(false);
            this.editorUIEnabled = false;
        }
        this.settingText = true;
        this.setEditorText(NO_EXPRESSION);
        this.settingText = false;
    }

    public ActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new ActionRegistry();
        }
        return this.actionRegistry;
    }

    public SourceViewer getViewer() {
        return (SourceViewer)this.getSourceViewer();
    }

    public void performRequest(ReportRequest request) {
        if ("selection".equals(request.getType())) {
            this.handleSelectionChange(request.getSelectionModelList());
        }
        if ("create element".equals(request.getType()) && request.getSelectionModelList().get(0) instanceof ScriptDataSourceHandle) {
            this.handleSelectionChange(request.getSelectionModelList());
        }
    }

    private void setComboViewerInput(Object model) {
        this.cmbExprListViewer.setInput(model);
        Object oldSelection = this.selectionMap.get(model);
        if (oldSelection == null) {
            this.selectItemInComboExpList((ISelection)new StructuredSelection());
        } else {
            this.selectItemInComboExpList((ISelection)oldSelection);
        }
    }

    private void setComboViewerInput(String message) {
        this.cmbExprListViewer.setInput((Object)message);
    }

    public void handleSelectionChange(List list) {
        SelectionChangedEvent event = new SelectionChangedEvent(this.getSelectionProvider(), (ISelection)new StructuredSelection(list));
        this.handleSelectionChanged(event);
    }
}

