/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.editors.pages;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.util.mediator.IMediatorState;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.internal.ui.editors.script.JSEditor;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.internal.ui.views.outline.DesignerOutlinePage;
import org.eclipse.birt.report.designer.ui.editors.IReportEditorPage;
import org.eclipse.birt.report.designer.ui.editors.IReportProvider;
import org.eclipse.birt.report.designer.ui.editors.pages.ReportFormPage;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.views.palette.PalettePage;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class ReportScriptFormPage
extends ReportFormPage {
    public static final String ID = "org.eclipse.birt.report.designer.ui.editors.script";
    private JSEditor jsEditor;
    private Control control;
    private int staleType;
    private ModuleHandle model;
    private IReportEditorPage previouPage;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        try {
            this.jsEditor = new JSEditor((IEditorPart)this);
            this.jsEditor.init(site, input);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean onBroughtToTop(IReportEditorPage prePage) {
        if (this.getEditorInput() != prePage.getEditorInput()) {
            this.setInput(prePage.getEditorInput());
        }
        this.previouPage = prePage;
        IMediatorState state = SessionHandleAdapter.getInstance().getMediator().getCurrentState();
        ReportRequest request = new ReportRequest(state.getSource());
        List list = state.getSelectionObject();
        request.setSelectionObject(list);
        request.setType((Object)"selection");
        SessionHandleAdapter.getInstance().getMediator().notifyRequest(request);
        return true;
    }

    public void markPageStale(int type) {
        this.staleType = type;
    }

    public int getStaleType() {
        return this.staleType;
    }

    public Control getPartControl() {
        return this.control;
    }

    public String getId() {
        return ID;
    }

    public void createPartControl(Composite parent) {
        try {
            this.jsEditor.createPartControl(parent);
            Control[] children = parent.getChildren();
            this.control = children[children.length - 1];
            if (this.previouPage != null) {
                this.onBroughtToTop(this.previouPage);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        this.jsEditor.saveModel();
        IReportProvider provider = this.getProvider();
        if (provider != null) {
            provider.saveReport(this.getReportModel(), (Object)this.getEditorInput(), monitor);
            this.firePropertyChange(257);
        }
        this.markPageStale(0);
        this.getEditor().editorDirtyStateChanged();
    }

    protected ModuleHandle getReportModel() {
        IReportProvider provider;
        if (this.model == null && (provider = this.getProvider()) != null) {
            this.model = provider.getReportModuleHandle((Object)this.getEditorInput());
        }
        return this.model;
    }

    public void doSaveAs() {
        IReportProvider provider = this.getProvider();
        if (provider != null) {
            IPath path = provider.getSaveAsPath((Object)this.getEditorInput());
            if (path == null) {
                return;
            }
            IEditorInput input = provider.createNewEditorInput(path);
            this.setInput(input);
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public final synchronized void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    InvocationTargetException[] iteHolder = new InvocationTargetException[1];
                    try {
                        IWorkspaceRunnable workspaceRunnable = new IWorkspaceRunnable(this, iteHolder){
                            private final /* synthetic */ InvocationTargetException[] val$iteHolder;
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                                this.val$iteHolder = val$iteHolder;
                            }

                            public void run(IProgressMonitor pm) throws CoreException {
                                try {
                                    this.this$1.execute(pm);
                                }
                                catch (InvocationTargetException e) {
                                    this.val$iteHolder[0] = e;
                                }
                                catch (InterruptedException e) {
                                    throw new OperationCanceledException(e.getMessage());
                                }
                            }
                        };
                        ResourcesPlugin.getWorkspace().run(workspaceRunnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 0, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (OperationCanceledException e) {
                        throw new InterruptedException(e.getMessage());
                    }
                    if (iteHolder[0] != null) {
                        throw iteHolder[0];
                    }
                }

                public void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    try {
                        ReportScriptFormPage.this.doSave(monitor);
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                }
            };
            try {
                new ProgressMonitorDialog(this.getSite().getWorkbenchWindow().getShell()).run(false, true, op);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
    }

    public boolean isDirty() {
        return this.jsEditor.isDirty();
    }

    public void dispose() {
        super.dispose();
        this.jsEditor.dispose();
        this.jsEditor = null;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ActionRegistry.class) {
            return this.jsEditor.getActionRegistry();
        }
        if (adapter == PalettePage.class) {
            return this.jsEditor.getAdapter(PalettePage.class);
        }
        if (adapter == IContentOutlinePage.class) {
            DesignerOutlinePage outlinePage = new DesignerOutlinePage(this.getModel());
            return outlinePage;
        }
        return this.jsEditor.getAdapter(adapter);
    }

    public IEditorPart getScriptEditor() {
        return this.jsEditor;
    }

    public boolean canLeaveThePage() {
        if (this.isDirty()) {
            this.doSave(null);
        }
        return super.canLeaveThePage();
    }

    private IReportProvider getProvider() {
        return (IReportProvider)this.getEditor().getAdapter(IReportProvider.class);
    }

    protected void finalize() throws Throwable {
        if (Policy.TRACING_PAGE_CLOSE) {
            System.out.println("Report script page finalized");
        }
        super.finalize();
    }
}

