/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.ole.win32.IDataObject;
import org.eclipse.swt.internal.ole.win32.STGMEDIUM;
import org.eclipse.swt.internal.win32.OS;

public class HTMLTransfer
extends ByteArrayTransfer {
    static HTMLTransfer _instance = new HTMLTransfer();
    static final String HTML_FORMAT = "HTML Format";
    static final int HTML_FORMATID = HTMLTransfer.registerType("HTML Format");
    static final String NUMBER = "00000000";
    static final String HEADER = "Version:0.9\r\nStartHTML:00000000\r\nEndHTML:00000000\r\nStartFragment:00000000\r\nEndFragment:00000000\r\n";
    static final String PREFIX = "<html><body><!--StartFragment-->";
    static final String SUFFIX = "<!--EndFragment--></body></html>";
    static final String StartFragment = "StartFragment:";
    static final String EndFragment = "EndFragment:";

    private HTMLTransfer() {
    }

    public static HTMLTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkHTML(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        String string = (String)object;
        int count = string.length();
        char[] chars = new char[count + 1];
        string.getChars(0, count, chars, 0);
        int codePage = OS.GetACP();
        int cchMultiByte = OS.WideCharToMultiByte(codePage, 0, chars, -1, null, 0, null, null);
        if (cchMultiByte == 0) {
            transferData.stgmedium = new STGMEDIUM();
            transferData.result = -2147221402;
            return;
        }
        int startHTML = HEADER.length();
        int startFragment = startHTML + PREFIX.length();
        int endFragment = startFragment + cchMultiByte - 1;
        int endHTML = endFragment + SUFFIX.length();
        StringBuffer buffer = new StringBuffer(HEADER);
        int maxLength = NUMBER.length();
        int start = buffer.toString().indexOf(NUMBER);
        String temp = Integer.toString(startHTML);
        buffer.replace(start + maxLength - temp.length(), start + maxLength, temp);
        start = buffer.toString().indexOf(NUMBER, start);
        temp = Integer.toString(endHTML);
        buffer.replace(start + maxLength - temp.length(), start + maxLength, temp);
        start = buffer.toString().indexOf(NUMBER, start);
        temp = Integer.toString(startFragment);
        buffer.replace(start + maxLength - temp.length(), start + maxLength, temp);
        start = buffer.toString().indexOf(NUMBER, start);
        temp = Integer.toString(endFragment);
        buffer.replace(start + maxLength - temp.length(), start + maxLength, temp);
        buffer.append(PREFIX);
        buffer.append(string);
        buffer.append(SUFFIX);
        count = buffer.length();
        chars = new char[count + 1];
        buffer.getChars(0, count, chars, 0);
        cchMultiByte = OS.WideCharToMultiByte(codePage, 0, chars, -1, null, 0, null, null);
        int lpMultiByteStr = OS.GlobalAlloc(64, cchMultiByte);
        OS.WideCharToMultiByte(codePage, 0, chars, -1, lpMultiByteStr, cchMultiByte, null, null);
        transferData.stgmedium = new STGMEDIUM();
        transferData.stgmedium.tymed = 1;
        transferData.stgmedium.unionField = lpMultiByteStr;
        transferData.stgmedium.pUnkForRelease = 0;
        transferData.result = 0;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object nativeToJava(TransferData transferData) {
        block22: {
            block21: {
                if (this.isSupportedType(transferData) == false) return null;
                if (transferData.pIDataObject == 0) {
                    return null;
                }
                data = new IDataObject(transferData.pIDataObject);
                data.AddRef();
                stgmedium = new STGMEDIUM();
                formatetc = transferData.formatetc;
                stgmedium.tymed = 1;
                transferData.result = data.GetData(formatetc, stgmedium);
                data.Release();
                if (transferData.result != 0) {
                    return null;
                }
                hMem = stgmedium.unionField;
                try {
                    block20: {
                        lpMultiByteStr = OS.GlobalLock(hMem);
                        if (lpMultiByteStr == 0) {
                        } else {
                            try {
                                codePage = OS.GetACP();
                                cchWideChar = OS.MultiByteToWideChar(codePage, 1, lpMultiByteStr, -1, null, 0);
                                if (cchWideChar == 0) {
                                    while (true) {
                                        var18_12 = null;
                                        break block20;
                                        break;
                                    }
                                }
                                lpWideCharStr = new char[cchWideChar - 1];
                                OS.MultiByteToWideChar(codePage, 1, lpMultiByteStr, -1, lpWideCharStr, lpWideCharStr.length);
                                string = new String(lpWideCharStr);
                                fragmentStart = 0;
                                fragmentEnd = 0;
                                start = string.indexOf("StartFragment:") + "StartFragment:".length();
                                for (end = start + 1; end < string.length(); ++end) {
                                    s = string.substring(start, end);
                                    try {
                                        fragmentStart = Integer.parseInt(s);
                                        continue;
                                    }
                                    catch (NumberFormatException v0) {}
                                    break;
                                }
                                start = string.indexOf("EndFragment:") + "EndFragment:".length();
                                for (end = start + 1; end < string.length(); ++end) {
                                    s = string.substring(start, end);
                                    try {
                                        fragmentEnd = Integer.parseInt(s);
                                        continue;
                                    }
                                    catch (NumberFormatException v1) {}
                                    break;
                                }
                                if (fragmentEnd <= fragmentStart || fragmentEnd > lpWideCharStr.length) ** continue;
                                s = string.substring(fragmentStart, fragmentEnd);
                                prefix = s.indexOf(foxStart = "<!--StartFragment -->\r\n");
                                if (prefix != -1) {
                                    s = s.substring(prefix += foxStart.length());
                                }
                                var20_24 = s;
                            }
                            catch (Throwable var19_25) {
                                var18_14 = null;
                                OS.GlobalUnlock(hMem);
                                throw var19_25;
                            }
                        }
lbl65:
                        // 2 sources

                        while (true) {
                            var21_7 = null;
                            break block21;
                            break;
                        }
                    }
                    OS.GlobalUnlock(hMem);
                    ** continue;
                    var18_13 = null;
                    OS.GlobalUnlock(hMem);
                    break block22;
                }
                catch (Throwable var22_26) {
                    var21_9 = null;
                    OS.GlobalFree(hMem);
                    throw var22_26;
                }
            }
            OS.GlobalFree(hMem);
            return null;
        }
        var21_8 = null;
        OS.GlobalFree(hMem);
        return var20_24;
    }

    protected int[] getTypeIds() {
        return new int[]{HTML_FORMATID};
    }

    protected String[] getTypeNames() {
        return new String[]{HTML_FORMAT};
    }

    boolean checkHTML(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    protected boolean validate(Object object) {
        return this.checkHTML(object);
    }
}

