/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.html;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.HTMLEmitterConfig;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IAction;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.IHTMLImageHandler;
import org.eclipse.birt.report.engine.api.IImage;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.api.impl.Action;
import org.eclipse.birt.report.engine.api.impl.Image;
import org.eclipse.birt.report.engine.content.IBandContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IElement;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.css.dom.CellMergedStyle;
import org.eclipse.birt.report.engine.emitter.ContentEmitterAdapter;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.emitter.html.AttributeBuilder;
import org.eclipse.birt.report.engine.emitter.html.DetailRowState;
import org.eclipse.birt.report.engine.emitter.html.HTMLWriter;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.executor.css.HTMLProcessor;
import org.eclipse.birt.report.engine.i18n.EngineResourceHandle;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.ir.ExtendedItemDesign;
import org.eclipse.birt.report.engine.ir.LabelItemDesign;
import org.eclipse.birt.report.engine.ir.ListItemDesign;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.SimpleMasterPageDesign;
import org.eclipse.birt.report.engine.ir.TableItemDesign;
import org.eclipse.birt.report.engine.ir.TemplateDesign;
import org.eclipse.birt.report.engine.parser.TextParser;
import org.eclipse.birt.report.engine.presentation.ContentEmitterVisitor;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSValue;

public class HTMLReportEmitter
extends ContentEmitterAdapter {
    public static final String OUTPUT_FORMAT_HTML = "HTML";
    public static final String REPORT_FILE = "report.html";
    public static final String IMAGE_FOLDER = "image";
    protected OutputStream out = null;
    protected IReportContent report;
    protected IReportRunnable runnable;
    protected IRenderOption renderOption;
    protected boolean outputMasterPageContent = true;
    protected boolean isEmbeddable = false;
    protected String urlEncoding = null;
    protected boolean htmlRtLFlag = false;
    protected boolean pageFooterFloatFlag = true;
    protected boolean includeSelectionHandler = false;
    protected List ouputInstanceIDs = null;
    protected int pageNo = 0;
    protected HTMLWriter writer;
    protected Object renderContext;
    protected Stack stack = new Stack();
    protected static Logger logger;
    protected IHTMLImageHandler imageHandler;
    protected IHTMLActionHandler actionHandler;
    protected IEmitterServices services;
    private Stack tagStack = new Stack();
    protected static final int DISPLAY_BLOCK = 1;
    protected static final int DISPLAY_INLINE = 2;
    protected static final int DISPLAY_INLINE_BLOCK = 4;
    protected static final int DISPLAY_NONE = 8;
    protected static final int DISPLAY_FLAG_ALL = 65535;
    protected ContentEmitterVisitor contentVisitor;
    private Stack detailRowStateStack = new Stack();
    protected int bookmarkId = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    public HTMLReportEmitter() {
        this.contentVisitor = new ContentEmitterVisitor((IContentEmitter)this);
    }

    public void initialize(IEmitterServices services) {
        Object ac;
        Object im;
        Object emitterConfig;
        this.services = services;
        Object fd = services.getOption("outputFile");
        File file = null;
        try {
            if (fd != null) {
                file = new File(fd.toString());
                File parent = file.getParentFile();
                if (parent != null && !parent.exists()) {
                    parent.mkdirs();
                }
                this.out = new BufferedOutputStream(new FileOutputStream(file));
            }
        }
        catch (FileNotFoundException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        if (this.out == null) {
            Object value = services.getOption("outputStream");
            if (value != null && value instanceof OutputStream) {
                this.out = (OutputStream)value;
            } else {
                try {
                    file = new File(REPORT_FILE);
                    this.out = new BufferedOutputStream(new FileOutputStream(file));
                }
                catch (FileNotFoundException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        if ((emitterConfig = services.getEmitterConfig().get("html")) != null && emitterConfig instanceof HTMLEmitterConfig) {
            this.imageHandler = ((HTMLEmitterConfig)emitterConfig).getImageHandler();
            this.actionHandler = ((HTMLEmitterConfig)emitterConfig).getActionHandler();
        }
        if ((im = services.getOption("imageHandler")) != null && im instanceof IHTMLImageHandler) {
            this.imageHandler = (IHTMLImageHandler)im;
        }
        if ((ac = services.getOption("actionHandler")) != null && ac instanceof IHTMLActionHandler) {
            this.actionHandler = (IHTMLActionHandler)ac;
        }
        this.renderContext = services.getRenderContext() instanceof Map ? ((Map)services.getRenderContext()).get("HTML_RENDER_CONTEXT") : services.getRenderContext();
        this.renderOption = services.getRenderOption();
        this.runnable = services.getReportRunnable();
        if (this.renderOption != null && this.renderOption instanceof HTMLRenderOption) {
            HTMLRenderOption htmlOption = (HTMLRenderOption)this.renderOption;
            this.isEmbeddable = htmlOption.getEmbeddable();
            HashMap options = this.renderOption.getOutputSetting();
            if (options != null) {
                this.urlEncoding = (String)options.get("url-encoding");
            }
            this.outputMasterPageContent = htmlOption.getMasterPageContent();
            IHTMLActionHandler actHandler = htmlOption.getActionHandle();
            if (ac != null) {
                this.actionHandler = actHandler;
            }
            this.pageFooterFloatFlag = htmlOption.getPageFooterFloatFlag();
            this.htmlRtLFlag = htmlOption.getHtmlRtLFlag();
            this.includeSelectionHandler = htmlOption.getIncludeSelectionHandle();
            this.ouputInstanceIDs = htmlOption.getInstanceIDs();
        }
        this.writer = new HTMLWriter();
    }

    public IReportContent getReport() {
        return this.report;
    }

    public void push(IStyle style) {
        this.stack.push(new Boolean(this.peek(style)));
    }

    public boolean pop() {
        return (Boolean)this.stack.pop();
    }

    public boolean peek(IStyle style) {
        String formats;
        boolean isHidden = false;
        if (!this.stack.empty()) {
            isHidden = (Boolean)this.stack.peek();
        }
        if (!(isHidden || (formats = style.getVisibleFormat()) == null || formats.indexOf("viewer") < 0 && formats.indexOf("all") < 0)) {
            isHidden = true;
        }
        return isHidden;
    }

    public boolean isHidden() {
        return (Boolean)this.stack.peek();
    }

    public String getOutputFormat() {
        return OUTPUT_FORMAT_HTML;
    }

    protected void fixTransparentPNG() {
        this.writer.writeCode("<!--[if gte IE 5.5000]>");
        this.writer.writeCode("   <script language=\"JavaScript\"> var ie55up = true </script>");
        this.writer.writeCode("<![endif]-->");
        this.writer.writeCode("<script language=\"JavaScript\">");
        this.writer.writeCode("   function fixPNG(myImage) // correctly handle PNG transparency in Win IE 5.5 or higher.");
        this.writer.writeCode("      {");
        this.writer.writeCode("      if (window.ie55up)");
        this.writer.writeCode("         {");
        this.writer.writeCode("         var imgID = (myImage.id) ? \"id='\" + myImage.id + \"' \" : \"\"");
        this.writer.writeCode("         var imgClass = (myImage.className) ? \"class='\" + myImage.className + \"' \" : \"\"");
        this.writer.writeCode("         var imgTitle = (myImage.title) ? \"title='\" + myImage.title + \"' \" : \"title='\" + myImage.alt + \"' \"");
        this.writer.writeCode("         var imgStyle = \"display:inline-block;\" + myImage.style.cssText");
        this.writer.writeCode("         var strNewHTML = \"<span \" + imgID + imgClass + imgTitle");
        this.writer.writeCode("         strNewHTML += \" style=\\\"\" + \"width:\" + myImage.width + \"px; height:\" + myImage.height + \"px;\" + imgStyle + \";\"");
        this.writer.writeCode("         strNewHTML += \"filter:progid:DXImageTransform.Microsoft.AlphaImageLoader\"");
        this.writer.writeCode("         strNewHTML += \"(src=\\'\" + myImage.src + \"\\', sizingMethod='scale');\\\"></span>\"");
        this.writer.writeCode("         myImage.outerHTML = strNewHTML");
        this.writer.writeCode("         }");
        this.writer.writeCode("      }");
        this.writer.writeCode("</script>");
    }

    public void start(IReportContent report) {
        IStyle style;
        String reportStyleName;
        logger.log(Level.FINE, "[HTMLReportEmitter] Start emitter.");
        this.report = report;
        this.writer.open(this.out, "UTF-8");
        if (this.htmlRtLFlag) {
            String string = reportStyleName = report == null ? null : report.getDesign().getRootStyleName();
            if (reportStyleName != null) {
                style = report.findStyle(reportStyleName);
                style.setTextAlign("right");
            }
        }
        if (this.isEmbeddable) {
            this.fixTransparentPNG();
            this.writer.openTag("div");
            String string = reportStyleName = report == null ? null : report.getDesign().getRootStyleName();
            if (reportStyleName != null) {
                style = report.findStyle(reportStyleName);
                StringBuffer styleBuffer = new StringBuffer();
                AttributeBuilder.buildStyle(styleBuffer, style, this, false);
                this.writer.attribute("style", styleBuffer.toString());
            }
            return;
        }
        this.writer.startWriter();
        this.writer.openTag("html");
        this.writer.openTag("head");
        Report reportDesign = null;
        if (report != null) {
            reportDesign = report.getDesign();
            ReportDesignHandle designHandle = reportDesign.getReportDesign();
            String title = designHandle.getStringProperty("title");
            if (title == null && this.renderOption != null && this.renderOption instanceof HTMLRenderOption) {
                HTMLRenderOption htmlOption = (HTMLRenderOption)this.renderOption;
                title = htmlOption.getHtmlTitle();
            }
            if (title != null) {
                this.writer.openTag("title");
                this.writer.text(title);
                this.writer.closeTag("title");
            }
        }
        this.writer.openTag("META");
        this.writer.attribute("http-equiv", "Content-Type");
        this.writer.attribute("content", "text/html; charset=UTF-8");
        this.writer.closeNoEndTag();
        this.writer.openTag("style");
        this.writer.attribute("type", "text/css");
        StringBuffer styleBuffer = new StringBuffer();
        if (report == null) {
            logger.log(Level.WARNING, "[HTMLReportEmitter] Report object is null.");
        } else {
            for (int n = 0; n < reportDesign.getStyleCount(); ++n) {
                styleBuffer.delete(0, styleBuffer.capacity());
                style = reportDesign.getStyle(n);
                AttributeBuilder.buildStyle(styleBuffer, style, this, true);
                this.writer.style("style_" + n, styleBuffer.toString(), false);
            }
        }
        this.writer.closeTag("style");
        this.fixTransparentPNG();
        this.writer.closeTag("head");
        String reportStyleName2 = report == null ? null : report.getDesign().getRootStyleName();
        this.writer.openTag("body");
        if (reportStyleName2 != null) {
            this.writer.attribute("class", reportStyleName2);
        }
    }

    private void appendErrorMessage(int index, ExecutionContext.ElementExceptionInfo info) {
        EngineResourceHandle rc = EngineResourceHandle.getInstance();
        this.writer.writeCode("\t\t\t<div>");
        this.writer.writeCode("\t\t\t\t<div  id=\"error_title\" style=\"text-decoration:underline\">");
        String name = info.getName();
        if (name != null) {
            this.writer.text(rc.getMessage("Error.ReportErrorMessage", new Object[]{info.getType(), name}), false);
        } else {
            this.writer.text(rc.getMessage("Error.ReportErrorMessageWithID", new Object[]{info.getType(), info.getID()}), false);
        }
        this.writer.writeCode("</div>");
        ArrayList errorList = info.getErrorList();
        ArrayList countList = info.getCountList();
        for (int i = 0; i < errorList.size(); ++i) {
            String errorId = "document.getElementById('error_detail" + index + "_" + i + "')";
            String errorIcon = "document.getElementById('error_icon" + index + "_" + i + "')";
            String onClick = "if (" + errorId + ".style.display == 'none') { " + errorIcon + ".innerHTML = '- '; " + errorId + ".style.display = 'block'; }" + "else { " + errorIcon + ".innerHTML = '+ '; " + errorId + ".style.display = 'none'; }";
            this.writer.writeCode("<div>");
            BirtException ex = (BirtException)errorList.get(i);
            this.writer.writeCode("<span id=\"error_icon" + index + "_" + i + "\"  style=\"cursor:pointer\" onclick=\"" + onClick + "\" > + </span>");
            this.writer.text(ex.getLocalizedMessage());
            this.writer.writeCode("\t\t\t\t<pre id=\"error_detail" + index + "_" + i + "\" style=\"display:none;\" >");
            String messageTitle = rc.getMessage("Error.ReportErrorID", new Object[]{ex.getErrorCode(), countList.get(i)});
            String detailTag = rc.getMessage("Error.ReportErrorDetail");
            String messageBody = this.getDetailMessage((Throwable)ex);
            boolean indent = this.writer.isIndent();
            this.writer.setIndent(false);
            this.writer.text(messageTitle, false);
            this.writer.writeCode("\r\n");
            this.writer.text(detailTag, false);
            this.writer.text(messageBody, false);
            this.writer.setIndent(indent);
            this.writer.writeCode("\t\t\t\t</pre>");
            this.writer.writeCode("</div>");
        }
        this.writer.writeCode("</div>");
        this.writer.writeCode("<br>");
    }

    private String getDetailMessage(Throwable t) {
        StringWriter out = new StringWriter();
        PrintWriter print = new PrintWriter(out);
        try {
            t.printStackTrace(print);
        }
        catch (Throwable ex) {
            // empty catch block
        }
        print.flush();
        return out.getBuffer().toString();
    }

    protected boolean outputErrors(List errors) {
        if (errors != null && !errors.isEmpty()) {
            this.writer.writeCode("\t<hr style=\"color:red\"/>");
            this.writer.writeCode("\t<div style=\"color:red\">");
            this.writer.writeCode("\t\t<div>");
            this.writer.text(EngineResourceHandle.getInstance().getMessage("Error.ErrorOnReportPage"), false);
            this.writer.writeCode("</div>");
            this.writer.writeCode("<br>");
            Iterator it = errors.iterator();
            int index = 0;
            while (it.hasNext()) {
                this.appendErrorMessage(index++, (ExecutionContext.ElementExceptionInfo)it.next());
            }
            this.writer.writeCode("</div>");
            return true;
        }
        return false;
    }

    public void end(IReportContent report) {
        List errors;
        logger.log(Level.FINE, "[HTMLReportEmitter] End body.");
        if (report != null && (errors = report.getErrors()) != null && !errors.isEmpty()) {
            this.outputErrors(errors);
        }
        if (!this.isEmbeddable) {
            this.writer.closeTag("body");
            this.writer.closeTag("html");
        } else {
            this.writer.closeTag("div");
        }
        this.writer.endWriter();
        this.writer.close();
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    public void handlePageStyle(String styleName, IStyle style) {
        StringBuffer styleBuffer = new StringBuffer();
        if (this.isEmbeddable) {
            AttributeBuilder.buildPageStyle(styleBuffer, style, this);
        } else {
            IStyle classStyle = this.report.findStyle(styleName);
            AttributeBuilder.buildPageStyle(styleBuffer, classStyle, this);
        }
        this.writer.attribute("style", styleBuffer.toString());
    }

    public void startPage(IPageContent page) {
        Object genBy;
        ++this.pageNo;
        if (this.pageNo > 1 && !this.outputMasterPageContent) {
            this.writer.openTag("hr");
            this.writer.closeTag("hr");
        }
        this.writer.openTag("div");
        if (page != null && (genBy = page.getGenerateBy()) instanceof MasterPageDesign) {
            MasterPageDesign masterPage = (MasterPageDesign)genBy;
            String masterPageStyleName = masterPage.getStyleName();
            IStyle classStyle = this.report.findStyle(masterPageStyleName);
            StringBuffer styleBuffer = new StringBuffer();
            AttributeBuilder.buildBackgroundStyle(styleBuffer, classStyle, this);
            this.writer.attribute("style", styleBuffer.toString());
        }
        if (this.htmlRtLFlag) {
            this.writer.attribute("dir", "RTL");
        }
        if (this.pageNo > 1) {
            this.writer.attribute("style", "page-break-before: always;");
        }
        if (page != null && this.outputMasterPageContent) {
            SimpleMasterPageDesign masterPage;
            boolean showHeader = true;
            Object genBy2 = page.getGenerateBy();
            if (genBy2 instanceof SimpleMasterPageDesign && !(masterPage = (SimpleMasterPageDesign)genBy2).isShowHeaderOnFirst() && page.getPageNumber() == 1L) {
                showHeader = false;
            }
            if (showHeader) {
                this.writer.openTag("div");
                this.handlePageStyle(page.getPageHeader().getStyleClass(), page.getPageHeader().getStyle());
                this.contentVisitor.visitChildren(page.getPageHeader(), null);
                this.writer.closeTag("div");
            }
        }
        this.writer.openTag("div");
        if (page != null) {
            IContent pageBody = page.getPageBody();
            IStyle bodyStyle = pageBody.getStyle();
            String bodyStyleName = pageBody.getStyleClass();
            Object genBy3 = page.getGenerateBy();
            if (genBy3 instanceof MasterPageDesign) {
                MasterPageDesign masterPage = (MasterPageDesign)genBy3;
                StringBuffer styleBuffer = new StringBuffer();
                if (this.isEmbeddable) {
                    AttributeBuilder.buildPageStyle(styleBuffer, bodyStyle, this);
                } else {
                    IStyle classStyle = this.report.findStyle(bodyStyleName);
                    AttributeBuilder.buildPageStyle(styleBuffer, classStyle, this);
                }
                if (!this.pageFooterFloatFlag) {
                    AttributeBuilder.buildSize(styleBuffer, "min-height", masterPage.getPageHeight());
                }
                this.writer.attribute("style", styleBuffer.toString());
            }
        }
    }

    public void endPage(IPageContent page) {
        logger.log(Level.FINE, "[HTMLReportEmitter] End page.");
        this.writer.closeTag("div");
        if (page != null && this.outputMasterPageContent) {
            SimpleMasterPageDesign masterPage;
            boolean showFooter = true;
            Object genBy = page.getGenerateBy();
            if (genBy instanceof SimpleMasterPageDesign && !(masterPage = (SimpleMasterPageDesign)genBy).isShowFooterOnLast()) {
                long totalPage = page.getPageNumber();
                IReportContent report = page.getReportContent();
                if (report != null) {
                    totalPage = report.getTotalPage();
                }
                if (page.getPageNumber() == totalPage) {
                    showFooter = false;
                }
            }
            if (showFooter) {
                this.writer.openTag("div");
                this.handlePageStyle(page.getPageFooter().getStyleClass(), page.getPageFooter().getStyle());
                this.contentVisitor.visitChildren(page.getPageFooter(), null);
                this.writer.closeTag("div");
            }
        }
        this.writer.closeTag("div");
    }

    public void startTable(ITableContent table) {
        if (!$assertionsDisabled && table == null) {
            throw new AssertionError();
        }
        IStyle mergedStyle = table.getStyle();
        this.push(mergedStyle);
        if (this.isHidden()) {
            return;
        }
        logger.log(Level.FINE, "[HTMLTableEmitter] Start table");
        DimensionType x = table.getX();
        DimensionType y = table.getY();
        StringBuffer styleBuffer = new StringBuffer();
        this.addDefaultTableStyles(styleBuffer);
        this.writer.openTag("table");
        this.setStyleName(table.getStyleClass());
        int display = this.checkElementType(x, y, mergedStyle, styleBuffer);
        this.setDisplayProperty(display, 2, styleBuffer);
        this.handleShrink(1, mergedStyle, table.getHeight(), table.getWidth(), styleBuffer);
        this.handleStyle((IContent)table, styleBuffer);
        String bookmark = table.getBookmark();
        if (bookmark == null) {
            bookmark = this.generateUniqueID();
            table.setBookmark(bookmark);
        }
        this.setBookmark(null, bookmark);
        this.setActiveIDTypeIID((IContent)table);
        String caption = table.getCaption();
        if (caption != null && caption.length() > 0) {
            this.writer.openTag("caption");
            this.writer.text(caption);
            this.writer.closeTag("caption");
        }
        if (this.includeSelectionHandler) {
            Object generateBy = table.getGenerateBy();
            if (generateBy instanceof TableItemDesign) {
                this.startSelectHandleTable();
            }
            DetailRowState state = null;
            state = generateBy instanceof TableItemDesign ? new DetailRowState(false, false, true) : new DetailRowState(false, false, false);
            this.detailRowStateStack.push(state);
        }
        this.writeColumns(table);
    }

    protected void startSelectHandleTable() {
        this.writer.openTag("col");
        this.writer.attribute("class", "table-side-bar-style");
        this.writer.closeTag("col");
        this.writer.openTag("col");
        this.writer.closeTag("col");
        this.writer.openTag("tr");
        this.writer.openTag("td");
        this.writer.closeTag("td");
        this.writer.openTag("td");
        this.writer.openTag("table");
        this.writer.attribute("style", "width:100%");
    }

    protected void endSelectHandleTable() {
        this.writer.closeTag("table");
        this.writer.closeTag("td");
        this.writer.closeTag("tr");
    }

    protected void writeColumns(ITableContent table) {
        for (int i = 0; i < table.getColumnCount(); ++i) {
            IStyle style;
            String styleName;
            IColumn column = table.getColumn(i);
            if (this.isColumnHidden(column)) continue;
            this.writer.openTag("col");
            this.setStyleName(column.getStyleClass());
            StringBuffer styleBuffer = new StringBuffer();
            AttributeBuilder.buildSize(styleBuffer, "width", column.getWidth());
            if (this.isEmbeddable && (styleName = column.getStyleClass()) != null && (style = this.report.findStyle(styleName)) != null) {
                AttributeBuilder.buildStyle(styleBuffer, style, this);
            }
            this.writer.attribute("style", styleBuffer.toString());
            InstanceID iid = column.getInstanceID();
            if (iid != null) {
                this.writer.attribute("iid", iid.toString());
            }
            this.writer.closeNoEndTag();
        }
    }

    public void push(boolean hidden) {
        boolean isHidden = false;
        if (!this.stack.empty()) {
            isHidden = (Boolean)this.stack.peek();
        }
        if (!isHidden) {
            isHidden = hidden;
        }
        this.stack.push(new Boolean(isHidden));
    }

    private boolean isColumnHidden(IColumn column) {
        String formats = column.getVisibleFormat();
        return formats != null && (formats.indexOf("viewer") >= 0 || formats.indexOf("all") >= 0);
    }

    private int getNewColSpan(ICellContent cell) {
        int columnNumber = cell.getColumn();
        int colSpan = cell.getColSpan();
        ITableContent table = this.getTableOfCell(cell);
        if (table == null) {
            return colSpan;
        }
        int newColSpan = colSpan;
        for (int i = 0; i < colSpan; ++i) {
            IColumn column = table.getColumn(columnNumber + i);
            if (!this.isColumnHidden(column)) continue;
            --newColSpan;
        }
        return newColSpan;
    }

    private ITableContent getTableOfCell(ICellContent cell) {
        for (IElement parent = cell.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof ITableContent)) continue;
            return (ITableContent)parent;
        }
        return null;
    }

    public void endTable(ITableContent table) {
        if (this.pop()) {
            return;
        }
        if (this.includeSelectionHandler) {
            Object generateBy = table.getGenerateBy();
            if (generateBy instanceof TableItemDesign) {
                this.endSelectHandleTable();
            }
            this.detailRowStateStack.pop();
        }
        this.writer.closeTag("table");
        logger.log(Level.FINE, "[HTMLTableEmitter] End table");
    }

    public void startTableHeader(ITableBandContent band) {
        if (this.isHidden()) {
            return;
        }
        this.writer.openTag("thead");
    }

    public void endTableHeader(ITableBandContent band) {
        if (this.isHidden()) {
            return;
        }
        this.writer.closeTag("thead");
    }

    public void startTableBody(ITableBandContent band) {
        if (this.isHidden()) {
            return;
        }
        this.writer.openTag("tbody");
    }

    public void endTableBody(ITableBandContent band) {
        if (this.isHidden()) {
            return;
        }
        this.writer.closeTag("tbody");
    }

    public void startTableFooter(ITableBandContent band) {
        if (this.isHidden()) {
            return;
        }
        this.writer.openTag("tfoot");
    }

    public void endTableFooter(ITableBandContent band) {
        if (this.isHidden()) {
            return;
        }
        this.writer.closeTag("tfoot");
    }

    boolean isRowInDetailBand(IRowContent row) {
        IElement parent = row.getParent();
        if (!(parent instanceof IBandContent)) {
            return false;
        }
        IBandContent band = (IBandContent)parent;
        return band.getBandType() == 0;
    }

    public void startRow(IRowContent row) {
        if (!$assertionsDisabled && row == null) {
            throw new AssertionError();
        }
        IStyle mergedStyle = row.getStyle();
        this.push(mergedStyle);
        if (this.isHidden()) {
            return;
        }
        if (this.includeSelectionHandler && this.isRowInDetailBand(row)) {
            DetailRowState state = (DetailRowState)this.detailRowStateStack.peek();
            if (!state.hasOutput && !state.isStartOfDetail && state.isTable) {
                state.isStartOfDetail = true;
                state.hasOutput = true;
            }
        }
        this.writer.openTag("tr");
        this.setStyleName(row.getStyleClass());
        this.setBookmark(null, row.getBookmark());
        StringBuffer styleBuffer = new StringBuffer();
        AttributeBuilder.buildSize(styleBuffer, "height", row.getHeight());
        this.outputRowMetaData(row);
        this.handleStyle((IContent)row, styleBuffer);
    }

    protected IGroupContent getGroup(IBandContent bandContent) {
        IContent parent = (IContent)bandContent.getParent();
        if (parent instanceof IGroupContent) {
            return (IGroupContent)parent;
        }
        return null;
    }

    protected void outputRowMetaData(IRowContent rowContent) {
        IElement parent = rowContent.getParent();
        if (parent instanceof ITableBandContent) {
            ITableBandContent bandContent = (ITableBandContent)parent;
            IGroupContent group = rowContent.getGroup();
            String groupId = rowContent.getGroupId();
            if (groupId != null) {
                this.writer.attribute("group-id", groupId);
            }
            String rowType = null;
            String metaType = null;
            int bandType = bandContent.getBandType();
            if (bandType == 1) {
                metaType = "wrth";
                rowType = "header";
            } else if (bandType == 2) {
                metaType = "wrtf";
                rowType = "footer";
            } else if (bandType == 3) {
                rowType = "group-header";
                if (group != null) {
                    metaType = "wrgh" + group.getGroupLevel();
                }
            } else if (bandType == 4) {
                rowType = "group-footer";
                if (group != null) {
                    metaType = "wrgf" + group.getGroupLevel();
                }
            }
            this.writer.attribute("type", metaType);
            this.writer.attribute("row-type", rowType);
        }
    }

    public void endRow(IRowContent row) {
        if (this.pop()) {
            return;
        }
        if (this.includeSelectionHandler) {
            DetailRowState state = (DetailRowState)this.detailRowStateStack.peek();
            if (state.isStartOfDetail) {
                state.isStartOfDetail = false;
            }
        }
        this.writer.closeTag("tr");
    }

    private boolean isCellInTableHead(ICellContent cell) {
        int type;
        IElement tableBand;
        IElement row = cell.getParent();
        return row instanceof IRowContent && (tableBand = row.getParent()) instanceof ITableBandContent && (type = ((ITableBandContent)tableBand).getBandType()) == 1;
    }

    public void startCell(ICellContent cell) {
        int colSpan = cell.getColSpan();
        this.push(false);
        if (this.isHidden()) {
            return;
        }
        logger.log(Level.FINE, "[HTMLTableEmitter] Start cell.");
        boolean isInTableHead = this.isCellInTableHead(cell);
        if (isInTableHead) {
            this.writer.openTag("th");
        } else {
            this.writer.openTag("td");
        }
        this.setStyleName(cell.getStyleClass());
        if (colSpan > 1) {
            this.writer.attribute("colspan", colSpan);
        }
        if (cell.getRowSpan() > 1) {
            this.writer.attribute("rowspan", cell.getRowSpan());
        }
        StringBuffer styleBuffer = new StringBuffer();
        this.handleColumnRelatedStyle(cell, styleBuffer);
        this.handleVerticalAlign(cell, styleBuffer);
        if (isInTableHead) {
            this.handleCellFont(cell, styleBuffer);
        }
        this.handleStyle((IContent)cell, styleBuffer);
        this.writer.attribute("align", cell.getComputedStyle().getTextAlign());
        this.initializeCell(cell);
    }

    private void initializeCell(ICellContent cell) {
        if (this.includeSelectionHandler) {
            if (this.needColumnFilter(cell) || cell.isStartOfGroup()) {
                this.writer.openTag("table");
                this.writer.attribute("height", "100%");
                this.writer.openTag("tr");
                this.writer.openTag("td");
            }
            if (cell.isStartOfGroup()) {
                this.writer.attribute("style", "vertical-align:top");
                this.writer.openTag("img");
                this.writer.attribute("src", "iv/images/collapsexpand.gif");
                this.writer.attribute("style", "cursor:pointer");
                String bookmark = this.generateUniqueID();
                this.setBookmark(null, bookmark);
                this.setActiveIDTypeIID(bookmark, "GROUP", null, -1L);
                this.writer.closeTag("img");
                this.writer.closeTag("td");
                this.writer.openTag("td");
            }
        }
    }

    private void handleColumnRelatedStyle(ICellContent cell, StringBuffer styleBuffer) {
        CellMergedStyle style = new CellMergedStyle(cell);
        AttributeBuilder.buildStyle(styleBuffer, (IStyle)style, this, true);
    }

    public void endCell(ICellContent cell) {
        if (this.pop()) {
            return;
        }
        logger.log(Level.FINE, "[HTMLReportEmitter] End cell.");
        if (this.includeSelectionHandler) {
            if (this.needColumnFilter(cell)) {
                this.writer.closeTag("td");
                this.writer.openTag("td");
                this.writer.attribute("style", "vertical-align:top");
                this.writer.openTag("img");
                this.writer.attribute("src", "iv/images/columnicon.gif");
                this.writer.attribute("style", "cursor:pointer");
                this.writer.attribute("column", cell.getColumnInstance().getInstanceID().toString());
                String bookmark = this.generateUniqueID();
                this.setBookmark(null, bookmark);
                this.setActiveIDTypeIID(bookmark, "COLOUMNINFO", null, -1L);
                this.writer.closeTag("img");
            }
            if (this.needColumnFilter(cell) || cell.isStartOfGroup()) {
                this.writer.closeTag("td");
                this.writer.closeTag("tr");
                this.writer.closeTag("table");
            }
        }
        if (this.isCellInTableHead(cell)) {
            this.writer.closeTag("th");
        } else {
            this.writer.closeTag("td");
        }
    }

    public void startContainer(IContainerContent container) {
        IStyle mergedStyle = container.getStyle();
        this.push(mergedStyle);
        if (this.isHidden()) {
            return;
        }
        logger.log(Level.FINE, "[HTMLReportEmitter] Start container");
        StringBuffer styleBuffer = new StringBuffer();
        DimensionType x = container.getX();
        DimensionType y = container.getY();
        DimensionType width = container.getWidth();
        DimensionType height = container.getHeight();
        int display = this.checkElementType(x, y, width, height, mergedStyle, styleBuffer);
        String tagName = this.openTagByType(display, 65535);
        this.tagStack.push(tagName);
        this.setStyleName(container.getStyleClass());
        String bookmark = container.getBookmark();
        if (bookmark == null) {
            bookmark = this.generateUniqueID();
            container.setBookmark(bookmark);
        }
        this.setBookmark(tagName, bookmark);
        this.setActiveIDTypeIID((IContent)container);
        this.setDisplayProperty(display, 4, styleBuffer);
        this.handleShrink(display, mergedStyle, height, width, styleBuffer);
        this.handleStyle((IContent)container, styleBuffer);
    }

    public void endContainer(IContainerContent container) {
        if (this.pop()) {
            return;
        }
        this.writer.closeTag((String)this.tagStack.pop());
        logger.log(Level.FINE, "[HTMLContainerEmitter] End container");
    }

    public void startText(ITextContent text) {
        String tagName;
        IStyle mergedStyle = text.getStyle();
        if (this.peek(mergedStyle)) {
            return;
        }
        logger.log(Level.FINE, "[HTMLReportEmitter] Start text");
        this.resizeTemplateElement((IContent)text);
        StringBuffer styleBuffer = new StringBuffer();
        DimensionType x = text.getX();
        DimensionType y = text.getY();
        DimensionType width = text.getWidth();
        DimensionType height = text.getHeight();
        String textValue = text.getText();
        if (textValue == null || textValue == "") {
            textValue = " ";
        }
        int display = textValue != null && textValue.indexOf(10) >= 0 ? this.checkElementType(x, y, width, height, mergedStyle, styleBuffer) : this.checkElementType(x, y, mergedStyle, styleBuffer);
        if (this.handleAction(text.getHyperlinkAction())) {
            tagName = "a";
            this.setDisplayProperty(display, 5, styleBuffer);
            AttributeBuilder.checkHyperlinkTextDecoration(mergedStyle, styleBuffer);
        } else {
            tagName = this.openTagByType(display, 65535);
            this.setDisplayProperty(display, 4, styleBuffer);
        }
        this.setStyleName(text.getStyleClass());
        this.setBookmark(tagName, text.getBookmark());
        this.setActiveIDTypeIID((IContent)text);
        this.writer.attribute("title", text.getHelpText());
        if (this.isTalbeTemplateElement((IContent)text)) {
            mergedStyle.setProperty(10, (CSSValue)IStyle.DOTTED_VALUE);
            mergedStyle.setProperty(13, (CSSValue)IStyle.DOTTED_VALUE);
            mergedStyle.setProperty(11, (CSSValue)IStyle.DOTTED_VALUE);
            mergedStyle.setProperty(12, (CSSValue)IStyle.DOTTED_VALUE);
            mergedStyle.setProperty(49, (CSSValue)IStyle.SANS_SERIF_VALUE);
        }
        this.handleShrink(display, mergedStyle, height, width, styleBuffer);
        this.handleStyle((IContent)text, styleBuffer, false);
        String verticalAlign = mergedStyle.getVerticalAlign();
        if (!"baseline".equals(verticalAlign) && height != null) {
            this.writer.openTag("table");
            this.writer.attribute("style", " width:100%; height:100%;");
            this.writer.openTag("tr");
            this.writer.openTag("td");
            StringBuffer textStyleBuffer = new StringBuffer();
            textStyleBuffer.append(" vertical-align:");
            textStyleBuffer.append(verticalAlign);
            textStyleBuffer.append(";");
            String textAlign = mergedStyle.getTextAlign();
            if (textAlign != null) {
                textStyleBuffer.append(" text-align:");
                textStyleBuffer.append(textAlign);
                textStyleBuffer.append(";");
            }
            this.writer.attribute("style", textStyleBuffer);
            this.writer.text(textValue);
            this.writer.closeTag("td");
            this.writer.closeTag("tr");
            this.writer.closeTag("table");
        } else {
            this.writer.text(textValue);
        }
        this.writer.closeTag(tagName);
    }

    public void startForeign(IForeignContent foreign) {
        String text;
        String tagName;
        IStyle mergedStyle = foreign.getStyle();
        if (this.peek(mergedStyle)) {
            return;
        }
        logger.log(Level.FINE, "[HTMLReportEmitter] Start foreign");
        StringBuffer styleBuffer = new StringBuffer();
        DimensionType x = foreign.getX();
        DimensionType y = foreign.getY();
        DimensionType width = foreign.getWidth();
        DimensionType height = foreign.getHeight();
        int display = this.checkElementType(x, y, width, height, mergedStyle, styleBuffer);
        if (this.handleAction(foreign.getHyperlinkAction())) {
            tagName = "a";
            this.setDisplayProperty(display, 5, styleBuffer);
            AttributeBuilder.checkHyperlinkTextDecoration(mergedStyle, styleBuffer);
        } else {
            tagName = this.openTagByType(display, 65535);
            this.setDisplayProperty(display, 4, styleBuffer);
        }
        this.setStyleName(foreign.getStyleClass());
        this.setBookmark(tagName, foreign.getBookmark());
        this.writer.attribute("title", foreign.getHelpText());
        this.handleShrink(display, mergedStyle, height, width, styleBuffer);
        this.handleStyle((IContent)foreign, styleBuffer, false);
        Object rawValue = foreign.getRawValue();
        String rawType = foreign.getRawType();
        boolean isHtml = "text/html".equalsIgnoreCase(rawType);
        String string = text = rawValue == null ? null : rawValue.toString();
        if (isHtml) {
            NodeList bodys;
            Document doc = new TextParser().parse(text, TextParser.TEXT_TYPE_HTML);
            ReportDesignHandle design = (ReportDesignHandle)this.runnable.getDesignHandle();
            HTMLProcessor htmlProcessor = new HTMLProcessor(design);
            HashMap styleMap = new HashMap();
            Element body = null;
            if (doc != null && (bodys = doc.getElementsByTagName("body")).getLength() > 0) {
                body = (Element)bodys.item(0);
            }
            if (body != null) {
                htmlProcessor.execute(body, styleMap);
                this.processNodes(body, styleMap);
            }
        }
        this.writer.closeTag(tagName);
    }

    private void processNodes(Element ele, HashMap cssStyles) {
        for (Node node = ele.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 3 && node.getNodeType() != 1) continue;
            if (!node.getNodeName().equals("#text")) {
                this.startNode(node, cssStyles);
            }
            if (node.getNodeType() == 3) {
                this.writer.textForHtmlItem(node.getNodeValue());
            } else {
                this.processNodes((Element)node, cssStyles);
            }
            if (node.getNodeName().equals("#text")) continue;
            this.endNode(node);
        }
    }

    public void startNode(Node node, HashMap cssStyles) {
        String nodeName = node.getNodeName();
        HashMap cssStyle = (HashMap)cssStyles.get(node);
        this.writer.openTag(nodeName);
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attrValueTrue;
                Node attribute = attributes.item(i);
                String attrName = attribute.getNodeName();
                String attrValue = attribute.getNodeValue();
                if (attrValue == null) continue;
                if ("img".equalsIgnoreCase(nodeName) && "src".equalsIgnoreCase(attrName) && (attrValueTrue = this.handleStyleImage(attrValue)) != null) {
                    attrValue = attrValueTrue;
                }
                this.writer.attribute(attrName, attrValue);
            }
        }
        if (cssStyle != null) {
            StringBuffer buffer = new StringBuffer();
            Iterator ite = cssStyle.entrySet().iterator();
            while (ite.hasNext()) {
                Map.Entry entry = ite.next();
                Object keyObj = entry.getKey();
                Object valueObj = entry.getValue();
                if (keyObj == null || valueObj == null) continue;
                String key = keyObj.toString();
                String value = valueObj.toString();
                buffer.append(key);
                buffer.append(":");
                if ("background-image".equalsIgnoreCase(key)) {
                    String valueTrue = this.handleStyleImage(value);
                    if (valueTrue != null) {
                        value = valueTrue;
                    }
                    buffer.append("url(");
                    buffer.append(value);
                    buffer.append(")");
                } else {
                    buffer.append(value.replaceAll(" ", ""));
                }
                buffer.append(";");
            }
            if (buffer.length() != 0) {
                this.writer.attribute("style", buffer.toString());
            }
        }
    }

    public void endNode(Node node) {
        this.writer.closeTag(node.getNodeName());
    }

    public void startLabel(ILabelContent label) {
        String bookmark = label.getBookmark();
        if (bookmark == null) {
            bookmark = this.generateUniqueID();
            label.setBookmark(bookmark);
        }
        this.startText((ITextContent)label);
    }

    public void startData(IDataContent data) {
        this.startText((ITextContent)data);
    }

    public void startImage(IImageContent image) {
        boolean useSVG;
        if (!$assertionsDisabled && image == null) {
            throw new AssertionError();
        }
        IStyle mergedStyle = image.getStyle();
        if (this.peek(mergedStyle)) {
            return;
        }
        logger.log(Level.FINE, "[HTMLImageEmitter] Start image");
        Object generateBy = image.getGenerateBy();
        boolean isSelectHandleTableChart = false;
        if (this.includeSelectionHandler && generateBy instanceof ExtendedItemDesign) {
            this.startSelectHandleTableChart((IContent)image);
            isSelectHandleTableChart = true;
        }
        StringBuffer styleBuffer = new StringBuffer();
        int display = this.checkElementType(image.getX(), image.getY(), mergedStyle, styleBuffer);
        String tag = this.openTagByType(display, 1);
        boolean hasAction = this.handleAction(image.getHyperlinkAction());
        String imgUri = this.getImageURI(image);
        boolean bl = useSVG = image.getMIMEType() != null && image.getMIMEType().equalsIgnoreCase("image/svg+xml");
        if (useSVG) {
            this.writer.openTag("embed");
            String bookmark = image.getBookmark();
            if (!isSelectHandleTableChart) {
                if (bookmark == null) {
                    bookmark = this.generateUniqueID();
                    image.setBookmark(bookmark);
                }
                this.setBookmark("img", bookmark);
                this.setActiveIDTypeIID((IContent)image);
            } else {
                bookmark = this.generateUniqueID();
                this.setBookmark("img", bookmark);
            }
            this.writer.attribute("onresize", bookmark + ".reload()");
            this.writer.attribute("type", "image/svg+xml");
            this.writer.attribute("src", imgUri);
            this.setStyleName(image.getStyleClass());
            StringBuffer buffer = new StringBuffer();
            AttributeBuilder.buildSize(buffer, "width", image.getWidth());
            AttributeBuilder.buildSize(buffer, "height", image.getHeight());
            this.handleStyle((IContent)image, buffer, false);
            this.writer.closeNoEndTag();
        } else {
            String altText;
            boolean hasImageMap;
            Object imageMapObject = image.getImageMap();
            String imageMapId = imgUri;
            boolean bl2 = hasImageMap = imageMapObject != null && imageMapObject instanceof String && ((String)imageMapObject).length() > 0;
            if (hasImageMap) {
                this.writer.openTag("map");
                this.writer.attribute("name", imageMapId);
                this.writer.text((String)imageMapObject, true, false);
                this.writer.closeTag("map");
            }
            this.writer.openTag("img");
            this.setStyleName(image.getStyleClass());
            this.setDisplayProperty(display, 0, styleBuffer);
            String bookmark = image.getBookmark();
            if (!isSelectHandleTableChart) {
                if (bookmark == null) {
                    bookmark = this.generateUniqueID();
                    image.setBookmark(bookmark);
                }
                this.setBookmark("img", bookmark);
                this.setActiveIDTypeIID((IContent)image);
            } else {
                bookmark = this.generateUniqueID();
                this.setBookmark("img", bookmark);
            }
            String ext = image.getExtension();
            this.writer.attribute("src", imgUri);
            if (hasImageMap) {
                if (!hasAction) {
                    IStyle style = image.getStyle();
                    if (style.getBorderTopStyle() == null) {
                        styleBuffer.append("border-top-style:none;");
                    } else if (style.getBorderTopColor() == null) {
                        styleBuffer.append("border-top-color:black");
                    }
                    if (style.getBorderBottomStyle() == null) {
                        styleBuffer.append("border-bottom-style:none;");
                    } else if (style.getBorderBottomColor() == null) {
                        styleBuffer.append("border-bottom-color:black");
                    }
                    if (style.getBorderLeftStyle() == null) {
                        styleBuffer.append("border-left-style:none;");
                    } else if (style.getBorderLeftColor() == null) {
                        styleBuffer.append("border-left-color:black");
                    }
                    if (style.getBorderRightStyle() == null) {
                        styleBuffer.append("border-right-style:none;");
                    } else if (style.getBorderRightColor() == null) {
                        styleBuffer.append("border-right-color:black");
                    }
                }
                this.writer.attribute("usemap", "#" + imageMapId);
            }
            if ((altText = image.getAltText()) == null) {
                this.writer.attributeAllowEmpty("alt", "");
            } else {
                this.writer.attribute("alt", altText);
            }
            this.writer.attribute("title", image.getHelpText());
            AttributeBuilder.buildSize(styleBuffer, "width", image.getWidth());
            AttributeBuilder.buildSize(styleBuffer, "height", image.getHeight());
            this.handleStyle((IContent)image, styleBuffer, false);
            if (".PNG".equalsIgnoreCase(ext) && this.imageHandler != null) {
                this.writer.attribute("onload", "fixPNG(this)");
            }
            this.writer.closeNoEndTag();
        }
        if (hasAction) {
            this.writer.closeTag("a");
        }
        this.writer.closeTag(tag);
        if (this.includeSelectionHandler && generateBy instanceof ExtendedItemDesign) {
            this.endSelectHandleTableChart();
        }
    }

    protected void startSelectHandleTableChart(IContent content) {
        this.writer.openTag("table");
        String bookmark = content.getBookmark();
        if (bookmark == null) {
            bookmark = this.generateUniqueID();
            content.setBookmark(bookmark);
        }
        this.setBookmark("img", bookmark);
        this.setActiveIDTypeIID(content);
        this.writer.attribute("style", "width:100%");
        this.writer.openTag("col");
        this.writer.attribute("style", "width:18px;background-color:#cccccc");
        this.writer.closeTag("col");
        this.writer.openTag("col");
        this.writer.closeTag("col");
        this.writer.openTag("tr");
        this.writer.openTag("td");
        this.writer.closeTag("td");
        this.writer.openTag("td");
    }

    protected void endSelectHandleTableChart() {
        this.writer.closeTag("td");
        this.writer.closeTag("tr");
        this.writer.closeTag("table");
    }

    protected String getImageURI(IImageContent image) {
        String imgUri = null;
        if (this.imageHandler != null) {
            Image img = new Image(image);
            img.setRenderOption(this.renderOption);
            img.setReportRunnable(this.runnable);
            switch (img.getSource()) {
                case 0: {
                    imgUri = this.imageHandler.onDesignImage((IImage)img, this.renderContext);
                    break;
                }
                case 2: {
                    imgUri = this.imageHandler.onURLImage((IImage)img, this.renderContext);
                    break;
                }
                case 1: {
                    imgUri = this.imageHandler.onDocImage((IImage)img, this.renderContext);
                    break;
                }
                case 4: {
                    imgUri = this.imageHandler.onCustomImage((IImage)img, this.renderContext);
                    break;
                }
                case 3: {
                    imgUri = this.imageHandler.onFileImage((IImage)img, this.renderContext);
                    break;
                }
            }
        }
        return imgUri;
    }

    protected void setStyleName(String styleName) {
        if (this.isEmbeddable) {
            return;
        }
        if (styleName != null) {
            this.writer.attribute("class", styleName);
        }
    }

    protected boolean handleShrink(int type, IStyle style, DimensionType height, DimensionType width, StringBuffer styleBuffer) {
        boolean canShrink;
        boolean bl = canShrink = style == null || !"false".equalsIgnoreCase(style.getCanShrink());
        if ((type & 1) > 0) {
            AttributeBuilder.buildSize(styleBuffer, "width", width);
            if (!canShrink) {
                AttributeBuilder.buildSize(styleBuffer, "min-height", height);
            }
        } else if ((type & 2) > 0) {
            AttributeBuilder.buildSize(styleBuffer, "height", height);
            if (!canShrink) {
                AttributeBuilder.buildSize(styleBuffer, "min-width", width);
            }
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return canShrink;
    }

    protected void setBookmark(String tagName, String bookmark) {
        if (tagName == null || !"a".equalsIgnoreCase(tagName)) {
            this.writer.attribute("id", bookmark);
        } else {
            this.writer.attribute("id", bookmark);
            this.writer.attribute("name", bookmark);
        }
    }

    protected int checkElementType(DimensionType x, DimensionType y, IStyle style, StringBuffer styleBuffer) {
        return this.checkElementType(x, y, null, null, style, styleBuffer);
    }

    protected int checkElementType(DimensionType x, DimensionType y, DimensionType width, DimensionType height, IStyle style, StringBuffer styleBuffer) {
        int type = 0;
        String display = null;
        if (style != null) {
            display = style.getDisplay();
        }
        if ("none".equalsIgnoreCase(display)) {
            type |= 8;
        }
        if (x != null || y != null) {
            styleBuffer.append("position: absolute;");
            AttributeBuilder.buildSize(styleBuffer, "left", x);
            AttributeBuilder.buildSize(styleBuffer, "left", y);
            return type | 1;
        }
        if ("inline".equalsIgnoreCase(display)) {
            type |= 2;
            if (width != null || height != null) {
                type |= 4;
            }
            return type;
        }
        return type | 1;
    }

    protected String openTagByType(int display, int mask) {
        int flag = display & mask;
        if ((flag & 1) > 0) {
            this.writer.openTag("div");
            return "div";
        }
        if ((flag & 2) > 0) {
            this.writer.openTag("span");
            return "span";
        }
        return null;
    }

    protected void setDisplayProperty(int display, int mask, StringBuffer styleBuffer) {
        int flag = display & mask;
        if ((display & 8) > 0) {
            styleBuffer.append("display: none;");
        } else if (flag > 0) {
            if ((flag & 1) > 0) {
                styleBuffer.append("display: block;");
            } else if ((flag & 4) > 0) {
                styleBuffer.append("display: inline-block;");
            } else if ((flag & 2) > 0) {
                styleBuffer.append("display: inline;");
            }
        }
    }

    protected boolean handleAction(IHyperlinkAction action) {
        boolean ret;
        if (action == null) {
            return false;
        }
        Action act = new Action(action);
        if (this.actionHandler == null) {
            return false;
        }
        String link = this.actionHandler.getURL((IAction)act, this.renderContext);
        boolean bl = ret = link != null && !link.equals("");
        if (ret) {
            this.writer.openTag("a");
            this.writer.attribute("href", link);
            this.writer.attribute("target", action.getTargetWindow());
        }
        return ret;
    }

    public String handleStyleImage(String uri) {
        ReportDesignHandle design = (ReportDesignHandle)this.runnable.getDesignHandle();
        URL url = design.findResource(uri, 1);
        if (url == null) {
            return uri;
        }
        uri = url.toExternalForm();
        Image image = new Image(uri);
        image.setReportRunnable(this.runnable);
        image.setRenderOption(this.renderOption);
        String imgUri = null;
        if (this.imageHandler != null) {
            switch (image.getSource()) {
                case 2: {
                    imgUri = this.imageHandler.onURLImage((IImage)image, this.renderContext);
                    break;
                }
                case 3: {
                    imgUri = this.imageHandler.onFileImage((IImage)image, this.renderContext);
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
        }
        return imgUri;
    }

    protected void handleStyle(IContent element, StringBuffer styleBuffer, boolean bContainer) {
        IStyle style = this.isEmbeddable ? element.getStyle() : element.getInlineStyle();
        AttributeBuilder.buildStyle(styleBuffer, style, this, bContainer);
        if (!bContainer) {
            AttributeBuilder.buildComputedTextStyle(styleBuffer, element.getComputedStyle(), this, bContainer);
        }
        this.writer.attribute("style", styleBuffer.toString());
    }

    protected void handleStyle(IContent element, StringBuffer styleBuffer) {
        IStyle style = this.isEmbeddable ? element.getStyle() : element.getInlineStyle();
        AttributeBuilder.buildStyle(styleBuffer, style, this, true);
        this.writer.attribute("style", styleBuffer.toString());
    }

    protected void handleVerticalAlign(ICellContent element, StringBuffer styleBuffer) {
        IStyle style = element.getComputedStyle();
        String verticalAlign = style.getVerticalAlign();
        if (verticalAlign == null || verticalAlign.equals("baseline")) {
            verticalAlign = "top";
        }
        if (verticalAlign != null) {
            styleBuffer.append("vertical-align: ");
            styleBuffer.append(verticalAlign);
            styleBuffer.append(";");
        }
    }

    protected void handleCellFont(ICellContent element, StringBuffer styleBuffer) {
        IStyle style = element.getInlineStyle();
        String fontWeight = style.getFontWeight();
        if (fontWeight == null) {
            style = element.getComputedStyle();
            fontWeight = style.getFontWeight();
            if (fontWeight == null) {
                fontWeight = "normal";
            }
            styleBuffer.append("font-weight: ");
            styleBuffer.append(fontWeight);
            styleBuffer.append(";");
        }
    }

    protected void addDefaultTableStyles(StringBuffer styleBuffer) {
        styleBuffer.append("border-collapse: collapse; empty-cells: show;");
    }

    protected void exportElementID(String bookmark, String type, long componentID) {
        if (this.ouputInstanceIDs != null && bookmark != null) {
            if (!$assertionsDisabled && type == null) {
                throw new AssertionError();
            }
            String newBookmark = bookmark + "," + type + "," + new Long(componentID).toString();
            this.ouputInstanceIDs.add(newBookmark);
        }
    }

    protected String generateUniqueID() {
        ++this.bookmarkId;
        return "AUTOGENBOOKMARK_" + this.bookmarkId;
    }

    private void setActiveIDTypeIID(IContent content) {
        Object genBy = content.getGenerateBy();
        String type = null;
        if (genBy instanceof LabelItemDesign) {
            type = "LABEL";
        } else if (genBy instanceof TemplateDesign) {
            type = "TEMPLATE";
        } else if (genBy instanceof ExtendedItemDesign) {
            type = "EXTENDED";
        } else if (genBy instanceof TableItemDesign) {
            type = "TABLE";
        } else if (genBy instanceof ListItemDesign) {
            type = "LIST";
        }
        if (type != null) {
            InstanceID iid = content.getInstanceID();
            long componentID = iid != null ? iid.getComponentID() : 0L;
            this.setActiveIDTypeIID(content.getBookmark(), type, iid, componentID);
        }
    }

    private void setActiveIDTypeIID(String bookmark, String type, InstanceID iid, long elementId) {
        this.exportElementID(bookmark, type, elementId);
        this.writer.attribute("element_type", type);
        if (iid != null) {
            this.writer.attribute("iid", iid.toString());
        }
    }

    private void resizeTemplateElement(IContent content) {
        Object genBy = content.getGenerateBy();
        if (genBy instanceof TemplateDesign) {
            TemplateDesign template = (TemplateDesign)genBy;
            String allowedType = template.getAllowedType();
            if ("ExtendedItem".equals(allowedType)) {
                IStyle style = content.getStyle();
                style.setProperty(6, (CSSValue)IStyle.FALSE_VALUE);
                content.setWidth(new DimensionType(3.0, "in"));
                content.setHeight(new DimensionType(3.0, "in"));
            } else if ("Table".equals(allowedType)) {
                IStyle style = content.getStyle();
                style.setProperty(6, (CSSValue)IStyle.FALSE_VALUE);
                content.setWidth(new DimensionType(5.0, "in"));
            }
        }
    }

    private boolean isTalbeTemplateElement(IContent content) {
        TemplateDesign template;
        String allowedType;
        Object genBy = content.getGenerateBy();
        return genBy instanceof TemplateDesign && "Table".equals(allowedType = (template = (TemplateDesign)genBy).getAllowedType());
    }

    private boolean needColumnFilter(ICellContent cell) {
        DetailRowState state = (DetailRowState)this.detailRowStateStack.peek();
        if (cell.getColumnInstance() == null) {
            return false;
        }
        return state.isStartOfDetail && cell.getColumnInstance().hasDataItemsInDetail();
    }

    public void endGroup(IGroupContent group) {
    }

    public void endListBand(IListBandContent listBand) {
    }

    public void endListGroup(IListGroupContent group) {
    }

    public void endTableBand(ITableBandContent band) {
    }

    public void endTableGroup(ITableGroupContent group) {
    }

    public void startGroup(IGroupContent group) {
    }

    public void startListBand(IListBandContent listBand) {
    }

    public void startListGroup(IListGroupContent group) {
    }

    public void startTableBand(ITableBandContent band) {
    }

    public void startTableGroup(ITableGroupContent group) {
    }

    static {
        $assertionsDisabled = !HTMLReportEmitter.class.desiredAssertionStatus();
        logger = Logger.getLogger(HTMLReportEmitter.class.getName());
    }
}

