/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Vector;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.impl.ChartWithoutAxesImpl;
import org.eclipse.birt.chart.style.IStyleProcessor;
import org.eclipse.birt.chart.ui.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.AttributePanelContainer;
import org.eclipse.birt.chart.ui.swt.ButtonPanel;
import org.eclipse.birt.chart.ui.swt.ChartModelAdapter;
import org.eclipse.birt.chart.ui.swt.ChartSelector;
import org.eclipse.birt.chart.ui.swt.MessageComposite;
import org.eclipse.birt.chart.ui.swt.NavTree;
import org.eclipse.birt.chart.ui.swt.PreviewButtonPanel;
import org.eclipse.birt.chart.ui.swt.PreviewPanel;
import org.eclipse.birt.chart.ui.swt.UIExtensionsImpl;
import org.eclipse.birt.chart.ui.swt.interfaces.IChangeListener;
import org.eclipse.birt.chart.ui.swt.interfaces.IRegisteredSheetEntry;
import org.eclipse.birt.chart.ui.swt.interfaces.ISheet;
import org.eclipse.birt.chart.ui.swt.interfaces.IUIManager;
import org.eclipse.birt.chart.ui.swt.interfaces.IUIServiceProvider;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class ChartDlg
implements SelectionListener,
DisposeListener,
ShellListener,
ControlListener,
IUIManager {
    private static IDisplayServer swtDisplayServer = null;
    private transient Display display = null;
    private transient Shell shell = null;
    private transient NavTree navTree = null;
    private transient ChartSelector selector = null;
    private transient ButtonPanel btnPanel = null;
    private transient AttributePanelContainer attributePanel = null;
    private transient MessageComposite mcSheetHeading = null;
    private transient Color clrWhite = Display.getCurrent().getSystemColor(1);
    private transient PreviewButtonPanel previewBtnPanel = null;
    private transient PreviewPanel previewPanel = null;
    private transient LinkedHashMap htRegisteredSheets = null;
    private transient LinkedHashMap htVisibleSheets = null;
    private transient Hashtable htSheetCollections = null;
    private transient ISheet oldSheet = null;
    private transient Chart chartModelCurrent = null;
    private transient ChartModelAdapter chartAdapter = null;
    private transient IUIServiceProvider serviceprovider = null;
    private transient IStyleProcessor processor = null;
    private transient Object oContext = null;
    private int iPreviewWidth = 0;
    private int iPreviewHeight = 0;
    private static final int MAX_PREVIEW_WIDTH = 400;
    private static final int MAX_PREVIEW_HEIGHT = 400;
    private static final int MIN_PREVIEW_WIDTH = 250;
    private static final int MIN_PREVIEW_HEIGHT = 180;
    private static final double DEFAULT_CHART_HEIGHT = 250.0;
    private static final double DEFAULT_CHART_WIDTH = 400.0;
    private static final double DEFAULT_CHART_WITHOUT_AXIS_HEIGHT = 250.0;
    private static final double DEFAULT_CHART_WITHOUT_AXIS_WIDTH = 280.0;
    private static final String INDEX_SEPARATOR = " - ";
    private transient MessageBox mb = null;
    private transient boolean bWasCancelled = true;
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.ui/swt");

    public ChartDlg() {
        this(null, null, null);
    }

    public ChartDlg(Chart chartModel, IUIServiceProvider builder, Object oContext) {
        this(chartModel, builder, oContext, null);
    }

    public ChartDlg(Chart chartModel, IUIServiceProvider builder, Object oContext, IStyleProcessor processor) {
        try {
            if (chartModel != null) {
                this.chartModelCurrent = chartModel;
            } else {
                this.selector = new ChartSelector(null);
                if (this.selector.wasCancelled()) {
                    return;
                }
                this.chartModelCurrent = this.selector.getChart();
                if (!this.selector.allowModification()) {
                    return;
                }
            }
            if (this.chartModelCurrent.getBlock().getBounds() == null || this.chartModelCurrent.getBlock().getBounds().getWidth() == 0.0 || this.chartModelCurrent.getBlock().getBounds().getHeight() == 0.0) {
                if (this.chartModelCurrent instanceof ChartWithoutAxesImpl) {
                    this.chartModelCurrent.getBlock().setBounds(BoundsImpl.create((double)0.0, (double)0.0, (double)280.0, (double)250.0));
                } else {
                    this.chartModelCurrent.getBlock().setBounds(BoundsImpl.create((double)0.0, (double)0.0, (double)400.0, (double)250.0));
                }
            }
            this.iPreviewWidth = (int)this.chartModelCurrent.getBlock().getBounds().getWidth();
            this.iPreviewHeight = (int)this.chartModelCurrent.getBlock().getBounds().getHeight();
            this.processor = processor;
            this.serviceprovider = builder;
            this.oContext = oContext;
            this.init();
            this.placeComponents();
            this.addListeners();
            this.addSheets();
            this.setDefaultSelection();
            this.shell.layout();
            this.shell.open();
            while (!this.shell.isDisposed()) {
                if (this.display.readAndDispatch()) continue;
                this.display.sleep();
            }
        }
        catch (Exception ex) {
            logger.log(ex);
        }
    }

    public static IDisplayServer getDisplayServer() {
        return swtDisplayServer;
    }

    private void setDefaultSelection() {
        TreeItem[] tiSelection = new TreeItem[]{this.navTree.getItems()[0]};
        this.navTree.setSelection(tiSelection);
        this.selectSheet(this.navTree.getSelection()[0]);
        this.btnPanel.setPreviousState(false);
        this.navTree.setFocus();
    }

    private void addSheets() {
        this.populateSheetsTable();
        this.updateUI();
    }

    private void populateSheetsTable() {
        this.htRegisteredSheets = new LinkedHashMap(12);
        this.htVisibleSheets = new LinkedHashMap(12);
        this.htSheetCollections = new Hashtable();
        Collection cRegisteredEntries = UIExtensionsImpl.instance().getUISheetExtensions();
        Iterator iterEntries = cRegisteredEntries.iterator();
        Vector vSortedEntries = new Vector();
        while (iterEntries.hasNext()) {
            IRegisteredSheetEntry entry = (IRegisteredSheetEntry)iterEntries.next();
            if (vSortedEntries.isEmpty()) {
                vSortedEntries.add(entry);
                continue;
            }
            int iNewIndex = entry.getNodeIndex();
            if (((IRegisteredSheetEntry)vSortedEntries.get(vSortedEntries.size() - 1)).getNodeIndex() <= iNewIndex) {
                vSortedEntries.add(entry);
                continue;
            }
            if (((IRegisteredSheetEntry)vSortedEntries.get(0)).getNodeIndex() > iNewIndex) {
                vSortedEntries.add(0, entry);
                continue;
            }
            vSortedEntries = this.addEntrySorted(vSortedEntries, entry, 0, vSortedEntries.size() - 1);
        }
        for (int i = 0; i < vSortedEntries.size(); ++i) {
            IRegisteredSheetEntry entry = (IRegisteredSheetEntry)vSortedEntries.get(i);
            ISheet sheet = entry.getSheet();
            String sNodePath = entry.getNodePath();
            this.htRegisteredSheets.put(sNodePath, sheet);
            this.htVisibleSheets.put(sNodePath, sheet);
        }
        cRegisteredEntries = UIExtensionsImpl.instance().getUIListeners();
        iterEntries = cRegisteredEntries.iterator();
        while (iterEntries.hasNext()) {
            IChangeListener listener = (IChangeListener)iterEntries.next();
            listener.initialize((Chart)EcoreUtil.copy((EObject)this.chartModelCurrent), this);
            this.chartAdapter.addListener(listener);
        }
    }

    private Vector addEntrySorted(Vector vSortedEntries, IRegisteredSheetEntry entry, int iStart, int iEnd) {
        int iNewIndex = entry.getNodeIndex();
        if (iStart == iEnd) {
            if (((IRegisteredSheetEntry)vSortedEntries.get(iStart)).getNodeIndex() > iNewIndex) {
                vSortedEntries.add(iStart, entry);
            } else {
                vSortedEntries.add(iEnd + 1, entry);
            }
        } else if (iEnd - iStart == 1) {
            vSortedEntries.add(iEnd, entry);
        } else if (((IRegisteredSheetEntry)vSortedEntries.get(iStart)).getNodeIndex() == iNewIndex) {
            vSortedEntries.add(iStart + 1, entry);
        } else {
            int iHalfwayPoint = (iEnd - iStart) / 2;
            if (((IRegisteredSheetEntry)vSortedEntries.get(iStart + iHalfwayPoint)).getNodeIndex() > iNewIndex) {
                this.addEntrySorted(vSortedEntries, entry, iStart, iStart + iHalfwayPoint);
            } else {
                this.addEntrySorted(vSortedEntries, entry, iStart + iHalfwayPoint, iEnd);
            }
        }
        return vSortedEntries;
    }

    private void updateUI() {
        this.navTree.removeAll();
        Iterator itKeys = this.htVisibleSheets.keySet().iterator();
        while (itKeys.hasNext()) {
            String sKey = (String)itKeys.next();
            Object oVal = this.htVisibleSheets.get(sKey);
            if (oVal instanceof Vector) {
                for (int i = 0; i < ((Vector)oVal).size(); ++i) {
                    String sParentKey;
                    Object oParentVal;
                    String sSuffix = "";
                    if (((Vector)oVal).size() > 1) {
                        sSuffix = INDEX_SEPARATOR + String.valueOf(i + 1);
                    }
                    if ((oParentVal = this.htVisibleSheets.get(sParentKey = sKey.substring(0, sKey.lastIndexOf(".")))) != null && oParentVal instanceof Vector) {
                        this.navTree.addNode(sParentKey + sSuffix + "." + sKey.substring(sKey.lastIndexOf(".")) + sSuffix);
                        continue;
                    }
                    this.navTree.addNode(sKey + sSuffix);
                }
                continue;
            }
            this.navTree.addNode(sKey);
        }
    }

    private void init() {
        this.display = Display.getCurrent();
        try {
            this.shell = PlatformUI.isWorkbenchRunning() ? new Shell(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 67696) : new Shell(this.display, 67696);
        }
        catch (Throwable t) {
            this.shell = new Shell(this.display, 67696);
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        this.shell.setLayout((Layout)gridLayout);
        this.shell.setSize(600, 650);
        UIHelper.centerOnScreen(this.shell);
        this.shell.setText(Messages.getString("ChartDlg.Title.ChartBuilder"));
        this.shell.setImage(UIHelper.getImage("icons/obj16/chartbuilder.gif"));
        this.chartAdapter = new ChartModelAdapter();
        this.chartAdapter.setUiManager(this);
        this.chartAdapter.setStyleProcessor(this.processor);
        this.chartAdapter.setUIServiceProvider(this.serviceprovider);
        this.chartAdapter.setPreview(this.previewPanel);
    }

    private void placeComponents() {
        this.previewBtnPanel = new PreviewButtonPanel((Composite)this.shell, 0);
        GridData gridData_4 = new GridData(640);
        gridData_4.horizontalSpan = 4;
        this.previewBtnPanel.setLayoutData(gridData_4);
        this.navTree = new NavTree((Composite)this.shell, 2048);
        GridData gridData_3 = new GridData(1296);
        gridData_3.verticalSpan = 2;
        gridData_3.widthHint = 127;
        this.navTree.setLayoutData(gridData_3);
        this.mcSheetHeading = new MessageComposite((Composite)this.shell, "icons/wizban/chartwatermark.gif", "", "", true);
        GridData gdMSGHeading = new GridData(768);
        gdMSGHeading.heightHint = 22;
        gdMSGHeading.horizontalSpan = 3;
        this.mcSheetHeading.setLayoutData(gdMSGHeading);
        this.mcSheetHeading.setBackground(this.clrWhite);
        this.attributePanel = new AttributePanelContainer((Composite)this.shell, 0);
        this.attributePanel.setLayout((Layout)new FillLayout());
        GridData gridData_1 = new GridData(784);
        gridData_1.horizontalSpan = 3;
        this.attributePanel.setLayoutData(gridData_1);
        this.btnPanel = new ButtonPanel((Composite)this.shell, 0);
        GridData gridData_2 = new GridData(768);
        gridData_2.horizontalSpan = 4;
        this.btnPanel.setLayoutData(gridData_2);
        this.calculateInitialPreviewSize();
        this.shell.setDefaultButton(this.btnPanel.getAcceptButton());
    }

    private void calculateInitialPreviewSize() {
        int iWidthTemp = this.iPreviewWidth;
        int iHeightTemp = this.iPreviewHeight;
        if (iHeightTemp > 400) {
            iHeightTemp = 400;
            iWidthTemp = Math.min(400, Math.max(400 / this.iPreviewHeight * iWidthTemp, 250));
        } else if (iWidthTemp > 400) {
            iWidthTemp = 400;
            iHeightTemp = Math.min(400, Math.max(400 / this.iPreviewWidth * iHeightTemp, 400));
        } else if (iHeightTemp < 180) {
            iHeightTemp = 180;
            iWidthTemp = this.iPreviewHeight == 0 ? 400 : Math.min(400, Math.max(180 / this.iPreviewHeight * iWidthTemp, 250));
        } else if (iWidthTemp < 250) {
            iWidthTemp = 250;
            iHeightTemp = this.iPreviewWidth == 0 ? 400 : Math.min(400, Math.max(250 / this.iPreviewWidth * iHeightTemp, 180));
        }
        this.iPreviewWidth = iWidthTemp;
        this.iPreviewHeight = iHeightTemp;
    }

    private void addListeners() {
        this.previewBtnPanel.addListener(this);
        this.navTree.addListener(this);
        this.btnPanel.addListener(this);
        this.chartModelCurrent.eAdapters().add((Object)this.chartAdapter);
        this.shell.addControlListener((ControlListener)this);
        this.shell.addDisposeListener((DisposeListener)this);
        this.shell.addShellListener((ShellListener)this);
    }

    private void selectSheet(TreeItem selectedItem) {
        try {
            ISheet newSheet = this.getIndexedSheet(selectedItem);
            if (newSheet == null) {
                return;
            }
            newSheet.setUIServiceProvider(this.serviceprovider, this.oContext);
            if (this.oldSheet != null) {
                this.oldSheet.after();
            }
            newSheet.before(this.chartModelCurrent);
            if (this.attributePanel.getChildren().length > 0) {
                this.attributePanel.getChildren()[0].dispose();
            }
            newSheet.getComponent(this.attributePanel);
            this.attributePanel.layout();
            this.mcSheetHeading.update(newSheet.getTitleText(), "");
            this.oldSheet = newSheet;
        }
        catch (Exception ex) {
            logger.log(ex);
        }
    }

    public void widgetSelected(SelectionEvent se) {
        Object oSelected = se.getSource();
        if (oSelected.getClass().equals(Button.class)) {
            Button bTemp = (Button)oSelected;
            String sSelected = bTemp.getText();
            if (sSelected.trim().equalsIgnoreCase(Messages.getString("PreviewButtonPanel.Lbl.ShowPreview"))) {
                if (this.previewPanel == null || this.previewPanel.shell.isDisposed()) {
                    this.previewPanel = new PreviewPanel(this.shell, this.iPreviewWidth, this.iPreviewHeight);
                    this.previewPanel.addListener(this);
                    this.previewPanel.canvas.addPaintListener(this.chartAdapter.getPaintListener());
                    this.chartAdapter.setPreview(this.previewPanel);
                    this.chartAdapter.renderModel(this.chartModelCurrent);
                } else {
                    this.previewPanel.shell.setVisible(true);
                }
                this.previewPanel.shell.setLocation(this.shell.getLocation().x + this.shell.getClientArea().width + 8, this.shell.getLocation().y);
                this.previewBtnPanel.toggleButtonText();
                this.previewPanel.open();
            } else if (sSelected.equalsIgnoreCase(Messages.getString("PreviewButtonPanel.Lbl.HidePreview"))) {
                this.previewBtnPanel.toggleButtonText();
                this.previewPanel.shell.setVisible(false);
            } else if (sSelected.equalsIgnoreCase(Messages.getString("ButtonPanel.Lbl.Next"))) {
                if (this.navTree.getSelectionCount() > 0) {
                    TreeItem ti = this.getNextNode(this.navTree.getSelection()[0], null);
                    if (ti != null) {
                        this.selectSheet(ti);
                        this.navTree.setSelection(new TreeItem[]{ti});
                        this.btnPanel.setPreviousState(true);
                    }
                    if ((ti = this.getNextNode(this.navTree.getSelection()[0], null)) == null) {
                        this.btnPanel.setNextState(false);
                    }
                }
            } else if (sSelected.equalsIgnoreCase(Messages.getString("ButtonPanel.Lbl.Previous"))) {
                if (this.navTree.getSelectionCount() > 0) {
                    TreeItem ti = this.getPreviousNode(this.navTree.getSelection()[0], null);
                    if (ti != null) {
                        this.selectSheet(ti);
                        this.navTree.setSelection(new TreeItem[]{ti});
                        this.btnPanel.setNextState(true);
                    }
                    if ((ti = this.getPreviousNode(this.navTree.getSelection()[0], null)) == null) {
                        this.btnPanel.setPreviousState(false);
                    }
                }
            } else if (sSelected.equalsIgnoreCase(Messages.getString("Shared.Lbl.Cancel"))) {
                this.removeAdapters();
                this.chartModelCurrent = null;
                if (!this.shell.isDisposed()) {
                    this.shell.dispose();
                }
            } else if (sSelected.equalsIgnoreCase(Messages.getString("Shared.Lbl.OK"))) {
                String[] saMessages;
                if (this.serviceprovider != null && (saMessages = this.serviceprovider.validate(this.chartModelCurrent, this.oContext)) != null && saMessages.length > 0) {
                    StringBuffer sbDisplayMessage = new StringBuffer();
                    sbDisplayMessage.append(Messages.getString("ChartDlg.Msg.ValidationErrors"));
                    if (saMessages != null) {
                        for (int iM = 0; iM < saMessages.length; ++iM) {
                            sbDisplayMessage.append(iM + 1 + "] ");
                            sbDisplayMessage.append(saMessages[iM]);
                            sbDisplayMessage.append("\n");
                        }
                    }
                    sbDisplayMessage.append(Messages.getString("ChartDlg.Msg.AskCorrectLater"));
                    this.mb = new MessageBox(this.shell, 200);
                    this.mb.setMessage(sbDisplayMessage.toString());
                    this.mb.setText(Messages.getString("ChartDlg.Title.ValidationResults"));
                    if (this.mb.open() == 128) {
                        return;
                    }
                }
                this.bWasCancelled = false;
                if (this.oldSheet != null) {
                    this.oldSheet.after();
                }
                this.removeAdapters();
                if (!this.shell.isDisposed()) {
                    this.shell.dispose();
                }
            } else if (sSelected.equalsIgnoreCase(Messages.getString("ButtonPanel.Lbl.SelectChartType"))) {
                if (this.chartModelCurrent.getType() == null || this.chartModelCurrent.getType().trim().length() == 0) {
                    logger.log(1, Messages.getString("ChartDlg.Info.CannotChangeSelection"));
                    return;
                }
                if (this.previewPanel != null && !this.previewPanel.shell.isDisposed()) {
                    this.previewPanel.shell.setVisible(false);
                }
                this.shell.setVisible(false);
                this.removeAdapters();
                this.selector = new ChartSelector(this.chartModelCurrent);
                this.shell.setVisible(true);
                if (this.previewBtnPanel.isPreviewVisible() && this.previewPanel != null && !this.previewPanel.shell.isDisposed()) {
                    this.previewPanel.shell.setVisible(true);
                }
                this.chartModelCurrent = this.selector.getChart();
                if (!this.chartModelCurrent.eAdapters().contains((Object)this.chartAdapter)) {
                    this.chartModelCurrent.eAdapters().add((Object)this.chartAdapter);
                }
                this.chartAdapter.clearListeners();
                this.addSheets();
                TreeItem tiTop = this.navTree.getTopItem();
                if (tiTop == null) {
                    tiTop = this.navTree.getItems()[0];
                }
                this.selectSheet(tiTop);
                this.btnPanel.setPreviousState(false);
                if (this.previewPanel != null && !this.previewPanel.shell.isDisposed()) {
                    this.chartAdapter.renderModel(this.chartModelCurrent);
                }
                this.navTree.forceFocus();
            }
        } else if (oSelected instanceof Tree) {
            this.selectSheet((TreeItem)se.item);
            TreeItem ti = this.getNextNode(this.navTree.getSelection()[0], null);
            if (ti == null) {
                this.btnPanel.setNextState(false);
                this.btnPanel.setPreviousState(true);
            } else {
                this.btnPanel.setNextState(true);
            }
            if (((TreeItem)se.item).equals(this.navTree.getTopItem())) {
                this.btnPanel.setNextState(true);
                this.btnPanel.setPreviousState(false);
            } else {
                this.btnPanel.setPreviousState(true);
            }
        }
    }

    private void removeAdapters() {
        this.chartModelCurrent.eAdapters().remove((Object)this.chartAdapter);
        TreeIterator iterator = this.chartModelCurrent.eAllContents();
        while (iterator.hasNext()) {
            Object oModel = iterator.next();
            if (!(oModel instanceof EObject)) continue;
            ((EObject)oModel).eAdapters().remove((Object)this.chartAdapter);
        }
    }

    private ISheet getIndexedSheet(TreeItem ti) {
        String sSelected = ti.getText();
        if (sSelected.indexOf(INDEX_SEPARATOR) == -1) {
            ISheet sheetTmp = this.getSheetForNode(ti);
            sheetTmp.setIndex(0);
            return sheetTmp;
        }
        int iSheetIndex = Integer.valueOf(sSelected.substring(sSelected.indexOf(INDEX_SEPARATOR) + INDEX_SEPARATOR.length()).trim());
        StringBuffer sbNodeName = new StringBuffer(sSelected.substring(0, sSelected.indexOf(INDEX_SEPARATOR)));
        for (ti = ti.getParentItem(); ti != null; ti = ti.getParentItem()) {
            if (sbNodeName.length() > 0) {
                sbNodeName.insert(0, ".");
            }
            if (ti.getText().indexOf(INDEX_SEPARATOR) != -1) {
                sbNodeName.insert(0, ti.getText().substring(0, ti.getText().indexOf(INDEX_SEPARATOR)));
                continue;
            }
            sbNodeName.insert(0, ti.getText());
        }
        ISheet sheetTmp = (ISheet)((Vector)this.htVisibleSheets.get(sbNodeName.toString())).get(iSheetIndex - 1);
        sheetTmp.setIndex(iSheetIndex - 1);
        return sheetTmp;
    }

    private ISheet getSheetForNode(TreeItem tiSelected) {
        StringBuffer sbSelected = new StringBuffer("");
        while (tiSelected != null) {
            if (sbSelected.length() > 0) {
                sbSelected.insert(0, ".");
            }
            sbSelected.insert(0, tiSelected.getText());
            tiSelected = tiSelected.getParentItem();
        }
        return (ISheet)this.htRegisteredSheets.get(sbSelected.toString());
    }

    private TreeItem getNextNode(TreeItem tiSearchRoot, TreeItem tiChild) {
        TreeItem[] tia = null;
        tia = tiSearchRoot == null ? this.navTree.getItems() : tiSearchRoot.getItems();
        if (tia.length > 0) {
            if (tiChild == null) {
                return tia[0];
            }
            boolean bChildFound = false;
            for (int i = 0; i < tia.length; ++i) {
                if (bChildFound) {
                    return tia[i];
                }
                if (!tia[i].equals(tiChild)) continue;
                bChildFound = true;
            }
        }
        if (tiSearchRoot != null) {
            return this.getNextNode(tiSearchRoot.getParentItem(), tiSearchRoot);
        }
        return null;
    }

    private TreeItem getLastChild(TreeItem node) {
        TreeItem[] tia = node.getItems();
        int iChildren = tia.length;
        if (iChildren > 0) {
            return this.getLastChild(tia[iChildren - 1]);
        }
        return node;
    }

    private TreeItem getPreviousNode(TreeItem tiSearchRoot, TreeItem tiChild) {
        TreeItem[] tia = null;
        if (tiChild != null) {
            tia = tiSearchRoot.getItems();
            boolean bCurrentNodeFound = false;
            for (int i = tia.length; i > 0; --i) {
                if (bCurrentNodeFound) {
                    return this.getLastChild(tia[i - 1]);
                }
                if (!tia[i - 1].equals(tiChild)) continue;
                bCurrentNodeFound = true;
            }
            return tiSearchRoot;
        }
        TreeItem tiParent = tiSearchRoot.getParentItem();
        if (tiParent == null) {
            tia = this.navTree.getItems();
            boolean bCurrentNodeFound = false;
            for (int i = tia.length; i > 0; --i) {
                if (bCurrentNodeFound) {
                    return this.getLastChild(tia[i - 1]);
                }
                if (!tia[i - 1].equals(tiSearchRoot)) continue;
                bCurrentNodeFound = true;
            }
            return null;
        }
        return this.getPreviousNode(tiParent, tiSearchRoot);
    }

    public void widgetDefaultSelected(SelectionEvent se) {
    }

    public void widgetDisposed(DisposeEvent de) {
        Object oSelected = de.getSource();
        if (oSelected instanceof Shell && this.shell.equals(oSelected)) {
            if (this.previewPanel != null && !this.previewPanel.shell.isDisposed()) {
                this.previewPanel.shell.dispose();
            }
            if (this.selector != null && !this.selector.isDisposed()) {
                this.selector.dispose();
            }
        }
    }

    public void shellActivated(ShellEvent se) {
    }

    public void shellClosed(ShellEvent se) {
        if (this.previewPanel != null && ((Shell)se.getSource()).equals(this.previewPanel.shell)) {
            this.previewBtnPanel.toggleButtonText();
            this.previewBtnPanel.toggleButtonState();
        } else if (this.shell.equals(se.getSource())) {
            this.removeAdapters();
            this.chartModelCurrent = null;
            this.shell.dispose();
        }
    }

    public void shellDeactivated(ShellEvent se) {
    }

    public void shellDeiconified(ShellEvent se) {
    }

    public void shellIconified(ShellEvent se) {
    }

    public void controlMoved(ControlEvent e) {
        if (this.previewPanel != null && !this.previewPanel.shell.isDisposed()) {
            this.previewPanel.shell.setLocation(this.shell.getLocation().x + this.shell.getClientArea().width + 8, this.shell.getLocation().y);
        }
    }

    public void controlResized(ControlEvent e) {
        if (this.previewPanel != null && !this.previewPanel.shell.isDisposed()) {
            this.previewPanel.shell.setLocation(this.shell.getLocation().x + this.shell.getClientArea().width + 8, this.shell.getLocation().y);
        }
    }

    public Chart getChart() {
        if (!this.bWasCancelled) {
            return this.chartModelCurrent;
        }
        return null;
    }

    private void addSheet(String sNodeName) {
        Vector vSheets = new Vector();
        if (this.htVisibleSheets.containsKey(sNodeName)) {
            block7: {
                try {
                    Object oSheets = this.htVisibleSheets.get(sNodeName);
                    if (oSheets instanceof Vector) {
                        vSheets = (Vector)oSheets;
                        break block7;
                    }
                    if (oSheets instanceof ISheet) {
                        vSheets.add(oSheets);
                        break block7;
                    }
                    return;
                }
                catch (ClassCastException e) {
                    e.printStackTrace();
                    return;
                }
            }
            vSheets.add(this.htRegisteredSheets.get(sNodeName));
            this.htVisibleSheets.put(sNodeName, vSheets);
        } else if (this.htRegisteredSheets.containsKey(sNodeName)) {
            vSheets.add(this.htRegisteredSheets.get(sNodeName));
            this.htVisibleSheets.put(sNodeName, vSheets);
        }
    }

    private void removeSheet(String sNodeName) {
        Vector vSheets = new Vector();
        if (this.htVisibleSheets.containsKey(sNodeName)) {
            block7: {
                try {
                    Object oSheets = this.htVisibleSheets.get(sNodeName);
                    if (oSheets instanceof Vector) {
                        vSheets = (Vector)oSheets;
                        break block7;
                    }
                    if (oSheets instanceof ISheet) {
                        vSheets.add(oSheets);
                        break block7;
                    }
                    return;
                }
                catch (ClassCastException e) {
                    e.printStackTrace();
                    return;
                }
            }
            int iLast = vSheets.lastIndexOf(this.htRegisteredSheets.get(sNodeName));
            vSheets.remove(iLast);
            this.htVisibleSheets.put(sNodeName, vSheets);
        } else if (this.htRegisteredSheets.containsKey(sNodeName)) {
            int iLast = vSheets.lastIndexOf(this.htRegisteredSheets.get(sNodeName));
            vSheets.remove(iLast);
            this.htVisibleSheets.put(sNodeName, vSheets);
        }
    }

    public Chart getCurrentModelState() {
        return this.chartModelCurrent;
    }

    public boolean registerSheetCollection(String sCollection, String[] saNodePaths) {
        try {
            this.htSheetCollections.put(sCollection, saNodePaths);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public String[] getRegisteredCollectionValue(String sCollection) {
        Object oArr = this.htSheetCollections.get(sCollection);
        if (oArr == null) {
            return null;
        }
        return (String[])oArr;
    }

    public boolean addCollectionInstance(String sCollection) {
        if (!this.htSheetCollections.containsKey(sCollection)) {
            return false;
        }
        String[] saNodes = (String[])this.htSheetCollections.get(sCollection);
        for (int iN = 0; iN < saNodes.length; ++iN) {
            this.addSheet(saNodes[iN]);
        }
        this.updateUI();
        return true;
    }

    public boolean removeCollectionInstance(String sCollection) {
        if (!this.htSheetCollections.containsKey(sCollection)) {
            return false;
        }
        String[] saNodes = (String[])this.htSheetCollections.get(sCollection);
        for (int iN = 0; iN < saNodes.length; ++iN) {
            this.removeSheet(saNodes[iN]);
        }
        this.updateUI();
        return true;
    }

    static {
        try {
            swtDisplayServer = PluginSettings.instance().getDisplayServer("ds.SWT");
        }
        catch (ChartException e) {
            logger.log((Exception)((Object)e));
        }
    }
}

