/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Vector;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.ui.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.MessageComposite;
import org.eclipse.birt.chart.ui.swt.UIExtensionsImpl;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartSubType;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartType;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class ChartSelector
implements SelectionListener {
    private transient Button btnAccept = null;
    private transient Button btnCancel = null;
    private transient Button btnSelect = null;
    private transient Chart chartModel = null;
    private transient Composite cmpButtons = null;
    private transient Composite cmpLabels = null;
    private transient Composite cmpTypeButtons = null;
    private transient Composite cmpSubTypes = null;
    private transient Composite cmpDimension = null;
    private transient Group grpDescription = null;
    private transient MessageComposite msgComposite = null;
    private transient LinkedHashMap htTypes = null;
    private transient RowData rowData = new RowData(80, 80);
    private transient Shell shell = null;
    private transient String sSubTypeDescription = null;
    private transient String sSubType = null;
    private transient String sType = null;
    private transient String sDimension = null;
    private transient Table table = null;
    private transient Vector vSubTypeNames = null;
    private transient Orientation orientation = Orientation.VERTICAL_LITERAL;
    private transient Combo cbDimension = null;
    private transient Button cbOrientation = null;
    private transient boolean bCancelled = true;
    private transient boolean bModify = false;
    private transient Color clrWhite = null;
    private static final String LEADING_BLANKS = "  ";
    private transient Label lblDescription = null;

    public ChartSelector(Chart chartModel) {
        this.chartModel = chartModel;
        this.clrWhite = new Color((Device)Display.getCurrent(), 255, 255, 255);
        if (chartModel != null) {
            this.sType = chartModel.getType();
            this.sSubTypeDescription = this.sSubType = chartModel.getSubType();
            this.sDimension = chartModel.getDimension().getName();
            if (chartModel instanceof ChartWithAxes) {
                this.orientation = ((ChartWithAxes)chartModel).getOrientation();
            }
        }
        this.htTypes = new LinkedHashMap();
        this.createShell();
        this.shell.setDefaultButton(this.btnAccept);
        this.shell.layout();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    private void createShell() {
        Display display = Display.getCurrent();
        try {
            this.shell = PlatformUI.isWorkbenchRunning() ? new Shell(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 67696) : new Shell(display, 67696);
        }
        catch (Throwable t) {
            this.shell = new Shell(display, 67696);
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.shell.setLayout((Layout)gridLayout);
        this.createHeader();
        this.createTable();
        this.addChartTypes();
        this.createComposite(new Vector());
        this.createButtonPanel();
        this.setDefaultTypeSelection();
        this.shell.setText(Messages.getString("ChartSelector.Title.ChartSelector"));
        this.shell.setSize(new Point(600, 500));
        this.shell.setImage(UIHelper.getImage("icons/obj16/chartselector.gif"));
        UIHelper.centerOnScreen(this.shell);
    }

    private void createHeader() {
        GridData gdHeader = new GridData(768);
        gdHeader.heightHint = 90;
        gdHeader.horizontalSpan = 2;
        this.msgComposite = new MessageComposite((Composite)this.shell, "icons/wizban/chartwatermark.gif", "", "", false);
        this.msgComposite.setBackground(this.clrWhite);
        this.msgComposite.setLayoutData(gdHeader);
        GridData gdLabels = new GridData(768);
        gdLabels.heightHint = 15;
        gdLabels.horizontalSpan = 2;
        this.cmpLabels = new Composite((Composite)this.shell, 0);
        this.cmpLabels.setLayoutData((Object)gdLabels);
        GridLayout glLabels = new GridLayout();
        glLabels.horizontalSpacing = 6;
        glLabels.numColumns = 10;
        glLabels.marginHeight = 0;
        glLabels.marginWidth = 4;
        this.cmpLabels.setLayout((Layout)glLabels);
        Label lblTypes = new Label(this.cmpLabels, 524288);
        lblTypes.setText(Messages.getString("ChartSelector.Lbl.ChartTypes"));
        GridData gdTypes = new GridData(1);
        gdTypes.widthHint = 110;
        lblTypes.setLayoutData((Object)gdTypes);
        Label lblSubtypes = new Label(this.cmpLabels, 524288);
        lblSubtypes.setText(Messages.getString("ChartSelector.Lbl.Subtypes"));
        GridData gdSubtypes = new GridData(769);
        gdSubtypes.horizontalSpan = 9;
        lblSubtypes.setLayoutData((Object)gdSubtypes);
    }

    private void createTable() {
        GridData gdTable = new GridData(1296);
        this.table = new Table((Composite)this.shell, 2048);
        this.table.setLayoutData((Object)gdTable);
        this.table.setToolTipText(Messages.getString("ChartSelector.Lbl.ChartTypes2"));
        this.table.addSelectionListener((SelectionListener)this);
    }

    private void addChartTypes() {
        this.populateTypesTable();
        this.updateUI();
    }

    public boolean isDisposed() {
        return this.shell.isDisposed();
    }

    public void dispose() {
        if (!this.shell.isDisposed()) {
            this.shell.dispose();
        }
        this.clrWhite.dispose();
    }

    private void createComposite(Vector vSubTypes) {
        GridData gdTypes = new GridData(784);
        this.cmpSubTypes = new Composite((Composite)this.shell, 0);
        this.createGroups(vSubTypes);
        this.cmpSubTypes.setLayoutData((Object)gdTypes);
        this.cmpSubTypes.setToolTipText(Messages.getString("ChartSelector.Lbl.ChartSubtypes"));
        this.cmpSubTypes.setLayout((Layout)new GridLayout());
        this.cmpSubTypes.setVisible(true);
    }

    private void createGroups(Vector vSubTypes) {
        this.vSubTypeNames = new Vector();
        if (this.cmpTypeButtons == null) {
            this.cmpTypeButtons = new Composite(this.cmpSubTypes, 0);
        }
        RowLayout rowLayout = new RowLayout();
        rowLayout.marginTop = 0;
        rowLayout.marginLeft = 0;
        rowLayout.marginBottom = 12;
        rowLayout.marginRight = 12;
        rowLayout.spacing = 4;
        this.cmpTypeButtons.setLayout((Layout)rowLayout);
        Control[] cTypeButtons = this.cmpTypeButtons.getChildren();
        for (int iCo = 0; iCo < cTypeButtons.length; ++iCo) {
            cTypeButtons[iCo].dispose();
        }
        for (int iC = 0; iC < vSubTypes.size(); ++iC) {
            IChartSubType subType = (IChartSubType)vSubTypes.get(iC);
            this.vSubTypeNames.add(subType.getName());
            Button btnType = new Button(this.cmpTypeButtons, 2);
            btnType.setText(subType.getName());
            btnType.setData((Object)subType.getDescription());
            btnType.setImage(subType.getImage());
            btnType.setLayoutData((Object)this.rowData);
            btnType.addSelectionListener((SelectionListener)this);
            btnType.setToolTipText(subType.getName());
            btnType.getImage().setBackground(btnType.getBackground());
            btnType.setVisible(true);
            this.cmpTypeButtons.layout();
        }
        this.cmpTypeButtons.setLayoutData((Object)new GridData(1808));
        if (this.cmpDimension == null) {
            this.cmpDimension = new Composite(this.cmpSubTypes, 0);
            GridLayout gridDimension = new GridLayout();
            gridDimension.numColumns = 4;
            this.cmpDimension.setLayout((Layout)gridDimension);
            Label lblDimension = new Label(this.cmpDimension, 0);
            lblDimension.setText(Messages.getString("ChartSelector.Lbl.Dimension"));
            GridData gdLDimension = new GridData();
            gdLDimension.horizontalIndent = 5;
            lblDimension.setLayoutData((Object)gdLDimension);
            this.cbDimension = new Combo(this.cmpDimension, 12);
            GridData gdCBDimension = new GridData(512);
            gdCBDimension.widthHint = 70;
            this.cbDimension.setLayoutData((Object)gdCBDimension);
            this.cbDimension.addSelectionListener((SelectionListener)this);
            this.cbOrientation = new Button(this.cmpDimension, 32);
            this.cbOrientation.setText(Messages.getString("ChartSelector.Lbl.Transposed"));
            GridData gdCBOrientation = new GridData(512);
            this.cbOrientation.setLayoutData((Object)gdCBOrientation);
            this.cbOrientation.addSelectionListener((SelectionListener)this);
            GridData gdCDimension = new GridData(768);
            gdCDimension.heightHint = 30;
            this.cmpDimension.setLayoutData((Object)gdCDimension);
        }
        this.populateLists();
        if (this.grpDescription == null) {
            this.grpDescription = new Group(this.cmpSubTypes, 0);
            this.grpDescription.setLayout((Layout)new FillLayout());
            GridData gdDesc = new GridData(768);
            gdDesc.heightHint = 60;
            this.grpDescription.setLayoutData((Object)gdDesc);
            this.lblDescription = new Label((Composite)this.grpDescription, 16448);
        }
    }

    private void populateLists() {
        if ("Horizontal".equals(this.orientation)) {
            this.cbOrientation.setSelection(true);
        } else {
            this.cbOrientation.setSelection(false);
        }
        if (this.sDimension == null) {
            this.cbDimension.select(0);
        } else {
            String[] strArr = this.cbDimension.getItems();
            for (int iD = 0; iD < strArr.length; ++iD) {
                if (!this.sDimension.equals(strArr[iD])) continue;
                this.cbDimension.select(iD);
                break;
            }
        }
    }

    private void populateDimensionCombo(String sSelectedType) {
        this.cbDimension.removeAll();
        String[] strArr = ((IChartType)this.htTypes.get(sSelectedType)).getSupportedDimensions();
        this.cbDimension.setItems(strArr);
        this.translateDimensionString();
        for (int iD = 0; iD < strArr.length; ++iD) {
            if ((this.sDimension == null || !strArr[iD].equals(this.sDimension)) && !strArr[iD].equals(((IChartType)this.htTypes.get(this.sType)).getDefaultDimension())) continue;
            this.cbDimension.select(iD);
        }
    }

    private void translateDimensionString() {
        if (this.sDimension.equals(ChartDimension.TWO_DIMENSIONAL_LITERAL.getName())) {
            this.sDimension = IChartType.TWO_DIMENSION_TYPE;
        } else if (this.sDimension.equals(ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL.getName())) {
            this.sDimension = IChartType.TWO_DIMENSION_WITH_DEPTH_TYPE;
        } else if (this.sDimension.equals(ChartDimension.THREE_DIMENSIONAL_LITERAL.getName())) {
            this.sDimension = IChartType.THREE_DIMENSION_TYPE;
        }
    }

    public boolean wasCancelled() {
        return this.bCancelled;
    }

    public boolean allowModification() {
        return this.bModify;
    }

    private void createAndDisplayTypesSheet(String sSelectedType) {
        IChartType chartType = (IChartType)this.htTypes.get(sSelectedType);
        this.cbOrientation.setEnabled(chartType.supportsTransposition(this.sDimension));
        if (!this.cbOrientation.isEnabled()) {
            this.orientation = Orientation.VERTICAL_LITERAL;
        }
        Vector vSubTypes = null;
        if (this.sDimension != null && this.orientation != null) {
            vSubTypes = new Vector(chartType.getChartSubtypes(this.sDimension, this.orientation));
        }
        if (vSubTypes == null || vSubTypes.size() == 0) {
            vSubTypes = new Vector(chartType.getChartSubtypes(chartType.getDefaultDimension(), Orientation.VERTICAL_LITERAL));
            this.sDimension = chartType.getDefaultDimension();
            this.orientation = Orientation.VERTICAL_LITERAL;
        }
        Orientation orientationTmp = this.orientation;
        this.createGroups(vSubTypes);
        this.populateDimensionCombo(sSelectedType);
        if (orientationTmp == Orientation.HORIZONTAL_LITERAL) {
            this.cbOrientation.setSelection(true);
        } else {
            this.cbOrientation.setSelection(false);
        }
        this.msgComposite.update(chartType.getHelp().getTitle(), chartType.getHelp().getDescription());
        this.shell.layout();
    }

    private void createButtonPanel() {
        GridData gdButtons = new GridData(768);
        gdButtons.heightHint = 30;
        gdButtons.horizontalSpan = 2;
        this.cmpButtons = new Composite((Composite)this.shell, 0);
        this.cmpButtons.setLayoutData((Object)gdButtons);
        GridLayout glButtons = new GridLayout();
        glButtons.numColumns = 7;
        this.cmpButtons.setLayout((Layout)glButtons);
        GridData gdSelect = new GridData(512);
        gdSelect.horizontalSpan = 5;
        this.btnSelect = new Button(this.cmpButtons, 8);
        if (this.chartModel == null) {
            this.btnSelect.setText(Messages.getString("ChartSelector.Lbl.DefineChart"));
        } else {
            this.btnSelect.setText(Messages.getString("ChartSelector.Lbl.EditChart"));
        }
        this.btnSelect.setLayoutData((Object)gdSelect);
        GridData gdAccept = new GridData(512);
        gdAccept.horizontalSpan = 1;
        this.btnAccept = new Button(this.cmpButtons, 8);
        this.btnAccept.setText(Messages.getString("Shared.Lbl.OK"));
        this.btnAccept.setToolTipText(Messages.getString("ChartSelector.Lbl.Accept"));
        GridData gdCancel = new GridData(512);
        gdCancel.horizontalSpan = 1;
        this.btnCancel = new Button(this.cmpButtons, 8);
        this.btnCancel.setText(Messages.getString("Shared.Lbl.Cancel"));
        this.btnCancel.setToolTipText(Messages.getString("Shared.Lbl.Cancel"));
        this.btnAccept.addSelectionListener((SelectionListener)this);
        this.btnCancel.addSelectionListener((SelectionListener)this);
        this.btnSelect.addSelectionListener((SelectionListener)this);
    }

    public Chart getChart() {
        return this.chartModel;
    }

    private void populateTypesTable() {
        Collection cTypes = UIExtensionsImpl.instance().getUIChartTypeExtensions();
        Iterator iterTypes = cTypes.iterator();
        while (iterTypes.hasNext()) {
            IChartType type = (IChartType)iterTypes.next();
            this.htTypes.put(type.getName(), type);
        }
    }

    private void updateUI() {
        Iterator iter = this.htTypes.keySet().iterator();
        while (iter.hasNext()) {
            String sTypeTmp = (String)iter.next();
            TableItem tItem = new TableItem(this.table, 0);
            tItem.setText(LEADING_BLANKS + ((IChartType)this.htTypes.get(sTypeTmp)).getName());
            tItem.setImage(((IChartType)this.htTypes.get(sTypeTmp)).getImage());
        }
    }

    private void setDefaultTypeSelection() {
        if (this.table.getItems().length > 0) {
            if (this.sType == null) {
                this.table.select(0);
                this.sType = this.table.getSelection()[0].getText().trim();
            } else {
                TableItem[] tiAll = this.table.getItems();
                for (int iTI = 0; iTI < tiAll.length; ++iTI) {
                    if (!tiAll[iTI].getText().trim().equals(this.sType)) continue;
                    this.table.select(iTI);
                    break;
                }
            }
            this.createAndDisplayTypesSheet(this.sType);
            this.setDefaultSubtypeSelection();
        }
    }

    private void setDefaultSubtypeSelection() {
        if (this.sSubType == null) {
            ((Button)this.cmpTypeButtons.getChildren()[0]).setSelection(true);
            this.sSubType = ((Button)this.cmpTypeButtons.getChildren()[0]).getText();
            this.sSubTypeDescription = ((Button)this.cmpTypeButtons.getChildren()[0]).getData().toString();
        } else {
            Control[] buttons = this.cmpTypeButtons.getChildren();
            boolean bSelected = false;
            for (int iB = 0; iB < buttons.length; ++iB) {
                if (!((Button)buttons[iB]).getText().equals(this.sSubType)) continue;
                ((Button)buttons[iB]).setSelection(true);
                this.sSubTypeDescription = ((Button)this.cmpTypeButtons.getChildren()[iB]).getData().toString();
                bSelected = true;
                break;
            }
            if (!bSelected) {
                ((Button)this.cmpTypeButtons.getChildren()[0]).setSelection(true);
                this.sSubType = ((Button)this.cmpTypeButtons.getChildren()[0]).getText();
                this.sSubTypeDescription = ((Button)this.cmpTypeButtons.getChildren()[0]).getData().toString();
            }
        }
        this.cmpTypeButtons.redraw();
        this.lblDescription.setText(this.sSubTypeDescription);
        this.grpDescription.layout(true);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Object oSelected = e.getSource();
        if (oSelected.getClass().equals(Button.class)) {
            if (oSelected.equals(this.btnAccept)) {
                if (this.chartModel == null) {
                    this.bModify = true;
                }
                this.bCancelled = false;
                IChartType chartType = (IChartType)this.htTypes.get(this.sType);
                this.chartModel = chartType.getModel(this.sSubType, this.orientation, this.sDimension, this.chartModel);
                this.shell.dispose();
            } else if (oSelected.equals(this.btnSelect)) {
                this.bModify = true;
                this.bCancelled = false;
                IChartType chartType = (IChartType)this.htTypes.get(this.sType);
                this.chartModel = chartType.getModel(this.sSubType, this.orientation, this.sDimension, this.chartModel);
                this.shell.dispose();
            } else if (oSelected.equals(this.btnCancel)) {
                this.shell.dispose();
            } else if (oSelected.equals(this.cbOrientation)) {
                this.orientation = this.cbOrientation.getSelection() ? Orientation.HORIZONTAL_LITERAL : Orientation.VERTICAL_LITERAL;
                this.createAndDisplayTypesSheet(this.sType);
                this.setDefaultSubtypeSelection();
            } else {
                Button btn = (Button)e.getSource();
                if (btn.getSelection()) {
                    int iTypeIndex;
                    if (this.sSubType != null && !btn.getText().equals(this.sSubType) && (iTypeIndex = this.vSubTypeNames.indexOf(this.sSubType)) >= 0) {
                        ((Button)this.cmpTypeButtons.getChildren()[iTypeIndex]).setSelection(false);
                        this.cmpTypeButtons.redraw();
                    }
                    this.sSubType = btn.getText();
                    this.sSubTypeDescription = btn.getData().toString();
                    ((Label)this.grpDescription.getChildren()[0]).setText(this.sSubTypeDescription);
                } else if (this.sSubType != null && btn.getText().equals(this.sSubType)) {
                    btn.setSelection(true);
                } else {
                    ((Label)this.grpDescription.getChildren()[0]).setText("");
                }
            }
        } else if (oSelected.getClass().equals(Table.class)) {
            this.sSubType = null;
            this.sSubTypeDescription = null;
            this.createAndDisplayTypesSheet(((TableItem)e.item).getText().trim());
            this.sType = ((TableItem)e.item).getText().trim();
            this.setDefaultSubtypeSelection();
        } else if (oSelected.equals(this.cbDimension)) {
            this.sDimension = this.cbDimension.getItem(this.cbDimension.getSelectionIndex());
            this.createAndDisplayTypesSheet(this.sType);
            this.setDefaultSubtypeSelection();
        }
    }
}

