/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.flatfile.ui.wizards;

import java.io.File;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.SortedMap;
import org.eclipse.datatools.connectivity.oda.flatfile.ui.i18n.Messages;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FolderSelectionPageHelper {
    private WizardPage m_wizardPage;
    private PreferencePage m_propertyPage;
    private transient Text m_folderLocation = null;
    private transient Button m_typeLineCheckBox = null;
    private transient Button m_browseFolderButton = null;
    private transient Combo m_charSetSelectionCombo = null;
    private SortedMap m_charSetMap;
    static final String DEFAULT_MESSAGE = Messages.getString("wizard.defaultMessage.selectFolder");
    private static final int ERROR_FOLDER = 1;
    private static final int ERROR_EMPTY_PATH = 2;
    private static final String EMPTY_STRING = "";

    FolderSelectionPageHelper(WizardPage page) {
        this.m_wizardPage = page;
    }

    FolderSelectionPageHelper(PreferencePage page) {
        this.m_propertyPage = page;
    }

    void createCustomControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        content.setLayout((Layout)layout);
        this.setupFolderLocation(content);
        this.setupCharset(content);
        this.setupTypeLineCheckBox(content);
    }

    String getFolderLocation() {
        if (this.m_folderLocation == null) {
            return EMPTY_STRING;
        }
        return this.m_folderLocation.getText();
    }

    String getWhetherUseSecondLineAsTypeLine() {
        if (this.m_typeLineCheckBox == null) {
            return EMPTY_STRING;
        }
        return this.m_typeLineCheckBox.getSelection() ? "YES" : "NO";
    }

    String getCharSet() {
        if (this.m_charSetSelectionCombo == null) {
            return EMPTY_STRING;
        }
        return this.m_charSetSelectionCombo.getItem(this.m_charSetSelectionCombo.getSelectionIndex());
    }

    Properties collectCustomProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        props.setProperty("HOME", this.getFolderLocation());
        props.setProperty("INCLTYPELINE", this.getWhetherUseSecondLineAsTypeLine());
        props.setProperty("CHARSET", this.getCharSet());
        return props;
    }

    void initCustomControl(Properties profileProps) {
        if (profileProps == null || profileProps.isEmpty() || this.m_folderLocation == null) {
            return;
        }
        String folderPath = profileProps.getProperty("HOME");
        if (folderPath == null) {
            folderPath = EMPTY_STRING;
        }
        this.m_folderLocation.setText(folderPath);
        String useSecondLine = profileProps.getProperty("INCLTYPELINE");
        if (useSecondLine == null) {
            useSecondLine = EMPTY_STRING;
        }
        this.m_typeLineCheckBox.setSelection(useSecondLine.equalsIgnoreCase("YES"));
        String charSet = profileProps.getProperty("CHARSET");
        if (charSet == null || charSet.trim().length() == 0) {
            this.m_charSetSelectionCombo.select(0);
        } else {
            this.m_charSetSelectionCombo.select(this.m_charSetSelectionCombo.indexOf(charSet));
        }
        this.verifyFileLocation();
    }

    private void setupFolderLocation(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("label.selectFolder"));
        GridData data = new GridData(768);
        this.m_folderLocation = new Text(composite, 2048);
        this.m_folderLocation.setLayoutData((Object)data);
        this.setPageComplete(false);
        this.m_folderLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FolderSelectionPageHelper.this.verifyFileLocation();
            }
        });
        this.m_browseFolderButton = new Button(composite, 0);
        this.m_browseFolderButton.setText("...");
        this.m_browseFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(FolderSelectionPageHelper.this.m_folderLocation.getShell());
                if (FolderSelectionPageHelper.this.m_folderLocation.getText() != null && FolderSelectionPageHelper.this.m_folderLocation.getText().trim().length() > 0) {
                    dialog.setFilterPath(FolderSelectionPageHelper.this.m_folderLocation.getText());
                }
                dialog.setMessage(DEFAULT_MESSAGE);
                String selectedLocation = dialog.open();
                if (selectedLocation != null) {
                    FolderSelectionPageHelper.this.m_folderLocation.setText(selectedLocation);
                }
            }
        });
    }

    private int verifyFileLocation() {
        int result = 0;
        if (this.m_folderLocation.getText().trim().length() > 0) {
            File f = new File(this.m_folderLocation.getText().trim());
            if (f.exists()) {
                this.setMessage(DEFAULT_MESSAGE, 0);
                this.setPageComplete(true);
            } else {
                this.setMessage(Messages.getString("error.selectFolder"), 3);
                this.setPageComplete(false);
                result = 1;
            }
        } else {
            this.setMessage(Messages.getString("error.emptyPath"), 3);
            this.setPageComplete(false);
            result = 2;
        }
        return result;
    }

    private void setupCharset(Composite composite) {
        Label labelCharSet = new Label(composite, 0);
        labelCharSet.setText(Messages.getString("label.selectCharset"));
        this.m_charSetSelectionCombo = new Combo(composite, 8);
        GridData data = new GridData(256);
        data.horizontalSpan = 2;
        this.m_charSetSelectionCombo.setLayoutData((Object)data);
        this.m_charSetMap = Charset.availableCharsets();
        Object[] charSetsArray = this.m_charSetMap.keySet().toArray();
        for (int i = 0; i < charSetsArray.length; ++i) {
            String charSetName = ((Charset)this.m_charSetMap.get(charSetsArray[i])).name();
            this.m_charSetSelectionCombo.add(charSetName);
            if (!"UTF-8".equalsIgnoreCase(charSetName)) continue;
            this.m_charSetSelectionCombo.select(i);
        }
    }

    private void setupTypeLineCheckBox(Composite composite) {
        this.m_typeLineCheckBox = new Button(composite, 32);
        GridData data = new GridData();
        data.horizontalSpan = 3;
        this.m_typeLineCheckBox.setLayoutData((Object)data);
        this.m_typeLineCheckBox.setText(Messages.getString("label.includeTypeLine"));
    }

    private void setPageComplete(boolean complete) {
        if (this.m_wizardPage != null) {
            this.m_wizardPage.setPageComplete(complete);
        } else if (this.m_propertyPage != null) {
            this.m_propertyPage.setValid(complete);
        }
    }

    private void setMessage(String newMessage, int newType) {
        if (this.m_wizardPage != null) {
            this.m_wizardPage.setMessage(newMessage, newType);
        } else if (this.m_propertyPage != null) {
            this.m_propertyPage.setMessage(newMessage, newType);
        }
    }
}

