/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.plugin;

import java.io.PrintWriter;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.plugin.AbstractExtensions;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Extensions
extends AbstractExtensions {
    private static final long serialVersionUID = 1L;
    private boolean fValid;
    private boolean fIsFragment;

    void load(Extensions srcPluginBase) {
        super.load(srcPluginBase);
        this.fValid = this.hasRequiredAttributes();
    }

    void load(Node node, String schemaVersion) {
        this.fSchemaVersion = schemaVersion;
        if (node == null) {
            return;
        }
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                this.processChild(child);
            }
            ++i;
        }
        this.fValid = this.hasRequiredAttributes();
    }

    void load(Node[] nodes) {
        int i = 0;
        while (i < nodes.length) {
            Node child = nodes[i];
            if (child.getNodeType() == 1) {
                this.processChild(child);
            }
            ++i;
        }
        this.fValid = this.hasRequiredAttributes();
    }

    public void reset() {
        super.reset();
        this.fValid = false;
    }

    public boolean isValid() {
        return this.fValid;
    }

    public void write(String indent, PrintWriter writer) {
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.print(this.fIsFragment ? "<fragment>" : "<plugin>");
        writer.println();
        String firstIndent = "   ";
        IPluginObject[] children = this.getExtensionPoints();
        if (children.length > 0) {
            writer.println();
        }
        int i = 0;
        while (i < children.length) {
            children[i].write(firstIndent, writer);
            ++i;
        }
        children = this.getExtensions();
        if (children.length > 0) {
            writer.println();
        }
        i = 0;
        while (i < children.length) {
            ((IPluginExtension)children[i]).write(firstIndent, writer);
            ++i;
        }
        writer.println();
        writer.println(this.fIsFragment ? "</fragment>" : "</plugin>");
    }

    public void setIsFragment(boolean isFragment) {
        this.fIsFragment = isFragment;
    }
}

