/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.wizards.INewLibraryCreationPage;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class NewLibraryWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private static final String NEW_REPORT_FILE_NAME_PREFIX = Messages.getString((String)"NewLibraryWizard.displayName.NewReportFileNamePrefix");
    private static final String NEW_REPORT_FILE_EXTENSION = Messages.getString((String)"NewLibraryWizard.displayName.NewReportFileExtension");
    private static final String NEW_REPORT_FILE_NAME = NEW_REPORT_FILE_NAME_PREFIX + NEW_REPORT_FILE_EXTENSION;
    private static final String CREATE_A_NEW_REPORT = Messages.getString((String)"NewLibraryWizard.text.CreateReport");
    private static final String REPORT = Messages.getString((String)"NewLibraryWizard.title.Report");
    private static final String NEW = Messages.getString((String)"NewLibraryWizard.title.New");
    private IStructuredSelection selection;
    private INewLibraryCreationPage newLibraryFileWizardPage;
    private int UNIQUE_COUNTER = 0;
    private static final List tmpList = new ArrayList();
    private IConfigurationElement configElement;

    public boolean performFinish() {
        return this.newLibraryFileWizardPage.performFinish();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.setWindowTitle(NEW);
    }

    public Image getDefaultPageImage() {
        return ReportPlugin.getImage((String)"/icons/wizban/create_report_wizard.gif");
    }

    public void addPages() {
        Object adapter = Platform.getAdapterManager().getAdapter((Object)this, INewLibraryCreationPage.class);
        this.newLibraryFileWizardPage = (INewLibraryCreationPage)adapter;
        this.addPage(this.newLibraryFileWizardPage);
        this.newLibraryFileWizardPage.setTitle(REPORT);
        this.newLibraryFileWizardPage.setDescription(CREATE_A_NEW_REPORT);
        this.resetUniqueCount();
        this.newLibraryFileWizardPage.setFileName(this.getUniqueReportName());
        this.newLibraryFileWizardPage.setContainerFullPath(this.getDefaultContainerPath());
    }

    private void resetUniqueCount() {
        this.UNIQUE_COUNTER = 0;
    }

    private IPath getDefaultContainerPath() {
        IEditorPart editor;
        IWorkbenchWindow benchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPart part = benchWindow.getPartService().getActivePart();
        Object selection = null;
        if (part instanceof IEditorPart) {
            selection = ((IEditorPart)part).getEditorInput();
        } else {
            ISelection sel = benchWindow.getSelectionService().getSelection();
            if (sel != null && sel instanceof IStructuredSelection) {
                selection = ((IStructuredSelection)sel).getFirstElement();
            }
        }
        IContainer ct = this.getDefaultContainer(selection);
        if (ct == null && (editor = UIUtil.getActiveEditor((boolean)true)) != null) {
            ct = this.getDefaultContainer(editor.getEditorInput());
        }
        if (ct != null) {
            return ct.getFullPath();
        }
        return Platform.getLocation();
    }

    private IContainer getDefaultContainer(Object selection) {
        IContainer ct = null;
        if (selection instanceof IAdaptable) {
            IResource resource = (IResource)((IAdaptable)selection).getAdapter(IResource.class);
            if (resource instanceof IContainer && resource.isAccessible()) {
                ct = (IContainer)resource;
            } else if (resource != null && resource.getParent() != null && resource.getParent().isAccessible()) {
                ct = resource.getParent();
            }
        }
        return ct;
    }

    private String getUniqueReportName() {
        IProject[] pjs = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        if (pjs.length != 0) {
            this.resetUniqueCount();
            boolean goon = true;
            block0: while (goon) {
                goon = false;
                for (int i = 0; i < pjs.length; ++i) {
                    if (!pjs[i].isAccessible() || this.validDuplicate(NEW_REPORT_FILE_NAME_PREFIX, NEW_REPORT_FILE_EXTENSION, this.UNIQUE_COUNTER, (IResource)pjs[i])) continue;
                    ++this.UNIQUE_COUNTER;
                    goon = true;
                    continue block0;
                }
            }
            if (this.UNIQUE_COUNTER == 0) {
                return NEW_REPORT_FILE_NAME;
            }
            return NEW_REPORT_FILE_NAME_PREFIX + "_" + this.UNIQUE_COUNTER + NEW_REPORT_FILE_EXTENSION;
        }
        String extension = NEW_REPORT_FILE_EXTENSION;
        String path = Platform.getLocation().toOSString();
        String name = NEW_REPORT_FILE_NAME_PREFIX + NEW_REPORT_FILE_EXTENSION;
        int count = 0;
        File file = new File(path, name);
        while (file.exists()) {
            name = NEW_REPORT_FILE_NAME_PREFIX + "_" + ++count + NEW_REPORT_FILE_EXTENSION;
            file = null;
            file = new File(path, name);
        }
        file = null;
        return name;
    }

    private boolean validDuplicate(String prefix, String ext, int count, IResource res) {
        if (res != null && res.isAccessible()) {
            final String name = count == 0 ? prefix + ext : prefix + "_" + count + ext;
            try {
                tmpList.clear();
                res.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        if (resource.getType() == 1 && name.equals(((IFile)resource).getName())) {
                            tmpList.add(Boolean.TRUE);
                        }
                        return true;
                    }
                }, 2, true);
                if (tmpList.size() > 0) {
                    return false;
                }
            }
            catch (CoreException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        return true;
    }

    protected IFolder createFolderHandle(IPath folderPath) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        return workspaceRoot.getFolder(folderPath);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.configElement = config;
    }

    public IConfigurationElement getConfigElement() {
        return this.configElement;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }
}

