/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.util.manifest;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.framework.IConfigurationElement;
import org.eclipse.birt.core.framework.IExtension;
import org.eclipse.birt.core.framework.IExtensionPoint;
import org.eclipse.birt.core.framework.IExtensionRegistry;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.data.oda.OdaException;
import org.eclipse.birt.data.oda.util.ResourceCache;
import org.eclipse.birt.data.oda.util.ResourceManager;
import org.eclipse.birt.data.oda.util.manifest.DataSetType;
import org.eclipse.birt.data.oda.util.manifest.ExtensionManifest;

public class ManifestExplorer {
    private static ManifestExplorer sm_instance = new ManifestExplorer();
    private static String sm_loggerName = ManifestExplorer.class.getPackage().getName();
    private static Logger sm_logger = Logger.getLogger(sm_loggerName);

    public static ManifestExplorer getInstance() {
        return sm_instance;
    }

    private ManifestExplorer() {
    }

    public Properties getDataSourceIdentifiers() {
        IExtension[] extensions = this.getDataSourceExtensions();
        int length = extensions == null ? 0 : extensions.length;
        Properties extensionIds = new Properties();
        for (int i = 0; i < length; ++i) {
            IExtension extension = extensions[i];
            try {
                IConfigurationElement dsElement = ManifestExplorer.getDataSourceElement(extension);
                String dataSourceId = dsElement.getAttribute("id");
                String dataSourceDisplayName = ManifestExplorer.getElementDisplayName(dsElement);
                extensionIds.setProperty(dataSourceId, dataSourceDisplayName);
                continue;
            }
            catch (OdaException ex) {
                sm_logger.log(Level.WARNING, "Ignoring invalid extension.", ex);
            }
        }
        return extensionIds;
    }

    public ExtensionManifest getExtensionManifest(String extensionId) throws OdaException {
        return new ExtensionManifest(this.findIExtension(extensionId));
    }

    IExtension findIExtension(String extensionId) {
        if (extensionId == null || extensionId.length() == 0) {
            throw new IllegalArgumentException(extensionId);
        }
        IExtension[] extensions = this.getDataSourceExtensions();
        int length = extensions == null ? 0 : extensions.length;
        for (int i = 0; i < length; ++i) {
            IExtension extension = extensions[i];
            String dataSourceId = null;
            try {
                IConfigurationElement dataSourceElement = ManifestExplorer.getDataSourceElement(extension);
                dataSourceId = dataSourceElement.getAttribute("id");
            }
            catch (OdaException ex) {
                sm_logger.log(Level.WARNING, "Ignoring invalid extension.", ex);
                continue;
            }
            if (dataSourceId == null || !dataSourceId.equals(extensionId)) continue;
            return extension;
        }
        throw new IllegalArgumentException(extensionId);
    }

    public ExtensionManifest[] getExtensionManifests() {
        IExtension[] extensions = this.getDataSourceExtensions();
        int length = extensions == null ? 0 : extensions.length;
        ArrayList<ExtensionManifest> manifestList = new ArrayList<ExtensionManifest>(length);
        for (int i = 0; i < length; ++i) {
            IExtension extension = extensions[i];
            try {
                manifestList.add(new ExtensionManifest(extension));
                continue;
            }
            catch (OdaException ex) {
                sm_logger.log(Level.WARNING, "Ignoring invalid extension.", ex);
            }
        }
        int numOfValidExtensions = manifestList.size();
        return manifestList.toArray(new ExtensionManifest[numOfValidExtensions]);
    }

    IExtension[] getDataSourceExtensions() {
        int i;
        IExtensionPoint dtpExtensionPoint;
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtension[] birtExtensions = null;
        IExtension[] dtpExtensions = null;
        int birtExtLength = 0;
        int dtpExtLength = 0;
        IExtensionPoint birtExtensionPoint = pluginRegistry.getExtensionPoint("org.eclipse.birt.data.oda.dataSource");
        if (birtExtensionPoint != null) {
            birtExtensions = birtExtensionPoint.getExtensions();
        }
        if ((dtpExtensionPoint = pluginRegistry.getExtensionPoint("org.eclipse.datatools.connectivity.oda.dataSource")) != null) {
            dtpExtensions = dtpExtensionPoint.getExtensions();
        }
        if (birtExtensions != null) {
            birtExtLength = birtExtensions.length;
        }
        if (dtpExtensions != null) {
            dtpExtLength = dtpExtensions.length;
        }
        LinkedList<IExtension> combinedList = new LinkedList<IExtension>();
        for (i = 0; i < birtExtLength; ++i) {
            combinedList.add(birtExtensions[i]);
        }
        for (i = 0; i < dtpExtLength; ++i) {
            if (dtpExtensions[i].getNamespace().equals("org.eclipse.birt.data.oda.adapter.dtp")) continue;
            combinedList.add(dtpExtensions[i]);
        }
        IExtension[] combinedArray = new IExtension[combinedList.size()];
        combinedList.toArray(combinedArray);
        return combinedArray;
    }

    static IConfigurationElement getDataSourceElement(IExtension extension) throws OdaException {
        IConfigurationElement[] configElements = extension.getConfigurationElements();
        int n = configElements.length;
        for (int i = 0; i < n; ++i) {
            IConfigurationElement configElement = configElements[i];
            if (!configElement.getName().equalsIgnoreCase("dataSource")) continue;
            String dataSourceId = configElement.getAttribute("id");
            if (dataSourceId == null || dataSourceId.length() == 0) {
                throw new OdaException(ManifestExplorer.getLocalizedMessage(9));
            }
            return configElement;
        }
        throw new OdaException(ManifestExplorer.getLocalizedMessage(8));
    }

    static Hashtable getDataSetElements(IExtension extension, String dataSourceElementId) throws OdaException {
        IConfigurationElement[] configElements = extension.getConfigurationElements();
        Hashtable<String, DataSetType> dataSetElements = new Hashtable<String, DataSetType>();
        int size = configElements.length;
        for (int i = 0; i < size; ++i) {
            IConfigurationElement configElement = configElements[i];
            if (!configElement.getName().equalsIgnoreCase("dataSet")) continue;
            String dataSetTypeId = configElement.getAttribute("id");
            if (dataSetTypeId == null || dataSetTypeId.length() == 0) {
                throw new OdaException(ManifestExplorer.getLocalizedMessage(14, new Object[]{dataSourceElementId}));
            }
            dataSetElements.put(dataSetTypeId, new DataSetType(configElement));
        }
        if (dataSetElements.size() < 1) {
            throw new OdaException(ManifestExplorer.getLocalizedMessage(13, new Object[]{dataSourceElementId}));
        }
        return dataSetElements;
    }

    static String getElementDisplayName(IConfigurationElement dsElement) {
        String displayName = dsElement.getAttribute("defaultDisplayName");
        if ((displayName == null || displayName.length() == 0) && (displayName = dsElement.getAttribute("id")) == null) {
            displayName = dsElement.getAttribute("name");
        }
        return displayName;
    }

    static String getLocalizedMessage(int errorNumber) {
        ResourceManager manager = ResourceCache.instance().getResources("org.eclipse.birt.data.oda.util.OdaResources", Locale.getDefault());
        return manager != null ? manager.getString(errorNumber) : "";
    }

    static String getLocalizedMessage(int errorNumber, Object[] arguments) {
        return MessageFormat.format(ManifestExplorer.getLocalizedMessage(errorNumber), arguments);
    }
}

