/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.ui.util;

import java.sql.Driver;

public final class JDBCDriverInformation {
    private String driverClassName = null;
    private int majorVersion = 0;
    private int minorVersion = 0;
    private String urlFormat = null;
    private String driverDisplayName = null;

    private JDBCDriverInformation() {
    }

    public static JDBCDriverInformation newInstance(Class driverClass) {
        try {
            Driver d = (Driver)driverClass.newInstance();
            if (d != null) {
                JDBCDriverInformation info = JDBCDriverInformation.newInstance(driverClass.getName());
                info.setMajorVersion(d.getMajorVersion());
                info.setMinorVersion(d.getMinorVersion());
                return info;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static JDBCDriverInformation newInstance(String driverClassName) {
        JDBCDriverInformation info = new JDBCDriverInformation();
        info.setDriverClassName(driverClassName);
        return info;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    protected void setMajorVersion(int majorVersion) {
        this.majorVersion = majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    protected void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }

    public String getUrlFormat() {
        return this.urlFormat;
    }

    protected void setUrlFormat(String urlFormat) {
        this.urlFormat = urlFormat;
    }

    public String getDisplayName() {
        return this.driverDisplayName;
    }

    public void setDisplayName(String displayName) {
        this.driverDisplayName = displayName;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.driverClassName);
        if (this.majorVersion != 0 || this.minorVersion != 0) {
            buffer.append(" (");
            buffer.append(this.majorVersion);
            buffer.append(".");
            buffer.append(this.minorVersion);
            buffer.append(")");
        }
        return buffer.toString();
    }

    public String getDisplayString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.driverClassName);
        if (this.majorVersion != 0 || this.minorVersion != 0 || this.driverDisplayName != null) {
            buffer.append(" (");
            if (this.driverDisplayName != null) {
                buffer.append(this.driverDisplayName);
            }
            if (this.majorVersion != 0 || this.minorVersion != 0) {
                if (this.driverDisplayName != null) {
                    buffer.append(" ");
                }
                buffer.append("v");
                buffer.append(this.majorVersion);
                buffer.append(".");
                buffer.append(this.minorVersion);
            }
            buffer.append(")");
        }
        return buffer.toString();
    }
}

