/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.util.Hashtable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.RecorderEntry;
import org.apache.tools.ant.types.EnumeratedAttribute;

public class Recorder
extends Task {
    private String filename = null;
    private Boolean append = null;
    private Boolean start = null;
    private int loglevel = -1;
    private boolean emacsMode = false;
    private static Hashtable recorderEntries = new Hashtable();

    public void setName(String fname) {
        this.filename = fname;
    }

    public void setAction(ActionChoices action) {
        this.start = action.getValue().equalsIgnoreCase("start") ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setAppend(boolean append) {
        this.append = append ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setEmacsMode(boolean emacsMode) {
        this.emacsMode = emacsMode;
    }

    public void setLoglevel(VerbosityLevelChoices level) {
        String lev = level.getValue();
        if (lev.equalsIgnoreCase("error")) {
            this.loglevel = 0;
        } else if (lev.equalsIgnoreCase("warn")) {
            this.loglevel = 1;
        } else if (lev.equalsIgnoreCase("info")) {
            this.loglevel = 2;
        } else if (lev.equalsIgnoreCase("verbose")) {
            this.loglevel = 3;
        } else if (lev.equalsIgnoreCase("debug")) {
            this.loglevel = 4;
        }
    }

    public void execute() throws BuildException {
        if (this.filename == null) {
            throw new BuildException("No filename specified");
        }
        this.getProject().log("setting a recorder for name " + this.filename, 4);
        RecorderEntry recorder = this.getRecorder(this.filename, this.getProject());
        recorder.setMessageOutputLevel(this.loglevel);
        if (this.start != null) {
            if (this.start.booleanValue()) {
                recorder.reopenFile();
                recorder.setRecordState(this.start);
            } else {
                recorder.setRecordState(this.start);
                recorder.closeFile();
            }
        }
        recorder.setEmacsMode(this.emacsMode);
    }

    protected RecorderEntry getRecorder(String name, Project proj) throws BuildException {
        RecorderEntry entry;
        Object o = recorderEntries.get(name);
        if (o == null) {
            entry = new RecorderEntry(name);
            if (this.append == null) {
                entry.openFile(false);
            } else {
                entry.openFile(this.append);
            }
            entry.setProject(proj);
            recorderEntries.put(name, entry);
        } else {
            entry = (RecorderEntry)o;
        }
        return entry;
    }

    public static class ActionChoices
    extends EnumeratedAttribute {
        private static final String[] VALUES = new String[]{"start", "stop"};

        public String[] getValues() {
            return VALUES;
        }
    }

    public static class VerbosityLevelChoices
    extends EnumeratedAttribute {
        private static final String[] VALUES = new String[]{"error", "warn", "info", "verbose", "debug"};

        public String[] getValues() {
            return VALUES;
        }
    }
}

