/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive;

import com.ibm.icu.text.SimpleDateFormat;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ArchiveUtil {
    public static String UNIX_SEPERATOR;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static String generateFullPath(String rootPath, String relativePath) {
        relativePath = ArchiveUtil.convertToSystemString(relativePath);
        if (rootPath != null) {
            if (!rootPath.endsWith(File.separator)) {
                rootPath = rootPath + File.separator;
            }
            if (relativePath.startsWith(File.separator)) {
                relativePath = relativePath.substring(1);
            }
            return rootPath + relativePath;
        }
        return relativePath;
    }

    public static String generateRelativePath(String rootPath, String fullPath) {
        String relativePath = null;
        relativePath = rootPath != null && fullPath.startsWith(rootPath) ? fullPath.substring(rootPath.length()) : fullPath;
        if (!(relativePath = ArchiveUtil.convertToUnixString(relativePath)).startsWith(UNIX_SEPERATOR)) {
            relativePath = UNIX_SEPERATOR + relativePath;
        }
        return relativePath;
    }

    private static String convertToUnixString(String path) {
        if (path == null) {
            return null;
        }
        return path.replace(File.separator.charAt(0), UNIX_SEPERATOR.charAt(0));
    }

    private static String convertToSystemString(String path) {
        if (path == null) {
            return null;
        }
        return path.replace(UNIX_SEPERATOR.charAt(0), File.separator.charAt(0));
    }

    public static synchronized String generateUniqueFileFolderName(String originalName) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
        String dateTimeString = df.format(new Date());
        String folderName = originalName + "_" + dateTimeString;
        Random generator = new Random();
        File folder = new File(folderName);
        while (folder.exists()) {
            folderName = folderName + generator.nextInt();
            folder = new File(folderName);
        }
        return folderName;
    }

    public static void createParentFolder(File fd) {
        if (fd != null && fd.getParentFile() != null && !fd.getParentFile().exists()) {
            fd.getParentFile().mkdirs();
        }
    }

    public static void DeleteAllFiles(File dirOrFile) {
        if (!dirOrFile.exists()) {
            return;
        }
        if (dirOrFile.isFile()) {
            dirOrFile.delete();
        } else {
            if (dirOrFile.listFiles() != null && dirOrFile.listFiles().length > 0) {
                File[] fileList = dirOrFile.listFiles();
                for (int i = 0; i < fileList.length; ++i) {
                    ArchiveUtil.DeleteAllFiles(fileList[i]);
                }
            }
            dirOrFile.delete();
        }
    }

    public static void zipFolderToStream(String tempFolderPath, OutputStream ostream) {
        ZipOutputStream zipOutput = new ZipOutputStream(ostream);
        File rootDir = new File(tempFolderPath);
        File[] files = rootDir.listFiles();
        try {
            ArchiveUtil.zipFiles(zipOutput, files, tempFolderPath);
            zipOutput.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void zipFiles(ZipOutputStream zipOut, File[] files, String tempFolderPath) throws FileNotFoundException, IOException {
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            int len;
            File file = files[i];
            if (file.isDirectory()) {
                File[] dirFiles = file.listFiles();
                ArchiveUtil.zipFiles(zipOut, dirFiles, tempFolderPath);
                continue;
            }
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            String relativePath = ArchiveUtil.generateRelativePath(tempFolderPath, file.getPath());
            ZipEntry entry = new ZipEntry(relativePath);
            entry.setTime(file.lastModified());
            zipOut.putNextEntry(entry);
            byte[] buf = new byte[5120];
            while ((len = in.read(buf)) > 0) {
                zipOut.write(buf, 0, len);
            }
            in.close();
            zipOut.closeEntry();
        }
    }

    public static void unzipArchive(File zipArchive, String tempFolderPath) {
        try {
            ZipFile zipFile = new ZipFile(zipArchive);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                int len;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    String dirName = ArchiveUtil.generateFullPath(tempFolderPath, entry.getName());
                    File dir = new File(dirName);
                    dir.mkdirs();
                    continue;
                }
                InputStream in = zipFile.getInputStream(entry);
                File file = new File(ArchiveUtil.generateFullPath(tempFolderPath, entry.getName()));
                File dir = new File(file.getParent());
                if (dir.exists()) {
                    if (!$assertionsDisabled && !dir.isDirectory()) {
                        throw new AssertionError();
                    }
                } else {
                    dir.mkdirs();
                }
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
                byte[] buf = new byte[5120];
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                in.close();
                out.close();
            }
            zipFile.close();
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        $assertionsDisabled = !ArchiveUtil.class.desiredAssertionStatus();
        UNIX_SEPERATOR = "/";
    }
}

