/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.framework.osgi;

import [Ljava.lang.String;;
import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.IPlatformContext;
import org.eclipse.birt.core.framework.PlatformConfig;

public class OSGILauncher {
    private static Logger logger = Logger.getLogger(OSGILauncher.class.getName());
    private static final String ECLIPSE_STARTER = "org.eclipse.core.runtime.adaptor.EclipseStarter";
    private File platformDirectory;
    private ClassLoader frameworkClassLoader;
    private ClassLoader frameworkContextClassLoader;
    private Object bundleContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startup(PlatformConfig config) throws BirtException {
        IPlatformContext context = config.getPlatformContext();
        if (context == null) {
            throw new BirtException("PlatformContext is not setted - {0}", new Object[]{"PlatformConfig"});
        }
        String root = context.getPlatform();
        this.platformDirectory = new File(root);
        if (!this.platformDirectory.exists() || !this.platformDirectory.isDirectory()) {
            throw new BirtException("Could not start the Framework - {0}" + root, root);
        }
        if (this.frameworkClassLoader != null) {
            logger.log(Level.WARNING, "Framework is already started");
            return;
        }
        System.setProperty("osgi.parentClassloader", "fwk");
        System.setProperty("osgi.install.area", this.platformDirectory.getAbsolutePath());
        File configurationDirectory = new File(this.platformDirectory, "configuration");
        if (!configurationDirectory.exists()) {
            configurationDirectory.mkdirs();
        }
        System.setProperty("osgi.configuration.area", configurationDirectory.getAbsolutePath());
        File workspaceDirectory = new File(this.platformDirectory, "workspace");
        if (!workspaceDirectory.exists()) {
            workspaceDirectory.mkdirs();
        }
        System.setProperty("osgi.instance.area", workspaceDirectory.getAbsolutePath());
        System.setProperty("eclipse.ignoreApp", "true");
        System.setProperty("osgi.noShutdown", "true");
        String path = new File(this.platformDirectory, "plugins").toString();
        path = this.searchFor("org.eclipse.osgi", path);
        if (path == null) {
            throw new BirtException("Could not find the Framework - {0}", new Object[]{"org.eclipse.osgi"});
        }
        String framework = new File(path).getAbsolutePath();
        String[] args = config.getOSGiArguments();
        if (args == null) {
            args = new String[]{"-clean"};
        }
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            URL frameworkUrl = new File(framework).toURL();
            System.setProperty("osgi.framework", frameworkUrl.toExternalForm());
            ClassLoader loader = this.getClass().getClassLoader();
            this.frameworkClassLoader = new URLClassLoader(new URL[]{frameworkUrl}, loader);
            try {
                loader.loadClass("org.mozilla.javascript.Context");
            }
            catch (Exception ex) {
                // empty catch block
            }
            Class<?> clazz = this.frameworkClassLoader.loadClass(ECLIPSE_STARTER);
            System.setProperty("osgi.framework.useSystemProperties", "true");
            Method runMethod = clazz.getMethod("startup", String;.class, Runnable.class);
            this.bundleContext = runMethod.invoke(null, new Object[]{args, null});
            this.frameworkContextClassLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public ClassLoader getFrameworkContextClassLoader() {
        return this.frameworkContextClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.platformDirectory == null) {
            logger.log(Level.WARNING, "Shutdown unnecessary. (not deployed)");
            return;
        }
        if (this.frameworkClassLoader == null) {
            logger.log(Level.WARNING, "Framework is already shutdown");
            return;
        }
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Class<?> clazz = this.frameworkClassLoader.loadClass(ECLIPSE_STARTER);
                Method method = clazz.getDeclaredMethod("shutdown", null);
                Thread.currentThread().setContextClassLoader(this.frameworkContextClassLoader);
                method.invoke(clazz, (Object[])null);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Error while stopping Framework", e);
                Object var5_6 = null;
                this.frameworkClassLoader = null;
                this.frameworkContextClassLoader = null;
                Thread.currentThread().setContextClassLoader(original);
                return;
            }
            Object var5_5 = null;
            this.frameworkClassLoader = null;
            this.frameworkContextClassLoader = null;
            Thread.currentThread().setContextClassLoader(original);
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.frameworkClassLoader = null;
            this.frameworkContextClassLoader = null;
            Thread.currentThread().setContextClassLoader(original);
            throw throwable;
        }
    }

    protected String searchFor(final String target, String start) {
        FileFilter filter = new FileFilter(){

            public boolean accept(File candidate) {
                return candidate.getName().equals(target) || candidate.getName().startsWith(target + "_");
            }
        };
        File[] candidates = new File(start).listFiles(filter);
        if (candidates == null) {
            return null;
        }
        String[] arrays = new String[candidates.length];
        for (int i = 0; i < arrays.length; ++i) {
            arrays[i] = candidates[i].getName();
        }
        int result = this.findMax(arrays);
        if (result == -1) {
            return null;
        }
        return candidates[result].getAbsolutePath().replace(File.separatorChar, '/') + (candidates[result].isDirectory() ? "/" : "");
    }

    protected int findMax(String[] candidates) {
        int result = -1;
        Object[] maxVersion = null;
        for (int i = 0; i < candidates.length; ++i) {
            String name = candidates[i];
            String version = "";
            int index = name.indexOf(95);
            if (index != -1) {
                version = name.substring(index + 1);
            }
            Object[] currentVersion = this.getVersionElements(version);
            if (maxVersion == null) {
                result = i;
                maxVersion = currentVersion;
                continue;
            }
            if (this.compareVersion(maxVersion, currentVersion) >= 0) continue;
            result = i;
            maxVersion = currentVersion;
        }
        return result;
    }

    private int compareVersion(Object[] left, Object[] right) {
        int result = ((Integer)left[0]).compareTo((Integer)right[0]);
        if (result != 0) {
            return result;
        }
        result = ((Integer)left[1]).compareTo((Integer)right[1]);
        if (result != 0) {
            return result;
        }
        result = ((Integer)left[2]).compareTo((Integer)right[2]);
        if (result != 0) {
            return result;
        }
        return ((String)left[3]).compareTo((String)right[3]);
    }

    private Object[] getVersionElements(String version) {
        if (version.endsWith(".jar")) {
            version = version.substring(0, version.length() - 4);
        }
        Object[] result = new Object[]{new Integer(0), new Integer(0), new Integer(0), ""};
        StringTokenizer t = new StringTokenizer(version, ".");
        int i = 0;
        while (t.hasMoreTokens() && i < 4) {
            String token = t.nextToken();
            if (i < 3) {
                try {
                    result[i++] = new Integer(token);
                    continue;
                }
                catch (Exception e) {
                    break;
                }
            }
            result[i++] = token;
        }
        return result;
    }

    Object getBundle(String symbolicName) {
        if (this.bundleContext == null) {
            return null;
        }
        try {
            Method methodLoadBundle = this.bundleContext.getClass().getMethod("getBundles", new Class[0]);
            Object objects = methodLoadBundle.invoke(this.bundleContext, new Object[0]);
            if (objects instanceof Object[]) {
                Object[] bundles = (Object[])objects;
                for (int i = 0; i < bundles.length; ++i) {
                    Object bundle = bundles[i];
                    Method methodGetSymbolicName = bundle.getClass().getMethod("getSymbolicName", new Class[0]);
                    Object name = methodGetSymbolicName.invoke(bundle, new Object[0]);
                    if (!symbolicName.equals(name)) continue;
                    return bundle;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }
}

