/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script.bre;

public class BirtMath {
    private static final long serialVersionUID = 1L;

    private BirtMath() {
    }

    public static double add(double value1, double value2) {
        return value1 + value2;
    }

    public static double round(double value) {
        return BirtMath.round(value, 0);
    }

    public static double round(double value, int dec) {
        double multiple = BirtMath.getMultiple(dec);
        return (double)Math.round(value * multiple) / multiple;
    }

    public static double roundUp(double value) {
        return BirtMath.roundUp(value, 0);
    }

    public static double roundUp(double value, int dec) {
        double multiple = BirtMath.getMultiple(dec);
        return (double)Math.round(Math.ceil(value * multiple)) / multiple;
    }

    private static double getMultiple(int dec) {
        double multiple = 1.0;
        if (dec >= 0) {
            for (int i = 0; i < dec; ++i) {
                multiple *= 10.0;
            }
        } else {
            double adjustment = 1.0;
            for (int i = dec; i < 0; ++i) {
                multiple *= 0.1;
                adjustment *= 10.0;
            }
            multiple = (double)Math.round(multiple * adjustment) / adjustment;
        }
        return multiple;
    }

    public static double roundDown(double value, int dec) {
        double multiple = BirtMath.getMultiple(dec);
        return (double)Math.round(Math.floor(value * multiple)) / multiple;
    }

    public static double roundDown(double value) {
        return BirtMath.roundDown(value, 0);
    }

    public static double ceiling(double n, double significance) {
        if (significance == 0.0 || n == 0.0) {
            return 0.0;
        }
        if (n * significance < 0.0) {
            throw new IllegalArgumentException("The given significance cannot be applied to the number");
        }
        if (Math.abs(n) < Math.abs(significance)) {
            return significance;
        }
        double multiple = Math.ceil(n / significance);
        return multiple * significance;
    }

    public static double mod(double n, double div) {
        if (div == 0.0) {
            throw new IllegalArgumentException("The divisor cannot be 0");
        }
        return n - div * Math.floor(n / div);
    }
}

