/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.adapter.oda.DataSetParameterAdapter;
import org.eclipse.birt.report.model.adapter.oda.DesignerStateAdapter;
import org.eclipse.birt.report.model.adapter.oda.ResultSetsAdapter;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedPropertyHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.OdaDesignerStateHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.ExtendedProperty;
import org.eclipse.birt.report.model.api.elements.structures.PropertyBinding;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.PropertyValueValidationUtil;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.DesignerState;
import org.eclipse.datatools.connectivity.oda.design.InputElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.Properties;
import org.eclipse.datatools.connectivity.oda.design.Property;
import org.eclipse.datatools.connectivity.oda.design.PropertyAttributes;
import org.eclipse.datatools.connectivity.oda.design.ResultSetDefinition;
import org.eclipse.datatools.connectivity.oda.design.ResultSets;
import org.eclipse.datatools.connectivity.oda.design.util.DesignUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class ModelOdaAdapter {
    static final /* synthetic */ boolean $assertionsDisabled;

    public DataSourceDesign createDataSourceDesign(OdaDataSourceHandle sourceHandle) {
        if (sourceHandle == null) {
            return null;
        }
        DataSourceDesign sourceDesign = DesignFactory.eINSTANCE.createDataSourceDesign();
        this.updateDataSourceDesign(sourceHandle, sourceDesign);
        return sourceDesign;
    }

    public DataSetDesign createDataSetDesign(OdaDataSetHandle setHandle) {
        if (setHandle == null) {
            return null;
        }
        DataSetDesign setDesign = DesignFactory.eINSTANCE.createDataSetDesign();
        this.updateDataSetDesign(setHandle, setDesign);
        return setDesign;
    }

    public OdaDataSetHandle createDataSetHandle(DataSetDesign setDesign, ModuleHandle module) throws SemanticException, IllegalStateException {
        if (setDesign == null) {
            return null;
        }
        DesignUtil.validateObject((EObject)setDesign);
        OdaDataSetHandle setHandle = module.getElementFactory().newOdaDataSet(setDesign.getName(), setDesign.getOdaExtensionDataSetId());
        if (setHandle == null) {
            return null;
        }
        this.adaptDataSetDesign(setDesign, setHandle);
        return setHandle;
    }

    private void adaptDataSetDesign(DataSetDesign setDesign, OdaDataSetHandle setHandle) throws SemanticException {
        ResultSets sets;
        Object value = null;
        value = setDesign.getName();
        PropertyValueValidationUtil.validateProperty((DesignElementHandle)setHandle, (String)"name", (Object)value);
        setHandle.getElement().setName(setDesign.getName());
        value = setDesign.getDisplayName();
        PropertyValueValidationUtil.validateProperty((DesignElementHandle)setHandle, (String)"displayName", (Object)value);
        setHandle.getElement().setProperty("displayName", (Object)setDesign.getDisplayName());
        value = this.newROMPrivateProperties(setDesign.getPrivateProperties());
        PropertyValueValidationUtil.validateProperty((DesignElementHandle)setHandle, (String)"privateDriverProperties", (Object)value);
        setHandle.getElement().setProperty("privateDriverProperties", value);
        this.updateROMPublicProperties(setDesign.getPublicProperties(), (ReportElementHandle)setHandle);
        DataSourceDesign sourceDesign = setDesign.getDataSourceDesign();
        String dataSourceName = sourceDesign.getName();
        if (sourceDesign != null) {
            setHandle.getElement().setProperty("dataSource", PropertyValueValidationUtil.validateProperty((DesignElementHandle)setHandle, (String)"dataSource", (Object)dataSourceName));
        } else {
            setHandle.getElement().clearProperty("dataSource");
        }
        setHandle.getElement().clearProperty("parameters");
        List dataSetParams = new DataSetParameterAdapter().newROMSetParams(setDesign.getParameters(), setDesign.getOdaExtensionDataSourceId(), setDesign.getOdaExtensionDataSetId());
        PropertyValueValidationUtil.validateProperty((DesignElementHandle)setHandle, (String)"parameters", (Object)dataSetParams);
        setHandle.getElement().setProperty("parameters", (Object)dataSetParams);
        List resultRetColumns = ResultSetsAdapter.newROMResultSets(setDesign.getPrimaryResultSet(), setDesign.getOdaExtensionDataSourceId(), setDesign.getOdaExtensionDataSetId());
        if (resultRetColumns == null && (sets = setDesign.getResultSets()) != null && !sets.getResultSetDefinitions().isEmpty()) {
            resultRetColumns = ResultSetsAdapter.newROMResultSets((ResultSetDefinition)sets.getResultSetDefinitions().get(0), setDesign.getOdaExtensionDataSourceId(), setDesign.getOdaExtensionDataSetId());
        }
        PropertyValueValidationUtil.validateProperty((DesignElementHandle)setHandle, (String)"resultSet", (Object)resultRetColumns);
        setHandle.getElement().setProperty("resultSet", (Object)resultRetColumns);
        String queryText = setDesign.getQueryText();
        PropertyValueValidationUtil.validateProperty((DesignElementHandle)setHandle, (String)"queryText", (Object)queryText);
        setHandle.getElement().setProperty("queryText", (Object)queryText);
        String resultSetName = setDesign.getPrimaryResultSetName();
        PropertyValueValidationUtil.validateProperty((DesignElementHandle)setHandle, (String)"resultSetName", (Object)queryText);
        setHandle.getElement().setProperty("resultSetName", (Object)resultSetName);
    }

    public void updateDataSetDesign(OdaDataSetHandle setHandle, DataSetDesign setDesign) {
        setDesign.setName(setHandle.getName());
        setDesign.setDisplayName(setHandle.getDisplayName());
        setDesign.setOdaExtensionDataSetId(setHandle.getExtensionID());
        setDesign.setPublicProperties(this.newOdaPublicProperties(setHandle.getExtensionPropertyDefinitionList(), (ReportElementHandle)setHandle));
        setDesign.setPrivateProperties(this.newOdaPrivateProperties(setHandle.privateDriverPropertiesIterator()));
        setDesign.setPrimaryResultSetName(setHandle.getResultSetName());
        setDesign.setQueryText(setHandle.getQueryText());
        OdaDataSourceHandle sourceHandle = (OdaDataSourceHandle)setHandle.getDataSource();
        if (sourceHandle != null) {
            setDesign.setDataSourceDesign(this.createDataSourceDesign(sourceHandle));
        }
        setDesign.setParameters(new DataSetParameterAdapter().newOdaDataSetParams(setHandle.parametersIterator()));
        setDesign.setPrimaryResultSet(ResultSetsAdapter.newOdaResultSetDefinition(setHandle));
    }

    public void updateDataSetDesign(OdaDataSetHandle setHandle, DataSetDesign setDesign, String propertyName) {
        if (setHandle == null || setDesign == null || propertyName == null) {
            return;
        }
        if ("name".equalsIgnoreCase(propertyName)) {
            setDesign.setName(setHandle.getName());
        } else if ("displayName".equalsIgnoreCase(propertyName)) {
            setDesign.setDisplayName(setHandle.getDisplayName());
        } else if ("extensionID".equalsIgnoreCase(propertyName)) {
            setDesign.setOdaExtensionDataSetId(setHandle.getExtensionID());
        } else if ("privateDriverProperties".equalsIgnoreCase(propertyName)) {
            setDesign.setPrivateProperties(this.newOdaPrivateProperties(setHandle.privateDriverPropertiesIterator()));
        } else if ("resultSetName".equalsIgnoreCase(propertyName)) {
            setDesign.setPrimaryResultSetName(setHandle.getResultSetName());
        } else if ("queryText".equalsIgnoreCase(propertyName)) {
            setDesign.setQueryText(setHandle.getQueryText());
        } else if ("dataSource".equalsIgnoreCase(propertyName)) {
            OdaDataSourceHandle sourceHandle = (OdaDataSourceHandle)setHandle.getDataSource();
            if (sourceHandle != null) {
                setDesign.setDataSourceDesign(this.createDataSourceDesign(sourceHandle));
            }
        } else if ("parameters".equalsIgnoreCase(propertyName)) {
            setDesign.setParameters(new DataSetParameterAdapter().newOdaDataSetParams(setHandle.parametersIterator()));
        } else if ("resultSet".equalsIgnoreCase(propertyName)) {
            setDesign.setPrimaryResultSet(ResultSetsAdapter.newOdaResultSetDefinition(setHandle));
        }
    }

    public void updateDataSourceDesign(OdaDataSourceHandle sourceHandle, DataSourceDesign sourceDesign) {
        sourceDesign.setName(sourceHandle.getName());
        sourceDesign.setDisplayName(sourceHandle.getDisplayName());
        sourceDesign.setOdaExtensionId(sourceHandle.getExtensionID());
        sourceDesign.setPrivateProperties(this.newOdaPrivateProperties(sourceHandle.privateDriverPropertiesIterator()));
        sourceDesign.setPublicProperties(this.newOdaPublicProperties(sourceHandle.getExtensionPropertyDefinitionList(), (ReportElementHandle)sourceHandle));
    }

    private Properties newOdaPublicProperties(List propDefns, ReportElementHandle element) {
        if (propDefns == null) {
            return null;
        }
        Properties retProps = null;
        for (int i = 0; i < propDefns.size(); ++i) {
            if (retProps == null) {
                retProps = DesignFactory.eINSTANCE.createProperties();
            }
            IPropertyDefn propDefn = (IPropertyDefn)propDefns.get(i);
            String propName = propDefn.getName();
            String propValue = element.getStringProperty(propName);
            retProps.setProperty(propName, propValue);
        }
        return retProps;
    }

    private Properties newOdaPrivateProperties(Iterator props) {
        if (props == null || !props.hasNext()) {
            return null;
        }
        Properties retProps = DesignFactory.eINSTANCE.createProperties();
        while (props.hasNext()) {
            ExtendedPropertyHandle propHandle = (ExtendedPropertyHandle)props.next();
            retProps.setProperty(propHandle.getName(), propHandle.getValue());
        }
        return retProps;
    }

    public OdaDataSourceHandle createDataSourceHandle(DataSourceDesign sourceDesign, ModuleHandle module) throws SemanticException, IllegalStateException {
        if (sourceDesign == null) {
            return null;
        }
        DesignUtil.validateObject((EObject)sourceDesign);
        OdaDataSourceHandle sourceHandle = module.getElementFactory().newOdaDataSource(sourceDesign.getName(), sourceDesign.getOdaExtensionId());
        if (sourceHandle == null) {
            return null;
        }
        this.adaptDataSourceDesign(sourceDesign, sourceHandle);
        return sourceHandle;
    }

    public void updateDataSourceHandle(DataSourceDesign sourceDesign, OdaDataSourceHandle sourceHandle) throws SemanticException {
        if (sourceDesign == null || sourceHandle == null) {
            return;
        }
        DesignUtil.validateObject((EObject)sourceDesign);
        CommandStack stack = sourceHandle.getModuleHandle().getCommandStack();
        stack.startTrans(null);
        try {
            Property prop;
            int i;
            EList propList;
            sourceHandle.getElement().setProperty("extensionID", (Object)sourceDesign.getOdaExtensionId());
            sourceHandle.setName(sourceDesign.getName());
            sourceHandle.setDisplayName(sourceDesign.getDisplayName());
            Properties props = sourceDesign.getPublicProperties();
            if (props != null) {
                propList = props.getProperties();
                for (i = 0; i < propList.size(); ++i) {
                    prop = (Property)propList.get(i);
                    sourceHandle.setProperty(prop.getName(), (Object)prop.getValue());
                }
            }
            if ((props = sourceDesign.getPrivateProperties()) != null) {
                propList = props.getProperties();
                for (i = 0; i < propList.size(); ++i) {
                    prop = (Property)propList.get(i);
                    sourceHandle.setPrivateDriverProperty(prop.getName(), prop.getValue());
                }
            }
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    private void adaptDataSourceDesign(DataSourceDesign sourceDesign, OdaDataSourceHandle sourceHandle) throws SemanticException {
        Object value = null;
        value = sourceDesign.getName();
        PropertyValueValidationUtil.validateProperty((DesignElementHandle)sourceHandle, (String)"name", (Object)value);
        sourceHandle.getElement().setName(sourceDesign.getName());
        value = sourceDesign.getDisplayName();
        PropertyValueValidationUtil.validateProperty((DesignElementHandle)sourceHandle, (String)"displayName", (Object)value);
        sourceHandle.getElement().setProperty("displayName", (Object)sourceDesign.getDisplayName());
        value = this.newROMPrivateProperties(sourceDesign.getPrivateProperties());
        PropertyValueValidationUtil.validateProperty((DesignElementHandle)sourceHandle, (String)"privateDriverProperties", (Object)value);
        sourceHandle.getElement().setProperty("privateDriverProperties", value);
        this.updateROMPublicProperties(sourceDesign.getPublicProperties(), (ReportElementHandle)sourceHandle);
    }

    private void updateROMPublicProperties(Properties designProps, ReportElementHandle sourceHandle) throws SemanticException {
        if (designProps == null) {
            return;
        }
        EList publicProps = designProps.getProperties();
        for (int i = 0; i < publicProps.size(); ++i) {
            Property prop = (Property)publicProps.get(i);
            String propName = prop.getName();
            String propValue = prop.getValue();
            PropertyValueValidationUtil.validateProperty((DesignElementHandle)sourceHandle, (String)propName, (Object)propValue);
            sourceHandle.getElement().setProperty(propName, (Object)propValue);
        }
    }

    private List newROMPrivateProperties(Properties props) {
        if (props == null) {
            return null;
        }
        ArrayList<ExtendedProperty> list = new ArrayList<ExtendedProperty>();
        EList designProps = props.getProperties();
        for (int i = 0; i < designProps.size(); ++i) {
            Property prop = (Property)designProps.get(i);
            ExtendedProperty extendedProperty = StructureFactory.createExtendedProperty();
            extendedProperty.setName(prop.getName());
            extendedProperty.setValue(prop.getValue());
            list.add(extendedProperty);
        }
        return list;
    }

    protected void updateOdaPublicProperties(Properties props, OdaDataSourceHandle sourceHandle) {
        List propDefns = sourceHandle.getExtensionPropertyDefinitionList();
        List propBindings = this.getPropertyBindings(sourceHandle.getID(), sourceHandle.getModuleHandle());
        for (int i = 0; i < propDefns.size(); ++i) {
            IPropertyDefn propDefn = (IPropertyDefn)propDefns.get(i);
            String propName = propDefn.getName();
            Property property = props.findProperty(propName);
            PropertyBinding propBinding = this.findPropertyBinding(propName, propBindings);
            if (propBinding != null) continue;
        }
    }

    private PropertyBinding findPropertyBinding(String propName, List propBindings) {
        if (propBindings == null || propBindings.isEmpty()) {
            return null;
        }
        for (int i = 0; i < propBindings.size(); ++i) {
            PropertyBinding propBinding = (PropertyBinding)propBindings.get(i);
            String tmpPropName = propBinding.getName();
            if (tmpPropName == null || !tmpPropName.equals(propName)) continue;
            return propBinding;
        }
        return null;
    }

    private List getPropertyBindings(long id, ModuleHandle module) {
        List bindingList = module.getListProperty("propertyBindings");
        if (bindingList == null || bindingList.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<PropertyBinding> retList = new ArrayList<PropertyBinding>();
        for (int i = 0; i < bindingList.size(); ++i) {
            PropertyBinding propBinding = (PropertyBinding)bindingList.get(i);
            long elementId = propBinding.getID().longValue();
            if (id != elementId) continue;
            retList.add(propBinding);
        }
        return bindingList;
    }

    protected void updateROMPropertyBindings(Properties props, ReportElementHandle sourceHandle) throws SemanticException {
        this.clearPropertyBindings(sourceHandle);
        EList propList = props.getProperties();
        for (int i = 0; i < propList.size(); ++i) {
            Property prop = (Property)propList.get(i);
            this.updateROMODAProperty(prop, sourceHandle);
        }
    }

    private void clearPropertyBindings(ReportElementHandle sourceHandle) throws PropertyValueException {
        List bindings = this.getPropertyBindings(sourceHandle.getID(), sourceHandle.getModuleHandle());
        PropertyHandle propHandle = sourceHandle.getModuleHandle().getPropertyHandle("propertyBindings");
        propHandle.removeItems(bindings);
    }

    private void updateROMODAProperty(Property prop, ReportElementHandle sourceHandle) throws SemanticException {
        String name = prop.getName();
        PropertyAttributes propAttrs = prop.getDesignAttributes();
        if (propAttrs == null) {
            return;
        }
        InputElementAttributes inputAttrs = propAttrs.getElementAttributes();
        List propBindings = this.getPropertyBindings(sourceHandle.getID(), sourceHandle.getModuleHandle());
        PropertyBinding propBinding = this.findPropertyBinding(name, propBindings);
        String paramName = propBinding.getValue();
        if (paramName == null) {
            return;
        }
        ScalarParameterHandle param = (ScalarParameterHandle)sourceHandle.getModuleHandle().findParameter(paramName);
    }

    public void updateDataSetHandle(DataSetDesign setDesign, OdaDataSetHandle setHandle, boolean isSourceChanged) throws SemanticException {
        if (setDesign == null || setHandle == null) {
            return;
        }
        DesignUtil.validateObject((EObject)setDesign);
        CommandStack stack = setHandle.getModuleHandle().getCommandStack();
        stack.startTrans(null);
        try {
            ResultSets resultSets;
            Property prop;
            int i;
            EList propList;
            setHandle.getElement().setProperty("extensionID", (Object)setDesign.getOdaExtensionDataSetId());
            setHandle.setName(setDesign.getName());
            setHandle.setDisplayName(setDesign.getDisplayName());
            Properties props = setDesign.getPublicProperties();
            if (props != null) {
                propList = props.getProperties();
                for (i = 0; i < propList.size(); ++i) {
                    prop = (Property)propList.get(i);
                    setHandle.setProperty(prop.getName(), (Object)prop.getValue());
                }
            }
            if ((props = setDesign.getPrivateProperties()) != null) {
                propList = props.getProperties();
                for (i = 0; i < propList.size(); ++i) {
                    prop = (Property)propList.get(i);
                    setHandle.setPrivateDriverProperty(prop.getName(), prop.getValue());
                }
            }
            this.updateROMDataSetParamList(setHandle, new DataSetParameterAdapter().newROMSetParams(setDesign.getParameters(), setDesign.getOdaExtensionDataSourceId(), setDesign.getOdaExtensionDataSetId()));
            ResultSetDefinition resultDefn = setDesign.getPrimaryResultSet();
            if (resultDefn == null && (resultSets = setDesign.getResultSets()) != null && !resultSets.getResultSetDefinitions().isEmpty()) {
                resultDefn = (ResultSetDefinition)resultSets.getResultSetDefinitions().get(0);
            }
            this.updateROMStructureList(setHandle.getPropertyHandle("resultSet"), ResultSetsAdapter.newROMResultSets(resultDefn, setDesign.getOdaExtensionDataSourceId(), setDesign.getOdaExtensionDataSetId()));
            setHandle.setResultSetName(setDesign.getPrimaryResultSetName());
            setHandle.setQueryText(setDesign.getQueryText());
            DataSourceDesign sourceDesign = setDesign.getDataSourceDesign();
            if (sourceDesign != null) {
                OdaDataSourceHandle sourceHandle = (OdaDataSourceHandle)setHandle.getDataSource();
                if (isSourceChanged && sourceHandle != null && !sourceHandle.getModuleHandle().isReadOnly()) {
                    setHandle.setDataSource(sourceDesign.getName());
                    this.updateDataSourceHandle(sourceDesign, sourceHandle);
                }
                if (!isSourceChanged && sourceHandle != null && !sourceHandle.getModuleHandle().isReadOnly()) {
                    this.updateDataSourceHandle(sourceDesign, sourceHandle);
                }
            } else {
                setHandle.setDataSource(null);
            }
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    private void updateROMStructureList(PropertyHandle propHandle, List structList) throws SemanticException {
        if (!$assertionsDisabled && propHandle == null) {
            throw new AssertionError();
        }
        propHandle.setValue(null);
        if (structList == null || structList.isEmpty()) {
            return;
        }
        for (int i = 0; i < structList.size(); ++i) {
            propHandle.addItem(structList.get(i));
        }
    }

    private void updateROMDataSetParamList(OdaDataSetHandle setHandle, List structList) throws SemanticException {
        setHandle.setProperty("parameters", null);
        if (structList == null || structList.isEmpty()) {
            return;
        }
        PropertyHandle propHandle = setHandle.getPropertyHandle("parameters");
        for (int i = 0; i < structList.size(); ++i) {
            propHandle.addItem(structList.get(i));
        }
    }

    public DesignerState newOdaDesignerState(OdaDataSetHandle setHandle) {
        OdaDesignerStateHandle designerState = setHandle.getDesignerState();
        return DesignerStateAdapter.createOdaDesignState(designerState);
    }

    public void updateROMDesignerState(DesignerState designerState, OdaDataSetHandle setHandle) throws SemanticException {
        if (designerState == null || setHandle == null) {
            return;
        }
        DesignerStateAdapter.updateROMDesignerState(designerState, (ReportElementHandle)setHandle);
    }

    public DesignerState newOdaDesignerState(OdaDataSourceHandle sourceHandle) {
        OdaDesignerStateHandle designerState = sourceHandle.getDesignerState();
        return DesignerStateAdapter.createOdaDesignState(designerState);
    }

    public void updateROMDesignerState(DesignerState designerState, OdaDataSourceHandle sourceHandle) throws SemanticException {
        if (designerState == null || sourceHandle == null) {
            return;
        }
        DesignerStateAdapter.updateROMDesignerState(designerState, (ReportElementHandle)sourceHandle);
    }

    static {
        $assertionsDisabled = !ModelOdaAdapter.class.desiredAssertionStatus();
    }
}

