/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.drivers;

import com.ibm.icu.util.StringTokenizer;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.DriverMgmtMessages;
import org.eclipse.datatools.connectivity.drivers.DriverValidator;
import org.eclipse.datatools.connectivity.drivers.IPropertySet;
import org.eclipse.datatools.connectivity.drivers.PropertySetImpl;
import org.eclipse.datatools.connectivity.drivers.XMLFileManager;
import org.eclipse.datatools.connectivity.drivers.models.TemplateDescriptor;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;

public class DriverManager {
    private static DriverManager sInstance;

    public static synchronized DriverManager getInstance() {
        if (sInstance == null) {
            sInstance = new DriverManager();
        }
        return sInstance;
    }

    private DriverManager() {
        this.resetDefaultInstances();
    }

    public DriverInstance getDriverInstanceByID(String id) {
        XMLFileManager.setFileName("driverStorage.xml");
        try {
            IPropertySet[] psets = XMLFileManager.loadPropertySets();
            if (psets.length > 0) {
                for (int i = 0; i < psets.length; ++i) {
                    IPropertySet pset = psets[i];
                    if (!pset.getID().equals(id)) continue;
                    return new DriverInstance(pset);
                }
            }
        }
        catch (CoreException e) {
            ConnectivityPlugin.getDefault().log(e);
        }
        return null;
    }

    public DriverInstance getDriverInstanceByName(String name) {
        XMLFileManager.setFileName("driverStorage.xml");
        try {
            IPropertySet[] psets = XMLFileManager.loadPropertySets();
            if (psets.length > 0) {
                for (int i = 0; i < psets.length; ++i) {
                    IPropertySet pset = psets[i];
                    if (!pset.getName().equals(name)) continue;
                    return new DriverInstance(pset);
                }
            }
        }
        catch (CoreException e) {
            ConnectivityPlugin.getDefault().log(e);
        }
        return null;
    }

    public String getFullJarList() {
        XMLFileManager.setFileName("driverStorage.xml");
        try {
            IPropertySet[] psets = XMLFileManager.loadPropertySets();
            if (psets.length > 0) {
                String fullList = "";
                for (int i = 0; i < psets.length; ++i) {
                    IPropertySet pset = psets[i];
                    if (pset.getBaseProperties() == null || pset.getBaseProperties().getProperty("jarList") == null) continue;
                    String jarlist = pset.getBaseProperties().getProperty("jarList").trim();
                    fullList = fullList + jarlist + ",";
                }
                if (fullList.substring(fullList.length() - 1, fullList.length()).equals(",")) {
                    fullList = fullList.substring(0, fullList.length() - 1);
                }
                String[] paths = this.parseString(fullList, ",");
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i < paths.length; ++i) {
                    File testFile = new File(paths[i]);
                    if (!testFile.exists() || list.contains(paths[i])) continue;
                    list.add(paths[i]);
                }
                String newList = "";
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    newList = newList + iter.next() + ",";
                }
                if (newList.substring(newList.length() - 1, newList.length()).equals(",")) {
                    newList = newList.substring(0, newList.length() - 1);
                }
                return newList;
            }
        }
        catch (CoreException e) {
            ConnectivityPlugin.getDefault().log(e);
        }
        return null;
    }

    public String[] getFullJarListAsArray() {
        if (this.getFullJarList() != null) {
            if (this.getFullJarList().length() == 0) {
                return new String[0];
            }
            String[] paths = this.parseString(this.getFullJarList(), ",");
            return paths;
        }
        return null;
    }

    public DriverInstance[] getValidDriverInstances() {
        DriverInstance[] array = new DriverInstance[]{};
        XMLFileManager.setFileName("driverStorage.xml");
        try {
            IPropertySet[] psets = XMLFileManager.loadPropertySets();
            if (psets.length > 0) {
                int i;
                ArrayList<DriverInstance> list = new ArrayList<DriverInstance>();
                for (i = 0; i < psets.length; ++i) {
                    IPropertySet pset = psets[i];
                    DriverInstance ndi = new DriverInstance(pset);
                    DriverValidator validator = new DriverValidator(ndi);
                    if (!validator.isValid()) continue;
                    list.add(ndi);
                }
                array = new DriverInstance[list.size()];
                for (i = 0; i < list.size(); ++i) {
                    array[i] = (DriverInstance)list.get(i);
                }
                return array;
            }
        }
        catch (CoreException e) {
            ConnectivityPlugin.getDefault().log(e);
        }
        return array;
    }

    public DriverInstance createNewDriverInstance(String templateID, String name, String jarList) {
        if (templateID == null) {
            return null;
        }
        if (name == null) {
            return null;
        }
        if (jarList == null) {
            return null;
        }
        IPropertySet pset = this.createDefaultInstance(templateID);
        pset.setName(name);
        String prefix = DriverMgmtMessages.getString("NewDriverDialog.text.id_prefix");
        String id = prefix + name;
        pset.setID(id);
        Properties props = pset.getBaseProperties();
        props.setProperty("jarList", jarList);
        this.addDriverInstance(pset);
        return this.getDriverInstanceByID(pset.getID());
    }

    public boolean removeDriverInstance(String id) {
        boolean rtnFlag = false;
        if (this.getDriverInstanceByID(id) != null) {
            XMLFileManager.setFileName("driverStorage.xml");
            try {
                IPropertySet[] psets = XMLFileManager.loadPropertySets();
                if (psets.length > 0) {
                    IPropertySet[] newPsets = new IPropertySet[psets.length - 1];
                    int counter = 0;
                    for (int i = 0; i < psets.length; ++i) {
                        IPropertySet pset = psets[i];
                        if (pset.getID().equals(id)) {
                            rtnFlag = true;
                            continue;
                        }
                        newPsets[counter] = pset;
                        ++counter;
                    }
                    if (rtnFlag) {
                        XMLFileManager.saveNamedPropertySet(newPsets);
                    }
                }
            }
            catch (CoreException e) {
                ConnectivityPlugin.getDefault().log(e);
            }
        }
        return rtnFlag;
    }

    private void addDriverInstance(IPropertySet pset) {
        XMLFileManager.setFileName("driverStorage.xml");
        try {
            IPropertySet[] psets = XMLFileManager.loadPropertySets();
            IPropertySet[] newPsets = new IPropertySet[psets.length + 1];
            for (int i = 0; i < psets.length; ++i) {
                newPsets[i] = psets[i];
            }
            newPsets[psets.length] = pset;
            XMLFileManager.saveNamedPropertySet(newPsets);
        }
        catch (CoreException e) {
            ConnectivityPlugin.getDefault().log(e);
        }
    }

    private String[] parseString(String str_list, String token) {
        StringTokenizer tk = new StringTokenizer(str_list, token);
        String[] pieces = new String[tk.countTokens()];
        int index = 0;
        while (tk.hasMoreTokens()) {
            pieces[index++] = tk.nextToken();
        }
        return pieces;
    }

    public void resetDefaultInstances() {
        ArrayList<IPropertySet> psets_list = new ArrayList<IPropertySet>();
        TemplateDescriptor[] types = TemplateDescriptor.getDriverTemplateDescriptors();
        XMLFileManager.setFileName("driverStorage.xml");
        IPropertySet[] psets = new IPropertySet[]{};
        try {
            psets = XMLFileManager.loadPropertySets();
        }
        catch (CoreException e) {
            ConnectivityPlugin.getDefault().log(e);
        }
        for (int i = 0; i < types.length; ++i) {
            TemplateDescriptor type = types[i];
            boolean alreadyExists = false;
            if (psets.length > 0) {
                for (int j = 0; j < psets.length; ++j) {
                    String category;
                    IPropertySet pset = psets[j];
                    if (pset.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.drivers.defnType") == null || !(category = pset.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.drivers.defnType")).equalsIgnoreCase(type.getId())) continue;
                    alreadyExists = true;
                    psets_list.add(pset);
                }
            }
            if (!type.getCreateDefaultFlag() || alreadyExists) continue;
            IPropertySet newPset = this.createDefaultInstance(type);
            psets_list.add(newPset);
        }
        if (!psets_list.isEmpty()) {
            Object[] objs = psets_list.toArray();
            IPropertySet[] propsets = new IPropertySet[objs.length];
            for (int i = 0; i < objs.length; ++i) {
                propsets[i] = (IPropertySet)objs[i];
            }
            try {
                XMLFileManager.saveNamedPropertySet(propsets);
            }
            catch (CoreException e) {
                ConnectivityPlugin.getDefault().log(e);
            }
        }
    }

    public IPropertySet createDefaultInstance(String id) {
        TemplateDescriptor template = TemplateDescriptor.getDriverTemplateDescriptor(id);
        IPropertySet pset = this.createInstance(template);
        return pset;
    }

    private IPropertySet createInstance(TemplateDescriptor template) {
        return this.createDefaultInstance(template, true);
    }

    private IPropertySet createDefaultInstance(TemplateDescriptor template) {
        return this.createDefaultInstance(template, false);
    }

    private IPropertySet createDefaultInstance(TemplateDescriptor template, boolean override) {
        if (template != null && (template.getCreateDefaultFlag() || override)) {
            String prefix = DriverMgmtMessages.getString("NewDriverDialog.text.id_prefix");
            String suffix = DriverMgmtMessages.getString("DriverMgmtPlugin.default_instance_suffix");
            String id = prefix + template.getId();
            String name = template.getName() + " " + suffix;
            PropertySetImpl propset = new PropertySetImpl(id, template.getName());
            propset.setID(id);
            propset.setName(name);
            Properties props = new Properties();
            String jarList = this.updatePluginJarList(template);
            props.setProperty("jarList", jarList);
            props.setProperty("org.eclipse.datatools.connectivity.drivers.defnType", template.getId());
            IConfigurationElement[] templateprops = template.getProperties();
            if (props != null && templateprops.length > 0) {
                for (int i = 0; i < templateprops.length; ++i) {
                    IConfigurationElement prop = templateprops[i];
                    String propid = prop.getAttribute("id");
                    String propvalue = prop.getAttribute("value");
                    props.setProperty(propid, propvalue);
                }
            }
            propset.setBaseProperties(props);
            return propset;
        }
        return null;
    }

    private String updatePluginJarList(TemplateDescriptor template) {
        String jarList = template.getJarList();
        if (jarList.indexOf("[") > -1) {
            int index = jarList.indexOf("[");
            while (index > -1) {
                String toReplace = jarList.substring(index, jarList.indexOf("]", index) + 1);
                String pluginId = null;
                pluginId = toReplace.toUpperCase().equals("[PLUGIN]") ? template.getElement().getDeclaringExtension().getNamespaceIdentifier() : toReplace.substring(1, toReplace.length() - 1);
                String restOfPath = null;
                restOfPath = jarList.indexOf(",", index) > 0 ? jarList.substring(jarList.indexOf("]", index) + 1, jarList.indexOf(",", index)) : jarList.substring(jarList.indexOf("]", index) + 1, jarList.length());
                if (Platform.getBundle((String)pluginId) != null) {
                    String entry = File.separator + restOfPath + File.separator;
                    URL url = Platform.getBundle((String)pluginId).getEntry(entry);
                    if (url != null) {
                        try {
                            url = FileLocator.toFileURL((URL)url);
                            Path path = new Path(url.getFile());
                            int totalLength = toReplace.length() + restOfPath.length();
                            jarList = jarList.substring(0, index) + path.toOSString() + jarList.substring(index + totalLength, jarList.length());
                        }
                        catch (IOException e) {
                            Object[] strs = new String[]{pluginId + restOfPath};
                            System.err.println(DriverMgmtMessages.format("DriverMgmtPlugin.FileMissing", strs));
                            ConnectivityPlugin.getDefault().log(DriverMgmtMessages.format("DriverMgmtPlugin.FileMissing", strs));
                        }
                    } else {
                        Object[] strs = new String[]{pluginId + restOfPath};
                        String msg = DriverMgmtMessages.format("DriverMgmtPlugin.FileMissing", strs);
                        System.err.println(msg);
                        ConnectivityPlugin.getDefault().log(msg);
                    }
                } else {
                    Object[] strs = new String[]{pluginId};
                    System.err.println(DriverMgmtMessages.format("DriverMgmtPlugin.BundleMissing", strs));
                    ConnectivityPlugin.getDefault().log(DriverMgmtMessages.format("DriverMgmtPlugin.BundleMissing", strs));
                }
                if ((index = jarList.indexOf(",", index)) <= 0) continue;
                ++index;
            }
        }
        return jarList;
    }
}

