/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.datatools.connectivity.ConnectEvent;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.IManagedConnectionListener;
import org.eclipse.datatools.connectivity.IServerVersionProvider;
import org.eclipse.datatools.connectivity.Version;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;
import org.eclipse.datatools.connectivity.internal.CreateConnectionJob;

public class ManagedConnection
implements IManagedConnection {
    private IConnection mConnection;
    private String mFactoryID;
    private Set mListeners = new HashSet();

    public ManagedConnection(String factoryID) {
        this.mFactoryID = factoryID;
    }

    public void addConnectionListener(IManagedConnectionListener listener) {
        this.mListeners.add(listener);
    }

    public void removeConnectionListener(IManagedConnectionListener listener) {
        this.mListeners.remove(listener);
    }

    public void fireModifiedEvent(Object context) {
        if (!this.isConnected()) {
            return;
        }
        ConnectEvent event = new ConnectEvent(this.getConnectionProfile(), this, context);
        Iterator it = new ArrayList(this.mListeners).iterator();
        while (it.hasNext()) {
            try {
                ((IManagedConnectionListener)it.next()).modified(event);
            }
            catch (Exception e) {
                ConnectivityPlugin.getDefault().log(e);
            }
        }
    }

    public IConnection cloneConnection() {
        if (!this.isConnected()) {
            throw new IllegalStateException();
        }
        CreateConnectionJob connectJob = new CreateConnectionJob(this.getConnectionProfile().getProvider().getConnectionFactory(this.getFactoryID()), this.getConnectionProfile(), null);
        connectJob.schedule();
        try {
            connectJob.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return connectJob.getConnection();
    }

    public void cloneConnection(IJobChangeListener listener) {
        if (!this.isConnected()) {
            throw new IllegalStateException();
        }
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        CreateConnectionJob connectJob = new CreateConnectionJob(this.getConnectionProfile().getProvider().getConnectionFactory(this.getFactoryID()), this.getConnectionProfile(), null);
        connectJob.addJobChangeListener(listener);
        connectJob.schedule();
    }

    public String getFactoryID() {
        return this.mFactoryID;
    }

    public boolean isConnected() {
        return this.mConnection != null && this.mConnection.getConnectException() == null;
    }

    public IConnection getConnection() {
        if (this.mConnection == null) {
            return null;
        }
        if (this.mConnection instanceof IServerVersionProvider) {
            return new RestrictedVersionProviderConnection();
        }
        return new RestrictedConnection();
    }

    public IConnectionProfile getConnectionProfile() {
        return this.mConnection.getConnectionProfile();
    }

    void setConnection(IConnection connection) {
        this.mConnection = connection;
        if (this.isConnected()) {
            ConnectEvent event = new ConnectEvent(this.getConnectionProfile(), this);
            Iterator it = new ArrayList(this.mListeners).iterator();
            while (it.hasNext()) {
                try {
                    ((IManagedConnectionListener)it.next()).opened(event);
                }
                catch (Exception e) {
                    ConnectivityPlugin.getDefault().log(e);
                }
            }
        }
    }

    boolean okToClose() {
        boolean okToClose = true;
        if (this.mConnection == null || this.mConnection.getConnectException() != null) {
            return okToClose;
        }
        ConnectEvent event = new ConnectEvent(this.getConnectionProfile(), this);
        Iterator it = new ArrayList(this.mListeners).iterator();
        while (okToClose && it.hasNext()) {
            try {
                okToClose = ((IManagedConnectionListener)it.next()).okToClose(event);
            }
            catch (Exception e) {
                ConnectivityPlugin.getDefault().log(e);
            }
        }
        return okToClose;
    }

    void close() {
        if (this.mConnection == null) {
            return;
        }
        if (this.mConnection.getConnectException() != null) {
            this.mConnection.close();
            this.mConnection = null;
            return;
        }
        ConnectEvent event = new ConnectEvent(this.getConnectionProfile(), this);
        Iterator it = new ArrayList(this.mListeners).iterator();
        while (it.hasNext()) {
            try {
                ((IManagedConnectionListener)it.next()).aboutToClose(event);
            }
            catch (Exception e) {
                ConnectivityPlugin.getDefault().log(e);
            }
        }
        this.mConnection.close();
        this.mConnection = null;
        it = new ArrayList(this.mListeners).iterator();
        while (it.hasNext()) {
            try {
                ((IManagedConnectionListener)it.next()).closed(event);
            }
            catch (Exception e) {
                ConnectivityPlugin.getDefault().log(e);
            }
        }
    }

    void dispose() {
        if (this.isConnected()) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mListeners.clear();
    }

    private class RestrictedVersionProviderConnection
    extends RestrictedConnection
    implements IServerVersionProvider {
        private RestrictedVersionProviderConnection() {
        }

        public String getProviderName() {
            return ((IServerVersionProvider)((Object)ManagedConnection.this.mConnection)).getProviderName();
        }

        public Version getProviderVersion() {
            return ((IServerVersionProvider)((Object)ManagedConnection.this.mConnection)).getProviderVersion();
        }

        public String getTechnologyName() {
            return ((IServerVersionProvider)((Object)ManagedConnection.this.mConnection)).getTechnologyName();
        }

        public Version getTechnologyVersion() {
            return ((IServerVersionProvider)((Object)ManagedConnection.this.mConnection)).getTechnologyVersion();
        }
    }

    private class RestrictedConnection
    implements IConnection {
        private RestrictedConnection() {
        }

        public void close() {
            throw new UnsupportedOperationException();
        }

        public Throwable getConnectException() {
            return ManagedConnection.this.mConnection.getConnectException();
        }

        public IConnectionProfile getConnectionProfile() {
            return ManagedConnection.this.mConnection.getConnectionProfile();
        }

        public Object getRawConnection() {
            return ManagedConnection.this.mConnection.getRawConnection();
        }
    }
}

