/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui;

import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.reportitem.ChartReportItemImpl;
import org.eclipse.birt.chart.reportitem.ui.DesignerRepresentation;
import org.eclipse.birt.chart.reportitem.ui.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.ChartDlg;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.report.designer.ui.extensions.ReportItemFigureProvider;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.util.DimensionUtil;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;

public class ChartReportItemUIImpl
extends ReportItemFigureProvider {
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.reportitem/trace");

    public final IFigure createFigure(ExtendedItemHandle eih) {
        try {
            eih.loadExtendedElement();
        }
        catch (ExtendedElementException eeex) {
            logger.log((Exception)((Object)eeex));
        }
        try {
            IReportItem iri = eih.getReportItem();
            DesignerRepresentation dr = new DesignerRepresentation((ChartReportItemImpl)iri);
            ((ChartReportItemImpl)iri).setDesignerRepresentation((Object)dr);
            return dr;
        }
        catch (ExtendedElementException e) {
            return null;
        }
    }

    public final void updateFigure(ExtendedItemHandle eih, IFigure ifg) {
        try {
            ChartReportItemImpl crii;
            IFigure parentFigure;
            IFigure parentFigure2;
            DimensionHandle dhHeight = eih.getHeight();
            DimensionHandle dhWidth = eih.getWidth();
            double dOriginalHeight = dhHeight.getMeasure();
            String sHeightUnits = dhHeight.getUnits();
            double dOriginalWidth = dhWidth.getMeasure();
            String sWidthUnits = dhWidth.getUnits();
            if (sHeightUnits == null || sWidthUnits == null) {
                return;
            }
            IDisplayServer idsSWT = ChartDlg.getDisplayServer();
            if (sHeightUnits == "px") {
                dOriginalHeight = ChartUtil.convertPixelsToPoints((IDisplayServer)idsSWT, (double)dOriginalHeight);
                sHeightUnits = "pt";
            }
            if (sHeightUnits == "%" && (parentFigure2 = ifg.getParent()) != null) {
                int height = (int)((double)(parentFigure2.getSize().height - parentFigure2.getInsets().getHeight()) * dOriginalHeight / 100.0);
                dOriginalHeight = ChartUtil.convertPixelsToPoints((IDisplayServer)idsSWT, (double)height);
                sHeightUnits = "pt";
            }
            double dHeightInPoints = DimensionUtil.convertTo((double)dOriginalHeight, (String)sHeightUnits, (String)"pt").getMeasure();
            if (sWidthUnits == "px") {
                dOriginalWidth = dOriginalWidth * 72.0 / (double)idsSWT.getDpiResolution();
                sWidthUnits = "pt";
            }
            if (sWidthUnits == "%" && (parentFigure = ifg.getParent()) != null) {
                int width = (int)((double)(parentFigure.getSize().width - parentFigure.getInsets().getWidth()) * dOriginalWidth / 100.0);
                dOriginalWidth = ChartUtil.convertPixelsToPoints((IDisplayServer)idsSWT, (double)width);
                sWidthUnits = "pt";
            }
            double dWidthInPoints = DimensionUtil.convertTo((double)dOriginalWidth, (String)sWidthUnits, (String)"pt").getMeasure();
            double dHeightInPixels = (double)idsSWT.getDpiResolution() * dHeightInPoints / 72.0;
            double dWidthInPixels = (double)idsSWT.getDpiResolution() * dWidthInPoints / 72.0;
            try {
                eih.loadExtendedElement();
                crii = (ChartReportItemImpl)eih.getReportItem();
                crii.setHandle((DesignElementHandle)eih);
            }
            catch (ExtendedElementException eeex) {
                logger.log((Exception)((Object)eeex));
                return;
            }
            Chart cm = (Chart)crii.getProperty("chart.instance");
            if (dWidthInPoints > 0.0) {
                cm.getBlock().getBounds().setWidth(dWidthInPoints);
            }
            if (dHeightInPoints > 0.0) {
                cm.getBlock().getBounds().setHeight(dHeightInPoints);
            }
            if (crii.getDesignerRepresentation() != null) {
                ((DesignerRepresentation)((Object)crii.getDesignerRepresentation())).setDirty(true);
            }
            Dimension newSize = ifg.getBounds().getCopy().getSize();
            if (dWidthInPixels > 0.0) {
                newSize.width = (int)dWidthInPixels;
            }
            if (dHeightInPixels > 0.0) {
                newSize.height = (int)dHeightInPixels;
            }
            ifg.setSize(newSize);
        }
        catch (Exception ex) {
            logger.log(ex);
        }
    }

    public final void disposeFigure(ExtendedItemHandle eih, IFigure ifg) {
        logger.log(1, Messages.getString("ChartReportItemUIImpl.log.ReceivedNotification"));
        ((DesignerRepresentation)ifg).dispose();
    }
}

