/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui;

import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.factory.IMessageLookup;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.reportitem.ChartReportItemImpl;
import org.eclipse.birt.chart.reportitem.ChartReportStyleProcessor;
import org.eclipse.birt.chart.reportitem.ui.BIRTDesignerMessageLookup;
import org.eclipse.birt.chart.reportitem.ui.ReportItemUIUtil;
import org.eclipse.birt.chart.reportitem.ui.i18n.Messages;
import org.eclipse.birt.chart.style.IStyleProcessor;
import org.eclipse.birt.chart.ui.swt.ChartDlg;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Display;

public final class DesignerRepresentation
extends Figure {
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.reportitem/trace");
    private static final String ERROR_MSG = Messages.getString("DesignerRepresentation.error.Error");
    private IDeviceRenderer idr = null;
    private final ChartReportItemImpl crii;
    private Image imgChart = null;
    private GC gc = null;
    private transient boolean bRtL = ReportItemUIUtil.isRtl();
    private transient boolean bDirty = true;
    private static final PaletteData PALETTE_DATA = new PaletteData(0xFF0000, 65280, 255);
    private static final int TRANSPARENT_COLOR = 1193046;
    private boolean bPainting = false;

    DesignerRepresentation(ChartReportItemImpl crii) {
        this.crii = crii;
        if (crii != null) {
            Chart cm = (Chart)crii.getProperty("chart.instance");
            if (cm != null) {
                IDisplayServer idsSWT = ChartDlg.getDisplayServer();
                Bounds bo = cm.getBlock().getBounds().scaledInstance(72.0 / (double)idsSWT.getDpiResolution());
                this.setSize((int)bo.getWidth(), (int)bo.getHeight());
            } else {
                this.setSize(212, 130);
            }
        } else {
            this.setSize(212, 130);
        }
        try {
            this.idr = PluginSettings.instance().getDevice("dv.SWT");
        }
        catch (ChartException pex) {
            logger.log((Exception)((Object)pex));
        }
    }

    final void setDirty(boolean bDirty) {
        this.bDirty = bDirty;
    }

    public Dimension getMinimumSize(int wHint, int hHint) {
        if (this.minSize != null) {
            return this.minSize;
        }
        DimensionHandle dimWidth = ((ExtendedItemHandle)this.crii.getHandle()).getWidth();
        DimensionHandle dimHeight = ((ExtendedItemHandle)this.crii.getHandle()).getHeight();
        boolean isPerWidth = "%".equals(dimWidth.getUnits());
        boolean isPerHeight = "%".equals(dimHeight.getUnits());
        Dimension dim = new Dimension();
        Dimension size = this.getSize();
        if (!isPerWidth) {
            dim.width = Math.max(wHint, size.width);
        }
        if (!isPerHeight) {
            dim.height = Math.max(hHint, size.height);
        }
        return dim;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        if (this.prefSize != null) {
            return this.prefSize;
        }
        DimensionHandle dimWidth = ((ExtendedItemHandle)this.crii.getHandle()).getWidth();
        DimensionHandle dimHeight = ((ExtendedItemHandle)this.crii.getHandle()).getHeight();
        boolean isPerWidth = "%".equals(dimWidth.getUnits());
        boolean isPerHeight = "%".equals(dimHeight.getUnits());
        Dimension dim = this.getSize().getCopy();
        if (isPerWidth && wHint != -1) {
            dim.width = (int)((double)wHint * dimWidth.getMeasure() / 100.0);
        }
        if (isPerHeight && hHint != -1) {
            dim.height = (int)((double)hHint * dimHeight.getMeasure() / 100.0);
        }
        this.setSize(dim.width, dim.height);
        Chart cm = (Chart)this.crii.getProperty("chart.instance");
        if (cm != null) {
            IDisplayServer ids = ChartDlg.getDisplayServer();
            cm.getBlock().getBounds().setWidth(ChartUtil.convertPixelsToPoints((IDisplayServer)ids, (double)dim.width));
            cm.getBlock().getBounds().setHeight(ChartUtil.convertPixelsToPoints((IDisplayServer)ids, (double)dim.height));
        }
        return dim;
    }

    public final void paintClientArea(Graphics g) {
        if (this.bPainting) {
            return;
        }
        Rectangle r = this.getClientArea().getCopy();
        if (r.width <= 0 || r.height <= 0) {
            return;
        }
        this.bPainting = true;
        if (this.bDirty) {
            this.bDirty = false;
            Chart cm = (Chart)this.crii.getProperty("chart.instance");
            if (cm == null) {
                this.bPainting = false;
                logger.log(4, Messages.getString("DesignerRepresentation.log.UnableToFind"));
                return;
            }
            Display d = Display.getCurrent();
            Dimension dSize = r.getSize();
            if (this.imgChart == null || this.imgChart.getImageData().width != dSize.width || this.imgChart.getImageData().height != dSize.height) {
                if (this.gc != null) {
                    this.gc.dispose();
                }
                if (this.imgChart != null) {
                    this.imgChart.dispose();
                }
                this.bDirty = true;
                ImageData ida = new ImageData(dSize.width, dSize.height, 32, PALETTE_DATA);
                ida.transparentPixel = 1193046;
                this.imgChart = new Image((Device)d, ida);
                this.gc = new GC((Drawable)this.imgChart);
            }
            Color clrBG = new Color((Device)d, 18, 52, 86);
            Color clrPreviousBG = this.gc.getBackground();
            this.gc.setBackground(clrBG);
            this.gc.fillRectangle(0, 0, this.imgChart.getImageData().width, this.imgChart.getImageData().height);
            clrBG.dispose();
            this.gc.setBackground(clrPreviousBG);
            Bounds bo = BoundsImpl.create((double)0.0, (double)0.0, (double)dSize.width, (double)dSize.height);
            bo.scale(72.0 / (double)this.idr.getDisplayServer().getDpiResolution());
            this.idr.setProperty("device.output.context", (Object)this.gc);
            Generator gr = Generator.instance();
            cm.clearSections(3);
            cm.createSampleRuntimeSeries();
            try {
                RunTimeContext rtc = new RunTimeContext();
                rtc.setScriptingEnabled(false);
                rtc.setMessageLookup((IMessageLookup)new BIRTDesignerMessageLookup(this.crii.getHandle()));
                if (this.bRtL) {
                    rtc.setRightToLeft(this.bRtL);
                }
                gr.render(this.idr, gr.build(this.idr.getDisplayServer(), cm, bo, null, rtc, (IStyleProcessor)new ChartReportStyleProcessor(this.crii.getHandle(), true)));
            }
            catch (ChartException gex) {
                this.showException(this.gc, (Exception)((Object)gex));
            }
        }
        if (this.imgChart != null) {
            g.drawImage(this.imgChart, r.x, r.y);
        }
        this.bPainting = false;
    }

    private final void showException(GC g2d, Exception ex) {
        Point pTLC = new Point(0, 0);
        Exception th = ex;
        String sMessage = null;
        sMessage = th instanceof BirtException ? ((BirtException)th).getLocalizedMessage() : ex.getMessage();
        if (sMessage == null) {
            sMessage = "<null>";
        }
        Dimension d = this.getSize();
        Display dv = Display.getCurrent();
        Font fo = new Font((Device)dv, "Courier", 1, 12);
        g2d.setFont(fo);
        FontMetrics fm = g2d.getFontMetrics();
        g2d.setBackground(dv.getSystemColor(1));
        g2d.fillRectangle(pTLC.x + 20, pTLC.y + 20, d.width - 40, d.height - 40);
        g2d.setForeground(dv.getSystemColor(2));
        g2d.drawRectangle(pTLC.x + 20, pTLC.y + 20, d.width - 40, d.height - 40);
        Region rgPrev = new Region();
        g2d.getClipping(rgPrev);
        g2d.setClipping(pTLC.x + 20, pTLC.y + 20, d.width - 40, d.height - 40);
        int x = pTLC.x + 25;
        int y = pTLC.y + 20 + fm.getHeight();
        g2d.setForeground(dv.getSystemColor(2));
        g2d.drawString(ERROR_MSG, x, y);
        g2d.setForeground(dv.getSystemColor(3));
        g2d.drawText(sMessage, x, y += fm.getHeight());
        g2d.setClipping(rgPrev);
        rgPrev.dispose();
        fo.dispose();
    }

    public final void dispose() {
        if (this.imgChart != null) {
            this.gc.dispose();
            this.imgChart.dispose();
            this.idr.dispose();
            this.gc = null;
            this.imgChart = null;
            this.bDirty = true;
            this.idr = null;
        }
    }
}

