/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui;

import com.ibm.icu.text.Collator;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.reportitem.ui.ChartReportItemUIActivator;
import org.eclipse.birt.chart.reportitem.ui.dialogs.ExtendedItemFilterDialog;
import org.eclipse.birt.chart.reportitem.ui.dialogs.ReportItemParametersDialog;
import org.eclipse.birt.chart.ui.swt.interfaces.IDataServiceProvider;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizard;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.DataUtil;
import org.eclipse.birt.report.designer.ui.actions.NewDataSetAction;
import org.eclipse.birt.report.designer.ui.dialogs.ColumnBindingDialog;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ReportDataServiceProvider
implements IDataServiceProvider {
    private ExtendedItemHandle itemHandle;
    private boolean isErrorFound = false;

    public ReportDataServiceProvider(ExtendedItemHandle itemHandle) {
        this.itemHandle = itemHandle;
    }

    private ModuleHandle getReportDesignHandle() {
        return SessionHandleAdapter.getInstance().getReportDesignHandle();
    }

    public String[] getAllDataSets() {
        List list = this.getReportDesignHandle().getVisibleDataSets();
        String[] names = new String[list.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = ((DataSetHandle)list.get(i)).getQualifiedName();
        }
        return names;
    }

    public final String[] getPreviewHeader() throws ChartException {
        Iterator iterator = this.getColumnDataBindings();
        ArrayList<String> list = new ArrayList<String>();
        while (iterator.hasNext()) {
            list.add(((ComputedColumnHandle)iterator.next()).getName());
        }
        return list.toArray(new String[0]);
    }

    public final List getPreviewData() throws ChartException {
        return this.getPreviewRowData(this.getPreviewHeader(true), -1, true);
    }

    private String[] getPreviewHeader(boolean isExpression) throws ChartException {
        String[] exps = this.getPreviewHeader();
        if (isExpression) {
            for (int i = 0; i < exps.length; ++i) {
                exps[i] = ChartUIUtil.getExpressionString((String)exps[i]);
            }
        }
        return exps;
    }

    private Iterator getColumnDataBindings() {
        return this.itemHandle.columnBindingsIterator();
    }

    protected final List getPreviewRowData(String[] columnExpression, int rowCount, boolean isStringType) throws ChartException {
        ArrayList<Object[]> dataList = new ArrayList<Object[]>();
        ClassLoader oldContextLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader parentLoader = oldContextLoader;
        if (parentLoader == null) {
            parentLoader = this.getClass().getClassLoader();
        }
        ClassLoader newContextLoader = this.getCustomScriptClassLoader(parentLoader);
        Thread.currentThread().setContextClassLoader(newContextLoader);
        try {
            QueryDefinition queryDefn = new QueryDefinition();
            queryDefn.setMaxRows(this.getMaxRow());
            queryDefn.setDataSetName(this.getDataSetFromHandle().getQualifiedName());
            DataRequestSession session = DataRequestSession.newSession((DataSessionContext)new DataSessionContext(3, this.getReportDesignHandle()));
            for (int i = 0; i < columnExpression.length; ++i) {
                queryDefn.addResultSetExpression(columnExpression[i], (IBaseExpression)new ScriptExpression(columnExpression[i]));
            }
            IQueryResults actualResultSet = session.executeQuery(queryDefn, this.itemHandle.getPropertyHandle("paramBindings").iterator(), this.itemHandle.getPropertyHandle("filter").iterator(), this.getColumnDataBindings());
            if (actualResultSet != null) {
                String[] expressions = columnExpression;
                int columnCount = expressions.length;
                IResultIterator iter = actualResultSet.getResultIterator();
                while (iter.next()) {
                    int n;
                    Object[] record;
                    if (isStringType) {
                        record = new String[columnCount];
                        for (n = 0; n < columnCount; ++n) {
                            record[n] = iter.getString(expressions[n]);
                        }
                        dataList.add(record);
                        continue;
                    }
                    record = new Object[columnCount];
                    for (n = 0; n < columnCount; ++n) {
                        record[n] = iter.getValue(expressions[n]);
                    }
                    dataList.add(record);
                }
                actualResultSet.close();
            }
        }
        catch (BirtException e) {
            throw new ChartException("org.eclipse.birt.chart.reportitem.ui", 19, (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextLoader);
        }
        return dataList;
    }

    public String getBoundDataSet() {
        if (this.itemHandle.getDataSet() == null) {
            return null;
        }
        return this.itemHandle.getDataSet().getQualifiedName();
    }

    public String getReportDataSet() {
        List list = DEUtil.getDataSetList((DesignElementHandle)this.itemHandle.getContainer());
        if (list.size() > 0) {
            return ((DataSetHandle)list.get(0)).getQualifiedName();
        }
        return null;
    }

    public void setContext(Object context) {
        this.itemHandle = (ExtendedItemHandle)context;
    }

    public void setDataSet(String datasetName) {
        boolean needClean = true;
        try {
            if (datasetName == null) {
                if (this.getBoundDataSet() == null && (this.getReportDataSet() == null || this.itemHandle.columnBindingsIterator().hasNext())) {
                    needClean = false;
                } else {
                    this.itemHandle.setDataSet(null);
                }
            } else {
                DataSetHandle dataset = this.getReportDesignHandle().findDataSet(datasetName);
                if (this.itemHandle.getDataSet() == dataset) {
                    needClean = false;
                } else {
                    this.itemHandle.setDataSet(dataset);
                }
            }
            if (needClean) {
                this.itemHandle.getPropertyHandle("paramBindings").clearValue();
                this.itemHandle.getPropertyHandle("filter").clearValue();
                this.itemHandle.getColumnBindings().clearValue();
                List columnList = this.generateComputedColumns((ReportItemHandle)this.itemHandle);
                if (columnList.size() > 0) {
                    Iterator iter = columnList.iterator();
                    while (iter.hasNext()) {
                        DEUtil.addColumn((DesignElementHandle)this.itemHandle, (ComputedColumn)((ComputedColumn)iter.next()), (boolean)false);
                    }
                }
            }
        }
        catch (SemanticException e) {
            ChartWizard.displayException((Throwable)e);
        }
    }

    private List generateComputedColumns(ReportItemHandle handle) throws SemanticException {
        Assert.isNotNull((Object)handle);
        DataSetHandle dataSetHandle = handle.getDataSet();
        if (dataSetHandle == null) {
            dataSetHandle = DEUtil.getBindingHolder((DesignElementHandle)handle).getDataSet();
        }
        if (dataSetHandle != null) {
            List resultSetColumnList = DataUtil.getColumnList((DataSetHandle)dataSetHandle);
            ArrayList<ComputedColumn> columnList = new ArrayList<ComputedColumn>();
            Iterator iter = resultSetColumnList.iterator();
            while (iter.hasNext()) {
                ResultSetColumnHandle resultSetColumn = (ResultSetColumnHandle)iter.next();
                ComputedColumn column = StructureFactory.newComputedColumn((DesignElementHandle)handle, (String)resultSetColumn.getColumnName());
                column.setDataType(resultSetColumn.getDataType());
                column.setExpression(DEUtil.getExpression((Object)resultSetColumn));
                columnList.add(column);
            }
            return columnList;
        }
        return Collections.EMPTY_LIST;
    }

    protected DataSetHandle getDataSetFromHandle() {
        if (this.itemHandle.getDataSet() != null) {
            return this.itemHandle.getDataSet();
        }
        List datasetList = DEUtil.getDataSetList((DesignElementHandle)this.itemHandle.getContainer());
        if (datasetList.size() > 0) {
            return (DataSetHandle)datasetList.get(0);
        }
        return null;
    }

    public int invoke(int command) {
        if (command == 0) {
            return this.invokeNewDataSet();
        }
        if (command == 1) {
            return this.invokeEditFilter();
        }
        if (command == 2) {
            return this.invokeEditParameter();
        }
        if (command == 3) {
            return this.invokeDataBinding();
        }
        return 1;
    }

    protected int invokeNewDataSet() {
        NewDataSetAction action = new NewDataSetAction();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)action, "org.eclipse.birt.chart.cshelp.NewDataSet_ID");
        action.run();
        return 0;
    }

    protected int invokeEditFilter() {
        ExtendedItemFilterDialog page = new ExtendedItemFilterDialog(this.itemHandle, this);
        return page.open();
    }

    protected int invokeEditParameter() {
        ReportItemParametersDialog page = new ReportItemParametersDialog((ReportItemHandle)this.itemHandle);
        return page.open();
    }

    protected int invokeDataBinding() {
        Shell shell = new Shell(Display.getDefault(), 67696);
        ChartUIUtil.bindHelp((Control)shell, (String)"org.eclipse.birt.chart.cshelp.SelectDataBinding_ID");
        ColumnBindingDialog page = new ColumnBindingDialog(shell, false){

            protected void addBinding(ComputedColumn column) {
                try {
                    DEUtil.addColumn((DesignElementHandle)ReportDataServiceProvider.this.itemHandle, (ComputedColumn)column, (boolean)true);
                }
                catch (SemanticException semanticException) {
                    // empty catch block
                }
            }

            protected List getBindingList(DesignElementHandle inputElement) {
                Iterator iterator = ReportDataServiceProvider.this.getColumnDataBindings();
                ArrayList list = new ArrayList();
                while (iterator.hasNext()) {
                    list.add(iterator.next());
                }
                return list;
            }

            protected void setShellStyle(int newShellStyle) {
                super.setShellStyle(newShellStyle | 0x860 | 0x10 | 0x10000);
            }
        };
        page.setInput((ReportItemHandle)this.itemHandle);
        return page.open();
    }

    private StyleHandle[] getAllStyleHandles() {
        StyleHandle[] list = this.getReportDesignHandle().getAllStyles().toArray(new StyleHandle[0]);
        Arrays.sort(list, new Comparator(){
            Collator collator = Collator.getInstance((ULocale)ULocale.getDefault());

            public int compare(Object o1, Object o2) {
                StyleHandle s1 = (StyleHandle)o1;
                StyleHandle s2 = (StyleHandle)o2;
                return this.collator.compare(s1.getDisplayLabel(), s2.getDisplayLabel());
            }
        });
        return list;
    }

    public String[] getAllStyles() {
        StyleHandle[] handles = this.getAllStyleHandles();
        String[] names = new String[handles.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = handles[i].getName();
        }
        return names;
    }

    public String[] getAllStyleDisplayNames() {
        StyleHandle[] handles = this.getAllStyleHandles();
        String[] names = new String[handles.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = handles[i].getDisplayLabel();
        }
        return names;
    }

    public String getCurrentStyle() {
        if (this.itemHandle.getStyle() == null) {
            return null;
        }
        return this.itemHandle.getStyle().getName();
    }

    public void setStyle(String styleName) {
        try {
            if (styleName == null) {
                this.itemHandle.setStyle(null);
            } else {
                this.itemHandle.setStyle(this.getStyle(styleName));
            }
        }
        catch (SemanticException e) {
            ChartWizard.displayException((Throwable)e);
        }
    }

    private SharedStyleHandle getStyle(String styleName) {
        return this.getReportDesignHandle().findStyle(styleName);
    }

    public final Object[] getDataForColumns(String[] sExpressions, int iMaxRecords, boolean byRow) throws ChartException {
        List rowData = this.getPreviewRowData(sExpressions, iMaxRecords, false);
        if (byRow) {
            return rowData.toArray();
        }
        ArrayList<Object[]> columnData = new ArrayList<Object[]>();
        for (int i = 0; i < sExpressions.length; ++i) {
            Object[] columnArray = new Object[rowData.size()];
            for (int j = 0; j < rowData.size(); ++j) {
                columnArray[j] = ((Object[])rowData.get(j))[i];
            }
            columnData.add(columnArray);
        }
        return columnData.toArray();
    }

    public void dispose() {
    }

    private int getMaxRow() {
        return ChartReportItemUIActivator.getDefault().getPluginPreferences().getInt("max_row");
    }

    public boolean isLivePreviewEnabled() {
        return !this.isErrorFound && ChartReportItemUIActivator.getDefault().getPluginPreferences().getBoolean("enable_live");
    }

    public boolean isInvokingSupported() {
        return true;
    }

    private ClassLoader getCustomScriptClassLoader(ClassLoader parent) {
        String classPath = System.getProperty("workspace.projectclasspath");
        if (classPath == null || classPath.length() == 0) {
            return parent;
        }
        String[] classPathArray = classPath.split(";", -1);
        int count = classPathArray.length;
        URL[] urls = new URL[count];
        for (int i = 0; i < count; ++i) {
            File file = new File(classPathArray[i]);
            try {
                urls[i] = file.toURL();
                continue;
            }
            catch (MalformedURLException e) {
                urls[i] = null;
            }
        }
        return new URLClassLoader(urls, parent);
    }
}

