/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui.dialogs.widget;

import java.util.Arrays;
import org.eclipse.birt.chart.reportitem.ui.dialogs.widget.PropertyDescriptorAdapter;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.PropertyProcessor;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ChoicePropertyDescriptor
extends PropertyDescriptorAdapter {
    protected Combo combo;
    private String oldValue;
    private int style = 2048;

    public ChoicePropertyDescriptor(PropertyProcessor propertyProcessor) {
        super(propertyProcessor);
    }

    public Control getControl() {
        return this.combo;
    }

    public Control createControl(Composite parent) {
        this.combo = new Combo(parent, this.style | 8);
        this.combo.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                ChoicePropertyDescriptor.this.combo.clearSelection();
            }

            public void controlResized(ControlEvent e) {
                ChoicePropertyDescriptor.this.combo.clearSelection();
            }
        });
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ChoicePropertyDescriptor.this.processAction();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ChoicePropertyDescriptor.this.processAction();
            }
        });
        return this.combo;
    }

    private void processAction() {
        String newValue = this.combo.getText();
        if (ChoiceSetFactory.CHOICE_NONE.equals(newValue)) {
            newValue = null;
        }
        try {
            this.getPropertyProcessor().setStringValue(newValue, this.getModelList());
        }
        catch (SemanticException e) {
            this.handleError(e);
            this.combo.setText(this.oldValue);
            this.combo.setSelection(new Point(0, this.oldValue.length()));
        }
    }

    public void resetUIData() {
        int sindex;
        boolean stateFlag;
        String property = this.getPropertyProcessor().getProperty();
        String[] items = new String[]{};
        String[] values = null;
        if (this.label != null && this.label.getText().length() == 0) {
            this.label.setText(this.getPropertyProcessor().getDisplayName(this.getModelList()));
        }
        if ("dataSet".equals(property)) {
            items = ChoiceSetFactory.getDataSets();
        } else if ("masterPage".equals(property)) {
            items = ChoiceSetFactory.getMasterPages();
        } else if ("style".equals(property)) {
            items = ChoiceSetFactory.getStyles();
        } else if ("theme".equals(property)) {
            items = ChoiceSetFactory.getThemes();
        } else {
            IChoiceSet cset = this.getPropertyProcessor().getChoiceSet(this.getModelList());
            items = ChoiceSetFactory.getDisplayNamefromChoiceSet((IChoiceSet)cset);
            values = ChoiceSetFactory.getNamefromChoiceSet((IChoiceSet)cset);
        }
        this.combo.setItems(items);
        this.oldValue = this.getPropertyProcessor().getStringValue(this.getModelList());
        boolean bl = stateFlag = this.oldValue == null == this.combo.getEnabled();
        if (stateFlag) {
            this.combo.setEnabled(this.oldValue != null);
        }
        if (this.getPropertyProcessor().isReadOnly(this.getModelList())) {
            this.combo.setEnabled(false);
        }
        int n = sindex = values == null ? Arrays.asList(items).indexOf(this.oldValue) : Arrays.asList(values).indexOf(this.oldValue);
        if ("style".equals(property) || "theme".equals(property) && sindex < 0) {
            if (this.oldValue != null && this.oldValue.length() > 0) {
                this.combo.setText(this.oldValue);
                return;
            }
            if (this.combo.getItemCount() > 0) {
                this.combo.select(0);
                return;
            }
        }
        this.combo.select(sindex);
    }

    public int getStyle() {
        return this.style;
    }

    public void addStyle(int style) {
        this.style |= style;
    }
}

