/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.service;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.IPlatformContext;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.birt.core.framework.PlatformServletContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSourceDesign;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.data.adapter.api.IRequestInfo;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLActionHandler;
import org.eclipse.birt.report.engine.api.HTMLEmitterConfig;
import org.eclipse.birt.report.engine.api.HTMLRenderContext;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.HTMLServerImageHandler;
import org.eclipse.birt.report.engine.api.IDataExtractionTask;
import org.eclipse.birt.report.engine.api.IDataIterator;
import org.eclipse.birt.report.engine.api.IExtractionResults;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.IHTMLImageHandler;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportEngineFactory;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IResultMetaData;
import org.eclipse.birt.report.engine.api.IResultSetItem;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.engine.api.IScalarParameterDefn;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.api.PDFRenderContext;
import org.eclipse.birt.report.engine.api.ReportParameterConverter;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.service.ViewerHTMLActionHandler;
import org.eclipse.birt.report.soapengine.api.Column;
import org.eclipse.birt.report.soapengine.api.ResultSet;
import org.eclipse.birt.report.utility.ParameterAccessor;

public class ReportEngineService {
    private static ReportEngineService instance;
    private IReportEngine engine = null;
    private EngineConfig config = null;
    private String imageDirectory = null;
    private String imageBaseUrl = null;
    private HTMLServerImageHandler imageHandler = null;
    private String contextPath = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ReportEngineService(ServletConfig servletConfig) {
        Object object;
        Object object2;
        System.setProperty("RUN_UNDER_ECLIPSE", "false");
        if (servletConfig == null) {
            return;
        }
        this.config = new EngineConfig();
        HTMLEmitterConfig hTMLEmitterConfig = new HTMLEmitterConfig();
        hTMLEmitterConfig.setActionHandler((IHTMLActionHandler)new HTMLActionHandler());
        this.imageHandler = new HTMLServerImageHandler();
        hTMLEmitterConfig.setImageHandler((IHTMLImageHandler)this.imageHandler);
        this.config.getEmitterConfigs().put("html", hTMLEmitterConfig);
        String string = servletConfig.getServletContext().getInitParameter("BIRT_RESOURCE_PATH");
        boolean bl = true;
        if (string == null || string.trim().length() <= 0 || ParameterAccessor.isRelativePath(string)) {
            bl = false;
        } else {
            object2 = new File(string);
            if (!((File)object2).exists()) {
                bl = ((File)object2).mkdirs();
            }
        }
        if (bl) {
            SessionHandle.setBirtResourcePath((String)string);
        }
        this.imageDirectory = servletConfig.getServletContext().getInitParameter("BIRT_VIEWER_IMAGE_DIR");
        if (this.imageDirectory == null || this.imageDirectory.trim().length() <= 0 || ParameterAccessor.isRelativePath(this.imageDirectory)) {
            this.imageDirectory = servletConfig.getServletContext().getRealPath("/report/images");
        }
        this.imageBaseUrl = "/run?__imageID=";
        object2 = servletConfig.getServletContext().getInitParameter("BIRT_VIEWER_LOG_DIR");
        if (object2 == null || ((String)object2).trim().length() <= 0 || ParameterAccessor.isRelativePath((String)object2)) {
            object2 = servletConfig.getServletContext().getRealPath("/logs");
        }
        String string2 = servletConfig.getServletContext().getInitParameter("BIRT_VIEWER_LOG_LEVEL");
        Level level = Level.OFF;
        if ("SEVERE".equalsIgnoreCase(string2)) {
            level = Level.SEVERE;
        } else if ("WARNING".equalsIgnoreCase(string2)) {
            level = Level.WARNING;
        } else if ("INFO".equalsIgnoreCase(string2)) {
            level = Level.INFO;
        } else if ("CONFIG".equalsIgnoreCase(string2)) {
            level = Level.CONFIG;
        } else if ("FINE".equalsIgnoreCase(string2)) {
            level = Level.FINE;
        } else if ("FINER".equalsIgnoreCase(string2)) {
            level = Level.FINER;
        } else if ("FINEST".equalsIgnoreCase(string2)) {
            level = Level.FINEST;
        } else if ("OFF".equalsIgnoreCase(string2)) {
            level = Level.OFF;
        }
        this.config.setLogConfig((String)object2, level);
        String string3 = servletConfig.getServletContext().getInitParameter("BIRT_VIEWER_SCRIPTLIB_DIR");
        if (string3 == null || string3.trim().length() <= 0 || ParameterAccessor.isRelativePath(string3)) {
            string3 = servletConfig.getServletContext().getRealPath("/scriptlib");
        }
        ArrayList arrayList = new ArrayList();
        if (string3 != null) {
            object = new File(string3);
            this.getAllJarFiles((File)object, arrayList);
        }
        object = "";
        for (int i = 0; i < arrayList.size(); ++i) {
            object = (String)object + ";" + ((File)arrayList.get(i)).getAbsolutePath();
        }
        if (((String)object).startsWith(";")) {
            object = ((String)object).substring(";".length());
        }
        System.setProperty("webapplication.projectclasspath", (String)object);
        this.config.setEngineHome("");
    }

    public static ReportEngineService getInstance() {
        return instance;
    }

    public static void initEngineInstance(ServletConfig servletConfig) throws BirtException {
        if (instance != null) {
            return;
        }
        instance = new ReportEngineService(servletConfig);
    }

    private void getAllJarFiles(File file, ArrayList arrayList) {
        if (file.exists() && file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return;
            }
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2.isFile()) {
                    if (!file2.getName().endsWith(".jar")) continue;
                    arrayList.add(file2);
                    continue;
                }
                if (!file2.isDirectory()) continue;
                this.getAllJarFiles(file2, arrayList);
            }
        }
    }

    public synchronized void setEngineContext(ServletContext servletContext, HttpServletRequest httpServletRequest) {
        if (this.engine == null) {
            PlatformServletContext platformServletContext = new PlatformServletContext(servletContext);
            this.config.setPlatformContext((IPlatformContext)platformServletContext);
            try {
                Platform.startup((PlatformConfig)this.config);
            }
            catch (BirtException birtException) {
                birtException.printStackTrace();
            }
            IReportEngineFactory iReportEngineFactory = (IReportEngineFactory)Platform.createFactoryObject((String)"org.eclipse.birt.report.engine.ReportEngineFactory");
            this.engine = iReportEngineFactory.createReportEngine(this.config);
            this.contextPath = httpServletRequest.getContextPath();
        }
    }

    public synchronized IReportRunnable openReportDesign(String string) throws EngineException {
        return this.engine.openReportDesign(string);
    }

    public synchronized IReportRunnable openReportDesign(InputStream inputStream) throws EngineException {
        return this.engine.openReportDesign(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IGetParameterDefinitionTask createGetParameterDefinitionTask(IReportRunnable iReportRunnable) {
        IGetParameterDefinitionTask iGetParameterDefinitionTask = null;
        try {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                iGetParameterDefinitionTask = this.engine.createGetParameterDefinitionTask(iReportRunnable);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return iGetParameterDefinitionTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IReportDocument openReportDocument(String string, String string2) {
        IReportDocument iReportDocument = null;
        try {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                iReportDocument = this.engine.openReportDocument(string, string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return iReportDocument;
    }

    public void renderImage(String string, OutputStream outputStream) throws RemoteException {
        if (!$assertionsDisabled && this.imageHandler == null) {
            throw new AssertionError();
        }
        try {
            this.imageHandler.getImage(outputStream, this.imageDirectory, string);
        }
        catch (EngineException engineException) {
            AxisFault axisFault = new AxisFault(engineException.getLocalizedMessage());
            axisFault.setFaultCode(new QName("ReportEngineService.renderImage( )"));
            axisFault.setFaultString(engineException.getLocalizedMessage());
            throw axisFault;
        }
    }

    private HTMLRenderContext createHTMLrenderContext(boolean bl, String string) {
        HTMLRenderContext hTMLRenderContext = new HTMLRenderContext();
        hTMLRenderContext.setImageDirectory(this.imageDirectory);
        hTMLRenderContext.setBaseImageURL(this.contextPath + this.imageBaseUrl);
        if (string != null && string.length() > 0 && !string.equalsIgnoreCase("/preview")) {
            hTMLRenderContext.setBaseURL(this.contextPath + string);
        } else {
            hTMLRenderContext.setBaseURL(this.contextPath + "/frameset");
        }
        hTMLRenderContext.setImageDirectory(this.imageDirectory);
        hTMLRenderContext.setSupportedImageFormats(bl ? "PNG;GIF;JPG;BMP;SVG" : "PNG;GIF;JPG;BMP");
        return hTMLRenderContext;
    }

    private PDFRenderContext createPDFrenderContext() {
        PDFRenderContext pDFRenderContext = new PDFRenderContext();
        pDFRenderContext.setBaseURL(this.contextPath + "/run");
        pDFRenderContext.setSupportedImageFormats("PNG;GIF;JPG;BMP");
        return pDFRenderContext;
    }

    public void runAndRenderReport(HttpServletRequest httpServletRequest, IReportRunnable iReportRunnable, OutputStream outputStream, String string, Locale locale, boolean bl, Map map, boolean bl2, boolean bl3) throws RemoteException {
        this.runAndRenderReport(httpServletRequest, iReportRunnable, outputStream, string, locale, bl, map, bl2, bl3, null, null, null);
    }

    public void runAndRenderReport(HttpServletRequest httpServletRequest, IReportRunnable iReportRunnable, ByteArrayOutputStream byteArrayOutputStream, Locale locale, boolean bl, Map map, boolean bl2, boolean bl3, List list, HTMLRenderContext hTMLRenderContext) throws RemoteException {
        this.runAndRenderReport(httpServletRequest, iReportRunnable, byteArrayOutputStream, "html", locale, bl, map, bl2, bl3, Boolean.TRUE, list, hTMLRenderContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAndRenderReport(HttpServletRequest httpServletRequest, IReportRunnable iReportRunnable, OutputStream outputStream, String string, Locale locale, boolean bl, Map map, boolean bl2, boolean bl3, Boolean bl4, List list, HTMLRenderContext hTMLRenderContext) throws RemoteException {
        if (!$assertionsDisabled && iReportRunnable == null) {
            throw new AssertionError();
        }
        HTMLRenderOption hTMLRenderOption = new HTMLRenderOption();
        hTMLRenderOption.setOutputStream(outputStream);
        hTMLRenderOption.setOutputFormat(string);
        hTMLRenderOption.setMasterPageContent(bl2);
        hTMLRenderOption.setHtmlRtLFlag(bl);
        hTMLRenderOption.setActionHandle((IHTMLActionHandler)new ViewerHTMLActionHandler(locale, bl, bl2));
        hTMLRenderOption.setHtmlTitle(BirtResources.getString("birt.viewer.title"));
        if (bl4 != null) {
            hTMLRenderOption.setEmbeddable(bl4.booleanValue());
        }
        if (list != null) {
            hTMLRenderOption.setInstanceIDs(list);
        }
        IRunAndRenderTask iRunAndRenderTask = null;
        Serializable serializable = this.getClass();
        synchronized (serializable) {
            iRunAndRenderTask = this.engine.createRunAndRenderTask(iReportRunnable);
        }
        iRunAndRenderTask.setLocale(locale);
        if (map != null) {
            iRunAndRenderTask.setParameterValues(map);
        }
        iRunAndRenderTask.setRenderOption((IRenderOption)hTMLRenderOption);
        serializable = new HashMap();
        Boolean bl5 = ParameterAccessor.isDesigner(httpServletRequest);
        ((HashMap)serializable).put("org.eclipse.birt.data.engine.dataset.cache.option", bl5);
        ((HashMap)serializable).put("BIRT_VIEWER_HTTPSERVET_REQUEST", httpServletRequest);
        ((HashMap)serializable).put("PARENT_CLASSLOADER", ReportEngineService.class.getClassLoader());
        if ("pdf".equalsIgnoreCase(string)) {
            ((HashMap)serializable).put("PDF_RENDER_CONTEXT", this.createPDFrenderContext());
        } else if (hTMLRenderContext != null) {
            ((HashMap)serializable).put("HTML_RENDER_CONTEXT", hTMLRenderContext);
        } else {
            ((HashMap)serializable).put("HTML_RENDER_CONTEXT", this.createHTMLrenderContext(bl3, httpServletRequest.getServletPath()));
        }
        iRunAndRenderTask.setAppContext((Map)((Object)serializable));
        try {
            iRunAndRenderTask.run();
        }
        catch (BirtException birtException) {
            AxisFault axisFault = new AxisFault(birtException.getLocalizedMessage());
            axisFault.setFaultCode(new QName("ReportEngineService.runAndRenderReport( )"));
            axisFault.setFaultString(birtException.getLocalizedMessage());
            throw axisFault;
        }
        finally {
            iRunAndRenderTask.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runReport(HttpServletRequest httpServletRequest, IReportRunnable iReportRunnable, String string, Locale locale, HashMap hashMap) throws RemoteException {
        if (!$assertionsDisabled && iReportRunnable == null) {
            throw new AssertionError();
        }
        IRunTask iRunTask = null;
        Serializable serializable = this.getClass();
        synchronized (serializable) {
            iRunTask = this.engine.createRunTask(iReportRunnable);
        }
        iRunTask.setLocale(locale);
        iRunTask.setParameterValues((Map)hashMap);
        serializable = new HashMap();
        Boolean bl = ParameterAccessor.isDesigner(httpServletRequest);
        ((HashMap)serializable).put("org.eclipse.birt.data.engine.dataset.cache.option", bl);
        ((HashMap)serializable).put("BIRT_VIEWER_HTTPSERVET_REQUEST", httpServletRequest);
        ((HashMap)serializable).put("PARENT_CLASSLOADER", ReportEngineService.class.getClassLoader());
        iRunTask.setAppContext((Map)((Object)serializable));
        try {
            iRunTask.run(string);
        }
        catch (BirtException birtException) {
            AxisFault axisFault = new AxisFault(birtException.getLocalizedMessage());
            axisFault.setFaultCode(new QName("ReportEngineService.runReport( )"));
            axisFault.setFaultString(birtException.getLocalizedMessage());
            throw axisFault;
        }
        finally {
            iRunTask.close();
        }
    }

    public ByteArrayOutputStream renderReport(HttpServletRequest httpServletRequest, IReportDocument iReportDocument, long l, boolean bl, boolean bl2, List list, Locale locale, boolean bl3) throws RemoteException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.renderReport(byteArrayOutputStream, httpServletRequest, iReportDocument, l, bl, bl2, list, locale, bl3);
        return byteArrayOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderReport(OutputStream outputStream, HttpServletRequest httpServletRequest, IReportDocument iReportDocument, long l, boolean bl, boolean bl2, List list, Locale locale, boolean bl3) throws RemoteException {
        if (!$assertionsDisabled && iReportDocument == null) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || l > 0L && l <= iReportDocument.getPageCount())) {
            throw new AssertionError();
        }
        OutputStream outputStream2 = outputStream;
        if (outputStream2 == null) {
            outputStream2 = new ByteArrayOutputStream();
        }
        IRenderTask iRenderTask = null;
        Serializable serializable = this.getClass();
        synchronized (serializable) {
            iRenderTask = this.engine.createRenderTask(iReportDocument);
        }
        serializable = new HashMap();
        String string = ParameterAccessor.getFormat(httpServletRequest);
        if (string.equalsIgnoreCase("pdf")) {
            ((HashMap)serializable).put("PDF_RENDER_CONTEXT", this.createPDFrenderContext());
        } else {
            ((HashMap)serializable).put("HTML_RENDER_CONTEXT", this.createHTMLrenderContext(bl2, httpServletRequest.getServletPath()));
        }
        ((HashMap)serializable).put("BIRT_VIEWER_HTTPSERVET_REQUEST", httpServletRequest);
        ((HashMap)serializable).put("PARENT_CLASSLOADER", ReportEngineService.class.getClassLoader());
        iRenderTask.setAppContext((Map)((Object)serializable));
        HTMLRenderOption hTMLRenderOption = new HTMLRenderOption();
        hTMLRenderOption.setOutputStream(outputStream2);
        if (string.equalsIgnoreCase("pdf")) {
            hTMLRenderOption.setOutputFormat("pdf");
            hTMLRenderOption.setActionHandle((IHTMLActionHandler)new ViewerHTMLActionHandler(iReportDocument, l, locale, false, bl3, bl));
        } else {
            hTMLRenderOption.setOutputFormat("html");
            boolean bl4 = false;
            if ("/frameset".equalsIgnoreCase(httpServletRequest.getServletPath())) {
                bl4 = true;
            }
            hTMLRenderOption.setEmbeddable(bl4);
            hTMLRenderOption.setHtmlRtLFlag(bl3);
            hTMLRenderOption.setInstanceIDs(list);
            hTMLRenderOption.setMasterPageContent(bl);
            hTMLRenderOption.setActionHandle((IHTMLActionHandler)new ViewerHTMLActionHandler(iReportDocument, l, locale, bl4, bl3, bl));
        }
        iRenderTask.setRenderOption((IRenderOption)hTMLRenderOption);
        iRenderTask.setLocale(locale);
        try {
            if (string.equalsIgnoreCase("pdf") || "/run".equalsIgnoreCase(httpServletRequest.getServletPath())) {
                iRenderTask.render();
            } else {
                iRenderTask.setPageNumber(l);
                iRenderTask.render();
            }
        }
        catch (BirtException birtException) {
            AxisFault axisFault = new AxisFault(birtException.getLocalizedMessage());
            axisFault.setFaultCode(new QName("ReportEngineService.renderReport( )"));
            axisFault.setFaultString(birtException.getLocalizedMessage());
            throw axisFault;
        }
        catch (Exception exception) {
            AxisFault axisFault = new AxisFault(exception.getLocalizedMessage());
            axisFault.setFaultCode(new QName("ReportEngineService.renderReport( )"));
            axisFault.setFaultString(exception.getLocalizedMessage());
            throw axisFault;
        }
        finally {
            iRenderTask.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderReportlet(OutputStream outputStream, HttpServletRequest httpServletRequest, IReportDocument iReportDocument, String string, boolean bl, boolean bl2, List list, Locale locale, boolean bl3) throws RemoteException {
        if (!$assertionsDisabled && iReportDocument == null) {
            throw new AssertionError();
        }
        OutputStream outputStream2 = outputStream;
        if (outputStream2 == null) {
            outputStream2 = new ByteArrayOutputStream();
        }
        IRenderTask iRenderTask = null;
        Serializable serializable = this.getClass();
        synchronized (serializable) {
            iRenderTask = this.engine.createRenderTask(iReportDocument);
        }
        serializable = new HashMap();
        String string2 = ParameterAccessor.getFormat(httpServletRequest);
        if (string2.equalsIgnoreCase("pdf")) {
            ((HashMap)serializable).put("PDF_RENDER_CONTEXT", this.createPDFrenderContext());
        } else {
            ((HashMap)serializable).put("HTML_RENDER_CONTEXT", this.createHTMLrenderContext(bl2, httpServletRequest.getServletPath()));
        }
        ((HashMap)serializable).put("BIRT_VIEWER_HTTPSERVET_REQUEST", httpServletRequest);
        ((HashMap)serializable).put("PARENT_CLASSLOADER", ReportEngineService.class.getClassLoader());
        iRenderTask.setAppContext((Map)((Object)serializable));
        HTMLRenderOption hTMLRenderOption = new HTMLRenderOption();
        hTMLRenderOption.setOutputStream(outputStream2);
        if (string2.equalsIgnoreCase("pdf")) {
            hTMLRenderOption.setOutputFormat("pdf");
            hTMLRenderOption.setActionHandle((IHTMLActionHandler)new ViewerHTMLActionHandler(iReportDocument, -1L, locale, false, bl3, bl));
        } else {
            hTMLRenderOption.setOutputFormat("html");
            boolean bl4 = false;
            if ("/frameset".equalsIgnoreCase(httpServletRequest.getServletPath())) {
                bl4 = true;
            }
            hTMLRenderOption.setEmbeddable(bl4);
            hTMLRenderOption.setHtmlRtLFlag(bl3);
            hTMLRenderOption.setInstanceIDs(list);
            hTMLRenderOption.setMasterPageContent(bl);
            hTMLRenderOption.setActionHandle((IHTMLActionHandler)new ViewerHTMLActionHandler(iReportDocument, -1L, locale, bl4, bl3, bl));
        }
        iRenderTask.setRenderOption((IRenderOption)hTMLRenderOption);
        iRenderTask.setLocale(locale);
        InstanceID instanceID = InstanceID.parse((String)string);
        try {
            iRenderTask.setInstanceID(instanceID);
            if (string2.equalsIgnoreCase("pdf")) {
                iRenderTask.render();
            } else {
                iRenderTask.render();
            }
        }
        catch (BirtException birtException) {
            AxisFault axisFault = new AxisFault(birtException.getLocalizedMessage());
            axisFault.setFaultCode(new QName("ReportEngineService.renderReport( )"));
            axisFault.setFaultString(birtException.getLocalizedMessage());
            throw axisFault;
        }
        catch (Exception exception) {
            AxisFault axisFault = new AxisFault(exception.getLocalizedMessage());
            axisFault.setFaultCode(new QName("ReportEngineService.renderReport( )"));
            axisFault.setFaultString(exception.getLocalizedMessage());
            throw axisFault;
        }
        finally {
            iRenderTask.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet[] getResultSets(IReportDocument iReportDocument) throws RemoteException {
        if (!$assertionsDisabled && iReportDocument == null) {
            throw new AssertionError();
        }
        ResultSet[] resultSetArray = null;
        IDataExtractionTask iDataExtractionTask = null;
        Object object = this.getClass();
        synchronized (object) {
            iDataExtractionTask = this.engine.createDataExtractionTask(iReportDocument);
        }
        try {
            object = iDataExtractionTask.getResultSetList();
            resultSetArray = new ResultSet[object.size()];
            if (object != null && object.size() > 0) {
                for (int i = 0; i < object.size(); ++i) {
                    resultSetArray[i] = new ResultSet();
                    IResultSetItem iResultSetItem = (IResultSetItem)object.get(i);
                    if (!$assertionsDisabled && iResultSetItem == null) {
                        throw new AssertionError();
                    }
                    resultSetArray[i].setQueryName(iResultSetItem.getResultSetName());
                    IResultMetaData iResultMetaData = iResultSetItem.getResultMetaData();
                    if (!$assertionsDisabled && iResultMetaData == null) {
                        throw new AssertionError();
                    }
                    Column[] columnArray = new Column[iResultMetaData.getColumnCount()];
                    for (int j = 0; j < iResultMetaData.getColumnCount(); ++j) {
                        columnArray[j] = new Column();
                        String string = iResultMetaData.getColumnName(j);
                        columnArray[j].setName(string);
                        String string2 = iResultMetaData.getColumnLabel(j);
                        if (string2 == null || string2.length() <= 0) {
                            string2 = string;
                        }
                        columnArray[j].setLabel(string2);
                        columnArray[j].setVisibility(new Boolean(true));
                    }
                    resultSetArray[i].setColumn(columnArray);
                }
            }
        }
        catch (BirtException birtException) {
            birtException.printStackTrace();
            AxisFault axisFault = new AxisFault(birtException.getLocalizedMessage());
            axisFault.setFaultCode(new QName("ReportEngineService.getResultSets( )"));
            axisFault.setFaultString(birtException.getLocalizedMessage());
            throw axisFault;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            AxisFault axisFault = new AxisFault(exception.getLocalizedMessage());
            axisFault.setFaultCode(new QName("ReportEngineService.getResultSets( )"));
            axisFault.setFaultString(exception.getLocalizedMessage());
            throw axisFault;
        }
        finally {
            iDataExtractionTask.close();
        }
        return resultSetArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void extractData(IReportDocument iReportDocument, String string, Collection collection, Locale locale, OutputStream outputStream) throws RemoteException {
        IDataIterator iDataIterator;
        IExtractionResults iExtractionResults;
        IDataExtractionTask iDataExtractionTask;
        block24: {
            if (!$assertionsDisabled && iReportDocument == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled) {
                if (string == null) throw new AssertionError();
                if (string.length() <= 0) {
                    throw new AssertionError();
                }
            }
            if (!$assertionsDisabled) {
                if (collection == null) throw new AssertionError();
                if (collection.isEmpty()) {
                    throw new AssertionError();
                }
            }
            String[] stringArray = new String[collection.size()];
            Iterator iterator = collection.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                stringArray[n] = (String)iterator.next();
                ++n;
            }
            iDataExtractionTask = null;
            iExtractionResults = null;
            iDataIterator = null;
            try {
                try {
                    Serializable serializable = this.getClass();
                    synchronized (serializable) {
                        iDataExtractionTask = this.engine.createDataExtractionTask(iReportDocument);
                    }
                    iDataExtractionTask.selectResultSet(string);
                    iDataExtractionTask.selectColumns(stringArray);
                    iDataExtractionTask.setLocale(locale);
                    iExtractionResults = iDataExtractionTask.extract();
                    if (iExtractionResults == null || (iDataIterator = iExtractionResults.nextResultIterator()) == null || stringArray.length <= 0) break block24;
                    serializable = new StringBuffer();
                    ((StringBuffer)serializable).append(stringArray[0]);
                    for (int i = 1; i < stringArray.length; ++i) {
                        ((StringBuffer)serializable).append(',');
                        ((StringBuffer)serializable).append(stringArray[i]);
                    }
                    ((StringBuffer)serializable).append('\n');
                    outputStream.write(((StringBuffer)serializable).toString().getBytes());
                    ((StringBuffer)serializable).delete(0, ((StringBuffer)serializable).length());
                    while (iDataIterator.next()) {
                        String i = null;
                        try {
                            i = this.cvsConvertor((String)DataTypeUtil.convert((Object)iDataIterator.getValue(stringArray[0]), (int)5));
                        }
                        catch (Exception i2) {
                            i = null;
                        }
                        if (i != null) {
                            ((StringBuffer)serializable).append(i);
                        }
                        for (int j = 1; j < stringArray.length; ++j) {
                            ((StringBuffer)serializable).append(',');
                            try {
                                i = this.cvsConvertor((String)DataTypeUtil.convert((Object)iDataIterator.getValue(stringArray[j]), (int)5));
                            }
                            catch (Exception exception) {
                                i = null;
                            }
                            if (i == null) continue;
                            ((StringBuffer)serializable).append(i);
                        }
                        ((StringBuffer)serializable).append('\n');
                        outputStream.write(((StringBuffer)serializable).toString().getBytes());
                        ((StringBuffer)serializable).delete(0, ((StringBuffer)serializable).length());
                    }
                }
                catch (Exception exception) {
                    AxisFault string2 = new AxisFault(exception.getLocalizedMessage());
                    string2.setFaultCode(new QName("ReportEngineService.extractData( )"));
                    string2.setFaultString(exception.getLocalizedMessage());
                    throw string2;
                }
            }
            catch (Throwable throwable) {
                Object var16_21 = null;
                if (iDataIterator != null) {
                    iDataIterator.close();
                }
                if (iExtractionResults != null) {
                    iExtractionResults.close();
                }
                if (iDataExtractionTask == null) throw throwable;
                iDataExtractionTask.close();
                throw throwable;
            }
        }
        Object var16_20 = null;
        if (iDataIterator != null) {
            iDataIterator.close();
        }
        if (iExtractionResults != null) {
            iExtractionResults.close();
        }
        if (iDataExtractionTask == null) return;
        iDataExtractionTask.close();
    }

    private String cvsConvertor(String string) throws RemoteException {
        if (string == null) {
            return null;
        }
        string = string.replaceAll("\"", "\"\"");
        boolean bl = false;
        bl = string.indexOf(44) != -1 || string.indexOf(34) != -1 || string.indexOf(10) != -1 || string.startsWith(" ") || string.endsWith(" ");
        string = bl ? "\"" + string + "\"" : string;
        return string;
    }

    public HashMap parseParameters(HttpServletRequest httpServletRequest, IGetParameterDefinitionTask iGetParameterDefinitionTask, Map map, Locale locale) {
        if (!$assertionsDisabled && iGetParameterDefinitionTask == null) {
            throw new AssertionError();
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Collection collection = iGetParameterDefinitionTask.getParameterDefns(false);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            IScalarParameterDefn iScalarParameterDefn = (IScalarParameterDefn)iterator.next();
            String string = null;
            Object object = null;
            String string2 = iScalarParameterDefn.getName();
            String string3 = iScalarParameterDefn.getDisplayFormat();
            ReportParameterConverter reportParameterConverter = new ReportParameterConverter(string3, locale);
            if (ParameterAccessor.isReportParameterExist(httpServletRequest, string2)) {
                string = ParameterAccessor.getReportParameter(httpServletRequest, string2, string);
                object = reportParameterConverter.parse(string, iScalarParameterDefn.getDataType());
            } else if (ParameterAccessor.isDesigner(httpServletRequest) && map.containsKey(string2)) {
                String string4 = (String)map.get(string2);
                ReportParameterConverter reportParameterConverter2 = new ReportParameterConverter(string3, Locale.US);
                object = reportParameterConverter2.parse(string4, iScalarParameterDefn.getDataType());
            } else {
                object = iGetParameterDefinitionTask.getDefaultValue(iScalarParameterDefn.getName());
            }
            hashMap.put(string2, object);
        }
        return hashMap;
    }

    public boolean validateParameters(IGetParameterDefinitionTask iGetParameterDefinitionTask, Map map) {
        if (!$assertionsDisabled && iGetParameterDefinitionTask == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && map == null) {
            throw new AssertionError();
        }
        boolean bl = false;
        Collection collection = iGetParameterDefinitionTask.getParameterDefns(false);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string;
            IScalarParameterDefn iScalarParameterDefn = (IScalarParameterDefn)iterator.next();
            String string2 = iScalarParameterDefn.getName();
            Object v = map.get(string2);
            if (iScalarParameterDefn.isHidden()) continue;
            if (v == null && !iScalarParameterDefn.allowNull()) {
                bl = true;
                break;
            }
            if (1 != iScalarParameterDefn.getDataType() || (string = (String)v) == null || string.length() > 0 || iScalarParameterDefn.allowBlank()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void clearCache(DataSetHandle dataSetHandle) throws BirtException {
        DataSessionContext dataSessionContext = new DataSessionContext(3, dataSetHandle.getModuleHandle(), null);
        DataRequestSession dataRequestSession = DataRequestSession.newSession((DataSessionContext)dataSessionContext);
        IModelAdapter iModelAdapter = dataRequestSession.getModelAdaptor();
        DataSourceHandle dataSourceHandle = dataSetHandle.getDataSource();
        BaseDataSourceDesign baseDataSourceDesign = iModelAdapter.adaptDataSource(dataSourceHandle);
        BaseDataSetDesign baseDataSetDesign = iModelAdapter.adaptDataSet(dataSetHandle);
        dataRequestSession.clearCache((IBaseDataSourceDesign)baseDataSourceDesign, (IBaseDataSetDesign)baseDataSetDesign);
    }

    public void setMaxRows(int n) {
        if (this.config != null) {
            this.config.setMaxRowsPerQuery(n);
        }
    }

    public List getColumnValueSet(String string, DesignElementHandle designElementHandle, IRequestInfo iRequestInfo) throws BirtException {
        if (string == null || designElementHandle == null || !(designElementHandle instanceof ReportItemHandle)) {
            return Collections.EMPTY_LIST;
        }
        ReportItemHandle reportItemHandle = this.getBindingHolder(designElementHandle);
        if (reportItemHandle == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList arrayList = new ArrayList();
        DataRequestSession dataRequestSession = DataRequestSession.newSession((DataSessionContext)new DataSessionContext(3, reportItemHandle.getModuleHandle()));
        arrayList.addAll(dataRequestSession.getColumnValueSet(reportItemHandle.getDataSet(), reportItemHandle.paramBindingsIterator(), reportItemHandle.columnBindingsIterator(), string, iRequestInfo));
        dataRequestSession.shutdown();
        return arrayList;
    }

    public List getColumnValueSet(String string, DesignElementHandle designElementHandle) throws BirtException {
        if (string == null || designElementHandle == null || !(designElementHandle instanceof ReportItemHandle)) {
            return Collections.EMPTY_LIST;
        }
        ReportItemHandle reportItemHandle = this.getBindingHolder(designElementHandle);
        if (reportItemHandle == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList arrayList = new ArrayList();
        DataRequestSession dataRequestSession = DataRequestSession.newSession((DataSessionContext)new DataSessionContext(3, reportItemHandle.getModuleHandle()));
        arrayList.addAll(dataRequestSession.getColumnValueSet(reportItemHandle.getDataSet(), reportItemHandle.paramBindingsIterator(), reportItemHandle.columnBindingsIterator(), string));
        dataRequestSession.shutdown();
        return arrayList;
    }

    private ReportItemHandle getBindingHolder(DesignElementHandle designElementHandle) {
        if (designElementHandle instanceof ReportElementHandle) {
            if (designElementHandle instanceof ListingHandle) {
                return (ReportItemHandle)designElementHandle;
            }
            if (designElementHandle instanceof ReportItemHandle && (((ReportItemHandle)designElementHandle).getDataSet() != null || ((ReportItemHandle)designElementHandle).columnBindingsIterator().hasNext())) {
                return (ReportItemHandle)designElementHandle;
            }
            ReportItemHandle reportItemHandle = this.getBindingHolder(designElementHandle.getContainer());
            if (reportItemHandle == null && designElementHandle instanceof ReportItemHandle) {
                reportItemHandle = (ReportItemHandle)designElementHandle;
            }
            return reportItemHandle;
        }
        return null;
    }

    public String getMIMEType(String string) {
        return this.engine.getMIMEType(string);
    }

    static {
        $assertionsDisabled = !ReportEngineService.class.desiredAssertionStatus();
    }
}

