/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.service.actionhandler;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.eclipse.birt.report.context.BaseAttributeBean;
import org.eclipse.birt.report.context.IContext;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.service.actionhandler.IActionHandler;
import org.eclipse.birt.report.service.api.IViewerReportService;
import org.eclipse.birt.report.service.api.InputOptions;
import org.eclipse.birt.report.service.api.OutputOptions;
import org.eclipse.birt.report.service.api.ReportServiceException;
import org.eclipse.birt.report.soapengine.api.GetUpdatedObjectsResponse;
import org.eclipse.birt.report.soapengine.api.Operation;
import org.eclipse.birt.report.soapengine.api.Oprand;
import org.eclipse.birt.report.soapengine.api.ReportId;
import org.eclipse.birt.report.soapengine.api.ReportIdType;

public abstract class AbstractBaseActionHandler
implements IActionHandler {
    protected IContext context = null;
    protected Operation operation = null;
    protected GetUpdatedObjectsResponse response = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected abstract void __execute() throws RemoteException;

    public AbstractBaseActionHandler(IContext iContext, Operation operation, GetUpdatedObjectsResponse getUpdatedObjectsResponse) {
        this.context = iContext;
        this.operation = operation;
        this.response = getUpdatedObjectsResponse;
    }

    public void execute() throws RemoteException {
        this.__execute();
    }

    protected boolean isValidPageNumber(HttpServletRequest httpServletRequest, long l, String string) throws RemoteException, ReportServiceException {
        InputOptions inputOptions = new InputOptions();
        inputOptions.setOption("request", httpServletRequest);
        return l > 0L && l <= this.getReportService().getPageCount(string, inputOptions, new OutputOptions());
    }

    protected long getPageNumber(HttpServletRequest httpServletRequest, Oprand[] oprandArray, String string) throws RemoteException, ReportServiceException {
        long l = -1L;
        if (oprandArray != null && oprandArray.length > 0) {
            for (int i = 0; i < oprandArray.length; ++i) {
                if (!"page".equalsIgnoreCase(oprandArray[i].getName())) continue;
                try {
                    l = Integer.parseInt(oprandArray[i].getValue());
                }
                catch (NumberFormatException numberFormatException) {
                    l = -1L;
                }
                InputOptions inputOptions = new InputOptions();
                inputOptions.setOption("request", httpServletRequest);
                if (l > 0L && l <= this.getReportService().getPageCount(string, inputOptions, new OutputOptions())) break;
                AxisFault axisFault = new AxisFault();
                axisFault.setFaultCode(new QName("DocumentProcessor.getPageNumber( )"));
                axisFault.setFaultString("Invalid page number.");
                throw axisFault;
            }
        }
        return l;
    }

    protected String getBookmark(Oprand[] oprandArray, BaseAttributeBean baseAttributeBean) {
        if (!$assertionsDisabled && baseAttributeBean == null) {
            throw new AssertionError();
        }
        String string = null;
        if (oprandArray != null && oprandArray.length > 0) {
            for (int i = 0; i < oprandArray.length; ++i) {
                if (!"bookmark".equalsIgnoreCase(oprandArray[i].getName())) continue;
                string = oprandArray[i].getValue();
                break;
            }
        }
        if (string == null || string.length() <= 0) {
            string = baseAttributeBean.getBookmark();
        }
        return string;
    }

    protected ReportId[] parseReportId(ArrayList arrayList) throws RemoteException {
        if (arrayList == null || arrayList.size() <= 0) {
            return null;
        }
        Vector<ReportId> vector = new Vector<ReportId>();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string;
            String string2 = (String)arrayList.get(i);
            int n = string2.indexOf(44);
            if (string2 == null || n == -1) {
                AxisFault axisFault = new AxisFault();
                axisFault.setFaultCode(new QName("DocumentProcessor.parseReportId( )"));
                axisFault.setFaultString(BirtResources.getFormattedString("birt.viewer.actionException.INVALID_ID_FORMAT", new String[]{string2}));
                throw axisFault;
            }
            int n2 = string2.indexOf(44, n + 1);
            if (n2 == -1) {
                n2 = string2.length();
            }
            if (!"Document".equalsIgnoreCase(string = string2.substring(n + 1, n2)) && !"Table".equalsIgnoreCase(string) && !"Chart".equalsIgnoreCase(string) && !"Extended".equalsIgnoreCase(string) && !"Group".equalsIgnoreCase(string) && !"ColoumnInfo".equalsIgnoreCase(string)) continue;
            ReportId reportId = new ReportId();
            reportId.setId(string2.substring(0, string2.indexOf(44)));
            if ("Document".equalsIgnoreCase(string)) {
                reportId.setType(ReportIdType.Document);
            } else if ("Table".equalsIgnoreCase(string)) {
                reportId.setType(ReportIdType.Table);
            } else if ("Chart".equalsIgnoreCase(string) || "Extended".equalsIgnoreCase(string)) {
                reportId.setType(ReportIdType.Chart);
            } else if ("Group".equalsIgnoreCase(string)) {
                reportId.setType(ReportIdType.Group);
            } else if ("ColoumnInfo".equalsIgnoreCase(string)) {
                reportId.setType(ReportIdType.ColumnInfo);
            }
            try {
                reportId.setRptElementId(new Long(Long.parseLong(string2.substring(n2 + 1))));
            }
            catch (Exception exception) {
                reportId.setRptElementId(null);
            }
            vector.add(reportId);
        }
        ReportId[] reportIdArray = new ReportId[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            reportIdArray[i] = (ReportId)vector.get(i);
        }
        return reportIdArray;
    }

    public boolean canExecute() {
        return true;
    }

    public boolean canUndo() {
        return false;
    }

    public boolean canRedo() {
        return false;
    }

    public void undo() {
    }

    public void redo() {
    }

    public boolean prepare() {
        return true;
    }

    protected abstract IViewerReportService getReportService();

    protected boolean getSVGFlag(Oprand[] oprandArray) {
        boolean bl = false;
        if (oprandArray != null && oprandArray.length > 0) {
            for (int i = 0; i < oprandArray.length; ++i) {
                if (!"svg".equalsIgnoreCase(oprandArray[i].getName())) continue;
                bl = "true".equalsIgnoreCase(oprandArray[i].getValue());
                break;
            }
        }
        return bl;
    }

    static {
        $assertionsDisabled = !AbstractBaseActionHandler.class.desiredAssertionStatus();
    }
}

