/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.servlet;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis.transport.http.AxisServlet;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.context.IContext;
import org.eclipse.birt.report.presentation.aggregation.IFragment;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.utility.ParameterAccessor;

public abstract class BaseReportEngineServlet
extends AxisServlet {
    private static final long serialVersionUID = 1L;
    protected static boolean openSource = true;
    protected IFragment engine = null;
    protected IFragment requester = null;

    protected abstract void __init(ServletConfig var1);

    protected abstract boolean __authenticate(HttpServletRequest var1, HttpServletResponse var2);

    protected abstract IContext __getContext(HttpServletRequest var1, HttpServletResponse var2);

    protected abstract void __doGet(IContext var1) throws ServletException, IOException, BirtException;

    protected abstract void __handleNonSoapException(IContext var1, Exception var2) throws ServletException, IOException;

    public static boolean isOpenSource() {
        return openSource;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        ParameterAccessor.initParameters(servletConfig);
        BirtResources.initResource(ParameterAccessor.getWebAppLocale());
        this.__init(servletConfig);
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (!this.__authenticate(httpServletRequest, httpServletResponse)) {
            return;
        }
        IContext iContext = this.__getContext(httpServletRequest, httpServletResponse);
        if (iContext.getBean().getException() != null) {
            this.__handleNonSoapException(iContext, iContext.getBean().getException());
        } else {
            String string = httpServletRequest.getHeader("request-type");
            if ("soap".equalsIgnoreCase(string)) {
                super.doPost(httpServletRequest, httpServletResponse);
            } else {
                try {
                    this.__doGet(iContext);
                }
                catch (BirtException birtException) {
                    this.__handleNonSoapException(iContext, (Exception)((Object)birtException));
                }
            }
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGet(httpServletRequest, httpServletResponse);
    }
}

