/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.ide.adapters;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.ide.adapters.ReportDocumentProvider;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.editors.IReportProvider;
import org.eclipse.birt.report.designer.ui.ide.wizards.SaveReportAsWizard;
import org.eclipse.birt.report.designer.ui.ide.wizards.SaveReportAsWizardDialog;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class IDEFileReportProvider
implements IReportProvider {
    private ModuleHandle model = null;
    private static final String VERSION_MESSAGE = Messages.getString((String)"TextPropertyDescriptor.Message.Version");

    public void connect(ModuleHandle model) {
        this.model = model;
    }

    public ModuleHandle getReportModuleHandle(Object element) {
        return this.getReportModuleHandle(element, false);
    }

    public void saveReport(ModuleHandle moduleHandle, Object element, IProgressMonitor monitor) {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            this.saveFile(moduleHandle, input.getFile(), monitor);
        }
    }

    private void saveFile(final ModuleHandle moduleHandle, final IFile file, IProgressMonitor monitor) {
        if (file.exists() && file.isReadOnly()) {
            MessageDialog.openError((Shell)UIUtil.getDefaultShell(), (String)Messages.getString((String)"IDEFileReportProvider.ReadOnlyEncounter.Title"), (String)Messages.getFormattedString((String)"IDEFileReportProvider.ReadOnlyEncounter.Message", (Object[])new Object[]{file.getFullPath()}));
            return;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public final synchronized void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    IWorkspaceRunnable workspaceRunnable = new IWorkspaceRunnable(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run(IProgressMonitor pm) throws CoreException {
                            try {
                                this.this$1.execute(pm);
                            }
                            catch (CoreException e) {
                                throw e;
                            }
                            catch (IOException e) {
                                ExceptionHandler.handle((Throwable)e);
                            }
                        }
                    };
                    ResourcesPlugin.getWorkspace().run(workspaceRunnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 0, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
                catch (OperationCanceledException e) {
                    throw new InterruptedException(e.getMessage());
                }
            }

            public void execute(IProgressMonitor monitor) throws CoreException, IOException {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                moduleHandle.serialize((OutputStream)out);
                byte[] bytes = out.toByteArray();
                out.close();
                ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                IContainer container = file.getParent();
                if (!container.exists() && container instanceof IFolder) {
                    UIUtil.createFolder((IFolder)((IFolder)container), (IProgressMonitor)monitor);
                }
                if (file.exists()) {
                    file.setContents((InputStream)is, true, true, monitor);
                } else {
                    file.create((InputStream)is, true, monitor);
                }
            }
        };
        try {
            new ProgressMonitorDialog(UIUtil.getDefaultShell()).run(false, true, op);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        try {
            file.refreshLocal(0, monitor);
        }
        catch (CoreException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public IPath getSaveAsPath(Object element) {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            SaveReportAsWizardDialog dialog = new SaveReportAsWizardDialog(UIUtil.getDefaultShell(), (IWizard)new SaveReportAsWizard(this.model, input.getFile()));
            if (dialog.open() == 0) {
                return dialog.getResult();
            }
        }
        return null;
    }

    public IEditorInput createNewEditorInput(IPath path) {
        return new FileEditorInput(ResourcesPlugin.getWorkspace().getRoot().getFile(path));
    }

    public IPath getInputPath(IEditorInput input) {
        if (input instanceof FileEditorInput) {
            return ((FileEditorInput)input).getPath();
        }
        return null;
    }

    public IDocumentProvider getReportDocumentProvider(Object element) {
        return new ReportDocumentProvider();
    }

    public ModuleHandle getReportModuleHandle(Object element, boolean reset) {
        if ((this.model == null || reset) && element instanceof IStorageEditorInput) {
            IEditorInput input = (IEditorInput)element;
            String fileName = input.getName();
            int blankIndex = fileName.lastIndexOf(" ");
            if (blankIndex > 0) {
                fileName = fileName.substring(0, blankIndex);
            }
            if (element instanceof IFileEditorInput) {
                fileName = ((IFileEditorInput)element).getFile().getLocation().toOSString();
            }
            try {
                InputStream stream = ((IStorageEditorInput)element).getStorage().getContents();
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("createdBy", MessageFormat.format(VERSION_MESSAGE, ReportPlugin.getVersion(), ReportPlugin.getBuildInfo()));
                this.model = SessionHandleAdapter.getInstance().init(fileName, stream, properties);
            }
            catch (CoreException e) {
            }
            catch (DesignFileException e) {
                // empty catch block
            }
        }
        return this.model;
    }
}

