/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.ide.adapters;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.wizards.INewLibraryCreationPage;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;
import org.osgi.framework.Bundle;

class NewLibraryCreationPage
extends WizardNewFileCreationPage
implements INewLibraryCreationPage {
    private static final String OPENING_FILE_FOR_EDITING = Messages.getString((String)"NewLibraryWizard.text.OpenFileForEditing");
    private static final String CREATING = Messages.getString((String)"NewLibraryWizard.text.Creating");

    public void createControl(Composite parent) {
        super.createControl(parent);
        UIUtil.bindHelp((Control)this.getControl(), (String)"org.eclipse.birt.cshelp.NewLibraryWizard_ID");
    }

    public NewLibraryCreationPage(String pageName, IStructuredSelection selection) {
        super(pageName, selection);
    }

    public boolean performFinish() {
        final IPath containerName = this.getContainerFullPath();
        String fn = this.getFileName();
        final String fileName = !fn.endsWith(".rptlibrary") ? fn + ".rptlibrary" : fn;
        InputStream streamFromPage = null;
        URL url = Platform.find((Bundle)Platform.getBundle((String)"org.eclipse.birt.report.designer.ui"), (IPath)new Path("/templates/blank_library.rptlibrary"));
        if (url != null) {
            try {
                streamFromPage = url.openStream();
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
        final InputStream stream = streamFromPage;
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    NewLibraryCreationPage.this.doFinish(containerName, fileName, stream, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            ExceptionHandler.handle((Throwable)realException);
            return false;
        }
        return true;
    }

    private void doFinish(IPath containerName, String fileName, InputStream stream, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(CREATING + fileName, 2);
        IContainer resource = (IContainer)ResourcesPlugin.getWorkspace().getRoot().findMember(containerName);
        IContainer container = null;
        if (resource == null || !resource.exists() || !(resource instanceof IContainer)) {
            IFolder folder = this.createFolderHandle(containerName);
            UIUtil.createFolder((IFolder)folder, (IProgressMonitor)monitor);
            container = folder;
        } else {
            container = resource;
        }
        final IFile file = container.getFile((IPath)new Path(fileName));
        try {
            if (file.exists()) {
                file.setContents(stream, true, true, monitor);
            } else {
                file.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        monitor.worked(1);
        monitor.setTaskName(OPENING_FILE_FOR_EDITING);
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                try {
                    IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                    ModuleHandle model = SessionHandleAdapter.getInstance().getReportDesignHandle();
                    if (ReportPlugin.getDefault().getEnableCommentPreference()) {
                        model.setStringProperty("comments", ReportPlugin.getDefault().getCommentPreference());
                        model.save();
                        editorPart.doSave(null);
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
        });
        monitor.worked(1);
    }

    protected IFolder createFolderHandle(IPath folderPath) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        return workspaceRoot.getFolder(folderPath);
    }
}

