/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.editors;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.ide.adapters.IDEFileReportProvider;
import org.eclipse.birt.report.designer.internal.ui.ide.adapters.LibraryProvider;
import org.eclipse.birt.report.designer.internal.ui.views.ILibraryProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.editors.IReportEditorPage;
import org.eclipse.birt.report.designer.ui.editors.IReportProvider;
import org.eclipse.birt.report.designer.ui.editors.MultiPageReportEditor;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.FileEditorInput;

public class IDEMultiPageReportEditor
extends MultiPageReportEditor {
    private static final String DLG_SAVE_BUTTON_CLOSE = Messages.getString((String)"ReportEditor.Button.Close");
    private static final String DLG_SAVE_BUTTON_SAVE = Messages.getString((String)"ReportEditor.Button.Save");
    private static final String DLG_SAVE_CONFIRM_DELETE = Messages.getString((String)"ReportEditor.Dlg.Confirm");
    private static final String DLG_SAVE_TITLE = Messages.getString((String)"ReportEditor.Dlg.Save");
    private boolean isWorkspaceResource = false;
    private ResourceTracker resourceListener = new ResourceTracker();

    protected void setInput(IEditorInput input) {
        if (this.isWorkspaceResource) {
            this.getFile(this.getEditorInput()).getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceListener);
        }
        this.isWorkspaceResource = input instanceof IFileEditorInput;
        super.setInput(input);
        if (this.isWorkspaceResource) {
            this.getFile(this.getEditorInput()).getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceListener);
        }
    }

    private IFile getFile(IEditorInput editorInput) {
        if (this.isWorkspaceResource) {
            return ((IFileEditorInput)editorInput).getFile();
        }
        return null;
    }

    public void partActivated(IWorkbenchPart part) {
        super.partActivated(part);
        if (part != this) {
            return;
        }
        if (this.isWorkspaceResource && !((IFileEditorInput)this.getEditorInput()).getFile().exists()) {
            String[] buttons;
            String message;
            String title;
            Shell shell = this.getSite().getShell();
            MessageDialog dialog = new MessageDialog(shell, title = DLG_SAVE_TITLE, null, message = DLG_SAVE_CONFIRM_DELETE, 3, buttons = new String[]{DLG_SAVE_BUTTON_SAVE, DLG_SAVE_BUTTON_CLOSE}, 0);
            if (dialog.open() == 0) {
                this.doSaveAs();
                this.partActivated(part);
            } else {
                this.closeEditor(false);
            }
        }
    }

    protected void addPages() {
        super.addPages();
        if (this.isWorkspaceResource) {
            try {
                this.refreshMarkers(this.getEditorInput());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    protected void refreshMarkers(IEditorInput input) throws CoreException {
        IFile file = this.getFile(input);
        file.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        ModuleHandle reportDesignHandle = this.getModel();
        if (reportDesignHandle == null) {
            return;
        }
        List list = reportDesignHandle.getErrorList();
        int errorListSize = list.size();
        list.addAll(reportDesignHandle.getWarningList());
        int m = list.size();
        for (int i = 0; i < m; ++i) {
            ErrorDetail errorDetail = (ErrorDetail)list.get(i);
            IMarker marker = file.createMarker("org.eclipse.core.resources.problemmarker");
            if (i < errorListSize) {
                marker.setAttribute("severity", 2);
            } else {
                marker.setAttribute("severity", 1);
            }
            marker.setAttribute("message", (Object)errorDetail.getMessage());
            marker.setAttribute("lineNumber", errorDetail.getLineNo());
            marker.setAttribute("location", (Object)errorDetail.getTagName());
        }
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        try {
            this.refreshMarkers(this.getEditorInput());
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void dispose() {
        try {
            this.clearMarkers();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (this.isWorkspaceResource) {
            this.getFile(this.getEditorInput()).getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceListener);
        }
        super.dispose();
        this.reportProvider = null;
    }

    protected void clearMarkers() throws CoreException {
        IFile resource = this.getFile(this.getEditorInput());
        if (resource.exists()) {
            resource.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 1);
        }
    }

    public Object getAdapter(Class type) {
        if (type == ILibraryProvider.class) {
            return new LibraryProvider();
        }
        if (type == IReportProvider.class) {
            return this.getProvider();
        }
        return super.getAdapter(type);
    }

    protected IReportProvider getProvider() {
        if (this.reportProvider == null) {
            this.reportProvider = new IDEFileReportProvider();
        }
        return this.reportProvider;
    }

    static /* synthetic */ String access$200() {
        return DLG_SAVE_TITLE;
    }

    static /* synthetic */ String access$300() {
        return DLG_SAVE_CONFIRM_DELETE;
    }

    static /* synthetic */ String access$400() {
        return DLG_SAVE_BUTTON_SAVE;
    }

    static /* synthetic */ String access$500() {
        return DLG_SAVE_BUTTON_CLOSE;
    }

    class ResourceTracker
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        ResourceTracker() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                if (delta != null) {
                    delta.accept((IResourceDeltaVisitor)this);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }

        public boolean visit(IResourceDelta delta) {
            if (delta == null || !delta.getResource().equals(IDEMultiPageReportEditor.this.getFile(IDEMultiPageReportEditor.this.getEditorInput()))) {
                return true;
            }
            if (delta.getKind() == 2) {
                Display display = IDEMultiPageReportEditor.this.getSite().getShell().getDisplay();
                if ((0x2000 & delta.getFlags()) == 0) {
                    display.asyncExec(new Runnable(this){
                        private final /* synthetic */ ResourceTracker this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            if (!ResourceTracker.access$100(this.this$1).isDirty()) {
                                ResourceTracker.access$100(this.this$1).closeEditor(false);
                            } else {
                                String title = IDEMultiPageReportEditor.access$200();
                                String message = IDEMultiPageReportEditor.access$300();
                                String[] buttons = new String[]{IDEMultiPageReportEditor.access$400(), IDEMultiPageReportEditor.access$500()};
                                MessageDialog dialog = new MessageDialog(ResourceTracker.access$100(this.this$1).getSite().getShell(), title, null, message, 3, buttons, 0);
                                if (dialog.open() == 0) {
                                    ResourceTracker.access$100(this.this$1).doSaveAs();
                                } else {
                                    ResourceTracker.access$100(this.this$1).closeEditor(false);
                                }
                            }
                        }
                    });
                } else {
                    IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getMovedToPath());
                    display.asyncExec(new Runnable(this, newFile){
                        private final /* synthetic */ IFile val$newFile;
                        private final /* synthetic */ ResourceTracker this$1;
                        {
                            this.this$1 = this$1;
                            this.val$newFile = val$newFile;
                        }

                        public void run() {
                            FileEditorInput input = new FileEditorInput(this.val$newFile);
                            ResourceTracker.access$600(this.this$1, input);
                        }
                    });
                }
            } else if (delta.getKind() == 4) {
                // empty if block
            }
            return false;
        }

        private void setAllInput(FileEditorInput input) {
            if (IDEMultiPageReportEditor.this.pages == null) {
                return;
            }
            IDEMultiPageReportEditor.this.setInput((IEditorInput)input);
            if (IDEMultiPageReportEditor.this.getEditorInput() != null) {
                IDEMultiPageReportEditor.this.setPartName(IDEMultiPageReportEditor.this.getEditorInput().getName());
                IDEMultiPageReportEditor.this.firePropertyChange(260);
                IDEMultiPageReportEditor.this.firePropertyChange(260);
                IDEMultiPageReportEditor.this.getProvider().getReportModuleHandle((Object)IDEMultiPageReportEditor.this.getEditorInput()).setFileName(IDEMultiPageReportEditor.this.getProvider().getInputPath(IDEMultiPageReportEditor.this.getEditorInput()).toOSString());
            }
            Iterator it = IDEMultiPageReportEditor.this.pages.iterator();
            while (it.hasNext()) {
                Object page = it.next();
                if (!(page instanceof IReportEditorPage)) continue;
                ((IReportEditorPage)page).setInput((IEditorInput)input);
            }
        }

        static /* synthetic */ IDEMultiPageReportEditor access$100(ResourceTracker x0) {
            return x0.IDEMultiPageReportEditor.this;
        }

        static /* synthetic */ void access$600(ResourceTracker x0, FileEditorInput x1) {
            x0.setAllInput(x1);
        }
    }
}

