/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.ide.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewReportProjectWizard
extends BasicNewResourceWizard
implements IExecutableExtension {
    private WizardNewProjectCreationPage mainPage;
    private boolean isJavaProject;
    private Text sourceText;
    private Text outputText;
    private IProject newProject;
    private IConfigurationElement configElement;

    public void addPages() {
        super.addPages();
        this.mainPage = new WizardNewProjectCreationPage("basicNewProjectPage"){

            public void createControl(Composite parent) {
                super.createControl(parent);
                UIUtil.bindHelp((Control)this.getControl(), (String)"org.eclipse.birt.cshelp.NewReportProjectWizard_ID");
            }

            public boolean isPageComplete() {
                return this.validatePage() || super.isPageComplete();
            }
        };
        this.mainPage.setTitle(Messages.getString((String)"NewReportProjectWizard.title"));
        this.mainPage.setDescription(Messages.getString((String)"NewReportProjectWizard.description"));
        this.addPage((IWizardPage)this.mainPage);
    }

    private IProject createNewProject() {
        if (this.newProject != null) {
            return this.newProject;
        }
        final IProject newProjectHandle = this.mainPage.getProjectHandle();
        IPath newPath = null;
        if (!this.mainPage.useDefaults()) {
            newPath = this.mainPage.getLocationPath();
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
        description.setLocation(newPath);
        String[] natures = null;
        natures = this.isJavaProject ? new String[]{"org.eclipse.birt.report.designer.ui.reportprojectnature", "org.eclipse.jdt.core.javanature"} : new String[]{"org.eclipse.birt.report.designer.ui.reportprojectnature"};
        description.setNatureIds(natures);
        if (this.isJavaProject) {
            this.addJavaBuildSpec(description);
        }
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                NewReportProjectWizard.this.createProject(description, newProjectHandle, monitor);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof CoreException) {
                if (((CoreException)t).getStatus().getCode() == 275) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString((String)"NewReportProjectWizard.errorMessage"), (String)Messages.getFormattedString((String)"NewReportProjectWizard.caseVariantExistsError", (Object[])new String[]{newProjectHandle.getName()}));
                } else {
                    ErrorDialog.openError((Shell)this.getShell(), (String)Messages.getString((String)"NewReportProjectWizard.errorMessage"), null, (IStatus)((CoreException)t).getStatus());
                }
            } else {
                ExceptionHandler.handle((Throwable)e);
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString((String)"NewReportProjectWizard.errorMessage"), (String)Messages.getFormattedString((String)"NewReportProjectWizard.internalError", (Object[])new Object[]{t.getMessage()}));
            }
            return null;
        }
        this.newProject = newProjectHandle;
        return this.newProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createProject(IProjectDescription description, IProject projectHandle, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            monitor.beginTask("", 2000);
            projectHandle.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            projectHandle.open((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
        }
        finally {
            monitor.done();
        }
    }

    public IProject getNewProject() {
        return this.newProject;
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.getString((String)"NewReportProjectWizard.windowTitle"));
    }

    public Image getDefaultPageImage() {
        return ReportPlugin.getImage((String)"/icons/wizban/create_project_wizard.gif");
    }

    public boolean performFinish() {
        this.createNewProject();
        if (this.newProject == null) {
            return false;
        }
        if (this.isJavaProject) {
            this.createSourceAndOutputFolder(this.newProject);
            try {
                this.setClasspath(this.newProject);
            }
            catch (JavaModelException e) {
                ExceptionHandler.handle((Throwable)e);
                return false;
            }
            catch (CoreException e) {
                ExceptionHandler.handle((Throwable)e);
                return false;
            }
        }
        this.updatePerspective();
        this.selectAndReveal((IResource)this.newProject);
        return true;
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.configElement = cfig;
    }

    protected void updatePerspective() {
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configElement);
    }

    private void addJavaBuildSpec(IProjectDescription description) {
        ICommand command = description.newCommand();
        command.setBuilderName("org.eclipse.jdt.core.javabuilder");
        description.setBuildSpec(new ICommand[]{command});
    }

    private void createSourceAndOutputFolder(IProject project) {
        IFolder folder;
        if (this.isJavaProject && this.sourceText.getText() != null && this.sourceText.getText().trim().length() > 0 && !(folder = project.getFolder(this.sourceText.getText())).exists()) {
            try {
                this.createFolder(folder);
            }
            catch (CoreException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if (this.isJavaProject && this.outputText.getText() != null && this.outputText.getText().trim().length() > 0 && !(folder = project.getFolder(this.outputText.getText())).exists()) {
            try {
                this.createFolder(folder);
            }
            catch (CoreException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
    }

    private void createFolder(IFolder folder) throws CoreException {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder) {
                this.createFolder((IFolder)parent);
            }
            folder.create(true, true, null);
        }
    }

    private void setClasspath(IProject project) throws JavaModelException, CoreException {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (this.outputText.getText() != null && this.outputText.getText().trim().length() > 0) {
            IPath path = project.getFullPath().append(this.outputText.getText());
            javaProject.setOutputLocation(path, null);
        }
        IClasspathEntry[] entries = this.getClassPathEntries(project);
        javaProject.setRawClasspath(entries, null);
    }

    private IClasspathEntry[] getClassPathEntries(IProject project) {
        IClasspathEntry[] internalClassPathEntries = this.getInternalClassPathEntries(project);
        IClasspathEntry[] entries = new IClasspathEntry[internalClassPathEntries.length + 1];
        System.arraycopy(internalClassPathEntries, 0, entries, 0, internalClassPathEntries.length);
        entries[entries.length - 1] = JavaCore.newContainerEntry((IPath)new Path("org.eclipse.jdt.launching.JRE_CONTAINER"));
        return entries;
    }

    protected IClasspathEntry[] getInternalClassPathEntries(IProject project) {
        if (this.sourceText.getText() == null || this.sourceText.getText().trim().equals("")) {
            return new IClasspathEntry[0];
        }
        IClasspathEntry[] entries = new IClasspathEntry[1];
        IPath path = project.getFullPath().append(this.sourceText.getText());
        entries[0] = JavaCore.newSourceEntry((IPath)path);
        return entries;
    }
}

