/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.ide.wizards;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.wizards.WizardReportSettingPage;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.ide.wizards.NewReportWizard;
import org.eclipse.birt.report.designer.ui.ide.wizards.WizardNewReportCreationPage;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.osgi.framework.Bundle;

public class NewTemplateWizard
extends NewReportWizard {
    private static final String WIZARDPAGE = Messages.getString((String)"NewTemplateWizard.title.WizardPage");
    private static final String OPENING_FILE_FOR_EDITING = Messages.getString((String)"NewTemplateWizard.text.OpenFileForEditing");
    private static final String CREATING = Messages.getString((String)"NewTemplateWizard.text.Creating");
    private static final String NEW_TEMPLATE_FILE_NAME_PREFIX = Messages.getString((String)"NewTemplateWizard.displayName.NewReportFileNamePrefix");
    private static final String NEW_TEMPLATE_DESCRIPTION = Messages.getString((String)"NewTemplateWizard.pageDescription.createNewTemplate");
    private static final String NEW_TEMPLATE_TITLE = Messages.getString((String)"NewTemplateWizard.title.Template");

    public NewTemplateWizard() {
        super(".rpttemplate");
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.setWindowTitle(Messages.getString((String)"NewTemplateWizard.title.New"));
    }

    public void addPages() {
        this.newReportFileWizardPage = new WizardNewReportCreationPage(WIZARDPAGE, this.getSelection(), "rpttemplate");
        this.addPage((IWizardPage)this.newReportFileWizardPage);
        this.resetUniqueCount();
        this.newReportFileWizardPage.setFileName(this.getUniqueReportName(NEW_TEMPLATE_FILE_NAME_PREFIX, this.getFileExtension()));
        this.newReportFileWizardPage.setContainerFullPath(this.getDefaultContainerPath());
        this.newReportFileWizardPage.setDescription(NEW_TEMPLATE_DESCRIPTION);
        this.newReportFileWizardPage.setTitle(NEW_TEMPLATE_TITLE);
        this.settingPage = new WizardReportSettingPage(null);
        this.settingPage.setTitle(Messages.getString((String)"SaveReportAsWizard.SettingPage.title"));
        this.addPage((IWizardPage)this.settingPage);
    }

    public boolean canFinish() {
        return this.newReportFileWizardPage.isPageComplete();
    }

    public boolean performFinish() {
        final IPath containerName = this.newReportFileWizardPage.getContainerFullPath();
        String fn = this.newReportFileWizardPage.getFileName();
        final String fileName = !fn.endsWith(this.getFileExtension()) ? fn + this.getFileExtension() : fn;
        InputStream streamFromPage = null;
        URL url = Platform.find((Bundle)Platform.getBundle((String)"org.eclipse.birt.report.designer.ui"), (IPath)new Path("/templates/blank_report.rptdesign"));
        if (url != null) {
            try {
                streamFromPage = url.openStream();
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
        final InputStream stream = streamFromPage;
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    NewTemplateWizard.this.doFinish(containerName, fileName, stream, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            ExceptionHandler.handle((Throwable)realException);
            return false;
        }
        return true;
    }

    private void doFinish(IPath containerName, String fileName, InputStream stream, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(CREATING + fileName, 2);
        IContainer resource = (IContainer)ResourcesPlugin.getWorkspace().getRoot().findMember(containerName);
        IContainer container = null;
        if (resource == null || !resource.exists() || !(resource instanceof IContainer)) {
            IFolder folder = this.createFolderHandle(containerName);
            UIUtil.createFolder((IFolder)folder, (IProgressMonitor)monitor);
            container = folder;
        } else {
            container = resource;
        }
        final IFile file = container.getFile((IPath)new Path(fileName));
        try {
            if (file.exists()) {
                file.setContents(stream, true, true, monitor);
            } else {
                file.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        monitor.worked(1);
        monitor.setTaskName(OPENING_FILE_FOR_EDITING);
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                try {
                    IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                    ModuleHandle model = SessionHandleAdapter.getInstance().getReportDesignHandle();
                    if (ReportPlugin.getDefault().getEnableCommentPreference()) {
                        model.setStringProperty("comments", ReportPlugin.getDefault().getCommentPreference());
                    }
                    NewTemplateWizard.this.setReportSettings(model);
                    editorPart.doSave(null);
                    BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)NewTemplateWizard.this.getConfigElement());
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
        });
        monitor.worked(1);
    }

    void setReportSettings(Object model) throws IOException {
        ReportDesignHandle handle = (ReportDesignHandle)model;
        try {
            handle.setDisplayName(this.settingPage.getDisplayName());
            handle.setDescription(this.settingPage.getDescription());
            handle.setIconFile(this.settingPage.getPreviewImagePath());
        }
        catch (SemanticException semanticException) {
            // empty catch block
        }
        handle.save();
    }
}

