/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.ide.wizards;

import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class WizardNewReportCreationPage
extends WizardNewFileCreationPage {
    String fileExtension = "rptdesign";

    public WizardNewReportCreationPage(String pageName, IStructuredSelection selection) {
        super(pageName, selection);
    }

    public WizardNewReportCreationPage(String pageName, IStructuredSelection selection, String fileType) {
        this(pageName, selection);
        this.fileExtension = fileType;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        if (this.fileExtension.equals("rpttemplate")) {
            UIUtil.bindHelp((Control)this.getControl(), (String)"org.eclipse.birt.cshelp.NewTemplateWizard_ID");
        } else if (this.fileExtension.equals("rptdesign")) {
            UIUtil.bindHelp((Control)this.getControl(), (String)"org.eclipse.birt.cshelp.NewReportWizard_ID");
        }
    }

    protected void createAdvancedControls(Composite parent) {
    }

    protected IStatus validateLinkedResource() {
        return new Status(0, ReportPlugin.getDefault().getBundle().getSymbolicName(), 0, "", null);
    }

    protected boolean validatePage() {
        String fn;
        boolean rt = super.validatePage();
        if (rt && !(fn = this.getFileName()).endsWith("." + this.fileExtension)) {
            IPath resourcePath = this.getContainerFullPath().append(this.getFileName() + "." + this.fileExtension);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            if (workspace.getRoot().getFolder(resourcePath).exists() || workspace.getRoot().getFile(resourcePath).exists()) {
                this.setErrorMessage(Messages.getString((String)"WizardNewReportCreationPage.Errors.nameExists"));
                rt = false;
            }
        }
        return rt;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }
}

