/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.reportitem.i18n.Messages;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.BaseQueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.InputParameterBinding;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SubqueryDefinition;
import org.eclipse.birt.report.engine.adapter.ModelDteApiAdapter;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.emf.common.util.EList;

public final class QueryHelper {
    private static final String BASE_SERIES = Messages.getString("QueryHelper.Text.CategroySeries");
    private static final String ORTHOGONAL_SERIES = Messages.getString("QueryHelper.Text.ValueSeries");
    private static final String X_SERIES = Messages.getString("QueryHelper.Text.XSeries");
    private static final String Y_SERIES = Messages.getString("QueryHelper.Text.YSeries");
    private static final SeriesQueries[] CAST_SERIES_QUERY_ARRAY = new SeriesQueries[0];
    public static final String[] CAST_STRING_ARRAY = new String[0];

    final IBaseQueryDefinition build(ExtendedItemHandle eih, IBaseQueryDefinition ibqdParent, Chart cm) throws ChartException {
        Object ibqd = null;
        ibqd = eih.getDataSet() == null ? new SubqueryDefinition("chart_subquery") : new QueryDefinition((BaseQueryDefinition)ibqdParent);
        DataSetHandle dsh = eih.getDataSet();
        if (dsh != null && ibqd instanceof QueryDefinition) {
            ((QueryDefinition)ibqd).setDataSetName(dsh.getQualifiedName());
            this.fillParamBindings(eih, (QueryDefinition)ibqd);
            this.addFilters(eih, (QueryDefinition)ibqd);
        }
        Iterator itr = eih.getColumnBindings().iterator();
        while (itr.hasNext()) {
            ComputedColumnHandle cch = (ComputedColumnHandle)itr.next();
            ScriptExpression sxp = new ScriptExpression(cch.getExpression());
            sxp.setDataType(ModelDteApiAdapter.toDteDataType((String)cch.getDataType()));
            if (ibqd instanceof QueryDefinition) {
                ((QueryDefinition)ibqd).addResultSetExpression(cch.getName(), (IBaseExpression)sxp);
                continue;
            }
            if (!(ibqd instanceof SubqueryDefinition)) continue;
            ibqd.addResultSetExpression(cch.getName(), (IBaseExpression)sxp);
        }
        return ibqd;
    }

    public final SeriesQueries[] getSeriesQueryDefinitions(Chart cm) {
        if (cm instanceof ChartWithAxes) {
            return this.getSeriesQueryDefinitions((ChartWithAxes)cm);
        }
        if (cm instanceof ChartWithoutAxes) {
            return this.getSeriesQueryDefinitions((ChartWithoutAxes)cm);
        }
        return null;
    }

    final SeriesQueries[] getSeriesQueryDefinitions(ChartWithAxes cwa) {
        ArrayList<SeriesQueries> alSeriesQueries = new ArrayList<SeriesQueries>(4);
        Axis axPrimaryBase = cwa.getPrimaryBaseAxes()[0];
        EList elSD = axPrimaryBase.getSeriesDefinitions();
        if (elSD.size() != 1) {
            return alSeriesQueries.toArray(CAST_SERIES_QUERY_ARRAY);
        }
        SeriesDefinition sd = (SeriesDefinition)elSD.get(0);
        Series seBase = sd.getDesignTimeSeries();
        EList elBaseSeries = seBase.getDataDefinition();
        Query[] qua = new Query[elBaseSeries.size()];
        SeriesQueries sqd = new SeriesQueries(X_SERIES, qua);
        for (int i = 0; i < elBaseSeries.size(); ++i) {
            qua[i] = (Query)elBaseSeries.get(i);
        }
        alSeriesQueries.add(sqd);
        Axis[] axaOrthogonal = cwa.getOrthogonalAxes(axPrimaryBase, true);
        for (int j = 0; j < axaOrthogonal.length; ++j) {
            elSD = axaOrthogonal[j].getSeriesDefinitions();
            for (int k = 0; k < elSD.size(); ++k) {
                sd = (SeriesDefinition)elSD.get(k);
                Series seOrthogonal = sd.getDesignTimeSeries();
                EList elOrthogonalSeries = seOrthogonal.getDataDefinition();
                qua = new Query[elOrthogonalSeries.size()];
                sqd = new SeriesQueries(Y_SERIES, qua);
                for (int i = 0; i < elOrthogonalSeries.size(); ++i) {
                    qua[i] = (Query)elOrthogonalSeries.get(i);
                }
                alSeriesQueries.add(sqd);
            }
        }
        return alSeriesQueries.toArray(CAST_SERIES_QUERY_ARRAY);
    }

    final SeriesQueries[] getSeriesQueryDefinitions(ChartWithoutAxes cwoa) {
        ArrayList<SeriesQueries> alSeriesQueries = new ArrayList<SeriesQueries>(4);
        EList elSD = cwoa.getSeriesDefinitions();
        if (elSD.size() != 1) {
            return alSeriesQueries.toArray(CAST_SERIES_QUERY_ARRAY);
        }
        SeriesDefinition sd = (SeriesDefinition)elSD.get(0);
        Series seBase = sd.getDesignTimeSeries();
        EList elBaseSeries = seBase.getDataDefinition();
        Query[] qua = new Query[elBaseSeries.size()];
        SeriesQueries sqd = new SeriesQueries(BASE_SERIES, qua);
        for (int i = 0; i < elBaseSeries.size(); ++i) {
            qua[i] = (Query)elBaseSeries.get(i);
        }
        alSeriesQueries.add(sqd);
        elSD = sd.getSeriesDefinitions();
        for (int k = 0; k < elSD.size(); ++k) {
            sd = (SeriesDefinition)elSD.get(k);
            Series seOrthogonal = sd.getDesignTimeSeries();
            EList elOrthogonalSeries = seOrthogonal.getDataDefinition();
            qua = new Query[elOrthogonalSeries.size()];
            sqd = new SeriesQueries(ORTHOGONAL_SERIES, qua);
            for (int i = 0; i < elOrthogonalSeries.size(); ++i) {
                qua[i] = (Query)elOrthogonalSeries.get(i);
            }
            alSeriesQueries.add(sqd);
        }
        return alSeriesQueries.toArray(CAST_SERIES_QUERY_ARRAY);
    }

    protected void fillParamBindings(ExtendedItemHandle eih, QueryDefinition queryDef) {
        Iterator iterator = eih.paramBindingsIterator();
        while (iterator.hasNext()) {
            ParamBindingHandle paramBinding = (ParamBindingHandle)iterator.next();
            ScriptExpression paramValueExpr = new ScriptExpression(paramBinding.getExpression());
            InputParameterBinding inputParamBinding = new InputParameterBinding(paramBinding.getParamName(), (IBaseExpression)paramValueExpr);
            queryDef.addInputParamBinding(inputParamBinding);
        }
    }

    protected void addFilters(ExtendedItemHandle eih, QueryDefinition queryDef) {
        Iterator filtersIter = eih.getPropertyHandle("filter").iterator();
        while (filtersIter.hasNext()) {
            FilterConditionHandle filterCon = (FilterConditionHandle)filtersIter.next();
            queryDef.addFilter(this.createFilter(filterCon));
        }
    }

    private IFilterDefinition createFilter(FilterConditionHandle handle) {
        String filterExpr = handle.getExpr();
        if (filterExpr == null || filterExpr.length() == 0) {
            return null;
        }
        String filterOpr = handle.getOperator();
        if (filterOpr == null || filterOpr.length() == 0) {
            return new FilterDefinition((IBaseExpression)new ScriptExpression(filterExpr));
        }
        String column = filterExpr;
        int dteOpr = this.toDteFilterOperator(filterOpr);
        String operand1 = handle.getValue1();
        String operand2 = handle.getValue2();
        return new FilterDefinition((IBaseExpression)new ConditionalExpression(column, dteOpr, operand1, operand2));
    }

    private int toDteFilterOperator(String modelOpr) {
        if (modelOpr.equals("eq")) {
            return 1;
        }
        if (modelOpr.equals("ne")) {
            return 2;
        }
        if (modelOpr.equals("lt")) {
            return 3;
        }
        if (modelOpr.equals("le")) {
            return 4;
        }
        if (modelOpr.equals("ge")) {
            return 5;
        }
        if (modelOpr.equals("gt")) {
            return 6;
        }
        if (modelOpr.equals("between")) {
            return 7;
        }
        if (modelOpr.equals("not-between")) {
            return 8;
        }
        if (modelOpr.equals("is-null")) {
            return 9;
        }
        if (modelOpr.equals("is-not-null")) {
            return 10;
        }
        if (modelOpr.equals("is-true")) {
            return 11;
        }
        if (modelOpr.equals("is-false")) {
            return 12;
        }
        if (modelOpr.equals("like")) {
            return 13;
        }
        if (modelOpr.equals("top-n")) {
            return 14;
        }
        if (modelOpr.equals("bottom-n")) {
            return 15;
        }
        if (modelOpr.equals("top-percent")) {
            return 16;
        }
        if (modelOpr.equals("bottom-percent")) {
            return 17;
        }
        if (modelOpr.equals("match")) {
            return 19;
        }
        if (modelOpr.equals("not-like")) {
            return 20;
        }
        if (modelOpr.equals("not-match")) {
            return 21;
        }
        return 0;
    }

    public static final class SeriesQueries {
        private final String sSeriesType;
        private final Query[] qua;

        SeriesQueries(String sSeriesType, Query[] qua) {
            this.sSeriesType = sSeriesType;
            this.qua = qua;
        }

        public Collection validate() {
            ArrayList<String> al = null;
            for (int i = 0; i < this.qua.length; ++i) {
                if (this.qua[i].isDefined()) continue;
                if (al == null) {
                    al = new ArrayList(this.qua.length);
                }
                al.add(Messages.getString("SeriesQueries.dataDefnUndefined", this.sSeriesType));
            }
            if (this.qua.length == 0) {
                al = new ArrayList<String>(this.qua.length);
                al.add(Messages.getString("SeriesQueries.NoDataDefinitionFor", this.sSeriesType));
            }
            return al;
        }
    }
}

