/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.sourcelookup;

import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupManager;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupUIMessages;
import org.eclipse.debug.internal.ui.views.launch.LaunchView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.sourcelookup.SourceLookupDialog;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionListenerAction;

public class EditSourceLookupPathAction
extends SelectionListenerAction {
    private ISourceLookupDirector director = null;
    private LaunchView fView = null;

    public EditSourceLookupPathAction(LaunchView view) {
        super(SourceLookupUIMessages.EditSourceLookupPathAction_0);
        this.setEnabled(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, IDebugHelpContextIds.EDIT_SOURCELOOKUP_ACTION);
        this.setImageDescriptor(DebugUITools.getImageDescriptor("IMG_SRC_LOOKUP_MENU"));
        this.fView = view;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        this.director = null;
        if (selection.size() == 1) {
            Object object = selection.getFirstElement();
            ILaunch launch = null;
            if (object instanceof IDebugElement) {
                launch = ((IDebugElement)object).getLaunch();
            } else if (object instanceof ILaunch) {
                launch = (ILaunch)object;
            }
            if (launch != null && launch.getLaunchConfiguration() != null && launch.getSourceLocator() instanceof ISourceLookupDirector) {
                this.director = (ISourceLookupDirector)launch.getSourceLocator();
            }
        }
        return this.director != null;
    }

    public void run() {
        IStructuredSelection ss;
        ISelection selection;
        Shell shell = DebugUIPlugin.getShell();
        SourceLookupDialog dialog = new SourceLookupDialog(shell, this.director);
        if (dialog.open() == 0 && (selection = this.fView.getViewer().getSelection()) instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1) {
            IWorkbenchPage page = this.fView.getSite().getPage();
            SourceLookupManager.getDefault().displaySource(ss.getFirstElement(), page, true);
        }
    }
}

