/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.viewer.browsers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.birt.report.viewer.ViewerPlugin;
import org.eclipse.birt.report.viewer.browsers.BrowserDescriptor;
import org.eclipse.birt.report.viewer.browsers.CurrentBrowser;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.browser.IBrowser;
import org.eclipse.help.browser.IBrowserFactory;

public class BrowserManager {
    public static final String ALWAYS_EXTERNAL_BROWSER_KEY = "always_external_browser";
    public static final String DEFAULT_BROWSER_ID_KEY = "default_browser";
    public static final String BROWSER_ID_CUSTOM = "org.eclipse.birt.report.viewer.custombrowser";
    public static final String BROWSER_ID_EMBEDDED = "org.eclipse.birt.report.viewer.embeddedbrowser";
    public static final String BROWSER_ID_SYSTEM = "org.eclipse.birt.report.viewer.systembrowser";
    private static BrowserManager instance;
    private Collection browsers = new ArrayList();
    private BrowserDescriptor[] browsersDescriptors;
    private BrowserDescriptor currentBrowserDesc;
    private BrowserDescriptor defaultBrowserDesc;
    private BrowserDescriptor internalBrowserDesc;
    private boolean alwaysUseExternal = false;

    public static BrowserManager getInstance() {
        if (instance == null) {
            instance = new BrowserManager();
            instance.init();
        }
        return instance;
    }

    private BrowserManager() {
    }

    private void init() {
        String string;
        this.browsersDescriptors = this.createBrowserDescriptors();
        String string2 = ViewerPlugin.getDefault().getPluginPreferences().getDefaultString(DEFAULT_BROWSER_ID_KEY);
        if (string2 != null && !"".equals(string2)) {
            this.setDefaultBrowserID(string2);
        }
        if (this.defaultBrowserDesc == null) {
            this.setDefaultBrowserID(BROWSER_ID_EMBEDDED);
        }
        String string3 = Platform.getOS();
        if (this.defaultBrowserDesc == null && "win32".equalsIgnoreCase(string3)) {
            this.setDefaultBrowserID(BROWSER_ID_SYSTEM);
        }
        if (this.defaultBrowserDesc == null) {
            for (int i = 0; i < this.browsersDescriptors.length; ++i) {
                if (!BROWSER_ID_CUSTOM.equals(this.browsersDescriptors[i].getID())) continue;
                this.defaultBrowserDesc = this.browsersDescriptors[i];
            }
        }
        if (this.defaultBrowserDesc == null) {
            this.setDefaultBrowserID(BROWSER_ID_CUSTOM);
        }
        if ((string = ViewerPlugin.getDefault().getPluginPreferences().getString(DEFAULT_BROWSER_ID_KEY)) != null && !"".equals(string)) {
            this.setCurrentBrowserID(string);
        }
        if (this.currentBrowserDesc == null) {
            this.setCurrentBrowserID(this.getDefaultBrowserID());
        }
        this.setAlwaysUseExternal(ViewerPlugin.getDefault().getPluginPreferences().getBoolean(ALWAYS_EXTERNAL_BROWSER_KEY));
    }

    private BrowserDescriptor[] createBrowserDescriptors() {
        if (this.browsersDescriptors != null) {
            return this.browsersDescriptors;
        }
        ArrayList<BrowserDescriptor> arrayList = new ArrayList<BrowserDescriptor>();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.birt.report.viewer", "browser");
        for (int i = 0; i < iConfigurationElementArray.length; ++i) {
            String string;
            String string2;
            if (!iConfigurationElementArray[i].getName().equals("browser") || (string2 = iConfigurationElementArray[i].getAttribute("id")) == null || (string = iConfigurationElementArray[i].getAttribute("name")) == null) continue;
            try {
                Object object = iConfigurationElementArray[i].createExecutableExtension("factoryclass");
                if (!(object instanceof IBrowserFactory) || !((IBrowserFactory)object).isAvailable()) continue;
                BrowserDescriptor browserDescriptor = new BrowserDescriptor(string2, string, (IBrowserFactory)object);
                if (browserDescriptor.isExternal()) {
                    arrayList.add(browserDescriptor);
                    continue;
                }
                this.internalBrowserDesc = browserDescriptor;
                continue;
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        this.browsersDescriptors = arrayList.toArray(new BrowserDescriptor[arrayList.size()]);
        return this.browsersDescriptors;
    }

    public BrowserDescriptor[] getBrowserDescriptors() {
        return this.browsersDescriptors;
    }

    public String getCurrentBrowserID() {
        if (this.currentBrowserDesc == null) {
            return null;
        }
        return this.currentBrowserDesc.getID();
    }

    public String getCurrentInternalBrowserID() {
        if (this.isEmbeddedBrowserPresent() && !this.alwaysUseExternal) {
            return this.internalBrowserDesc.getID();
        }
        return this.getCurrentBrowserID();
    }

    public String getDefaultBrowserID() {
        if (this.defaultBrowserDesc == null) {
            return null;
        }
        return this.defaultBrowserDesc.getID();
    }

    public void setCurrentBrowserID(String string) {
        for (int i = 0; i < this.browsersDescriptors.length; ++i) {
            if (!this.browsersDescriptors[i].getID().equals(string)) continue;
            this.currentBrowserDesc = this.browsersDescriptors[i];
            return;
        }
    }

    private void setDefaultBrowserID(String string) {
        for (int i = 0; i < this.browsersDescriptors.length; ++i) {
            if (!this.browsersDescriptors[i].getID().equals(string)) continue;
            this.defaultBrowserDesc = this.browsersDescriptors[i];
            return;
        }
    }

    public IBrowser createBrowser(boolean bl) {
        if (bl) {
            return new CurrentBrowser(this.createBrowserAdapter(true), this.getCurrentBrowserID(), true);
        }
        return new CurrentBrowser(this.createBrowserAdapter(this.alwaysUseExternal), this.getCurrentInternalBrowserID(), false);
    }

    public IBrowser createBrowser() {
        return this.createBrowser(true);
    }

    private IBrowser createBrowserAdapter(boolean bl) {
        IBrowser iBrowser = null;
        iBrowser = !bl && this.isEmbeddedBrowserPresent() ? this.internalBrowserDesc.getFactory().createBrowser() : this.currentBrowserDesc.getFactory().createBrowser();
        this.browsers.add(iBrowser);
        return iBrowser;
    }

    public void closeAll() {
        Iterator iterator = this.browsers.iterator();
        while (iterator.hasNext()) {
            IBrowser iBrowser = (IBrowser)iterator.next();
            iBrowser.close();
        }
    }

    public boolean isEmbeddedBrowserPresent() {
        return this.internalBrowserDesc != null;
    }

    public void setAlwaysUseExternal(boolean bl) {
        this.alwaysUseExternal = bl || !this.isEmbeddedBrowserPresent();
    }
}

