/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.viewer.utilities;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class ViewerClassPathHelper {
    protected static boolean inDevelopmentMode = false;
    protected static String[] devDefaultClasspath;
    protected static Properties devProperties;

    public static String[] getDevClassPath(String string) {
        String string2;
        String[] stringArray = null;
        if (string != null && devProperties != null && (string2 = devProperties.getProperty(string)) != null) {
            stringArray = ViewerClassPathHelper.getArrayFromList(string2);
        }
        if (stringArray == null) {
            stringArray = devDefaultClasspath;
        }
        return stringArray;
    }

    public static String[] getArrayFromList(String string) {
        if (string == null || string.trim().equals("")) {
            return new String[0];
        }
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.equals("")) continue;
            vector.addElement(string2);
        }
        return vector.isEmpty() ? new String[]{} : vector.toArray(new String[vector.size()]);
    }

    public static boolean inDevelopmentMode() {
        return inDevelopmentMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties load(URL uRL) {
        Properties properties = new Properties();
        try {
            InputStream inputStream = null;
            try {
                inputStream = uRL.openStream();
                properties.load(inputStream);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties;
    }

    static {
        devProperties = null;
        String string = System.getProperty("osgi.dev");
        if (string != null) {
            try {
                inDevelopmentMode = true;
                URL uRL = new URL(string);
                devProperties = ViewerClassPathHelper.load(uRL);
                if (devProperties != null) {
                    devDefaultClasspath = ViewerClassPathHelper.getArrayFromList(devProperties.getProperty("*"));
                }
            }
            catch (MalformedURLException malformedURLException) {
                devDefaultClasspath = ViewerClassPathHelper.getArrayFromList(string);
            }
        }
    }
}

