/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.viewer.utilities;

import java.io.IOException;
import java.net.URL;
import org.eclipse.birt.report.viewer.ViewerPlugin;
import org.eclipse.birt.report.viewer.utilities.AppServerWrapper;
import org.eclipse.birt.report.viewer.utilities.ViewerClassLoaderWrapper;
import org.eclipse.birt.report.viewer.utilities.WorkspaceClasspathManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.internal.appserver.IWebappServer;
import org.osgi.framework.Bundle;

public class WebappAccessor {
    private static final String WORKSPACE_CLASSPATH_KEY = "workspace.projectclasspath";
    private static boolean applicationsStarted = false;

    private WebappAccessor() {
    }

    public static synchronized void start(String string, String string2, IPath iPath) throws CoreException {
        String string3 = WorkspaceClasspathManager.getClassPath();
        if (string3 == null) {
            string3 = "";
        }
        System.setProperty(WORKSPACE_CLASSPATH_KEY, string3);
        if (!applicationsStarted) {
            IPath iPath2 = WebappAccessor.getWebappPath(string2, iPath);
            IWebappServer iWebappServer = AppServerWrapper.getInstance().getAppServer();
            ViewerClassLoaderWrapper viewerClassLoaderWrapper = new ViewerClassLoaderWrapper(string2);
            iWebappServer.start(string, iPath2, (ClassLoader)viewerClassLoaderWrapper);
            applicationsStarted = true;
        }
    }

    public static void stop(String string) throws CoreException {
        if (!applicationsStarted) {
            return;
        }
        AppServerWrapper.getInstance().getAppServer().stop(string);
    }

    public static int getPort() {
        try {
            return AppServerWrapper.getInstance().getAppServer().getPort();
        }
        catch (CoreException coreException) {
            return 0;
        }
    }

    public static String getHost() {
        try {
            return AppServerWrapper.getInstance().getAppServer().getHost();
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private static IPath getWebappPath(String string, IPath iPath) throws CoreException {
        Bundle bundle = Platform.getBundle((String)string);
        if (bundle == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.birt.report.viewer", 0, ViewerPlugin.getFormattedResourceString("viewer.appserver.cannotfindplugin", new Object[]{string}), null));
        }
        URL uRL = Platform.find((Bundle)bundle, (IPath)iPath);
        if (uRL == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.birt.report.viewer", 0, ViewerPlugin.getFormattedResourceString("viewer.appserver.cannotfindpath", new Object[]{string, iPath.toOSString()}), null));
        }
        try {
            String string2 = Platform.asLocalURL((URL)Platform.resolve((URL)uRL)).getFile();
            string2 = string2 + "birt/";
            return new Path(string2);
        }
        catch (IOException iOException) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.birt.report.viewer", 0, ViewerPlugin.getFormattedResourceString("viewer.appserver.cannotresolvepath", new Object[]{string, iPath.toOSString()}), (Throwable)iOException));
        }
    }
}

