/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.ui.frameworks.taskwizard;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Vector;
import org.eclipse.birt.core.ui.frameworks.errordisplay.ErrorDialog;
import org.eclipse.birt.core.ui.frameworks.taskwizard.TasksManager;
import org.eclipse.birt.core.ui.frameworks.taskwizard.interfaces.IRegistrationListener;
import org.eclipse.birt.core.ui.frameworks.taskwizard.interfaces.ITask;
import org.eclipse.birt.core.ui.frameworks.taskwizard.interfaces.IWizardContext;
import org.eclipse.birt.core.ui.i18n.Messages;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class WizardBase
implements IRegistrationListener {
    private transient LinkedHashMap availableTasks = null;
    private transient Vector vTaskIDs = null;
    private transient String sCurrentActiveTask = null;
    protected transient IWizardContext context = null;
    private transient String sWizardID = "";
    private transient Shell shellParent = null;
    private transient Object[] errorHints = null;
    private WizardBaseDialog dialog;
    static /* synthetic */ Class class$org$eclipse$birt$core$ui$frameworks$taskwizard$WizardBase;

    public IWizardContext open(String[] sTasks, String topTaskId, IWizardContext initialContext) {
        this.context = initialContext;
        WizardBaseDialog.access$002(this.dialog, sTasks);
        this.dialog.tmpTopTaskId = topTaskId;
        return this.dialog.open() == 0 ? this.context : null;
    }

    public IWizardContext open(IWizardContext initialContext) {
        return this.open(null, null, initialContext);
    }

    public void setMinimumSize(int iWidth, int iHeight) {
        this.dialog.setMinimumSize(iWidth, iHeight);
    }

    public void firePageChanged(IDialogPage taskPage) {
        this.dialog.firePageChanged(new PageChangedEvent((IPageChangeProvider)this.dialog, (Object)taskPage));
    }

    public void addTask(String sTaskID) {
        ITask task = TasksManager.instance().getTask(sTaskID);
        if (task == null) {
            try {
                throw new RuntimeException("Task " + sTaskID + " is not registered!");
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                return;
            }
        }
        task.setUIProvider(this);
        if (!this.vTaskIDs.contains(sTaskID)) {
            this.availableTasks.put(sTaskID, task);
            this.vTaskIDs.add(sTaskID);
        }
    }

    public void removeTask(String sTaskID) {
        if (this.vTaskIDs.size() == 1) {
            throw new RuntimeException("There is only one task left in the wizard...you are not allowed to remove all tasks from a wizard!");
        }
        if (this.availableTasks.containsKey(sTaskID)) {
            this.availableTasks.remove(sTaskID);
            int iTaskIndex = this.vTaskIDs.indexOf(sTaskID);
            this.vTaskIDs.remove(iTaskIndex);
            this.switchTo((String)this.vTaskIDs.get(0));
        }
    }

    public ITask getCurrentTask() {
        return (ITask)this.availableTasks.get(this.sCurrentActiveTask);
    }

    public void switchTo(String sTaskID) {
        if (this.sCurrentActiveTask != null) {
            ErrorDialog ed;
            String[] sErrors = this.getCurrentTask().getErrors();
            if (sErrors != null && sErrors.length > 0 && (ed = new ErrorDialog(this.shellParent, Messages.getString("WizardBase.error.ErrorsEncountered"), Messages.getString("WizardBase.error.FollowingErrorsReportedByTask"), sErrors, new String[0])).getOption() == "ACCEPT") {
                return;
            }
            this.context = this.getCurrentTask().getContext();
        }
        this.sCurrentActiveTask = sTaskID;
        if (this.errorHints != null) {
            this.getCurrentTask().setErrorHints(this.errorHints);
        }
        this.getCurrentTask().setContext(this.context);
        this.errorHints = null;
        this.detachPopup();
        this.dialog.switchTask();
    }

    public Shell createPopupContainer() {
        return this.dialog.createPopupContainer();
    }

    public Shell getPopupContainer() {
        return this.dialog.getPopupContainer();
    }

    public void attachPopup(String sPopupTitle, int iWidth, int iHeight) {
        this.dialog.attachPopup(sPopupTitle, iWidth, iHeight);
    }

    public void detachPopup() {
        this.dialog.detachPopup();
    }

    public void updateContext(IWizardContext wizardcontext) {
        this.context = wizardcontext;
    }

    public WizardBase(String sID) {
        this(sID, -1, -1, null, null, null, null);
    }

    public WizardBase(String sID, int iInitialWidth, int iInitialHeight, String strTitle, Image imgTitle, String strHeader, Image imgHeader) {
        this.sWizardID = sID;
        TasksManager.instance();
        this.availableTasks = new LinkedHashMap();
        this.vTaskIDs = new Vector();
        Shell shell = this.shellParent == null ? new Shell(Display.getDefault(), 67696) : new Shell(this.shellParent, 67696);
        this.dialog = new WizardBaseDialog(shell, iInitialWidth, iInitialHeight, strTitle, imgTitle);
        this.dialog.setTitleImage(imgHeader);
    }

    public WizardBase() {
        this("org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase");
    }

    public void clearCache() {
        this.availableTasks.clear();
        this.vTaskIDs.clear();
    }

    public static void displayException(Throwable t) {
        new ErrorDialog(null, Messages.getString("WizardBase.error.ErrorsEncountered"), Messages.getString("WizardBase.error.FollowingErrorEncountered"), t);
    }

    public void displayError(String[] sErrors, String[] sFixes, String[] sTaskIDs, IWizardContext currentContext, Object[] hints) {
        if (sErrors != null && sErrors.length > 0) {
            this.errorHints = hints;
            ErrorDialog dlg = new ErrorDialog(this.shellParent, Messages.getString("WizardBase.error.ErrorsEncountered"), Messages.getString("WizardBase.error.FollowingErrorEncountered"), sErrors, sFixes);
            if (dlg.getOption() == "ACCEPT") {
                // empty if block
            }
        }
    }

    protected void setParentShell(Shell parentShell) {
        this.shellParent = parentShell;
    }

    public void taskRegistered(String sTaskID) {
    }

    public void taskDeregistered(String sTaskID) {
    }

    protected String[] validate() {
        return null;
    }

    public void dispose() {
    }

    protected void setTitle(String wizardTitle) {
        this.dialog.wizardTitle = wizardTitle;
    }

    public void packWizard() {
        this.dialog.packWizard();
    }

    final class WizardBaseDialog
    extends TitleAreaDialog
    implements SelectionListener,
    ControlListener,
    DisposeListener,
    IPageChangeProvider {
        private ListenerList pageChangedListeners;
        private transient CTabFolder cmpTaskContainer;
        private transient int iWizardHeightMinimum;
        private transient int iWizardWidthMinimum;
        private transient String wizardTitle;
        private transient Image imgShell;
        private transient Shell shellPopup;
        private transient String[] tmpTaskArray;
        private transient String tmpTopTaskId;
        static final /* synthetic */ boolean $assertionsDisabled;

        public WizardBaseDialog(Shell parentShell, int iInitialWidth, int iInitialHeight, String strTitle, Image imgTitle) {
            super(parentShell);
            this.pageChangedListeners = new ListenerList();
            this.iWizardHeightMinimum = 100;
            this.iWizardWidthMinimum = 100;
            this.wizardTitle = "Task Wizard";
            this.imgShell = null;
            this.shellPopup = null;
            this.setHelpAvailable(true);
            this.iWizardWidthMinimum = iInitialWidth;
            this.iWizardHeightMinimum = iInitialHeight;
            this.wizardTitle = strTitle;
            this.imgShell = imgTitle;
        }

        protected void setShellStyle(int newShellStyle) {
            super.setShellStyle(newShellStyle | 0x860 | 0x10 | 0x10000);
        }

        private void configureTaskContext(String[] sTasks, String topTaskId) {
            int i;
            String[] allTasks = TasksManager.instance().getTasksForWizard(WizardBase.this.sWizardID);
            for (i = 0; i < allTasks.length; ++i) {
                WizardBase.this.addTask(allTasks[i]);
            }
            if (sTasks != null && sTasks.length > 0) {
                for (i = 0; i < sTasks.length; ++i) {
                    if (WizardBase.this.vTaskIDs.contains(sTasks[i])) continue;
                    WizardBase.this.addTask(sTasks[i]);
                }
            }
            if (topTaskId == null) {
                if (WizardBase.this.vTaskIDs.size() > 0) {
                    WizardBase.this.sCurrentActiveTask = WizardBase.this.vTaskIDs.get(0).toString();
                }
            } else {
                if (!$assertionsDisabled && !WizardBase.this.vTaskIDs.contains(topTaskId)) {
                    throw new AssertionError();
                }
                WizardBase.this.sCurrentActiveTask = topTaskId;
            }
        }

        protected void initializeBounds() {
            this.getShell().setText(this.wizardTitle);
            this.setTitle(this.wizardTitle);
            if (this.imgShell != null) {
                this.getShell().setImage(this.imgShell);
            }
            this.getShell().addControlListener((ControlListener)this);
            this.getShell().addDisposeListener((DisposeListener)this);
            String[] allTasks = TasksManager.instance().getTasksForWizard(WizardBase.this.sWizardID);
            for (int i = 0; i < allTasks.length; ++i) {
                CTabItem item = new CTabItem(this.getTabContainer(), 0);
                item.setText(TasksManager.instance().getTask(allTasks[i]).getTitle());
                item.setData((Object)allTasks[i]);
            }
            if (this.tmpTopTaskId != null) {
                int taskIndex = WizardBase.this.vTaskIDs.indexOf(this.tmpTopTaskId);
                this.cmpTaskContainer.setSelection(taskIndex);
            }
            if (WizardBase.this.getCurrentTask() != null) {
                WizardBase.this.getCurrentTask().setContext(WizardBase.this.context);
                WizardBase.this.switchTo(WizardBase.this.sCurrentActiveTask);
            }
            super.initializeBounds();
            this.getShell().setLocation(this.getShell().getDisplay().getClientArea().width / 2 - this.getShell().getSize().x / 2, this.getShell().getDisplay().getClientArea().height / 2 - this.getShell().getSize().y / 2);
        }

        public void create() {
            this.configureTaskContext(this.tmpTaskArray, this.tmpTopTaskId);
            super.create();
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.verticalSpacing = 0;
            layout.horizontalSpacing = 0;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(1808));
            composite.setFont(parent.getFont());
            Label lblSeparator = new Label(composite, 258);
            lblSeparator.setLayoutData((Object)new GridData(768));
            this.cmpTaskContainer = new CTabFolder(composite, 0x800080);
            this.cmpTaskContainer.setLayoutData((Object)new GridData(1808));
            this.cmpTaskContainer.setTabHeight(25);
            this.cmpTaskContainer.addSelectionListener((SelectionListener)this);
            lblSeparator = new Label(composite, 258);
            lblSeparator.setLayoutData((Object)new GridData(768));
            FormData layoutData = (FormData)this.getTitleImageLabel().getParent().getLayoutData();
            layoutData.width = this.iWizardWidthMinimum;
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 14, Messages.getString("WizardBase.Back"), false);
            this.createButton(parent, 15, Messages.getString("WizardBase.Next"), false);
            this.createButton(parent, 16, Messages.getString("WizardBase.Finish"), false);
            this.createButton(parent, 1, Messages.getString("WizardBase.Cancel"), false);
            int taskIndex = WizardBase.this.vTaskIDs.indexOf(WizardBase.this.sCurrentActiveTask);
            if (taskIndex > 0) {
                this.getButton(14).setEnabled(true);
            } else {
                this.getButton(14).setEnabled(false);
            }
            if (taskIndex < WizardBase.this.vTaskIDs.size() - 1) {
                this.getButton(15).setEnabled(true);
            } else {
                this.getButton(15).setEnabled(false);
            }
            this.getButton(1).setFocus();
        }

        protected void buttonPressed(int buttonId) {
            if (16 == buttonId) {
                this.okPressed();
            } else if (1 == buttonId) {
                this.cancelPressed();
            } else if (14 == buttonId) {
                this.backPressed();
            } else if (15 == buttonId) {
                this.nextPressed();
            }
        }

        void switchTask() {
            String strDesc = WizardBase.this.getCurrentTask().getDescription();
            if (strDesc != null) {
                this.setMessage(strDesc);
            }
            if (this.getTabContainer().getSelectionIndex() < 0) {
                this.getTabContainer().setSelection(0);
            }
            CTabItem currentItem = this.getTabContainer().getItem(this.getTabContainer().getSelectionIndex());
            WizardBase.this.getCurrentTask().createControl((Composite)this.getTabContainer());
            if (currentItem.getControl() == null) {
                currentItem.setControl(WizardBase.this.getCurrentTask().getControl());
            }
            this.packWizard();
            this.firePageChanged(new PageChangedEvent((IPageChangeProvider)this, (Object)WizardBase.this.getCurrentTask()));
        }

        private void backPressed() {
            int i = WizardBase.this.vTaskIDs.indexOf(WizardBase.this.sCurrentActiveTask);
            if (i > 0) {
                this.cmpTaskContainer.setSelection(i - 1);
                WizardBase.this.switchTo((String)WizardBase.this.vTaskIDs.get(i - 1));
                this.getButton(15).setEnabled(true);
            }
            if (i == 1) {
                this.getButton(14).setEnabled(false);
            }
        }

        private void nextPressed() {
            int i = WizardBase.this.vTaskIDs.indexOf(WizardBase.this.sCurrentActiveTask);
            if (i < WizardBase.this.vTaskIDs.size() - 1) {
                this.cmpTaskContainer.setSelection(i + 1);
                WizardBase.this.switchTo((String)WizardBase.this.vTaskIDs.get(i + 1));
                this.getButton(14).setEnabled(true);
            }
            if (i == WizardBase.this.vTaskIDs.size() - 2) {
                this.getButton(15).setEnabled(false);
            }
        }

        protected void okPressed() {
            ErrorDialog ed;
            String[] saMessages = WizardBase.this.validate();
            if (saMessages != null && saMessages.length > 0 && (ed = new ErrorDialog(WizardBase.this.shellParent, Messages.getString("WizardBase.error.ErrorsEncountered"), Messages.getString("WizardBase.error.FollowingErrorsReportedWhileVerifying"), saMessages, new String[0])).getOption() == "ACCEPT") {
                return;
            }
            super.okPressed();
        }

        public void setMinimumSize(int iWidth, int iHeight) {
            this.iWizardWidthMinimum = iWidth;
            this.iWizardHeightMinimum = iHeight;
        }

        public Shell createPopupContainer() {
            if (this.shellPopup != null && !this.shellPopup.isDisposed()) {
                this.shellPopup.dispose();
            }
            if (this.shellPopup == null || this.shellPopup.isDisposed()) {
                int shellStyle = 2160;
                if (SWT.getPlatform().indexOf("win32") < 0) {
                    shellStyle |= 0x10000;
                }
                this.shellPopup = new Shell(this.getShell(), shellStyle);
                this.shellPopup.setLayout((Layout)new FillLayout());
            }
            return this.shellPopup;
        }

        public Shell getPopupContainer() {
            return this.shellPopup;
        }

        public void attachPopup(String sPopupTitle, int iWidth, int iHeight) {
            this.shellPopup.setText(sPopupTitle);
            if (iWidth != -1 && iHeight != -1) {
                this.shellPopup.setSize(iWidth, iHeight);
            } else {
                this.shellPopup.pack();
            }
            this.setPopupLocation();
            this.shellPopup.open();
        }

        public void detachPopup() {
            if (this.shellPopup != null && !this.shellPopup.isDisposed()) {
                this.shellPopup.close();
            }
        }

        public void packWizard() {
            boolean changed = false;
            Point wizardSize = this.getShell().computeSize(-1, -1);
            int iWizardWidth = Math.max(wizardSize.x, this.iWizardWidthMinimum);
            int iWizardHeight = Math.max(wizardSize.y, this.iWizardHeightMinimum);
            Point oldSize = this.getShell().getSize();
            if (oldSize.x < iWizardWidth) {
                oldSize.x = iWizardWidth;
                changed = true;
            }
            if (oldSize.y < iWizardHeight) {
                oldSize.y = iWizardHeight;
                changed = true;
            }
            if (changed) {
                this.getShell().setSize(oldSize);
                this.getShell().layout();
            }
        }

        CTabFolder getTabContainer() {
            return this.cmpTaskContainer;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.getSource() instanceof CTabFolder) {
                String taskId = (String)e.item.getData();
                int indexLabel = WizardBase.this.vTaskIDs.indexOf(taskId);
                if (indexLabel >= 0) {
                    WizardBase.this.switchTo(taskId);
                    this.getButton(15).setEnabled(indexLabel < WizardBase.this.vTaskIDs.size() - 1);
                    this.getButton(14).setEnabled(indexLabel > 0);
                }
            }
        }

        public void controlMoved(ControlEvent e) {
            this.setPopupLocation();
        }

        public void controlResized(ControlEvent e) {
            this.setPopupLocation();
        }

        private void setPopupLocation() {
            if (this.shellPopup != null && !this.shellPopup.isDisposed()) {
                int x = 0;
                x = this.getShell().getLocation().x + this.getShell().getSize().x + this.shellPopup.getSize().x > this.getShell().getDisplay().getClientArea().width ? this.getShell().getDisplay().getClientArea().width - this.shellPopup.getSize().x : this.getShell().getLocation().x + this.getShell().getSize().x;
                this.shellPopup.setLocation(x, this.getShell().getLocation().y + 20);
            }
        }

        public void widgetDisposed(DisposeEvent e) {
            Iterator tasks = WizardBase.this.availableTasks.values().iterator();
            while (tasks.hasNext()) {
                ((ITask)tasks.next()).dispose();
            }
            WizardBase.this.dispose();
        }

        public void addPageChangedListener(IPageChangedListener listener) {
            this.pageChangedListeners.add((Object)listener);
        }

        public Object getSelectedPage() {
            return WizardBase.this.getCurrentTask();
        }

        public void removePageChangedListener(IPageChangedListener listener) {
            this.pageChangedListeners.remove((Object)listener);
        }

        private void firePageChanged(PageChangedEvent event) {
            Object[] listeners = this.pageChangedListeners.getListeners();
            for (int i = 0; i < listeners.length; ++i) {
                IPageChangedListener l = (IPageChangedListener)listeners[i];
                SafeRunnable.run((ISafeRunnable)new SafeRunnable(this, l, event){
                    private final /* synthetic */ IPageChangedListener val$l;
                    private final /* synthetic */ PageChangedEvent val$event;
                    private final /* synthetic */ WizardBaseDialog this$1;
                    {
                        this.this$1 = this$1;
                        this.val$l = val$l;
                        this.val$event = val$event;
                    }

                    public void run() {
                        this.val$l.pageChanged(this.val$event);
                    }
                });
            }
        }

        static /* synthetic */ String[] access$002(WizardBaseDialog x0, String[] x1) {
            x0.tmpTaskArray = x1;
            return x1;
        }

        static {
            $assertionsDisabled = !(class$org$eclipse$birt$core$ui$frameworks$taskwizard$WizardBase == null ? (class$org$eclipse$birt$core$ui$frameworks$taskwizard$WizardBase = WizardBase.class$("org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase")) : class$org$eclipse$birt$core$ui$frameworks$taskwizard$WizardBase).desiredAssertionStatus();
        }
    }
}

